ADDTRACES <-
function(J, WUSE, event, col=rgb(0.7,0.7,1) )
  {
#############   add traces to a GSN world seismic display
###   J=TOTAL; WUSE=1:length(J) ;  col=rgb(0.7,0.7,1)
    if(missing(col)) { col = rgb(0.7,0.7,1) }

   if(missing(WUSE)) { WUSE=1:length(J) }

    
    u = par("usr")

    DX = 0.03*(u[2]-u[1])
    DY = 0.1*(u[4]-u[3])

    NW = length(WUSE)
    
    N = length(J)


    if(any(WUSE>N) | any(WUSE<1))
      {
        print("error in WUSE selection")
      }
    
    APAL = GPAL()
    
    NCOLORS = length(APAL)
    

    EX = vector()
    WHY = vector()
    IND = vector()
    
    COL  = rep(rgb(0.7,0.7,1), times=NW)

    if(is.na(col))
      {

        numpal = ceiling(NW/NCOLORS)
        
        vid = rep(1:NCOLORS , times=2, length.out=NW)
        COL = APAL[vid]
        
        ##COL = sample(APAL, NW, replace = TRUE)

      }
    else
      {

        COL  = rep(col, times=NW)

      }


   
    for(j in 1:NW )
      {

        i = WUSE[j]
        
        d = J[[i]]$DATTIM
        dt = J[[i]]$dt
        N = J[[i]]$N
        stn = J[[i]]$sta
        lat = J[[i]]$lat 
        lon = J[[i]]$lon 
        el = J[[i]]$el
        
        amp = J[[i]]$amp

        if(length(lat)<1 | length(lon)<1 ) next
        if(is.na(lat) | is.na(lon) ) next
        if(length(amp)<2) next
        
       ##  tim = seq(from=0, length=N, by=dt)

        
        dis1 = RSEIS::GreatDist(event$lon, event$lat, lon , lat, EARTHRAD= 6371)

        #####   get time position 
        sd1a = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, d$jd, d$hr, d$mi, d$sec)
        sd2a = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, d$jd, d$hr, d$mi, d$sec+N*dt)


        x = dis1$ddeg

        if(  ((x+DX/2) < u[1]) | ( (x-DX/2) >u[2])) next
        
        y1 = sd1a
        y2 = sd2a
        
        NY  = seq(from=sd1a, length=N, by=dt)

        tempamp = amp[ NY>u[3] & NY<u[4] ]

        

        if(length(tempamp)>1)
          {
            SCmin = min(tempamp, na.rm = TRUE)
            
            SCmax = max(tempamp, na.rm = TRUE)
          }
        else
          {

            SCmin = min(amp, na.rm = TRUE)
            
            SCmax = max(amp, na.rm = TRUE)


          }

        
        NX  = RPMG::RESCALE(amp, x-DX/2, x+DX/2, SCmin, SCmax )
        
  
        EX[j] = NX[1]
        WHY[j] = NY[1]
        IND[j] = i
        
        lines(NX, NY, col=COL[j] , lwd=.6)
        points(NX[1], NY[1], col="brown", pch=1)

      }

    invisible(list(x=EX, y=WHY, COL=COL, IND=IND))

  }

