GSNplot<-function(J, WUSE, event, TTCURVES ,
                  labs = c("DONE", "REFRESH") ,
                  IASPpath = "~/Progs/TTIMES",
                  decim=10,
                  FILT=list(fl=1/100, fh=1/10,  type="LP", proto="BU"),
                  filters=NULL ,deglim=c(0,180), tlim=c(0,3000), 
                  demo = FALSE )
  {
##########################################   arguments
     # STA=NULL
    if(missing(demo)) { demo = FALSE }
#######   this program illustrates how to use the interactive program RPMG
    
    if(missing(IASPpath)){
      IASPpath = SetIASPhome()
    }
    if(missing(labs)) {
      labs = c("DONE", "REFRESH",  "ZOOM", "UNZOOM", "P-GEN","FILT", "UnFILT",   "SURF",  "TTC", "TRACE","LINE",
          "CITY",  "STName",
        "IDARR","DECIM", "MAP",  "WCURVE","TTlab", "DSPR","PNG",  "DOC"  )

      
    }
    if(missing(FILT)) {  FILT = list(fl=1/100, fh=1/5,  type="HP", proto="BU", npoles=2) }
    if(missing(decim)) { decim = 10 }
    if(missing(filters)) {
     filters  =
        list(flo=
             c(
               1/20, 1/10,
               1/5, 1/2, 1, 2, 5, 10,

               1/100, 1/100, 1/100, 1/100, 1/100,
               1/100, 1/100, 1/100, 1/100, 1/100,
               100
               ),
             
             fhi=
             c(100, 100, 100, 100, 
               100, 100, 100, 100, 
               1/50, 1/40, 1/30, 1/20, 1/10,
               1/5, 1/2, 1, 5, 10,
               100),
             type =
             c( "HP","HP", "HP", "HP",
               "HP","HP", "HP", "HP",
               "LP","LP", "LP", "LP", "LP",
               "LP", "LP","LP", "LP", "LP",
               "None"))
    }


      Jchecker<-function(BJ)
          {

              for(i in 1:length(BJ) )
                  {      
                      d = BJ[[i]]$DATTIM
                      dt = BJ[[i]]$dt
                      N = BJ[[i]]$N
                      stn = BJ[[i]]$sta
                      lat = BJ[[i]]$lat 
                      lon = BJ[[i]]$lon 
                      el = BJ[[i]]$el
                      
                      amp = BJ[[i]]$amp
                      
                      if(length(lat)<1 | length(lon)<1 )
                          {print(paste('Problem 1 with lat lon', i, stn))  }
                      if(is.na(lat) | is.na(lon) )
                          {print(paste('Problem 2 with lat lon', i, stn))   }
                      if(length(amp)<2)
                          {print(paste('Problem with amp', i, stn)) }
                      if(any(is.na(amp)))
                          {print(paste('Problem: NAs in amp', i, stn)) }
                      
                      
                  }
              cat('Checker Done\n')
          }

#################################  initializations
    MAPdev = NULL
    PGENdev = NULL
    DOCdev = NULL
    PHASEDOCdev = NULL
    FILTSPREADdev = NULL

    WCURVES = "all" 
    
 
    colabs = rep("blue", length=length(labs))
    pchlabs = rep(" ",length(labs))

colabs[ grep("ZOOM", labs)] = "red"
colabs[ grep("FILT", labs)] =  rgb(0, .4, 0)

tagcex = .7
    #################################
#####  DJ = DECIM(J, fh=NA, dec=decim)
      #### copy the input list of station wiggles
  
    stalon= attr(J, "stalon")
    stalat= attr(J, "stalat")
    
    staname= attr(J, "staname")
    stael = attr(J, "stael")
      ###Jchecker(J)

      
    if(length(stalat)!=length(J))
      {
        print("NOTE: Add station data base information")
        return(NULL)
    }

      
     ## Jchecker(J)
    DJ = J
#################################

      Jchecker(DJ)
      
    PPH = PHASEnames()

    SURF.FLAG = FALSE
    TTC.FLAG = FALSE
    CITY.FLAG =  FALSE
    TRACE.FLAG =  TRUE
    TRACE.COL.FLAG =  TRUE
    TRACE.COL = NA
    PICK.FLAG = FALSE
    ZOOM.FLAG = FALSE
    
    TT.COL = grey(.6)

    
    SD1 = attr(J, "startT")
    SD2 = attr(J, "endT")
    SD1 = SD1[WUSE]
    SD2 =   SD2[WUSE]

    if(missing(tlim))
      {
    tlim = range(c(SD1, SD2, na.rm=TRUE))
  }
    TLIM.ORG = tlim


    
    AA = RSEIS::GreatDist(event$lon, event$lat, stalon[WUSE] , stalat[WUSE], EARTHRAD= 6371)

    if(missing(deglim))
      { 
        deglim =  range(AA$ddeg)

      }

    
    DEGLIM.ORG = deglim

#################################    
#################################    
    replotGSN<-function(DJ)
      {
        LIMS = PrepGSNdisplay(DJ, WUSE, event, xlim=deglim, ylim=tlim ,  TTCURVES=NA)
        if(SURF.FLAG) SurfaceWaves()
        if(TTC.FLAG) ADDttcurves(TTCURVES, sel= WCURVES, col=TT.COL )
        if(TRACE.FLAG) tagXY = ADDTRACES(DJ, WUSE, event, col=TRACE.COL)
        if(CITY.FLAG) addCITY(event)

        return(tagXY)
      }
#################################    
#################################    
    nameTRACES<-function(WW1)
      {
        WW2 = tagXY$IND[WW1]
        
        stations = attr( J, "staname" )
        
        tx = tagXY$x[WW1]
        ty = tagXY$y[WW1]
        tcol = tagXY$COL[WW1]
        labb = stations[WW2]

        ordx = order(tx)

        tx = tx[ordx]
        ty = ty[ordx]
        labb = labb[ordx]
        WW2  =  WW2[ordx]
        tcol = tcol[ordx]
        
        points(tx, ty, col='black', pch=6)

        RMAT =   RPMG::textrect( tx, rep(min(ty), times=length(tx)),
          labb, textcol=tcol   ,xpd=TRUE, add=FALSE, font=1, cex=tagcex, brd = 0.03 )

        newjitx = RSEIS::jitter.lab(RMAT[,1]  , RMAT[,3]-RMAT[,1])
        newy = min(ty)-newjitx*(RMAT[,4]-RMAT[,2])        

        segments(tx, ty,  tx, newy, col=tcol)
        RMAT =   RPMG::textrect( tx, newy, labb, textcol=tcol,
          xpd=TRUE, add=TRUE, font=1, cex=tagcex, brd = 0.03 )
        
      }
#################################    
#################################        
    
    
## pp = IDTRACE(J, WUSE, event, idev=2, newdev=3, EX=tagXY$x, WHY=tagXY$y)

 ##
  
    MAINdev = dev.cur()

    if(MAINdev==1)
      {
        MAINdev = dev.new(width=14, height=10)
      }


    tagXY =  replotGSN(DJ)

    
    buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
    NLABS = length(labs)
    NOLAB = NLABS +1000  ## some large number
  
    
    if(demo==TRUE)  return(NULL)
    iloc = locator(1, type='p', pch=3)

        if(is.null(iloc)) {
          print('DONE');
          u = par("usr")
           buttons = RPMG::rowBUTTONS(labs, col=rep(grey(.8), length(labs)), pch=rep(NA, length(labs)))
            title("Return to calling program", cex=1.2)
          
         ##### text(mean(c(u[1], u[2])), mean(c(u[4])), labels="DONE", cex=4, pos=3)
          return(NULL)

        }
     
    
    zloc = iloc

    Nclick = length(iloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K =  RPMG::whichbutt(zloc , buttons)
    sloc = zloc

      ##Jchecker(DJ)
      
#################################    
#################################    
    while(TRUE)
      {
        ############   button actions
#################################    
#################################    BUTTON DEFINITION
        ###########   quit and break loop
        if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
          {

            buttons = RPMG::rowBUTTONS(labs, col=rep(grey(.8), length(labs)), pch=rep(NA, length(labs)))
            title("Return to calling program", cex=1.2)
          
            break;
          }
#################################    
#################################    BUTTON DEFINITION
        ###########   refresh the screen
        if(K[Nclick] == match("REFRESH", labs, nomatch = NOLAB))
          {
            tagXY =replotGSN(DJ)
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }

#################################    
#################################    BUTTON DEFINITION
        ###########   refresh the screen
        if(K[Nclick] == match("DOC", labs, nomatch = NOLAB))
          {
            
            if(is.null(DOCdev))
              {
                dev.new(width=12, height=10)
                DOCdev = dev.cur()
              }
            else
              {
                
                dev.set(DOCdev)
              }
 
            DOC.GSNPLOT()
            dev.set(MAINdev)
            
            zloc = list(x=NULL, y=NULL)
          }

        
#################################    
#################################    BUTTON DEFINITION
        ###########   refresh the screen
        if(K[Nclick] == match("PNG", labs, nomatch = NOLAB))
          {
              pngfile =  RPMG::local.file("GSN", "png")
              cat(paste('Creating plot file: ',pngfile, '\n'), sep='\n' ) 
            RPMG::jpng(file=pngfile )
            tagXY =replotGSN(DJ)
            dev.off()

            zloc = list(x=NULL, y=NULL)
          }

#################################    
#################################    BUTTON DEFINITION
        ###########   refresh the screen
        if(K[Nclick] == match("LINE", labs, nomatch = NOLAB))
          {

            n = length(zloc$x)

            if(n>=3)
              {
                ##########  for each pair of clicks, calculate a velocity
                npairs = floor (  (n-1)/2 ) 

                for(j in 1:npairs)
                  {
                    nj = (j-1)*2+1
                  ###  print(c(nj, nj+1))
                    x1 = zloc$x[nj]
                    y1 = zloc$y[nj]
                    x2 = zloc$x[nj+1]
                    y2 = zloc$y[nj+1]


                    segments(x1, y1, x2, y2, lwd=1.5, col=grey(.4) )


                    ##   slope = (y2-y1)/(x2-x1)
                    
                    vel1 = (6371*pi/180)*   (x2-x1)/(y2-y1)


                     RPMG::textrect( x2, y2, format(vel1, digits=3), textcol="blue" ,
                              xpd=TRUE, add=TRUE, font=1, cex=1.2, brd = 0.05 )
        

                    print(paste("Velocity = ", format(vel1, digits=3)))
                  }


                
              }

            
            zloc = list(x=NULL, y=NULL)
          }

        
#################################    
#################################    BUTTON DEFINITION        
        ###########  redo decimation
        if(K[Nclick] == match("DECIM", labs, nomatch = NOLAB))
          {
            decims=c(0, 1, 2, 5, 10, 15, 20, 50)
            pk = RPMG::chooser(opts=decims, nsel=1  )

            if(is.numeric(pk))
              {
                decim = as.numeric(pk)
              }
            if(decim>1)
              {
               DJ = DECIM(J, fh=NA, dec=decim)
             }
            else
              {
                decim = 1
                DJ = J
              }

            
              tagXY =replotGSN(DJ)
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################    
#################################    BUTTON DEFINITION
        ###########   MAP
        if(K[Nclick] == match("MAP", labs, nomatch = NOLAB))
          {
            n = length(zloc$x)

            if(n>=3)
              {
                x1 = zloc$x[n-2]
                y1 = zloc$y[n-2]
                x2 = zloc$x[n-1]
                y2 = zloc$y[n-1]
                
                EX=tagXY$x
                WHY=tagXY$y
                
                II = InRect(EX, WHY, x1, y1, x2, y2)
                WW1 = which(II)
                WW2 = tagXY$IND[WW1]
              }
            else
              {
                WW1= 1:length(J)
              }

            if(length(WW1)<1)
              { WW1= 1:length(J) }

          ####  print(paste("length of choice", length(WW1)))
            if(length(WW1)<length(J))  nameTRACES(WW1)
            


            
            if(is.null(MAPdev))
              {
                dev.new(width=12, height=10)
                MAPdev = dev.cur()
              }
            else
              {
                
                dev.set(MAPdev)
              }
 
            GreatCirclePlot(J, event,  WUSE=WW1, col=TRACE.COL, filters=filters)
          ####  points(  RPMG::fmod(stalon[WW1], 360),stalat[WW1] , col='red', pch=6 )
           #### text(  RPMG::fmod(stalon[WW1], 360),stalat[WW1] ,  staname[WW1], pos=3)
            dev.set( MAINdev)
            zloc = list(x=NULL, y=NULL)
          }

#################################    
#################################    BUTTON DEFINITION
        ################ 
        if(K[Nclick] == match("SURF", labs, nomatch = NOLAB))
          {
            SURF.FLAG = !SURF.FLAG
            if(SURF.FLAG)
              {
                SurfaceWaves()
              }
            else
              {
                tagXY =replotGSN(DJ)
              }
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################
#################################    
#################################    BUTTON DEFINITION
        ################ 
        if(K[Nclick] == match("WCURVE", labs, nomatch = NOLAB))
          {

          choices = c( "all", "Pplus",  "Splus" , "basic", "named")

          pchoice = RPMG::chooser(choices, nsel=1, ncol=1)

           WCURVES = as.character(pchoice)

          if(is.na(WCURVES)) WCURVES = choices[1]
          if(!any(WCURVES==choices)) WCURVES = choices[1]

         ### print(WCURVES) 
                tagXY =replotGSN(DJ)
            
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################    


        
#################################    BUTTON DEFINITION
        ################  make postscript file
        if(K[Nclick] == match("TRACE", labs, nomatch = NOLAB))
          {
            TRACE.FLAG = !TRACE.FLAG
             if(TRACE.FLAG)
              {
                 tagXY = ADDTRACES(DJ, WUSE, event, col=TRACE.COL)
              }
            else
              {
               tagXY = replotGSN(DJ)
              }
            
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################    
#################################    BUTTON DEFINITION
        if(K[Nclick] == match("TTC", labs, nomatch = NOLAB))
          {
            TTC.FLAG = !TTC.FLAG
            if(TTC.FLAG)
              {
                ADDttcurves(TTCURVES, sel= WCURVES, col=TT.COL )
              }
            else
              {
                tagXY =replotGSN(DJ)
              }
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################    
#################################    BUTTON DEFINITION
        if(K[Nclick] == match("CITY", labs, nomatch = NOLAB))
          {
            CITY.FLAG = !CITY.FLAG
            if(CITY.FLAG)
              {addCITY(event)}
            else
              {
               tagXY = replotGSN(DJ)
              }
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }

#################################    
#################################    BUTTON DEFINITION

        if(K[Nclick] == match("TRcol", labs, nomatch = NOLAB))
          {
            TRACE.COL.FLAG = !TRACE.COL.FLAG
            if(TRACE.COL.FLAG) { TRACE.COL = NA } else { TRACE.COL = rgb(0.7, 0.7, 1) } 
            tagXY =replotGSN(DJ)
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
#################################    
#################################    BUTTON DEFINITION
        if(K[Nclick] == match("STName", labs, nomatch = NOLAB))
          {

           ##   WW1 =  1:length(tagXY$IND)

            upar = par("usr")
            x1 = upar[1]
            x2 = upar[2]
            y1  = upar[3]
            y2 = upar[4]
                           
                EX=tagXY$x
                WHY=tagXY$y
                
                II = InRect(EX, WHY, x1, y1, x2, y2)
                WW1 = which(II)
                
           
          
            if(length(WW1)<1)
              { WW1= 1:length(J) }

          ####  print(paste("length of choice", length(WW1)))
            if(length(WW1)<length(J))  nameTRACES(WW1) 
            
              
            stations = attr( J, "staname" )
            
            WW2 = tagXY$IND[WW1]

           ####   if(length(WW2)<length(J))
              nameTRACES(WW1)
          ########  labb = stations[WW2]

           ########addTRACEtags(tagXY, labb)
           ######## nameTRACES(WW1)
            zloc = list(x=NULL, y=NULL)
          }



#################################  
#################################    
#################################    BUTTON DEFINITION        

   
        ###########   DISPERSION
         if(K[Nclick] == match("DSPR", labs, nomatch = NOLAB))
          {

            n = length(zloc$x)
            
            if(n>=3)
              {
                x1 = zloc$x[n-2]
                y1 = zloc$y[n-2]
                x2 = zloc$x[n-1]
                y2 = zloc$y[n-1]
                
                EX=tagXY$x
                WHY=tagXY$y
                
                II = InRect(EX, WHY, x1, y1, x2, y2)
                WW1 = which(II)
                WW2 = tagXY$IND[WW1]


                
                
                if(length(WW2)>=1)
                  {

                    fh=1/c(5, 10,20,30,40)
                    fl=1/c(10,20,30,40,50)
                    
                    delperp = 4
                    cenperiods = c(5, 10, 15, 20, 25, 30, 35, 40, 50)
                    fh = 1/  ( cenperiods-delperp )
                    fl = 1/  ( cenperiods+delperp )
          
                    wj = WW2[1]
                    print(paste(sep=" ",wj,staname[wj] ))
                    staname[wj]
                    y = J[[wj]]$amp
                   

                    jdt = J[[wj]]$dt
                    x = seq(from=0, length=length(y), by= jdt)


                    if(is.null(FILTSPREADdev))
                      {
                        dev.new(width=12, height=10)
                        FILTSPREADdev = dev.cur()
                      }
                    else
                      {
                        dev.set(FILTSPREADdev)
                      }

                    RSEIS::FILT.spread(x, y, jdt, fl = fl, fh = fh, sfact = 1, WIN = NULL, PLOT = TRUE, TIT = staname[wj], TAPER = 0.05, POSTTAPER=0.05)

                    wwm = DISPERSION(y, jdt, fl, fh, PLOT=FALSE)
                    dev.set(MAINdev)
                    
                  }

              }
            zloc = list(x=NULL, y=NULL)
            
          }
#################################  
#################################    
#################################    BUTTON DEFINITION        

        
         if(K[Nclick] == match("Pick", labs, nomatch = NOLAB))
          {
            Ldev= dev.list()
            
            idev = dev.cur()
            if(any(Ldev==3)) { newdev=3 }
            else { newdev=dev.new(width=14, height=6) }

            pp = 1
            while(!is.null(pp) )
              {
                
                pp = IDTRACE(J, WUSE, event, idev=idev, newdev=newdev, EX=tagXY$x, WHY=tagXY$y)

              }

            zloc = list(x=NULL, y=NULL)
            
          }
#################################    
#################################    BUTTON DEFINITION
        if(K[Nclick] == match("ZOOM", labs, nomatch = NOLAB))
          {
            n = length(zloc$x)
            x1 = zloc$x[n-2]
            y1 = zloc$y[n-2]
            x2 = zloc$x[n-1]
            y2 = zloc$y[n-1]

            tlim = c(y1, y2)
            deglim = c(x1, x2) 
            tagXY =replotGSN(DJ)
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
            
            
          }

#################################    
#################################    BUTTON DEFINITION
        
              if(K[Nclick] == match("UNZOOM", labs, nomatch = NOLAB))
          {
           
            tlim = TLIM.ORG 
            deglim = DEGLIM.ORG
            tagXY =replotGSN(DJ)
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
            
            
          }

#################################    
#################################    BUTTON DEFINITION        
          if(K[Nclick] == match("IDARR", labs, nomatch = NOLAB))
          {
            n = length(zloc$x)

            
        
            x2 = zloc$x[1:(n-1)]
            y2 = zloc$y[1:(n-1)]
            KLOC = list(x=x2, y=y2)

            IDARRIVAL(TTCURVES, KLOC)

             zloc = list(x=NULL, y=NULL)
            


          }
#################################
#################################    
#################################    BUTTON DEFINITION        
          if(K[Nclick] == match("TTlab", labs, nomatch = NOLAB))
          {
           label.ttcurves(TTCURVES, sel=selTTC(TTCURVES, sel=WCURVES)   )

          }
#################################


        
#################################    BUTTON DEFINITION        

        if(K[Nclick]==match("FILT", labs, nomatch = NOLAB))
          {####FILT
            
              FILT = RSEIS::choosfilt(filters)
              FILT$npoles = 2

            ## FILT$npoles = 4
            if(!is.null(FILT))
              {

                if(FILT$type=="None")
                  {
                    if(exists("OLDJ"))
                      {
                        J = OLDJ
                        DJ = DECIM(J, fh=NA, dec=decim)
                      }
                    
                  }
                else
                  {
                    u = par("usr")
                    text(mean(c(u[1], u[2])), mean(c(u[3], u[4])), labels="Please Wait....Filtering", cex=4)
                    OLDJ=J
                    
                    for(ik in 1:length(J))
                      {
                        ry = DJ[[ik]]$amp
                        rdt = DJ[[ik]]$dt
                        fy = RSEIS::butfilt(ry, fl=FILT$fl, fh=FILT$fh , deltat=rdt, type=FILT$type ,
                            proto=FILT$proto, npoles=FILT$npoles )
                        DJ[[ik]]$amp = fy
                        
                      }
                    ## DJ = DECIM(J, fh=NA, dec=decim)
                    ## DJ = J
                    ## cat(names(DJ[[1]]), sep='\n')
                    cat('Done with Filter\n')
                  }
###  X11()
              }
            dev.set(MAINdev)
            ##cat('going to replot\n')
            
            
            Jchecker(DJ)
            
            tagXY =replotGSN(DJ)
          
            
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
###  dev.set( MAINdev)  
            zloc = list(x=NULL, y=NULL) 
          }
#################################    
#################################    BUTTON DEFINITION
        if(K[Nclick]==match("UnFILT", labs, nomatch = NOLAB))
          {

            
            if(exists("OLDJ"))J = OLDJ
            dev.set(MAINdev)
            u = par("usr")
            text(mean(c(u[1], u[2])), mean(c(u[3], u[4])), labels="Please Wait....Restoring", cex=4)
            
            ## DJ = DECIM(J, fh=NA, dec=decim)
            DJ = J
             tagXY =replotGSN(DJ)
          
            buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
###  dev.set( MAINdev)  
            zloc = list(x=NULL, y=NULL) 
            


          }
        
#################################    
#################################    BUTTON DEFINITION        
         if(K[Nclick] == match("P-GEN", labs, nomatch = NOLAB))
          {
           #### Ldev= dev.list()
            
         ####   idev = dev.cur()
         ####   if(any(Ldev==3)) { newdev=3 }
         ####   else { newdev=dev.new(width=14, height=6) }
            #######  zloc =  locator(3) 
            n = length(zloc$x)
            x1 = zloc$x[n-2]
            y1 = zloc$y[n-2]
            x2 = zloc$x[n-1]
            y2 = zloc$y[n-1]
            
            
            EX=tagXY$x
            WHY=tagXY$y

            II = InRect(EX, WHY, x1, y1, x2, y2)
            WW1 = which(II)

            if(length(WW1)>0)
              {

            WW2 = tagXY$IND[WW1]
            
            stations = attr( J, "staname" )
            
            if(length(WW1)<length(J))  nameTRACES(WW1)
            
            GG = list()
            for(ig in 1:length(WW2))
              {
                GG[[ig]] = J[[WW2[ig]]]


              }

             slist = list(name=staname[WW2], lat=stalat[WW2] , lon=stalon[WW2],
               z= stael[WW2])

            YALL = GETtelesTT(event, slist, IASPHOME =  IASPpath )

            ystas  =  attr(YALL, "ystas") 
            ytimes = attr(YALL,"ytimes")
            ord1 = order(ytimes)
            ostas = ystas[ord1]


            GH = RSEIS::prepSEIS(GG)
            GH$pcol = tagXY$COL[WW1]
            
        
            if(is.null(PGENdev))
              {
                dev.new(width=12, height=10)
                PGENdev = dev.cur()
              }
            else
              {
               dev.set(PGENdev)
              }
            
            m1 =  match(  ostas, GH$STNS)
            PSTDLAB = c("DONE", "QUIT", "zoom out","zoom in",  "refresh", "restore",
              "PickWin","RMS", "XTR", "SPEC", "SGRAM" , "FILT", "UNFILT" , "Pinfo",
              "WINFO", "PTS", "YPIX",  "SavePIX", "Postscript")
                    
         ####   PIX = RSEIS::swig(GH, APIX=, STDLAB=PSTDLAB)

            timGH1 = list(yr=GH$info$yr[1], jd=GH$info$jd[1]  , hr=GH$info$hr[1] , mi=GH$info$mi[1] , sec=GH$info$sec[1] )
            pictimes =     RSEIS::secdifL(timGH1, YALL )
            
          ####  maxpick = max( pictimes[YALL$onoff>=0] , na.rm=TRUE) 
          ####  minpick = min( pictimes[YALL$onoff>=0] , na.rm=TRUE)

            maxpick = max( pictimes , na.rm=TRUE) 
            minpick = min( pictimes , na.rm=TRUE)

            WIN=c( max(c(0, minpick-100))  ,maxpick)
            
            PIX = RSEIS::swig(GH, sel=m1,  APIX=YALL, STDLAB=PSTDLAB, WIN=WIN, filters=filters)
            
          }

            zloc = list(x=NULL, y=NULL) 
            
            
            dev.set(MAINdev)
           
          }

#################################    
#################################  END  BUTTON DEFINITIONS
       
################  cut cross sections
   
        iloc = locator(1,type='p', pch=3)

        if(is.null(iloc)) {
          print('DONE');
          u = par("usr")
         ### text(mean(c(u[1], u[2])), mean(c(u[4])), labels="DONE", cex=4, pos=1)
          buttons = RPMG::rowBUTTONS(labs, col=rep(grey(.8), length(labs)), pch=rep(NA, length(labs)))
            title("Return to calling program", cex=1.2)
          
          
          return(NULL)

        }
     
        
        ##print(iloc)
        zloc  = list(x=c(zloc$x,iloc$x), y=c(zloc$y, iloc$y))
        Nclick = length(iloc$x)
        if(is.null(zloc$x)) { return(sloc) }
        K =  RPMG::whichbutt(iloc , buttons)
##### print(K)   
      }
    
  }

