GreatCirclePlot <- function(J , event , WUSE=1 ,
                            col=rgb(0.7,0.7,1),  IASPpath = "/home/lees/Progs/TTIMES",
                            FILT=list(fl=1/100, fh=1/10,  type="LP", proto="BU"),
                            filters=NULL ,
                            demo = FALSE )
  {

    if(missing(demo)) { demo = FALSE }
    if(missing(col)) col = rgb(0.7,0.7,1)

    if(missing(IASPpath)){
      IASPpath = SetIASPhome()
    }
      if(missing(FILT)) {  FILT = list(fl=.2, fh=15,  type="HP", proto="BU") }
    

    if(missing(filters)) {
     filters  =
        list(flo=
             c(1/100, 1/100, 1/100, 1/100, 1/100,
               1/100, 1/100, 1/100, 1/100, 1/100,
               100
               ),
             
             fhi=
             c(1/50, 1/40, 1/30, 1/20, 1/10,
               1/5, 1/2, 1, 5, 10,
               100),
             type =
             c("LP","LP", "LP", "LP", "LP",
               "LP", "LP","LP", "LP", "LP",
               "None"))
    }

    #######   plot great RPMG::circle map
  #######   require(geomapdata)
   STA = NULL

    data(worldmap, package='geomapdata' )

    worldmap$STROKES$col  =rep(grey(.7), times=length(worldmap$STROKES$col))
    
    stalat = sapply(J, '[[', 'lat')
    stalon = sapply(J, '[[', 'lon')
    staname = sapply(J, '[[', 'sta')
    stael = sapply(J, '[[', 'el')
    staLON  = RPMG::fmod(stalon, 360)

    NAlat = !is.na(stalat)
    NAlon = !is.na(stalon)
    GOODsta = NAlat & NAlon
    NAw = which(GOODsta)

    
    if(any(!(GOODsta) ) )
      {
         print("NOTE: check station data base information")
           }

    

    THEarcs = list()
    
    for(jsta in 1:length(NAw))
        {
            j = NAw[jsta]
            
        stn = J[[j]]$sta
        lat = J[[j]]$lat 
            lon = J[[j]]$lon

        if(length(lat)<1 | length(lon)<1 ) next
        if(is.na(lat) | is.na(lon) ) next
        GA = GEOmap::getgreatarc(event$lat, event$lon, lat, lon, 40)
        XA = list(x=RPMG::fmod(GA$lon, 360), y=GA$lat)
        FA =    GEOmap::fixCoastwrap(XA)
        THEarcs[[jsta]] = list(y=FA$y, x=FA$x, del=GA$del) 
    }


    
    
    NW = length(WUSE)
    N = length(J)
    
    COL  = rep(rgb(0.7,0.7,1), times=N)
    APAL = GPAL()
    
    NCOLORS = length(APAL)
   
    if(is.na(col))
      {
        
        numpal = ceiling(N/NCOLORS)
        
        vid = rep(1:NCOLORS , times=2, length.out=N)
        COL = APAL[vid]
        
        ##COL = sample(APAL, NW, replace = TRUE)

      }
    else
      {
        
        if(length(col)==1)
          {
            COL  = rep(col, times=N)
          }
        if(length(col)==N)
          {
            COL = col
          }
        
      }
    
    
    if(missing(WUSE)) WUSE = which(!is.na(stalat) & !duplicated(staname) )


      PGENdev = NULL
 
    labs = c("DONE", "REFRESH", "RESTORE", "NAMES", "ARCS", "ALL", "TARGET", "ZOOM", "P-GEN",   "EPS" )

    colabs = rep(rgb(.4, .8, .2)  , length=length(labs))
    pchlabs = rep(" ",length(labs))

    NAMEflag = TRUE
    ARCflag = TRUE
    ALLflag = FALSE

    WUSEold = WUSE

    oldLIM = c(-180, -90, 180, 90)
    newLIM = c(-180, -90, 180, 90)

    gcreplot<-function()
      {
        GEOmap::plotworldmap(worldmap, LIM = newLIM )

        if(ARCflag==TRUE)
          {
            for(j in 1:length(WUSE))
              {
                i = WUSE[j]
                k = which(NAw==i)
                if(length(k)<1) next
                lines(THEarcs[[i]]$x, THEarcs[[i]]$y , col=COL[i], pch=6 )
              }
            
          }
        
        
        if(NAMEflag==TRUE)
          {
            points(staLON[WUSE], stalat[WUSE], pch=6, col='red')
            text(staLON[WUSE], stalat[WUSE], labels=staname[WUSE], pos=3)
            
          }
        
      }

    
    MAINdev = dev.cur()

    if(MAINdev==1)
      {
        MAINdev = dev.new(width=12, height=10)
      }


    tagXY =  gcreplot()

     if(demo==TRUE)  invisible(NULL)
    buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
    NLABS = length(labs)
    NOLAB = NLABS +1000  ## some large number
  
   
    iloc = locator(1, type='p', pch=3)
    zloc = iloc

    Nclick = length(iloc$x)
    if(is.null(zloc$x)) { return(NULL) }
    K =  RPMG::whichbutt(zloc , buttons)
    sloc = zloc
    
        while(TRUE)
      {
        ########### ########## ########## ####################        
        if(K[Nclick] == match("DONE", labs, nomatch = NOLAB))
          {
            
            buttons = RPMG::rowBUTTONS(labs, col=rep(grey(.8), length(labs)), pch=rep(NA, length(labs)))
          title("Return to calling program", cex=1.2)
            break;
          }
        ########### ########## ########## ####################        
        if(K[Nclick] == match("REFRESH", labs, nomatch = NOLAB))
          {
            tagXY =gcreplot()
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }
        ########### ########## ########## ####################        
        if(K[Nclick] == match("RESTORE", labs, nomatch = NOLAB))
          {

            newLIM = c(-180, -90, 180, 90)
            WUSE = WUSEold
            tagXY =gcreplot()
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
            zloc = list(x=NULL, y=NULL)
          }

        ########### ########## ########## ####################
        if(K[Nclick] == match("ALL", labs, nomatch = NOLAB))
          {
            ALLflag = !ALLflag
            
            if(ALLflag)
              {
                WUSE = 1:length(J)
                
              }
            else
              {

                WUSE = WUSEold

              }
             tagXY =gcreplot()
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
        
            zloc = list(x=NULL, y=NULL)
          }
        ########### ########## ########## ####################
        if(K[Nclick] == match("TARGET", labs, nomatch = NOLAB))
          {
          
            n = length(zloc$x)
            
            if(n>=3)
              {
                x1 = zloc$x[n-2]
                y1 = zloc$y[n-2]
                x2 = zloc$x[n-1]
                y2 = zloc$y[n-1]
                targ = c(min(c(x1,x2))  , min(c(y1,y2))   , max(c(x1,x2))  , max(c(y1,y2)) )

                
                 WUSE1 = which(staLON>targ[1] & staLON<targ[3] & stalat>targ[2] & stalat<targ[4])

                if(length(WUSE1)>0) WUSE = WUSE1
                
              }
            
             tagXY =gcreplot()
             buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
        
            zloc = list(x=NULL, y=NULL)
          }
        
        ########### ########## ########## ####################
        if(K[Nclick] == match("NAMES", labs, nomatch = NOLAB))
          {

            NAMEflag = !NAMEflag
            if(NAMEflag==FALSE)
              {
                tagXY =gcreplot()
                buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
              }
            else
              {

                points(staLON[WUSE], stalat[WUSE], pch=6, col='red')
                text(staLON[WUSE], stalat[WUSE], labels=staname[WUSE], pos=3)


              }
            
          
            
           
            zloc = list(x=NULL, y=NULL)
          }
    

        ########### ########## ########## ####################
        if(K[Nclick] == match("ARCS", labs, nomatch = NOLAB))
          {
            ARCflag = !ARCflag
            if(ARCflag==FALSE)
              {
                tagXY =gcreplot()
                buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)
              }
            else
              {
                for(j in 1:length(WUSE))
                  {
                    i = WUSE[j]
                    
                    lines(THEarcs[[i]]$x, THEarcs[[i]]$y , col=COL[i], pch=6 )
                  }
              }
            
            zloc = list(x=NULL, y=NULL)
          }

########### ########## ########## ####################
        if(K[Nclick] == match("ZOOM", labs, nomatch = NOLAB))
          {
            n = length(zloc$x)

            if(n>=3)
              {
                x1 = zloc$x[n-2]
                y1 = zloc$y[n-2]
                x2 = zloc$x[n-1]
                y2 = zloc$y[n-1]
                newLIM = c(min(c(x1,x2))  , min(c(y1,y2))   , max(c(x1,x2))  , max(c(y1,y2)) )
                tagXY =gcreplot()
                buttons = RPMG::rowBUTTONS(labs, col=colabs, pch=pchlabs)

              }
            zloc = list(x=NULL, y=NULL)
          }
        ########### ########## ########## ####################        
        if(K[Nclick] == match("P-GEN", labs, nomatch = NOLAB))
          {
            n = length(zloc$x)
            
            if(n>=3)
              {
                x1 = zloc$x[n-2]
                y1 = zloc$y[n-2]
                x2 = zloc$x[n-1]
                y2 = zloc$y[n-1]

                rect(x1, y1, x2, y2, col=NA, border='black')

                alon=staLON[WUSE]
                alat=stalat[WUSE]
                II = InRect(alon, alat, x1, y1, x2, y2)
                
                WW1 = which(II)
                
                WW2 = WUSE[WW1]

                print(WW1)
                
                if(length(WW1)>0)
                  {
                    GG = list()
                    tcol = vector()
                    
                    for(ig in 1:length(WW1))
                      {
                        GG[[ig]] = J[[WW2[ig]]]
                        tcol[ig] = COL[WW2[ig]]
                        
                      }

                    
                    slist = list(name=staname[WW2], lat=stalat[WW2] , lon=staLON[WW2],
                      z= stael[WW2])


                   YALL = GETtelesTT(event, slist, IASPHOME =  IASPpath )

                    ystas  =  attr(YALL, "ystas") 
                    ytimes = attr(YALL,"ytimes")
                    ord1 = order(ytimes)
                    ostas = ystas[ord1]

                    
                    GH = RSEIS::prepSEIS(GG)
                    GH$pcol = tcol
                    
                    m1 =  match(  ostas, GH$STNS)
    
                    PSTDLAB = c("DONE", "QUIT", "zoom out","zoom in",  "refresh", "restore",
                      "PickWin","RMS", "XTR", "SPEC", "SGRAM" , "FILT", "UNFILT" , "Pinfo",
                      "WINFO", "PTS", "YPIX",  "SavePIX", "Postscript")
                    
                    if(is.null(PGENdev))
                      {
                        dev.new(width=12, height=10)
                        PGENdev = dev.cur()
                      }
                    else
                      {
                        dev.set(PGENdev)
                      }


            timGH1 = list(yr=GH$info$yr[1], jd=GH$info$jd[1]  , hr=GH$info$hr[1] , mi=GH$info$mi[1] , sec=GH$info$sec[1] )
            pictimes =     RSEIS::secdifL(timGH1, YALL )
            
          ####  maxpick = max( pictimes[YALL$onoff>=0] , na.rm=TRUE) 
          ####  minpick = min( pictimes[YALL$onoff>=0] , na.rm=TRUE)

            maxpick = max( pictimes , na.rm=TRUE) 
            minpick = min( pictimes , na.rm=TRUE)

            WIN=c( max(c(0, minpick-100))  ,maxpick)
            
                    
                    
                    PIX = RSEIS::swig(GH, sel=m1,  APIX=YALL, STDLAB=PSTDLAB, WIN=WIN, filters=filters)
                  }
                dev.set(MAINdev)
                
              }
            
            
            zloc = list(x=NULL, y=NULL)
          }
########### ########## ########## ####################
###########   refresh the screen
        if(K[Nclick] == match("EPS", labs, nomatch = NOLAB))
          {
              pngfile =  RPMG::local.file("GCplot", "png")
              RPMG::jpng(file=pngfile)
              tagXY =gcreplot()
              dev.off()

            zloc = list(x=NULL, y=NULL)
          }
        ########### ########## ########## ####################
        iloc = locator(1,type='p', pch=3)
##### print(iloc)
        zloc  = list(x=c(zloc$x,iloc$x), y=c(zloc$y, iloc$y))
        Nclick = length(iloc$x)
        if(is.null(zloc$x)) { return(sloc) }
        K =  RPMG::whichbutt(iloc , buttons)
      }

  }

