IDTRACE <-
function(J, WUSE, event, idev=2, newdev=3, EX=0, WHY=0, IASPpath = "/home/lees/Progs/TTIMES")
  {

    if(missing(idev)) { idev=2 }
    if(missing(newdev)) { newdev=3 }
    if(missing(IASPpath)){

     IASPpath = SetIASPhome()
    }

    dev.set(idev)
    u = par("usr")
    DX = 0.05*(u[2]-u[1])
    DY = 0.05*(u[4]-u[3])


    APAL = GPAL()

    dev.set(idev)

    if(missing(EX) | missing(WHY))
      {
    EX = vector()
    WHY = vector()
    L = vector()
    for(j in 1:length(WUSE))
      {

        i = WUSE[j]
        
        dtim = J[[i]]$DATTIM
        dt = J[[i]]$dt
        N = J[[i]]$N
        stn = J[[i]]$sta
        lat = J[[i]]$lat 
        lon = J[[i]]$lon 
        el = J[[i]]$el 
        amp = J[[i]]$amp
        
        dis1 = RSEIS::GreatDist(event$lon, event$lat, lon , lat, EARTHRAD= 6371)
        
        sd1a = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, dtim$jd, dtim$hr, dtim$mi, dtim$sec)
        sd2a = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, dtim$jd, dtim$hr, dtim$mi, dtim$sec+N*dt)


        x = dis1$ddeg
        
        y1 = sd1a
        y2 = sd2a

        NX  = RPMG::RESCALE(amp[1], x-DX/2, x+DX/2, min(amp) , max(amp))
        
        NY  = seq(from=sd1a, length=N, by=dt)
        
        points(NX, y1, col="brown", pch=1)
        EX[i] = NX
        WHY[i] = y1
        

      }

  }

    ###################################
    ###################################


####draw.circ
    
    K = locator(1, type='p', col='purple', pch=4 )
    if(is.null(K) |  !InRect(K$x, K$y, u[1], u[3], u[2], u[4])  )
      {
        return(NULL)
        
      }

    


    
    rrad = (WHY-K$y[1])^2+(EX-K$x[1])^2
    
    pp =  which.min( (WHY-K$y[1])^2+(EX-K$x[1])^2)



    stn = J[[pp]]$sta
    lat = J[[pp]]$lat 
    lon = J[[pp]]$lon 
    el = J[[pp]]$el 
    
      dtim = J[[pp]]$DATTIM
        dt = J[[pp]]$dt
        N = J[[pp]]$N
        stn = J[[pp]]$sta
        lat = J[[pp]]$lat 
        lon = J[[pp]]$lon 
        el = J[[pp]]$el 
        amp = J[[pp]]$amp
        
    slist = list(name=stn, lat=lat , lon=lon,  z= el)



    
    dis1 = RSEIS::GreatDist(event$lon, event$lat, lon , lat, EARTHRAD= 6371)

    
    Aout = TTteles(event, slist, ista = 1, IASPHOME = IASPpath)

    Bout = Aout[[1]]
    SEC = Bout$sec
    PHS = Bout$phase

    
    sd2a = RSEIS::secdif(J[[pp]]$DATTIM$jd,J[[pp]]$DATTIM$hr, J[[pp]]$DATTIM$mi, J[[pp]]$DATTIM$sec,
      event$jd, event$hr, event$mi, event$sec+SEC)



    if(missing(newdev))
      { newdev = dev.new(width=12, height=8) }

    dev.set(newdev)
    
   
    tim = seq(from=0, length=N, by=dt)
    plot(tim , amp, xlab="s", ylab="Amplitude", type='n' )
    title(main=paste(sep=":", J[[pp]]$sta, J[[pp]]$nameID) )


     MCOL = length(sd2a)

    PASTCOL = APAL[1:MCOL]
    
    abline(v=sd2a, col= PASTCOL )
    lines(tim , J[[pp]]$amp)

    u = par("usr")
    
    x = sd2a
    y = rep(u[3], times=length(x) )

    
  
RMAT =    RPMG::textrect(x,y, PHS, xpd=TRUE, add=FALSE, font=1, cex=.8 )


    
    newjitx = RSEIS::jitter.lab(RMAT[,1]  , RMAT[,3]-RMAT[,1])
    y = y+newjitx*(RMAT[,4]-RMAT[,2])
    
    RMAT =    RPMG::textrect(x,y, PHS, xpd=TRUE, add=TRUE, textcol=PASTCOL,  font=1, cex=.8 )

    return(pp)

  }

