PrepGSNdisplay <-
function(JINPUT, WUSE, event, TTCURVES=list(), xlim=c(0,180), ylim=c(0, 4000) )
{
  if(missing(TTCURVES)) TTCURVES=NA
  if(missing(xlim)) xlim=NA
  if(missing(ylim)) ylim=NA

####  must get lat-lon for each trace

  h1 = JINPUT[[1]]
  nams1 = tolower(names(h1))

  glat = grep('lat', nams1)
  glon = grep('lon', nams1)
  
  if(length(glon)>=1 & length(glat>=1) )
  {
      stalat = sapply(JINPUT, '[[', "lat")
      stalon = sapply(JINPUT, '[[', "lon")
      staname = sapply(JINPUT, '[[',"sta")
      
  }
  else
    {


        }
  
 

  
  SD1 = attr(JINPUT, "startT")
  SD2 = attr(JINPUT, "endT")

  if(is.null(SD1))
    {
      for(j in 1:length(WUSE))
        {

          i = WUSE[j]
          
          d = JINPUT[[i]]$DATTIM
          dt = JINPUT[[i]]$dt
          N = JINPUT[[i]]$N
          stn = JINPUT[[i]]$sta
          
          SD1[i] = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, d$jd, d$hr, d$mi, d$sec)
          
          SD2[i] = RSEIS::secdif(event$jd, event$hr, event$mi, event$sec, d$jd, d$hr, d$mi, d$sec+N*dt)


        }
    }

  SD1 = SD1[WUSE]
  SD2 =   SD2[WUSE]

  tlim = range(c(SD1, SD2, na.rm=TRUE))

  if(!is.na(ylim[1]))
    {
      tlim = ylim

    }
  
  AA = RSEIS::GreatDist(event$lon, event$lat, stalon[WUSE] , stalat[WUSE], EARTHRAD= 6371)
deglim =  range(AA$ddeg)
  if(!is.na(xlim[1]))
    {

      deglim = xlim

    }
  
  
  plot(deglim, tlim , type='n', xlab="Distance, deg", ylab="time, sec")

  tmins = pretty(tlim/60)
  tmins.sec= tmins*60
    
  axis(4, at=tmins.sec, labels=tmins, col='blue' )
  mtext("time, min", side=4, line=-1, at=mean(tmins.sec))
  
  if(!is.na(TTCURVES))
    {
      ADDttcurves(TTCURVES)
    }

  return(list(xlim=deglim, ylim=tlim))
}

