TAUP.RAYPATHS<-function(H, PHASE="P", STANAMES=NULL, PLOT=FALSE)
  {
    if(missing(PLOT)) { PLOT=FALSE }
    if(missing(STANAMES)) { STANAMES=NULL }
    if(missing(PHASE)) { PHASE="P" }

    ##  fn = "/home/lees/Site/World/world.leesmap"
    ##  L = setworld(fn)
    worldmap = NULL
    if(PLOT)
        {
            data(worldmap, package='geomapdata' )
            GEOmap::plotGEOmap(worldmap  ,shiftlon=0,  add=FALSE)

        }
    myscan1<-function (string, what = character(0), ...)
        {
          tc <- textConnection(string)
          result <- scan(tc, what = what, quiet = TRUE, ...)
          close(tc)
          return(result)
        }
    
    ddd = dim(H)

    if(ddd[2]==4)
      {

       H =  cbind(H, rep(35, length(ddd[1])))
        
      }
    
    RAYS = vector("list", ddd[1] )

    for(j in 1:ddd[1])
      {
        ## cat(paste("TAUP TEST: " , j), sep="\n")

        

       if(file.exists( "taup_path.gmt"  ) )  file.remove("taup_path.gmt")
        
        taupcmd =  paste(sep=' ', "taup_path -mod iasp91  -ph", PHASE, " -h", H[j,5], "-sta", H[j,1], H[j,2],"-evt", H[j,3], H[j,4])

        cat(taupcmd, sep="  ")
        
        system(taupcmd)

        if(!file.exists("taup_path.gmt")) next
        if(!is.null(STANAMES)) { stn = STANAMES[j] } else { stn=NA }
        
###  system("cat     taup_path.gmt")

       
        TAUP = scan(file="taup_path.gmt", what='',sep="\n", quiet = TRUE)

        if(length(TAUP)<1)
          {
            cat(" NO ")
            cat("\n")
            next
          }
        
        sepline = grep(">", TAUP)

        if(length(sepline)>1)
          {
            ibegs = sepline+1
            iends = c(sepline[(2:length(sepline))]-1, length(TAUP))
          }    else
          {
            ibegs = 2
            iends = length(TAUP)
          }

        #####  we want, at this stage only the first arrival branch
        ####  so, search through and find the one with the
        ####  smallest tt

        mintt = 100000000
        itt = -1
        for(i in 1:length(sepline))
          {
            aline = TAUP[sepline[i]]
            STSPL  = unlist(strsplit(aline, split=' '))
            STSPL=STSPL[STSPL!=""]
            phase = STSPL[2]
            if(length(which(phase==PHASE))<1)next

            ws1 = which(STSPL=="seconds")
            
            tt = as.numeric(STSPL[ws1-1])
            if(tt<mintt)
              {
                mintt=tt
                itt = i
              }
          }
        
       ###  print(paste(sep=' ', j, stn))
       ###  print(c(ibegs))
       ###  print(c(iends))
        
   ###     ONERAY = list()
###  for(i in 1:length(sepline))
        if(itt<1)
          {
        
            ONERAY = NULL
            next
          }
        else
        {

          cat(" YES ")
            cat("\n")
          i = itt
          
          aline = TAUP[sepline[i]]
          STSPL  = unlist(strsplit(aline, split=' '))
          STSPL=STSPL[STSPL!=""]
          
          phase = STSPL[2]
          
          deg  = as.numeric(STSPL[7])
          depth  = as.numeric(STSPL[11])
          tt = as.numeric(STSPL[4])
          rayparam = as.numeric(STSPL[21])
          mod = STSPL[17]

      ###      print(paste(sep=' ', j, stn, i, phase, deg, depth, tt,rayparam ))
          
          TP = TAUP[ibegs[i]:iends[i] ]

          Rpath = myscan1(TP, what=list(d=0, rad=0, lat=0, lon=0) )
          
          if(PLOT) lines( RPMG::fmod(Rpath$lon, 360) , Rpath$lat)
          
            ONERAY = list(sta=stn, phase=phase, tt=tt, deg=deg, depth=depth,  rayparam=rayparam, Rpath=Rpath)
        }
        
        RAYS[[j]] = ONERAY
      }
    
    invisible(RAYS)
  }
