breqrequest<-function(P=list(), sta=list(), ev=list(), fout="BREQ.out", pre=10, post=40 )
  {
    ##  create a breqfast request to send to IRIS DMC
    ##   to extract data

## P is a list of personal information
    ## sta is a list of station information for extraction
stafile = NULL
IASPHOME="~/Progs/TTIMES"

    
    if(missing(P))
      {
        P =
          list(name="Jonathan Lees",
               inst="Geological Sciences, University of North Carolina, CH",
               email="jonathan.lees@unc.edu",
               phone="919 962-1562",
               fax="919 966-4519",
               media = c("FTP","DAT","EXABYTE"),
               label ="seks_data")
      }

    
zz <- file(fout, "w")

NP = names(P)
UP = toupper(NP)

for(i in 1:length(UP))
  {
    cat(file=zz, paste(paste(".", UP[i], sep=""), P[i], sep=" "), sep="\n")

  }
    cat(file=zz, ".END", sep="\n")
  
  G = GETtelesTT(ev, sta, IASPHOME = IASPHOME)
h = grep("SKS", G$phase)

r1 = RSEIS::rangedatetime(G)
r1$min$sec = r1$min$sec-pre*60
r1$max$sec = r1$max$sec+post*60

dmin = RSEIS::recdatel(r1$min)
dmax = RSEIS::recdatel(r1$max)
ddmin  = RSEIS::getmoday(dmin$jd, dmin$yr)
dmin$dom = ddmin$dom
dmin$mo = ddmin$mo
ddmax  = RSEIS::getmoday(dmax$jd, dmax$yr)
dmax$dom = ddmax$dom
dmax$mo = ddmax$mo


for(j in 1:length(stafile$name))
{
if(is.na(stafile$NetworkCode[j])) next

cat(file=zz, paste(stafile$name[j], stafile$NetworkCode[j] , 
dmin$yr, dmin$mo, dmin$dom,dmin$hr, dmin$mi,format(dmin$sec),
dmax$yr, dmax$mo, dmax$dom,dmax$hr, dmax$mi,format(dmax$sec), 3, "BHE","BHN","BHZ"), sep="\n")

}

  close(zz)
       

  }
