iasp91<-function(PLOT=FALSE)
{
  if(missing(PLOT)) {  PLOT=FALSE }
  R = 6371;

  x = c(0, 1217.1  ,3482,  3631,   5611,   5711,5961,  6161,    6251, 6336,   6351,   7371      )

  V = list()

  V[[1]] = list()
  V[[1]]$r = seq(from=x[1], to=x[2], length=100)
  V[[1]]$v = 11.24094 - 4.09689*(V[[1]]$r/R)^2

  V[[2]] = list()
  V[[2]]$r = seq(from=x[2], to=x[3], length=100)
  V[[2]]$v = 10.03904 + 3.75665*(V[[2]]$r/R)-13.67046*(V[[2]]$r/R)^2

  V[[3]] = list()
  V[[3]]$r = seq(from=x[3], to=x[4], length=100)
  V[[3]]$v = 14.49470-1.47089*(V[[3]]$r/R)



  V[[4 ]] = list()
  V[[4 ]]$r = seq(from=x[4], to=x[5], length=100)
  V[[4 ]]$v = 25.1486-41.1538*(V[[4]]$r/R)+51.9932*(V[[4]]$r/R)^2-26.6083*(V[[4]]$r/R)^3

  V[[5 ]] = list()
  V[[5 ]]$r = seq(from=x[5], to=x[6], length=100)
  V[[5 ]]$v = 25.96984-16.93412*(V[[5 ]]$r/R)

  V[[6 ]] = list()
  V[[6 ]]$r = seq(from=x[6], to=x[7], length=100)
  V[[6 ]]$v = 29.38896-21.40656*(V[[6 ]]$r/R)

  V[[7 ]] = list()
  V[[7 ]]$r = seq(from=x[7], to=x[8], length=100)
  V[[7 ]]$v = 30.78765-23.25415*(V[[7 ]]$r/R)

  V[[8 ]] = list()
  V[[8 ]]$r = seq(from=x[8], to=x[9], length=100)
  V[[8 ]]$v = 25.41389-17.69722*(V[[8 ]]$r/R)

  V[[9 ]] = list()
  V[[9 ]]$r = seq(from=x[9], to=x[10], length=100)
  V[[9 ]]$v = 8.78541-0.74953*(V[[9 ]]$r/R)

  V[[10 ]] = list()
  V[[10 ]]$r = seq(from=x[10], to=x[11], length=100)
  V[[10 ]]$v = rep(6.5, times=length(V[[10 ]]$r))

  V[[11 ]] = list()
  V[[11 ]]$r = seq(from=x[11], to=x[12], length=100)
  V[[11 ]]$v =  rep( 5.8, times=length(V[[11 ]]$r))

  if(PLOT)
    {
      plot(x=c(0,14), y=c(0, -6371), type='n', xlab="Velocity(km/s)", ylab="Depth(km)")
      axis(3)
      abline(h= -( R-x  ) , col=grey(.85) )

      for(i in 1:length(V))
        {
          lines( V[[i]]$v,   -(R-V[[i]]$r) , lwd=2)

        }


    }

  invisible(V)
  
}
