label.ttcurves <-
function(TTCURVES, sel=1:2 )
  {
    ####  interactively identify and display information
    ####   or arrivals  on gsn seismic display
    if(missing(sel))
      {
        sel=1:length(TTCURVES)
      }



    upar = par("usr")

   
    ##  which( min((SEC-KLOC$y)^2 (DIS-KLOC$x)^2


    xloc = vector()
    yloc = vector()
    lab = vector()
    tcol = vector()
    
    m = 0
    for(i in 1:length(sel))
      {
      j = sel[i]


      tx = TTCURVES[[j]]$dis
      ty  = TTCURVES[[j]]$sec


      flag = tx>=upar[1] & tx<=upar[2] & ty>=upar[3] & ty<=upar[4]

      
      x = tx[flag]
      y = ty[flag]

      if(length(x)<1 | length(y) < 1 ) next
      
    
     

      
      xloc1 = median(x)

      ij = which.min(abs(x-xloc1))
      
      
      m = m + 1

        lab[m] = TTCURVES[[j]]$phase
      tcol[m] = phaseCOL(lab[m])

      
      xloc[m] = x[ij]
      yloc[m] = y[ij]

    }
      points(xloc, yloc) 
      ##   text(DIS[pp], SEC[pp], labels=PHS[pp], pos=4, xpd=TRUE)
      rmat =  RPMG::textrect(xloc, yloc, lab, textcol = tcol, col = "white", border = tcol,
     off = 0.06, brd = 0.06, pos = 1, log="" , add=TRUE)

    invisible(rmat)
    
  }

