
showIASP91<-function(SCALE=FALSE)
  {
    EARTH = 6371
    
    jcirc = RPMG::circle(1)

    JX = EARTH*jcirc$x
    JY = EARTH*jcirc$y

    giasp = iasp91(PLOT=FALSE)

    i = 1
    vmin = min( giasp[[i]]$v)
    vmax = max( giasp[[i]]$v)

    for(i in 1:length(giasp))
      {
        vmin = min(vmin, giasp[[i]]$v)
        vmax = max(vmax, giasp[[i]]$v)


      }


    ##   rcol = c(topo.colors(60), heat.colors(40))

    rcol = c(RPMG::shade.col(10, acol = c(165, 42,42)/255, bcol = c(.2,.2,.5)),
      RPMG::shade.col(50, acol = c(1, 0, 0), bcol = c(1,1,1)),
      RPMG::shade.col(40, acol = c(1,1,1), bcol = c(0, 0,1 )) )


    
    ##  iseq = seq(from=vmin, to=vmax, length=100)


    

    DO.EARTH()

    ##   Xa = seq(from=min(JX), to=max(JX), length=100)
    ##   Ya = seq(from=min(JY), to=max(JY), length=100)
    
    ##   M = meshgrid(Xa, Ya)


    ##   Zee =  matrix(0, ncol=ncol(M$x), nrow=nrow(M$x))


    
    ##  R = sqrt(  M$x^2+M$y^2 ) 
    
    
    ##  lines(EARTH* jcirc$x,  EARTH* jcirc$y, col = 'black'  )

    for(i in 1:length(giasp))
      {


        r = giasp[[i]]$r
        v = giasp[[i]]$v

        flag =  r <= EARTH


        r = r[ flag ]
        v = v[ flag ]


        icol = floor( RPMG::RESCALE(v, 1, 100, vmin, vmax))
        vcol =  rcol[icol ]
        
        for(j in 1:length(r))
          {

            ##    Zee[R >= r[j-1] & R<=r[j]   ] =  v[j]
            lines(r[j]* jcirc$x, r[j] * jcirc$y, col = vcol[j]  )

          }

      }


    if(SCALE)
      {
        RPMG::ColorScale(c(vmin, vmax) , loc=list(x=range(JX), y=range(JY)), offset=.2 ,
               col = rcol, units = "Veolocity:km/s", font = 1, fontindex = 3, SIDE = 3)
  }



    
  }
