splitGSNnames<-function(fwigs)
  {

    bn = basename(fwigs)


    WDAT = list(fninfo=0,
      yr=0,
      jd=0,
      hr=0,
      mi=0,
      sec=0,
      msec=0,
      net=0,
      stn=0,
      stn2=0,
      comp=0,
      q=0,
      sformat=0)

    for(i in 1:length(bn))
      {
        fninfo = unlist(strsplit(bn[i], split = "\\."))
        WDAT$fninfo[i] = bn[i]
        WDAT$yr[i] = as.numeric(fninfo[1])
        WDAT$jd[i] = as.numeric(fninfo[2])
        WDAT$hr[i] = as.numeric(fninfo[3])
        WDAT$mi[i] = as.numeric(fninfo[4])
        WDAT$sec[i] = as.numeric(fninfo[5])
        WDAT$msec[i] = as.numeric(fninfo[6])
        WDAT$net[i] = fninfo[7]
        WDAT$stn[i] = fninfo[8]
        WDAT$stn2[i] = fninfo[9]
        WDAT$comp[i] = fninfo[10]
        WDAT$q[i] = fninfo[11]
        WDAT$sformat[i] = fninfo[12]
      }


    WDAT$sta = WDAT$stn

    return(WDAT)

  }


