\name{ADDTRACES}
\alias{ADDTRACES}
\title{Add traces to Global Seismic Plot
}
\description{Add traces to Global Seismic Plot
}
\usage{
ADDTRACES(J, WUSE, event, col = rgb(0.7, 0.7, 1))
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{WUSE}{numeric index vector selection of traces to display
}
  \item{event}{Event structure with location and time of source
}
  \item{col}{colors
}
}
\details{add seismic waveform data to seismic display.
  The data might (should) be decimated prior to display for speed.
  The returned tags are only those selected via the WUSE
  vector.
  
}
\value{Graphical Side effects and
  list of locations of first sample:
    \item{x}{x-location (distance, degrees)
}
  \item{y}{y-location (time, s)
  }
\item{COL}{Colors assigned to selected vectors}
\item{IND}{Index in original J list of chosen traces}

  
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{PrepGSNdisplay, GET.TTCURVES, IDTRACE, JSAC.seis
}
\examples{

\dontrun{
wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(
yr=2010,
mo=1,
dom=12,
hr=21,
mi=53,
sec=10.0600	,
lat=18.443,	
lon= -72.571,
mag=7.0	,
depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)



STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)


J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT = -1)

H = addSTAINFO(J, STA)
J = H

stalat = attr(H, "stalat")
staname = attr(H, "staname")

TTCURVES = GET.TTCURVES(Z=event$depth, DIS= seq(from=5, to=180, by=2), IASPHOME=IASPHOME)
WUSE = which(!is.na(stalat) & !duplicated(staname) )
WUSE = sample(WUSE, 20)

dev.set(2)
PrepGSNdisplay(J, WUSE, event, TTCURVES=NA)

DJ = DECIM(J, fh=NA, dec=10)

## tagXY = ADDTRACES(DJ, WUSE, event)

tagXY = ADDTRACES(DJ, WUSE, event, col=NA)

}



}
\keyword{misc}
\keyword{aplot}