\name{ADDttcurves}
\alias{ADDttcurves}
\alias{selTTC}

\title{Add travel time curves
}
\description{Add travel time curves from IASP91 Model
  based on Kennet code.
}
\usage{
ADDttcurves(TTCURVES, sel = 1, col = grey(0.6), flip=FALSE, ...)

selTTC(TTCURVES, sel)

}
\arguments{
  \item{TTCURVES}{list of travel times (output of GET.TTCURVES)
}
\item{sel}{index to select which curves to plot. see below.
  
}
  \item{col}{ colors for plotting curves
  }
  \item{flip}{ If TRUE add DEL v Time, otherwise plotting Time v DEL}
  
\item{...}{ graphical parameters for lines
  }

  
}
\details{
  The selection can be references as a character string code:
  all, P+, Pplus, S+ ,Splus, basic, named.

  ADDttcurves uses  selTTC  for determining which arrivals to select

  DEL(angle) is plotted in degrees.
  
  If data is plotted with Time on the y-axis, use flip=FALSE.
  
}
\value{Graphical Side effects
}
\references{

  Buland, R., and C. H. Chapman (1983). The computation of seismic
  travel times. Bulletin of the Seismological Society of America
  73,1,271 -1,302.

 
  Kennett, B. L. N., and E. R. Engdahl (1991). Traveltimes for global
  earthquake location and phase identification. Geophysical Journal
  International 122,429 -465.
  

  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  Labels for arrival phases can be access or added
  using IDARRIVAL.
}


\seealso{IDARRIVAL
}
\examples{

\dontrun{

DIS  = seq(from=5, to=180, by=5)

TTCURVES = GET.TTCURVES(Z=8, DIS= seq(from=5, to=180, by=2))

plot(c(0,180), c(0, 3500), type='n')

ADDttcurves(TTCURVES, sel = "all" , col = grey(0.6))

plot(c(0,180), c(0, 3500), type='n')

ADDttcurves(TTCURVES, sel = "basic" , col = grey(0.6))

plot(c(0,180), c(0, 3500), type='n')

ADDttcurves(TTCURVES, sel = "P+" , col = grey(0.6))

}




}



\keyword{misc}
