\name{DISPERSION}
\alias{DISPERSION}
\title{Show Dispersion By filtering
}
\description{Fitler traces and estimate dispersion
  
}
\usage{
DISPERSION(y, dt, fl, fh, PLOT = FALSE)
}
\arguments{
  \item{y}{vector of amplitude values
}
  \item{dt}{delta-T, sample time interval, s
}
  \item{fl}{vector of low frequencty cut for BP filter
}
  \item{fh}{vector of high frequencty cut for BP filter
}
  \item{PLOT}{logical, TRUE = plot results
}
}
\details{
  Successive filters are applied to the data and
  the peak energy arrival is estimated as the peak of the hilbert
  transform (envelope) of the waveform.
  
}
\value{vector of sample index where maxima occured
  along trace at the given pass band.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{applytaper,  butfilt, envelope
}
\examples{


\dontrun{
y = J[[pp]]$amp-mean(J[[pp]]$amp)
x = seq(from=0, length=length(y), by= J[[pp]]$dt)

plot(x,y, type='l')

FILT.spread(x, y, J[[pp]]$dt, fl = fl, fh = fh, sfact = 1, WIN = NULL, PLOT = TRUE, TIT = NULL, TAPER = 0.05, POSTTAPER=0.05)

i = 6
dt=J[[pp]]$dt


wwm = DISPERSION(y, dt, fl, fh, PLOT=FALSE)
}


}
\keyword{misc}
