\name{GETtelesTT}
\alias{GETtelesTT}
\title{Get Teleseismic Travel Time
}
\description{Get Teleseismic Travel Time using Tau-P
  
}
\usage{
GETtelesTT(event, slist, IASPHOME = "~/Progs/TTIMES" )
}
\arguments{
  \item{event}{Event structure with location and time of source
}
  \item{slist}{list of stations: name, lat, lon, elev
}
  \item{IASPHOME}{directory path for IASPEI files
}
}
\details{Uses Brian Kennet's Fortran code.
}
\value{
  data frame:
\item{tag}{tag for unique identification of trace}
\item{name}{station name}
\item{comp}{component name}
\item{c3}{three element id}
\item{phase}{phase name}
\item{err}{uncertainity of arrival time}
\item{pol}{polarity}
\item{flg}{flag for location program}
\item{res}{residual fom predicted model}
\item{yr}{year}
\item{mo}{month}
\item{dom}{day of month}
\item{jd}{Julian day}
\item{hr}{hour}
\item{mi}{minute}
\item{sec}{second}
\item{col}{color for plotting}
\item{onoff}{logical, flag whether to plot or not}
\item{cat}{category (usually equal to phase)}

also, attributes:
ystas, yphase, ytimes  for determining which station arrives first
}
\references{
Buland and Chapman (1983) in "The Computation of
Seismic Travel Times", BSSA, v. 73, pp. 1271-1302

}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{This program requires the use of external files and programs.
}


\seealso{TTteles, phaseCOL, BKpfile2ypx, yeardate
}
\examples{

\dontrun{
event=list(yr=2010, mo=1, dom=12, hr=21, mi=53, sec=10.0600,
lat=18.443,lon= -72.571,mag=7.0, depth=13.0, z=13.0)

event$jd = getjul(event$yr, event$mo, event$dom)

data(STA)

#############   example with 2 stations
WW2 = c(  which(STA$NAME=="Albuquerque"  &  STA$CODE=="ANMO" ),
which(STA$NAME=="Longmire"  &  STA$CODE=="LON" ))

 slist = list(name=STA$CODE[WW2], lat=STA$LATITUDE[WW2] , lon=STA$LONGITUDE[WW2],
                      z= STA$ELEVATION[WW2])
  IASPHOME="/home/lees/Progs/TTIMES"
YALL = GETtelesTT(event, slist, IASPHOME =  IASPpath )

print(YALL)

}



}
\keyword{misc}
