\name{GSNplot}
\alias{GSNplot}
\title{Interactive GSN plot
}
\description{Interactive GSN plot
}
\usage{
GSNplot(J, WUSE, event, TTCURVES, labs = c("DONE", "REFRESH"),
IASPpath= "~/Progs/TTIMES", decim = 10,
 FILT=list(fl=1/100, fh=1/10,  type="LP", proto="BU"),filters=NULL ,deglim=c(0,180), tlim=c(0,3000), 
demo = FALSE)
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{WUSE}{numeric index vector selection of traces to display
}
  \item{event}{Event structure with location and time of source
}
  \item{TTCURVES}{List of travel time curves
}
  \item{labs}{labels for RPMG buttons
}
  \item{IASPpath}{path to IASP91 programs and binary vel models for Taup-P
  }
\item{decim}{Decimation factor: select only every decim sample; default=10}
  
  \item{FILT}{list, filter definition; default=list(fl=.2, fh=15,  type="HP", proto="BU")
  }
    \item{filters}{  list of filters (see choosfilt)
}
    \item{deglim}{ x-axis limits in degrees
}
    \item{tlim}{  y-axis limits, sec
}
  
  \item{demo}{logical, TRUE=no interactive
}
}
\details{
  Program uses RPMG to set up buttons and
  interative behavior.  
}
\value{Graphical Side Effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{PrepGSNdisplay, IDTRACE, TTteles, GET.TTCURVES,  ADDTRACES, ADDttcurves


  
}
\examples{
\dontrun{

#### load up station information
 data(STA)
####  get data
J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT = -1)

        J = addSTAINFO(J, STA)
       

GSNplot(J, WUSE,event, TTCURVES ,demo = FALSE )



}


}
\keyword{misc}
