\name{GreatCirclePlot}
\alias{GreatCirclePlot}
\title{Plot great circles
}
\description{Plot great circles on global map.
}
\usage{
GreatCirclePlot(J , event , WUSE=1 ,
              col=rgb(0.7,0.7,1), IASPpath = "/home/lees/Progs/TTIMES",
                            FILT=list(fl=1/100, fh=1/10,  type="LP", proto="BU"),
                            filters=NULL ,   demo = FALSE)
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
  }
   \item{event}{Event structure with location and time of source
}
  \item{WUSE}{Selection index of stations to show
  }

  \item{col}{colors for great circles}
\item{IASPpath}{path to IASP91 programs and binary vel models for Taup-P
  }
 \item{FILT}{list, filter definition; default=list(fl=.2, fh=15,  type="HP", proto="BU")
  }
    \item{filters}{  list of filters (see choosfilt)
}
  
  

  
\item{demo}{demonstration mode (non-interactive) }
   
}
\details{Makes  world map and plots the
  great circles from earthquake source to selected stations.
}
\value{Graphical Side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{getgreatarc, plotworldmap, fixCoastwrap
}
\examples{

\dontrun{

wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(yr=2010,mo=1,dom=12,hr=21,mi=53,sec=10.0600	,
lat=18.443,	lon= -72.571,mag=7.0	,depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)
data(STA)
J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT =-1)
H = addSTAINFO(J, STA, DO.FE=TRUE)
stalat = attr(H, "stalat")
staname = attr(H, "staname")
WUSE = which(!is.na(stalat) & !duplicated(staname) )
WUSE = sample(WUSE, 20)
GreatCirclePlot(H, event, WUSE=WUSE)
}

}
\keyword{misc}