\name{IDTRACE}
\alias{IDTRACE}
\title{Identify Traces
}
\description{Identify seismic traces
  interactively.
}
\usage{
IDTRACE(J, WUSE, event, idev = 2, newdev = 3, EX = 0, WHY = 0, IASPpath = "/home/lees/Progs/TTIMES")
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{WUSE}{numeric index vector selection of traces to display
}
  \item{event}{Event structure with location and time of source
}
  \item{idev}{numeric, device for identification
}
  \item{newdev}{numeric, device for plotting trace
}
  \item{EX}{x, ID tags from ADDTRACES
}
  \item{WHY}{y, ID tags from ADDTRACES
  }

 \item{IASPpath}{path for finding IASP91 information}
  
}
\details{Interactively toggles from main
  plot showing all traces in global display versus
  distance (angle) to close up of
  traces with arrivals shown in detail.
}
\value{Graphical Side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Creats a new window, unless the window is already open
  and user gives the designated numeric index to that device.
}


\seealso{ADDTRACES, PLOT.GEN
}
\examples{

\dontrun{wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(
yr=2010,
mo=1,
dom=12,
hr=21,
mi=53,
sec=10.0600	,
lat=18.443,	
lon= -72.571,
mag=7.0	,
depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)

STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)

J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT = -1)

H = addSTAINFO(J, STA)
J = H
stalat = attr(H, "stalat")
staname = attr(H, "staname")
WUSE = which(!is.na(stalat) & !duplicated(staname) )

TTCURVES = GET.TTCURVES(Z=event$depth, DIS= seq(from=5, to=180, by=2), IASPHOME=IASPHOME)
DJ = DECIM(J, fh=NA, dec=10)

dev.set(2)
PrepGSNdisplay(J, WUSE, event, TTCURVES=NA)
ADDttcurves(TTCURVES, sel="P+", col=grey(.6) )
WUSE = sample(WUSE, 20)

tagXY = ADDTRACES(DJ, WUSE, event)

 dev.new(width=14, height=6)

dev.set(2)

while(TRUE)
  {
pp = IDTRACE(J, WUSE, event, idev=2, newdev=3, EX=tagXY$x, WHY=tagXY$y)

}
}

}
\keyword{misc}
