\name{J2PICK}
\alias{J2PICK}
\title{Convert GSN list to RSEIS file
}
\description{Convert GSN list to RSEIS file
}
\usage{
J2PICK(J, event, sel, IASPpath = "")
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{event}{Event structure with location and time of source
}
  \item{sel}{numeric index vector selection of traces to display
}
  \item{IASPpath}{new path for IASP91 codes, default is from SetIASPhome
}
}
\details{
  This simply re-arranges the
  list to create a structure (list)
  that RSEIS PICK.GEN code can process interactively.
}
\value{Seismic data structure
  List, see RSEIS
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Colors are chosen via GPAL palette
}


\seealso{PICK.GEN, GPAL, SetIASPhome
}
\examples{

\dontrun{


pp = StationChooser(J, event, WUSE )
staname[pp]
J2PICK(J, event, pp)



}




}
\keyword{misc}
