\name{STA}
\alias{STA}
\docType{data}
\title{GSN station meta data

}
\description{
Station location and identification for GSN stations
}
\usage{data(STA)}
\format{
  The format is:
List of 7
 $ CODE     : chr [1:14660] "-A0MA" "034A" "035A" "035Z" ...
 $ LATITUDE : num [1:14660] 46.7 27.1 26.9 26.5 32.5 ...
 $ LONGITUDE: num [1:14660] -106.2 -98.7 -98.1 -98.1 -107.8 ...
 $ ELEVATION: num [1:14660] 897 155 29 19 1652 ...
 $ NETWORK  : chr [1:14660] "LRSM" "USTA" "USTA" "USTA" ...
 $ STATUS   : chr [1:14660] "Closed" "Open" "Open" "Open" ...
 $ NAME     : chr [1:14660] "Subarray A0 LASA" "Hebronville" "Encino" "Hargill" ...
}
\details{
  Downloaded on, Wed Jun  2 11:04:41 EDT 2010,
  read into R and saved.
}
\source{
http://neic.usgs.gov/neis/gis/station_comma_list.asc
}
\references{
http://earthquake.usgs.gov
}
\examples{

\dontrun{
###  this data set was created by reading in the downloaded
##    data from http://neic.usgs.gov/neis/gis/station_comma_list.asc
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)

}


data(STA)
##

 library(geomapdata)
    library(GEOmap)

    data(worldmap)

GEOmap::plotworldmap(worldmap)

points(RPMG::fmod(STA$LONGITUDE, 360) , STA$LATITUDE, pch=6, col='red')



}
\keyword{datasets}
