\name{addSTAINFO}
\alias{addSTAINFO}
\title{Add Station Information
}
\description{Add Station Information to
  list of global Seismic waveform data
}
\usage{
addSTAINFO(JINPUT, STA, origin=list(), DO.FE=FALSE)
}
\arguments{
  \item{JINPUT}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
\item{STA}{Station Data List, namely:
  CODE LATITUDE LONGITUDE ELEVATION NETWORK STATUS NAME
}
\item{origin}{ list of time for the origin time (yr, jd, hr, mi, sec) }
\item{DO.FE}{
  logical, add FE region
  }



}
\details{
  The List of Station information is extracted from
  NEIC ascii data file download from the web.
  
}
\value{
  List of J is returned with
  each element augmented with
  station information from the file.
}
\references{
  See http://earthquake.usgs.gov for information about stations.
  This file is extracted from:
  http://neic.usgs.gov/neis/gis/station_comma_list.asc
  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  The data has been extracted and can be
  accessed in the data file.
}


\seealso{JSAC.seis, 
}
\examples{


\dontrun{
wigdir = "~/XMDEMO_R/HAITI/WIGS"

data(STA, pacakge="TELES" )
J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT =-1 )
H = addSTAINFO(J, STA)


}

}
\keyword{misc}
