\name{phasedoc}
\alias{phasedoc}
\docType{data}
\title{
Global Seismic Phase Explanations
}
\description{
  explanation of seismic phases based on
  IASPEI STANDARD SEISMIC PHASE LIST (DRAFT)
  R.Adams, P.Bormann, R.Engdahl, J.Havskov, B.Kennett, J.Schweitzer, and D.Storchak


}
\usage{data(phasedoc)}
\format{
  The format is:
List of 4
 $ phase: chr [1:138] "Pg" "P*" "Pn" "PnPn" ...
 $ doc  : chr [1:138] "At short distances, etc..." "Either an upgoing P
 wave etc..." "An upgoing P wave from a source etc..." "Pn free surface
 reflection" ...
 $ alias : chr [1:10]  "Pg" "P*" "Pn" "PnPn" ...
 $ aliasind : index to phase
}
\details{
  This is a simple list of phase in one character vector and
  a short explanation in the  other character.

  The alias vector is a set of older names, or
  aliases now defunct (perhaps)
  The aliasind is an index pointer to the current usage in phase and doc
  vectors
  
}
\source{
http://www.iris.edu/data/vocab.htm
}
\references{
At its meeting in Hanoi, August 23, 2001 the IASPEI Commission on Seismological Observation and Interpretation decided to set up a Working Group on Standard Seismic Phase List. The final product of the WG is supposed to be recommended by the IASPEI for use in data exchange between seismic observatories, local, regional, and international data centres. The members of the WG are (in alphabetical order): R.Adams, P.Bormann, R.Engdahl, J.Havskov, B.Kennett, J.Schweitzer, and D.Storchak (Chairman).
}
\examples{
data(phasedoc)


RPMG::butdoc(phasedoc$phase, phasedoc$doc )

##############  to see aliases and older names:
RPMG::butdoc(phasedoc$alias, phasedoc$doc[phasedoc$aliasind] )





}
\keyword{datasets}
