\name{splitGSNnames}
\alias{splitGSNnames}
\title{Split IRIS/GSN station names
}
\description{Extract the elements of a
  downloaded IRIS/DMC GSN file name from
  SEGY or SAC format
}
\usage{
splitGSNnames(fwigs)
}
\arguments{
  \item{fwigs}{vector of file names 
}
}
\details{Splits the names and returns a data frame
  or list of the elements.
}
\value{list:
  \item{fninfo}{file name}
  \item{yr}{year}
  \item{jd}{julian day}
  \item{ mi}{minutes}
  \item{sec}{seconds}
  \item{msec}{mseconds}
  \item{net}{network ID}
  \item{stn2 }{second station ID}
  \item{comp}{component}
  \item{q}{quality, Q=quality controlled, R=Raw}
  \item{sformat}{data format}
  \item{sta}{station name}
}
\references{
  http://www.iris.edu/data
  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  down load the data, convert using rdseed.
}


\seealso{JSEGY.seis, JSAC.seis
}
\examples{

\dontrun{
 wigdir = "/home/lees/XMDEMO_R/CHILE/WIGS3"
fwigs = list.files(path=wigdir, pat="BHZ", full.names="TRUE")

WDAT = splitGSNnames(fwigs)

##   data.frame(WDAT)
names(WDAT)



}






}
\keyword{misc}
