cat("sourcing /home/lees/Progs/R_stuff/CAZI.R\n")

#  source("/home/lees/Progs/R_stuff/CAZI.R")
#  source("/home/lees/Progs/R_stuff/net.R")

# labs = c("Quit","Next", "P", "T1", "S", "T2")

#  Z = doCAZI(j, T1pf)   LabelBAR(u, 5, labs)  print(ValBAR(u, 5,locator(1)) )


#  graphics.off()
#  X11()
#  X11()
#  X11()
#                       seeoneM
#   W1  = doGetAZ(Mpf) 
#   W1  = doGetAZ(goodies) 

#  doCAZI(9, T1pf)  doCAZI(25, T1pf)   doCAZI(44, T1pf)   doCAZI(49, T1pf)   


# T2pf = scan(file="/home/beer/lees/Coso/Scat_Data/S4T2.pfiles", what="")
# T2Wf_paste(substring(T2pf, 1, nchar(T2pf)-1), "W", sep="")


# T1pf = scan(file="/home/beer/lees/Coso/Scat_Data/S4T1.pfiles", what="")
# T1Wf_paste(substring(T1pf, 1, nchar(T1pf)-1), "W", sep="")

plotBAR<-function(u, n)
{

	dx = (u[2]-u[1])*0.03
	dy = (u[4]-u[3])*0.1

	for(j in 1:n)
	{
	px1 = u[1]
	px2 = u[1]+dx
	py1 = u[4]-j*dy-dy
	py2 = py1+dy
	rect(px1 ,py1 ,px2, py2, col=j, border = NULL, lwd = -1 )
	}	

}


####################################
SortAZ<-function(FLS)
{

  KL = length(FLS)
  AZ = matrix(NA, ncol=3, nrow=KL)

  for(i in 1:KL)
    {
      pfile = FLS[i]
      a1 = getUWwin(pfile)
       if(length(a1$data)<=1) { next(); }
      B = distaz( a1$evla[1],a1$evlo[1] ,  a1$stla[1] , a1$stlo[1] )
      AZ[i, ] = c(B$az, a1$evla[1], a1$evlo[1])

    }

  OAZ = order(AZ[, 1])
  return(OAZ)
}
################
doGetAZ<-function(FLS)
{

graphics.off()
X11(); X11();

   labs = c("Quit", "Next", "P", "T1", "S", "T2")
   r = as.list(FLS)	
   
   for(j in 1:length(FLS))
	{
          pfile = FLS[j];
          a1 = getUWwin(pfile)
          if(length(a1$data)<=1) { next(); }
         dev.set(which = 2)
          par(mfrow=c(2,1))
	#  here we plot the focal mechanism radiation patterns
	seeMech(pfile)
                                        # COSOmap(cmp)
          COSOmap(cmp, EQS=eqs, STA=stas)
          
          points(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), pch=c(8,6) )
          lines(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), col=2 )
          
          dev.set(which=3)
          
          Z  = CAZI(a1, 50, 1, 0.1)

	# Z = doCAZI(j, FLS)

         
	# print(Z$azpar)
	u = Z$azpar$usr
 	LabelBAR(u, length(labs), labs)
	K = 0
    #   DP = c(med, mn, q1, q2, med, mn, q1, q2, med, mn, q1, q2 )

        PSTRUCT = list(P=c(NaN, NaN), T1=c(NaN, NaN), S=c(NaN, NaN), T2=c(NaN, NaN))
	DMAT = matrix(rep(NA, 12*4), ncol=12)

	while(K!=1 & K!=2)
	{


        
	W = locator(n=1, type="p", pch="+", col=2)
	
	K = ValBAR(u, length(labs) ,W)
	print(paste(sep=" ", "K=", K, "Pick Type=", labs[K]))

	if(K==1) break
	if(K==2) break

	J = K-2
        W = locator(n=2, type="p", pch="+", col=3)
	if( W$x[1] < min(Z$aex) ) next	
	if( J>4 || J <1) next

	locid = Z$aex>W$x[1] & Z$aex<W$x[2]
  #   print(paste("MAX MIN:", min(Z$aex[locid]), max(Z$aex[locid])))

	angles = Z$aaz[locid]
        angles2 = MOD(2*angles, 360)
        

        DMAT[J, 1] = median(angles2$rem)/2
        DMAT[J, 2] = mean(angles2$rem)/2
        DMAT[J, 3] = quantile(angles2$rem, 0.25)/2
        DMAT[J, 4] = quantile(angles2$rem, 0.75)/2

     
         angles = Z$ai[locid]
         angles2 = MOD(2*angles, 360)

        
        DMAT[J, 5] = median(angles2$rem)/2
        DMAT[J, 6] = mean(angles2$rem)/2
        DMAT[J, 7] = quantile(angles2$rem, 0.25)/2
        DMAT[J, 8] = quantile(angles2$rem, 0.75)/2


        DMAT[J, 9] = median(Z$rateig[locid])
        DMAT[J, 10] = mean(Z$rateig[locid])
        DMAT[J, 11] = quantile(Z$rateig[locid], 0.25)
        DMAT[J, 12] = quantile(Z$rateig[locid], 0.75)

	segments(  min(Z$aex[locid]), DMAT[J, 1], max(Z$aex[locid]), DMAT[J, 1], col=(J+1))

        PSTRUCT[[J]] = c(min(Z$aex[locid]), max(Z$aex[locid]))
        
        }
	# W = locator(2)
	#  print(W)

	r[[j]] = list(name = FLS[j], DMAT=DMAT, picks=PSTRUCT)
	print(DMAT)
        if(K==1) break 
	}

return(r)

}
################
###
###  AMPS = AutoGetAmps(Mpf)

AutoGetAmps<-function(FLS)
{

   KLS = length(FLS)
   r = 	matrix(rep(NA, KLS*4), ncol=4, nrow=KLS)

   for(j in 1:KLS)
	{
          pfile = FLS[j];
          a1 = getUWwin(pfile)
          if(length(a1$data)<=1) { next(); }
          picks = c(a1$p[1], a1$T1[1], a1$s[1],  a1$T2[1])
          picks[picks==(-999.0)] = NA
          JI = 1:4
          JI[is.na(picks)] = NA
          dt = a1$info$dt[1]
          for( J  in 1:4)
            {

              if(is.na(JI[J])) { next(); }
              W = c(picks[J], picks[J]+50*dt)
              nbaz = a1$data[ a1$t>=W[1] & a1$t<W[2] , ]
              r[j, J ] = max(sqrt(nbaz[,1]^2+nbaz[,2]^2+nbaz[,3]^2))
              
              
            }
        
        }
   return(r)

}


#  source("/home/lees/Progs/R_stuff/CAZI.R")
AutoGetAZ<-function(FLS, ask=FALSE, PS=TRUE)
{
  if(missing(ask)) { ask=FALSE; }
  if(missing(PS))  { PS=FALSE; }

  # print(paste(sep=" ", "ask=", ask, "PS=", PS))

                                        # graphics.off()
                                        # X11(); X11();

  labs = c("P", "T1", "S", "T2")
  r = as.list(FLS)	
  
  for(j in 1:length(FLS))
    {
      pfile = FLS[j];
      
      PSFileName1 = paste(sep=".",  pfile ,"AZDIR.ps")
      PSFileName2 = paste(sep=".",  pfile ,"pmot.ps")
      
      
      print(paste(sep=" ", "WORKING ON FILE:", pfile, j, "out of ", length(FLS))) 
      PSTRUCT = list(P=c(NaN, NaN), T1=c(NaN, NaN), S=c(NaN, NaN), T2=c(NaN, NaN))
      
      AMPSTRUCT = list(P=c(NaN, NaN, NaN), T1=c(NaN, NaN, NaN), S=c(NaN, NaN, NaN), T2=c(NaN, NaN, NaN))
      
      DMAT = matrix(rep(NA, 12*4), ncol=12)
      
      r[[j]] = list(name = FLS[j], DMAT=DMAT, picks=PSTRUCT)
      
      a1 = getUWwin(pfile)
       # print(paste(sep=" ", j, pfile, "done getting UWwin",a1$t[1] , a1$p[1]) )
      if(length(a1$data)<=1) { next(); }

      if(a1$p[1]==(-999))
        {
          next();
        }
      
      if(PS==FALSE){
        dev.set(which=3)
      } else {
        postscript(file = PSFileName1, width=7, height=10, horizontal=FALSE, onefile=FALSE  ,print.it=FALSE)
        
      }

      # print("doing CAZI now")
      
      Z  = CAZI(a1, 50, 1, 0.1)
       # print("done with  CAZI ")
      
      
      picks = c(a1$p[1], a1$T1[1], a1$s[1],  a1$T2[1])
      picks[picks==(-999.0)] = NA
      JI = 1:4
      JI[is.na(picks)] = NA
      
      
      for( J  in 1:4)
	{
          
          if(is.na(JI[J])) { next(); }
          
          
          W = c(picks[J], picks[J]+PWINS[J])
          
          
          if( W[1] < min(Z$aex) ) next	
          if( J>4 || J <1) next
          
          locid= (Z$aex>W[1]) & (Z$aex<W[2])
          
                                        #  print(paste("MAX MIN:", min(Z$aex[locid]), max(Z$aex[locid])))

          angles = Z$aaz[locid]
          angles2 = MOD(2*angles, 360)
          
          DMAT[J, 1] = median(angles2$rem)/2
          DMAT[J, 2] = mean(angles2$rem)/2
          DMAT[J, 3] = quantile(angles2$rem, 0.25)/2
          DMAT[J, 4] = quantile(angles2$rem, 0.75)/2
          
          angles = Z$ai[locid]
          angles2 = MOD(2*angles, 360)
          
          DMAT[J, 5] = median(angles2$rem)/2
          DMAT[J, 6] = mean(angles2$rem)/2
          DMAT[J, 7] = quantile(angles2$rem, 0.25)/2
          DMAT[J, 8] = quantile(angles2$rem, 0.75)/2
          
          DMAT[J, 9] = median(Z$rateig[locid])
          DMAT[J, 10] = mean(Z$rateig[locid])
          DMAT[J, 11] = quantile(Z$rateig[locid], 0.25)
          DMAT[J, 12] = quantile(Z$rateig[locid], 0.75)
          
          segments(  min(Z$aex[locid]), DMAT[J, 1], max(Z$aex[locid]), DMAT[J, 1], col=(J+1), lwd=2)
          
          PSTRUCT[[J]] = c(min(Z$aex[locid]), max(Z$aex[locid]))
          
          
          
        }
      if(PS==TRUE){
        
        dev.off()
            
      }
          
      JK = length(JI[!is.na(JI)])
      
      if(PS==FALSE){
        dev.set(which=2)
      } else {
        postscript(file = PSFileName2, width=7, height=10, horizontal=FALSE, onefile=FALSE  ,print.it=FALSE)
        
      }
          
      nf <- layout(matrix(c(1,2,3,4,5,6),3,2,byrow=TRUE), heights=c(3,3,3), widths=c(3, 3), TRUE)
    
                                        # par(mfrow=c(2,1))
      
                                        #  here we plot the focal mechanism radiation patterns
      seeMech(pfile)
                                        # COSOmap(cmp)
      COSOmap(cmp, EQS=eqs, STA=stas, LAB=lstas)
      
      points(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), pch=c(8,6) )
      lines(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), col=2 )
      xx = range(a1$data[,3])
      yy = range(a1$data[,2])
      dt = a1$info$dt[1]
      
      for( J  in 1:4)
	{
          
          if(is.na(JI[J])) { next(); }
          
          
                                        # W = c(picks[J], picks[J]+2*PWINS[J])
          W = c(picks[J], picks[J]+50*dt)
          
          if( W[1] < min(Z$aex) ) next	
          if( J>4 || J <1) next
          
          nbaz = a1$data[ a1$t>=W[1] & a1$t<W[2] , ]
          pmotion(nbaz, 3, 2 , labs=c("Vertical", "North", "East"), xlim=xx, ylim=yy, tit=labs[J])
          
                                        # AMPS  = 
        }
      
      if(PS==TRUE)
        {
          dev.off();
        }
                                        # W = locator(2)
                                        #  print(W)
      
      r[[j]] = list(name = FLS[j], DMAT=DMAT, picks=PSTRUCT)
                                        #print(DMAT)
      if(ask) { locator(1); }
      
    }
  
  return(r)
  
}
#####################################################
Rsection<-function(LPF, COMP=1)
  {

    if(missing(COMP)) { COMP=1 }

    K = length(LPF)

    jar = list()
    gd = rep(0,K)
    gbeg = rep(0,K)
    gend = rep(0,K)

    for(i in 1:K)
      {
        pfile = LPF[i]
        ain = getUWwin(pfile)
        if(length(ain$data)<=1) { next(); }
        if(COMP==1)
          {
            h = ain$data[,1]
          }
        if(COMP==2)
          {
            h = ain$data[,2]
          }
        if(COMP==3)
          {
            h = ain$data[,3]
          }
        if(COMP==4)
          {
            h = sqrt(ain$data[,2]^2+ain$data[,3]^2)
          }
       
        lat2=ain$evla[1]
        lon2=ain$evlo[1]
        lat1=ain$stla[1]
        lon1=ain$stlo[1]
        depth = ain$evel[1]
        GD1  = distaz(lat2, lon2, lat1, lon1) 
        GD2  = GreatDist( lon2,  lat2,  lon1, lat1)

        gd[i] = sqrt(GD2$dkm^2+depth^2)
        gbeg[i] = ain$tbeg+min(ain$t)
        gend[i] = ain$tbeg+max(ain$t)
        # print(paste(sep=" ", ain$pfil, gd[i], gbeg[i], gend[i]))
        jar[[i]] = list(pfil=ain$pfil,  dt=ain$info$dt[1],
             tbeg=ain$tbeg,  az=GD1$baz, dis=GD2$dkm ,
             lat1=lat1, lon1=lon1, lat2=lat2, lon2=lon2 ,
             edepth=depth, p=ain$p[1], s=ain$s[1] , T1=ain$T1[1] , T2=ain$T2[1] ,  h=h )
      }

    dw = .015 
    plot(c(0-dw,1+dw ), c(0,1),  type="n", axes=FALSE, xlab="", ylab="")

    sgd = order(gd)
    
    
    for(j in 1:K)
      {
        i = sgd[j]
        sid = MOD(j, 2)
        d1 = dw+(gd[i]-min(gd))/(max(gd)-min(gd) )
        h = jar[[i]]$h
        ppic = jar[[i]]$p/jar[[i]]$dt
         spic = jar[[i]]$s/jar[[i]]$dt
        T1pic = jar[[i]]$T1/jar[[i]]$dt
         T2pic = jar[[i]]$T2/jar[[i]]$dt    
        t =  seq(0, length(h)-1, by=1)
        t1 = (gbeg[i]-min(gbeg))/(max(gend)-min(gbeg))
        tw = (gend[i]-gbeg[i])/(max(gend)-min(gbeg))
        
        ax  = RESCALE(h , d1-dw , d1+dw, min(h), max(h))
        ty  = RESCALE(t, t1, t1+tw, 0,length(h)-1 )

        ty1=ty[1]
        ty2=ty[length(ty)]
        
        lines(ax, ty, type='l', col=1)


        ax  = RESCALE(c(max(h), min(h)) , d1-dw , d1+dw, min(h), max(h))
        ty  = RESCALE(c(ppic, ppic), t1, t1+tw, 0,length(h)-1 )

        # lines(ax, ty, type='l', col=4)
        points(ax[2], ty[2], pch=5, col=4)
        
        ty  = RESCALE(c(spic, spic), t1, t1+tw, 0,length(h)-1 )

       # lines(ax, ty, type='l', col=2)
        points(ax[2], ty[2], pch=5, col=2)

        ty  = RESCALE(c(T1pic, T1pic), t1, t1+tw, 0,length(h)-1 )

       # lines(ax, ty, type='l', col=2)
        points(ax[2], ty[2], pch=1, col=3)

        ty  = RESCALE(c(T2pic, T2pic), t1, t1+tw, 0,length(h)-1 )

       # lines(ax, ty, type='l', col=2)
        points(ax[2], ty[2], pch=1, col=3)
        
        
        ax  = RESCALE((max(h)+ min(h))/2 , d1-dw , d1+dw, min(h), max(h))
        if(COMP==4)
          {
        ax  = RESCALE((min(h)) , d1-dw , d1+dw, min(h), max(h))
          }
        if(sid$rem==0)
          {
            ty  = ty1
              text(ax, ty, labels=i, col=1, pos=1)
          }else
        {
          ty  = ty2
            text(ax, ty, labels=i, col=1, pos=3)
        }
        
      
        
      }

    
    ex = pretty(c(min(gd), max(gd)), n=8)
    
    ax  = RESCALE(ex ,0-dw, 1+dw , min(gd), max(gd))
    axis(1, at=ax, labels=ex)


    ex = pretty(c(min(gbeg), max(gend)), n=8)
    
    ax  = RESCALE(ex ,0, 1 , min(gbeg), max(gend))
    axis(2, at=ax, labels=ex)


    
    # print(gd)
    
    
    
  }


#####################################################

getUWwin<-function(PF)
{
  pfile = PF

  wfile = paste(substring(pfile, 1, nchar(pfile)-1), "W", sep="")

   # cmand_paste("dump1sta  S4 SHV P -0.3 2 ", PF[i], T1Wf[i], sep=" ")
  cmand=paste("dump1sta  S4 SHV P -0.3 2 ", pfile, wfile, sep=" ")

 #  print(cmand)

  system(cmand)
  system("cat asc.info asc.data > ASC.IN ")

  h1<-scan("ASC.IN", n=19*3, quiet=TRUE, list(pfil="",id="",sec=0, psec=0, sta="",comp="",
                       n=0, dt=0, p=0, s=0, evla=0, evlo=0, evel=0,
                       stla=0, stlo=0,stel=0, az=0, T1=0, T2=0) )


  if(length(h1$pfil) == 0 )
    {
      a1 = list(pfil=pfile, data=0, t=0, sta="", comp="",
        info=list(dt=0, fn="", sec=0),
        p=0, s=0, T1=0, T2=0, az=0,
        evla=0, evlo=0 , evel=0, stla=0, stlo=0,stel=0   )
      return(a1)
    }

  h2<-matrix( scan(file="ASC.IN", quiet=TRUE,  skip=3)  ,ncol=3,nrow=h1$n[1])

  rseis = grotseis(-S4.ang, flip=TRUE)
  ascd= h2 %*% rseis

  t = h1$dt[1]*seq(0,h1$n[1]-1)
  
  tbeg = h1$psec[1]-h1$p[1]-h1$sec[1]

  # print(paste(sep=" ", pfile, tbeg))
  
  a1 = list(pfil=pfile, data=h2, t=t,   sta=h1$sta[1], comp=h1$comp,
    info=list(dt=h1$dt, fn=h1$pfil, id=h1$id,   sec=h1$sec, psec=h1$psec),
    p=h1$p, s=h1$s, T1=h1$T1, T2=h1$T2, az=h1$az,
    evla=h1$evla, evlo=h1$evlo , evel=h1$evel,
    stla=h1$stla, stlo=h1$stlo,stel=h1$stel, tbeg=tbeg   )

  return(a1)

}
#####################################################
slider.rot<-function(a1)
{

ascd=a1$dat
tt <- tktoplevel()
bb<-1
img <-tkrplot(tt, function() srot(ascd, bb))
f<-function(...) {
    b <- as.numeric(tclvalue("bb"))
    if (b != bb) {
        bb <<- b
        tkrreplot(img)
    }
}
s <- tkscale(tt, command=f, from=0, to=360, variable="bb",length=300,
             showvalue=FALSE, resolution=1.0, orient="horiz")
tkpack(img,s)


}



doCAZI<-function(i, PF)
{
  ##X##   run CAZI and COSOmap in tandem
  ##X##  i = index to list
  ##X##  PF = list of pick files

  
pfile = PF[i]


a1 = getUWwin(pfile)
  if(length(a1$data)<=1) { next(); } 
dev.set(which=3)

# COSOmap(cmp)
COSOmap(cmp, EQS=eqs, STA=stas)

points(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), pch=c(8,6) )
lines(c(a1$evlo[1], a1$stlo[1]),c(a1$evla[1], a1$stla[1] ), col=2 )

dev.set(which=4)

aa = CAZI(a1, 50, 1, 0.1)

return(aa)
}
###################################################################################
###################################################################################
###################################################################################

#########################################
setCOSOmap<-function(FN, eqs=NULL)
{
##X##  set up coso map
  
loc = paste(sep="", FN, "/*.spmap")
c1 = paste(sep=" ", "ls -1" , loc, " > coso.rmap")
system(c1)
  
cmap = scan("coso.rmap", what='')
cosomap.lat=as.list(cmap)
cosomap.lon=as.list(cmap)
cosomap.kind=as.list(cmap)
cosomap.name=as.list(cmap)

for(i in 1:length(cmap))
{
 kay=strsplit(cmap[i], "\\.")
 nm = strsplit(kay[[1]][1], "\\/")
 len = length(nm[[1]])

 
 cosomap.kind[[i]] = as.numeric(kay[[1]][2])
 cosomap.name[[i]] = (nm[[1]][len])
 
map1=scan(file=cmap[i], list(x=0, y=0))
cosomap.lat[[i]]=map1$x
cosomap.lon[[i]]=map1$y
}
par(mfrow=c(1,1))
   plot(unlist(cosomap.lon), unlist(cosomap.lat), xlab="Lon", ylab="Lat", type="n")
   for(i in 1:length(cosomap.lon))
   {
   lines(unlist(cosomap.lon[i]), unlist(cosomap.lat[i]))
   }
if(!missing(eqs))
  {
points(eqs$lon, eqs$lat)
}

print("CLICK IN THE MAP TO DETERMINE THEW ZOOM")
yl = locator(2)

rect(yl$x[1] ,yl$y[1] , yl$x[2],  yl$y[2] , col=NULL, border = NULL, lwd = -1 )

zoom = list(x=range(yl$x), y=range(yl$y))

return(list(lat=cosomap.lat,   lon=cosomap.lon, kind=unlist(cosomap.kind), name=unlist(cosomap.name), ZM=zoom ) )

}
#########################################
COSOmap<-function(cmp, EQS=NULL, STA=NULL, LAB=NULL)
{
##X##   plot a map of the Coso Geothermal region
##X##  
##X##   cmp = map structure
##X##   EQS  = structure of earthquakes
##X##   STA  = structureof stations
##X##   LAB = I don't know


  
  DX = cmp$ZM$x
  DY = cmp$ZM$y

  #  Y-direction km
  #  D1 = GreatDist(DX[1],DY[1], DX[1],  DY[2])
  #  X-direction km
  #  D2 = GreatDist(DX[1],DY[1], DX[2],  DY[1])

  #  Y-direction km
  D1 = GreatDist(DX[1],DY[1], DX[1],  DY[1]+1)
  #  X-direction km
  D2 = GreatDist(DX[1],DY[1], DX[1]+1,  DY[1])

  ASPRAT = D1$dkm/D2$dkm

  plot(unlist(cmp$lon), unlist(cmp$lat), asp=ASPRAT, xlab="", ylab="", xlim=cmp$ZM$x, ylim=cmp$ZM$y, type="n")
  
  for(i in 1:length(cmp$lon))
    {
      if(cmp$kind[i] == 1)
        {
          points(unlist(cmp$lon[i]), unlist(cmp$lat[i]))
        }
      if(cmp$kind[i] == 2)
        {
          lines(unlist(cmp$lon[i]), unlist(cmp$lat[i]))
        }
      if(cmp$kind[i] == 3)
        {
          polygon(unlist(cmp$lon[i]), unlist(cmp$lat[i]), col=gray(.95))
        }


      
    }

  
  if( !missing(EQS))
    {
      points(EQS$lon, EQS$lat)
    }

  if( !missing(STA))
    {
      points(STA$lon, STA$lat, pch=6, cex=1.5)
    }
  if( !missing(LAB))
    {
      text(LAB$lon, LAB$lat, labels=LAB$name, pos=2)
    }

                                        # lines(fault$x, fault$y, lwd=2, col=4)

}

###################################################################################
###################################################################################
###################################################################################
CAZI<-function(ain, len, shift, p )
{
   ##X##  set up mainly for Coso (UW) data  
  ##X## #  particle motion estimator
  ##X## #    len=window length   shift=10 samples  p=pre-event offset(0.1)
  ##X##   
##X##  #    ain = output of getUWwin(pfile)  structure described there       
##X##  len = length of analysis window
 ##X##  shift = shift between windows
 ##X## p = pre-event window for estimating noise stuff
  
	opar=par(no.readonly = TRUE)
	alen=length(ain$data[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$data


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
	
  	aex=rep(0,alen)
 	aaz=rep(0,alen)
  	ai=rep(0,alen)
  	rateig=rep(0,alen)

	winlen=len*dt
 	winn=len
  	winhalf=winn/2
	k = winn/2
   	wincen=ex[k]-ex[1]	
   	wina=(wincen/dt)-winhalf
    	winb=(wincen/dt)+winhalf
  
  	k=len/2
  	j=1
  

  # 	xtics=pretty(seq(from=min(ex), to=max(ex), N=10))
  	xtics=pretty(ex, n=10)


	mintic=min(xtics)
	maxtic=max(xtics)

  	# for each trace, find pre-event DC offset and remove that from the whole trace
	# do not remove the mean again below, that would be wrong

  	ax=1:length(ex)

	#   here we determine a limit on X

  	flagax = ax[ex<p]
  	tem=dat[ flagax ,]
  	mns=apply(tem,2,mean)
  	dtem=sweep(dat, 2, mns)

  while(k<(alen-len/2))
    {
      wincen=ex[k]-ex[1]
      wina=round((wincen/dt)-winhalf+1)
      winb=round((wincen/dt)+winhalf+1)
      
      winb=min(winb,alen)
      #    print(c(wina, winb))

      tem=dtem[wina:winb,]
					# need to remove the mean value from each column (we did this above)
					#    NO:  tem=sweep(tem, 2, apply(tem,2,mean))
      
      covtem=t(tem) %*% (tem)
      eg=eigen(covtem, symmetric = TRUE )
					# Be=winn*diag(1,nrow=3) + matrix(c(-1,1,1,1,-1,1,1,1,-1),nrow=3)*covtem
					# Beg=eigen(Be)
      
					# Kappa<-log(Beg$values[1]/Beg$values[2])/log(Beg$values[2]/Beg$values[3])
      
      
      aex[j]=ex[k]
      ## rateig[j]=sqrt( eg$values[2]^2 + eg$values[3]^2 ) / eg$values[1]


      ##  Joydeep recommends using the following measure of rectilinearity
      ## jepsen and kennett, 1990, bssa, 80b, #6, 2032-2052.

      rateig[j]= 1 - ((eg$values[2]+eg$values[3])/(2*eg$values[1]))


      
					#  rateig[j]=Kappa

      #   careful here: be sure the azimuth below is calculated in the N-E-Down coordinate system
#   1=Z   2=N   3=E
#  this means that the real azimuth is 90-alpha  where alpha is the counter-clockwise
#  coordinate angle derived below

      alpha=RAD2DEG*atan(eg$vectors[2,1], eg$vectors[3,1])

       az<-90-alpha


      inci=RAD2DEG*atan(eg$vectors[1,1], sqrt(eg$vectors[2,1]^2+eg$vectors[3,1]^2))


### convert angles so that they are orientations as shiftnd not simply directions
###  this is because the direction is irrelevant and -10deg=170deg orientation

      if(az<0) az=az+180

      aaz[j]=az
      if(inci<0)inci=abs(inci)
      ai[j]=inci
      
      k=k+shift
      j=j+1
    }
  jall=j-1
  
#  dev.set(which=2)
#########   old: par(mfrow=c(6, 1) )
  par(mfrow=c(6, 1) )
  par(mai=c(0.1, .5, 0.1, 0.5) )
  for(i in 1:3)
    { 
      plot(ex,dat[,i], axes=FALSE, xlab="",ylab="", type="n")
      lines(ex,dat[,i],type="l")
      axis(1,tck=.03,at=xtics,lab=FALSE)
      # axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])
      tcomp = fixcompname(comp[i])
     
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
       plot.ps(ain)
       plot.t1t2(ain)
      
      letter.it(i,2)
      
    }	
  i=3
  locy=0.8*max(ascd[,i])
					#  locy=0.95*min(dat[,i])
					# text(max(ex), locy, paste(ain$fil, ain$pfil,ain$id, ain$sec,sep=" : ") , cex=.8,  adj=1, col=3)
  
#######  NOW plot New Stuff  ############################
##  this switches to the other opened window

##    dev.set(which=3)
##  par(mfrow=c(3, 1) )
##   par(mai=c(0.0, .5, 0.1, 0.5) )
  par(mai=c(0.1, .5, 0.1, 0.5) )



#####    INC ANGLE
  
  plot(aex[0:jall],ai[0:jall],xlim=range(ex),ylim=c(0,90),type="n",  axes=FALSE, xlab="",ylab="IncAng, deg")
        lines(aex[0:jall],ai[0:jall],type="l")
					#   abline(h=c(0))
					#   axis(2, las=1)
 #  axis(2, at=c(-60, -30,0,30 , 60), tck=1, las=1, lty=2, lwd=0.5)
axis(2, at=seq(0,90, by=10), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   plot.ps(ain)
   plot.t1t2(ain)
  
   letter.it(4,2)
  box()

  incpar<-par()

  figinc=par("fig")
  
####  RATIO
  

  plot(aex[0:jall],rateig[0:jall],xlim=range(ex),type='n',  axes=FALSE, xlab="",ylab="RatEig")
        lines(aex[0:jall],rateig[0:jall], type='l')
  locy=0.8*max(rateig[0:jall])
  
  axis(2, las=1)
  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))
  axis(3,at=xtics,tck=.03,lab=FALSE)
  mtext( paste(fil) , line=0.1)
  
   plot.ps(ain)
   plot.t1t2(ain)
  box()
   letter.it(5,2)
#####   Azimuth
   par(mai=c(0.2, .5, 0.15, 0.5) )

  plot(aex[1:jall],aaz[1:jall],xlim=range(ex),ylim=c(0,180),axes=FALSE, xlab="Time, s",ylab="Az, deg")

 # axis(2, at=c(-150,-100, -50,0,50, 100, 150), tck=1, las=1, lty=2, lwd=0.5)
  axis(2, at=seq(0,180, by=20), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  AZ<- ain$az[1]

  if(AZ>180) AZ<-AZ-360
					# abline(h=c(0))
  abline(h=c(AZ),lty=4, col=2)
    #   locy=0.8*max(aaz[0:jall])
  locy=165
  text(max(xtics), locy, paste("AZ=",format.default(AZ, digits=3)) ,adj=1, cex=1.2, col=2)
  box()
  

   plot.ps(ain)
   plot.t1t2(ain)

 #  plot.medbars(ain,aex[1:jall], aaz[1:jall]   )

   figaz=par("fig")
   usraz=par("usr")
  
     locy=0.9*min(aaz[0:jall])
 	#   locy=-165
  m=max(aex[0:jall])
  segments( m-winlen, locy, m , locy, lwd=3)
  
   letter.it(6,2)
  azpar<-par()
  # dev.prev()

  #  invisible(par(opar))
  #   par(opar)
  list(aex=aex[1:jall], rateig=rateig[1:jall], aaz=aaz[1:jall], ai=ai[1:jall], figaz=figaz, azpar=azpar, incpar=incpar )	
}

####################################################
TESTBAR<-function()
{
  ##X##  test making a bar across the top of the window
labs = c("Quit", "Next", "P", "T1", "S", "T2")
plot(1:10, 1:10)
u = par("usr")
LabelBAR(u, length(labs), labs)


 #  print(ValBAR(u, length(labs) ,locator(1)) )
   for(j in 1:5)
	{

    plot(1:10, 1:10, main=j)
	u = par("usr")
	LabelBAR(u, length(labs), labs)

	K = 0	
	while(K!=1 & K!=2)
	{
	K = ValBAR(u, length(labs),locator(1))
	print(K)
	if(K==1) 
	{
	print("break")
	break
	}
	if(K==2) next


	  }
        if(K==1) break 

	}	
}


#########################################
fixcompname<-function(comp)
  {
##X## convert wierd component names to something more useful for seismic

    tcomp = "XXX"
    if(comp=="SHV"|| comp=="4"|| comp=="1" || comp=="V" || comp=="v" || comp=="G1V") { return("Vertical") }
    if(comp=="SHN"|| comp=="5"|| comp=="2" || comp=="N" || comp=="n" || comp=="G1N") { return("North") }
    if(comp=="SHE"|| comp=="6"|| comp=="3" || comp=="E" || comp=="e" || comp=="G1E") { return("East") }

    

 return(tcomp)
  }
#########################################
########
PLTpicks<-function(picks, labs=NA, cols=NA)
{
##X##  plot a list of picks on a seismogram
##X## 
##X##   picks = vector of times relative to the start of the plot (seismogram)
##X##   labs = labels to plot next to picks
  ##X##  cols = vector of colors to plot line and label
  
  if(missing(labs)) { labs = NA }
  if(missing(cols)) { cols = NA }

  u=par("usr")
     pyt=u[4]-0.05*(u[4]-u[3])
     for(i in 1:length(picks))
     {
       if(!is.na(cols))
         {
           col=cols[i]
         }
       else
         {
           col = 1
         }
       abline(v=picks[i], col=col, lty=3)
       if(!is.na(labs)) { text( picks[i], pyt, labs[i], adj=0, col=col) }
     }
     

}

#############################################
############################################
############################################ source("/home/lees/Progs/R_stuff/CAZI.R")

GAZI<-function(ADAT, dt=1, ex=seq(0, 100), comp=c(4,5,6), sta="ZZZ", az=0, len=50, shift=10, prev=1, fileid="", picks=NA, labs=NA )
{
##X##    particle motion estimator
##X## INPUT:
##X##     ADAT = N by 3 matrix of three component seismic data
##X##     dt = deltat  sample interval (s)
##X##     ex = time values for X axis
##X##     comp  = components
##X##     sta = station name
##X##     az = azimuth from source to reciever
##X##     len = length of sliding window (samples)
##X##     shift = shift of each window (samples)
##X##     prev = pre-event window for calculation of noise average
##X##     fileid = character string identifying the event (yy:mm:hh:mi:se, for example)
##X##     picks = vector of times relative to the start for lines to be drawn
##X##     labs = vector of labels for the picks lines
  

       if(missing(dt)) { dt=1 }
       if(missing(ex)) { ex=seq(from=0, length=dim(ADAT)[1], by=dt) }
       if(missing(len)) { len=50 }
       if(missing(shift)) { shift=10 }
       if(missing(comp)) { comp=c(4,5,6) }
       if(missing(sta)) {  sta="ZZZ"}
       if(missing(az)) {  az=0 }
       if(missing(prev)) {  prev=1 }
       if(missing(fileid)) { fileid=" " }
       if(missing(picks)) { picks=NA  }
       if(missing(labs)) {  labs=NA  }




	opar=par(no.readonly = TRUE)
	alen=length(ADAT[,1])
	dt=dt
	ex = ex

	dat = ADAT

	ascd = ADAT
	
  	aex=rep(0,alen)
 	aaz=rep(0,alen)
  	ai=rep(0,alen)
  	rateig=rep(0,alen)

	winlen=len*dt
 	winn=len
  	winhalf=winn/2
	k = winn/2
   	wincen=ex[k]-ex[1]	
   	wina=(wincen/dt)-winhalf
    	winb=(wincen/dt)+winhalf
  
  	k=len/2
  	j=1
  

  # 	xtics=pretty(seq(from=min(ex), to=max(ex), N=10))
  	xtics=pretty(ex, n=10)


	mintic=min(xtics)
	maxtic=max(xtics)

  	# for each trace, find pre-event DC offset and remove that from the whole trace
	# do not remove the mean again below, that would be wrong

  	ax=1:length(ex)

	#   here we determine a limit on X

  	flagax = ax[ex<prev]
  	tem=dat[ flagax ,]
  	mns=apply(tem,2,mean)
  	dtem=sweep(dat, 2, mns)

  while(k<(alen-len/2))
    {
      wincen=ex[k]-ex[1]
      wina=round((wincen/dt)-winhalf+1)
      winb=round((wincen/dt)+winhalf+1)
      
      winb=min(winb,alen)
      #    print(c(wina, winb))

      tem=dtem[wina:winb,]
					# need to remove the mean value from each column (we did this above)
					#    NO:  tem=sweep(tem, 2, apply(tem,2,mean))
      
      covtem=t(tem) %*% (tem)
      eg=eigen(covtem, symmetric = TRUE )
					# Be=winn*diag(1,nrow=3) + matrix(c(-1,1,1,1,-1,1,1,1,-1),nrow=3)*covtem
					# Beg=eigen(Be)
      
					# Kappa<-log(Beg$values[1]/Beg$values[2])/log(Beg$values[2]/Beg$values[3])
      
      
      aex[j]=ex[k]
      ## rateig[j]=sqrt( eg$values[2]^2 + eg$values[3]^2 ) / eg$values[1]


      ##  Joydeep recommends using the following measure of rectilinearity
      ## jepsen and kennett, 1990, bssa, 80b, #6, 2032-2052.

      rateig[j]= 1 - ((eg$values[2]+eg$values[3])/(2*eg$values[1]))


      
					#  rateig[j]=Kappa

      #   careful here: be sure the azimuth below is calculated in the N-E-Down coordinate system
#   1=Z   2=N   3=E
#  this means that the real azimuth is 90-alpha  where alpha is the counter-clockwise
#  coordinate angle derived below

      alpha=RAD2DEG*atan(eg$vectors[2,1], eg$vectors[3,1])

       az<-90-alpha


      inci=RAD2DEG*atan(eg$vectors[1,1], sqrt(eg$vectors[2,1]^2+eg$vectors[3,1]^2))


### convert angles so that they are orientations as shiftnd not simply directions
###  this is because the direction is irrelevant and -10deg=170deg orientation

      if(az<0) az=az+180

      aaz[j]=az
      if(inci<0)inci=abs(inci)
      ai[j]=inci
      
      k=k+shift
      j=j+1
    }
       
  jall=j-1
  
#  dev.set(which=2)
#########   old: par(mfrow=c(6, 1) )
  par(mfrow=c(6, 1) )
  par(mai=c(0.1, .5, 0.1, 0.5) )
  for(i in 1:3)
    { 
      plot(ex,dat[,i], axes=FALSE, xlab="",ylab="", type="n")
      lines(ex,dat[,i],type="l")
      axis(1,tck=.03,at=xtics,lab=FALSE)
      # axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

      tcomp = fixcompname(comp[i])
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)


      if(!is.na(picks)) { PLTpicks(picks, labs) }
      
       ###  plot.ps(ain)    ###  plots the P and S lines on the graph
        ###   plot.t1t2(ain)
      
      letter.it(i,2)
      
    }	
  i=3
  locy=0.8*max(ascd[,i])
					#  locy=0.95*min(dat[,i])
					# text(max(ex), locy, paste(ain$fil, ain$pfil,ain$id, ain$sec,sep=" : ") , cex=.8,  adj=1, col=3)
  
#######  NOW plot New Stuff  ############################
##  this switches to the other opened window

##    dev.set(which=3)
##  par(mfrow=c(3, 1) )
##   par(mai=c(0.0, .5, 0.1, 0.5) )
  par(mai=c(0.1, .5, 0.1, 0.5) )



#####    INC ANGLE
  
  plot(aex[0:jall],ai[0:jall],xlim=range(ex),ylim=c(0,90),type="n",  axes=FALSE, xlab="",ylab="IncAng, deg")
        lines(aex[0:jall],ai[0:jall],type="l")
					#   abline(h=c(0))
					#   axis(2, las=1)
 #  axis(2, at=c(-60, -30,0,30 , 60), tck=1, las=1, lty=2, lwd=0.5)
axis(2, at=seq(0,90, by=10), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)

   if(!is.na(picks)) { PLTpicks(picks, labs) }
       
  ### plot.ps(ain)
  ### plot.t1t2(ain)
  
   letter.it(4,2)
  box()

  incpar<-par()

  figinc=par("fig")
  
####  RATIO
  

  plot(aex[0:jall],rateig[0:jall],xlim=range(ex),type='n',  axes=FALSE, xlab="",ylab="RatEig")
        lines(aex[0:jall],rateig[0:jall], type='l')
  locy=0.8*max(rateig[0:jall])
  
  axis(2, las=1)
  axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))
  axis(3,at=xtics,tck=.03,lab=FALSE)
  mtext( paste(fileid) , line=0.1)
     if(!is.na(picks)) { PLTpicks(picks, labs) }
   ### plot.ps(ain)
   ### plot.t1t2(ain)
  box()
   letter.it(5,2)
#####   Azimuth
   par(mai=c(0.2, .5, 0.15, 0.5) )

   azims =     fmod(aaz[1:jall], 180)

  plot(aex[1:jall], azims ,xlim=range(ex),ylim=c(0,180),axes=FALSE, xlab="Time, s",ylab="Az, deg")

 # axis(2, at=c(-150,-100, -50,0,50, 100, 150), tck=1, las=1, lty=2, lwd=0.5)
  axis(2, at=seq(0,180, by=20), tck=1, las=1, lty=2, lwd=0.5)
  axis(3,at=xtics,tck=.03,lab=FALSE)
   axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  AZ=  fmod(az, 180)

###    if(AZ>180) AZ<-AZ-360
					# abline(h=c(0))
  abline(h=c(AZ),lty=4, col=2)
    #   locy=0.8*max(aaz[0:jall])
  locy=165
  text(max(xtics), locy, paste("AZ=",format.default(AZ, digits=3)) ,adj=1, cex=1.2, col=2)
  box()
  
   if(!is.na(picks)) { PLTpicks(picks, labs) }
  ### plot.ps(ain)
 ###   plot.t1t2(ain)

 #  plot.medbars(ain,aex[1:jall], aaz[1:jall]   )

   figaz=par("fig")
   usraz=par("usr")
  
     locy=0.9*min(aaz[0:jall])
 	#   locy=-165
  m=max(aex[0:jall])
  segments( m-winlen, locy, m , locy, lwd=3)
  
   letter.it(6,2)
  azpar<-par()
  # dev.prev()

  #  invisible(par(opar))
  #   par(opar)
  invisible(list(aex=aex[1:jall], rateig=rateig[1:jall], aaz=aaz[1:jall], ai=ai[1:jall], figaz=figaz, azpar=azpar, incpar=incpar ))	
}
