
####Here is an example that
####--creates an image of a bright square on a dark background
####--centres the spectrum using Gonzalez and Wintz method
####--creates image plots of uncentred and centred amplitude spectra

####example of 2D amplitude spectrum

##### sample image:
w<-5 #width of central square
m=w
xn<- 128; yn<- 128
im<- matrix(0,nrow=yn,ncol=xn)
xc<-floor(xn/2)+1;
yc<- floor(yn/2)+1 # centers of the image
im[(-m:m)+xc,(-m:m)+yc]<- 1
fftim<-fft(im)

im2<- matrix(0,nrow=yn,ncol=xn)
#centres spectrum: Gonzalez & Wintz (1977) Digital Image Processing p.53
im2<-im * (-1)^(row(im) + col(im))
fftim2<-fft(im2)


##  postscript(file ="2dfft.ex1.ps" , onefile=FALSE, print.it=FALSE)

par(mfrow=c(2,2),pty='s')
cmap = topo.colors(50)

image(im, col=cmap); title('im=Original image')
image(Mod(fftim), col=cmap); title('Mod(fft(im))')
image(Mod(fftim2), col=cmap) ; title('Centred Mod(fft(im))')
image(log10(Mod(fftim2)), col=cmap) ; title('Centred LogMod(fft(im))')

dev.off()



#####################################################

 t = seq(0, 6, by=0.001)
#   % sample rate = 1000 Hz, 0.001 seconds 601 samples
 x = 6*sin(2*pi*50*t) + 10* sin(2*pi*120*t)



xn<- 128;
yn<- 128
im2<- matrix(0,nrow=yn,ncol=xn)
w1 = 4
w2 = 10
A1 = 6
A2 = 10
im3<- A1*sin(2*pi*w1*(row(im2)/yn)) + A2*sin(2*pi*w2*(col(im2)/xn))

cmap = heat.colors(50)
cmap = rainbow(50)
cmap = topo.colors(50)


# im3<- A1*sin(2*pi*w1*(row(im2)/yn)) * A2*sin(2*pi*w2*(col(im2)/xn))
# im3<- A1*sin(2*pi*w1*(row(im2)/yn)*2*pi*w1*(col(im2)/xn))  ##  weird

##  postscript(file ="2dfft.ex2.ps" , onefile=FALSE, print.it=FALSE)


im3<- A1*sin(2*pi*w1*(row(im2)/yn + (col(im2)/xn)  ))+A2*sin(2*pi*w2*(col(im2)/xn))

par(mfrow=c(2,2))
image(im3 , col = cmap ); title('im=Original image')


im4<-im3 * (-1)^(row(im3) + col(im3))

fftim<-fft(im3)
image(Mod(fftim), col = cmap); title('Mod(fft(im3))')

fftim4<-fft(im4)
image(Mod(fftim4), col = cmap); title('Mod(fft(im4))')
abline(v=0.5)
abline(h=0.5)

image(log10(Mod(fftim4)), col = cmap); title('LOGMod(fft(im4))')
abline(v=0.5)
abline(h=0.5)

dev.off()


###################
### postscript(file ="2dmods.ex3.ps" , onefile=FALSE, print.it=FALSE)
par(mfrow=c(2,2))
##  now add in a high frequency additional noise
im3<- A1*sin(2*pi*w1*(row(im2)/yn + (col(im2)/xn)  ))+A2*sin(2*pi*w2*(col(im2)/xn))
image(im3 , col = cmap ); title('im=Original image')

im3<- im3 + 12*sin(2*pi*25*(row(im2)/yn + (col(im2)/xn)  ))
image(im3 , col = cmap ); title('im=Original image + high freq')


## and add in some randome noise

im3<- im3+ matrix(rnorm(ncol(im3)*nrow(im3), 0, 20), ncol=ncol(im3), nrow=nrow(im3))
image(im3 , col = cmap ); title('im=Original image+HF+noise')


dev.off()



##  postscript(file ="2dfft.ex3.ps" , horizontal=FALSE, onefile=FALSE, print.it=FALSE)

par(mfrow=c(2,2))
par(xaxs='i', yaxs='i')

image(im3 , asp=TRUE, col = cmap , axes=FALSE); title('im=Original image+noise')
axis(1, xaxs='i')
axis(2, yaxs='i')
# box()


im4<-im3 * (-1)^(row(im3) + col(im3))
fftim<-fft(im3)
fftim4<-fft(im4)

image(Mod(fftim),   asp=TRUE, col = cmap , axes=FALSE); title('Mod(fft(im3))')
axis(1, xaxs='i')
axis(2, yaxs='i')
# box()

image(Mod(fftim4),   asp=TRUE, col = cmap , axes=FALSE); title('Mod(fft(im4))')
axis(1, xaxs='i')
axis(2, yaxs='i')
# box()

abline(v=0.5)
abline(h=0.5)
###  plot it on a log scale
image(log10(Mod(fftim4)),   asp=TRUE, col = cmap , axes=FALSE); title('LOG(Mod(fft(im4)))')
axis(1, xaxs='i')
axis(2, yaxs='i')
# box()

abline(v=0.5)
abline(h=0.5)

dev.off()





#####################################################


w<-5 #width of central square
xn<- 128; yn<- 128
im<- matrix(0,nrow=yn,ncol=xn)

xc<-floor(xn/2)+1;
yc<- floor(yn/2)+1 # centers of the image


im[(-m:m)+xc,(-m:m)+yc]<- 1
fftim<-fft(im)
#####################################################

library(pixmap)

#########  x <- read.pnm(system.file("pictures/logo.ppm", package="pixmap")[1])

#####  to read in images in R you need to first make sure they are in the format that
#####  R can understand.
#####  Convert the files to PNM format - in LINUX use the display function or the

#####  display
#####  xv
#####  tifftopnm

#####  xv function or convert to get a new file that is in pnm format
#####  pnm stands for portable anymap
#####  but it also goes by other names:
#####  ppm  = portable pixmap ?
#####  pgm =
#####  pbm = ? bitmap? black-white?
#####  
#####  from the R-search:
#####  "If you can convert your image to a portable anymap, then read.pnm() in the
#####  pixmap package should do this. On Linux/Unix the NetPBM program tifftopnm
#####  does the conversion, ImageMagick convert does it, and many bitmap graphics
#####  applications will too. "

yum  <- read.pnm("/home/lees/CLASS/Data_Analysis/dos_files/YUMA4.pnm")

str.rast = read.pnm("/home/lees/Figures/stromb_raster.ppm")
plot(str.rast)

#####
you can then digitize and do other stuff to these images.

###  extract teh data from the image
matyum = slot(yum, "grey")
## or
matyum = yum@grey

fftim = fft(matyum)

yum2<-matyum * (-1)^(row(matyum) + col(matyum))
fftim2<-fft(yum2)


par(mfrow=c(2,2),pty='s')
image(matyum); title('im=Original image')
image(Mod(fftim)); title('Mod(fft(im))')
image(Mod(fftim2)) ; title('Centred Mod(fft(im))')
plot(yum)


image(Mod(fftim2)) ; title('Centred Mod(fft(im))')
#####################################################
