

g = runif(2048+9)
dt = 1
t = seq(from=0, by=dt, length=length(g))

plot(t,g, type='l')

###  smooth with a nine point filter
fil = rep(1,length=9)

h = hanning.window(10);
## convolve this with the input signal y

hx = convolve(g, h, type="filter");
hx = hx-mean(hx)


plot(t[1:length(hx)],hx, type='l')
#############

### zero pad h
kh = c(h-mean(h), rep(0, 2048-length(h)))
##  spectrum(kh-mean(kh))
ker = naive(kh-mean(kh),1, LOG='y', PLOT=FALSE)
plot(ker$f, 20*log(ker$Syy/max(ker$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0) )

spectrum(h)


#####  duplicate figure 11.4 in Karl:
hx = hx-mean(hx)

par(mfrow=c(2,2))

###  this is with a hanning taper:  z = hx[1:64]*hanning.window(64);
z = hx[1:64]*hanning.window(64);

per = naive(z,1, LOG='y', PLOT=FALSE)
plot(per$f, 20*log(per$Syy/max(per$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0) )
title("DFT with 64 samples")

z = hx[1:128]
per = naive(z,1, LOG='y', PLOT=FALSE)
plot(per$f, 20*log(per$Syy/max(per$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("DFT with 128 samples")

z = hx[1:256]
per = naive(z,1, LOG='y', PLOT=FALSE)
plot(per$f, 20*log(per$Syy/max(per$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("DFT with 256 samples")

z = hx[1:1024]
per = naive(z,1, LOG='y', PLOT=FALSE)
plot(per$f, 20*log(per$Syy/max(per$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("DFT with 1024 samples")

par(mfrow=c(1,1))
################################
####### decibel = 10*log(amplitude ratio) (for power spectra)
####### or        20*log(amplitude ratio) (for amplitude spectra)

z = hx[1:256]
par(mfrow=c(2,2))
spectrum(z)
spectrum(z, spans=3)
spectrum(z, spans=c(3,5))
spectrum(z, spans=c(5,7))

################################
###  smoothing by sub-sampling the time series
K = floor(length(hx)/256)-1
dlen =  256

BIGPER  = rep(0, length(per$Syy))
for(i in 1:K)
{
a1 = (i-1)*256+1
a2 = a1+255
print(c(a1,a2))
Z = hx[a1:a2]
PER = naive(Z,1, LOG='y', PLOT=FALSE)
BIGPER = BIGPER+PER$Syy
}

par(mfrow=c(2,1))

BIGPER = BIGPER/length(K)
plot(per$f, 20*log(BIGPER/max(BIGPER)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("DFT with smoothing")
################################


####  welch's method
lh = length(hx)
dlen =  256
olap =  100
shif =  100
tapwin = hanning.window(dlen);

## initialize
k=0
a1 = 1
a2 = a1+dlen-1
Z = hx[a1:a2]*tapwin
PER1 = naive(Z,1, LOG='y', PLOT=FALSE)
BIGPER = PER1$Syy
k = k+1

## start loop
while(a2<(lh-dlen))
{
a1 = a1+shif
a2 = a1+dlen-1
print(c(a1,a2))
Z = hx[a1:a2]*tapwin
PER = naive(Z,1, LOG='y', PLOT=FALSE)
BIGPER = BIGPER+PER$Syy
###   print(BIGPER)
k=k+1
}

BIGPER = BIGPER/k

par(mfrow=c(2,2))
plot(PER1$f, 20*log(PER1$Syy/max(PER1$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("1 DFT taper with NO smoothing")

ALL = hx*hanning.window(length(hx))
PERALL = naive(ALL,1, LOG='y', PLOT=FALSE)
plot(PERALL$f, 20*log(PERALL$Syy/max(PERALL$Syy)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("ALL taper with NO smoothing")

plot(PER$f, 20*log(BIGPER/max(BIGPER)), type='l', xlab="Freq", ylab="dB", ylim=c(-300,0))
title("Welch's method with smoothing and taper")


#####################################################
#####################################################

###  for welch's method in R use:

X = hx
rwelch =    stft(X, win=min(80,floor(length(X)/10)), inc=min(24, floor(length(X)/30)), coef=64, wtype="hanning.window")

this give a matrix which is a spectrogram
can get the averaged time series
by 

KK = apply(rwelch$values, 2, FUN="mean")

plot(KK, log='y')
#####################################################
#####################################################
