###  R function for calculating the auto-correlation function

data(sunspots)
attributes(sunspots)

A = acf(sunspots, lag.max=200)

data(lynx)

ccf(sunspots, lynx)
##############################################
##############################################

y1 = rep(0, 100)
y2 = y1
z = rnorm(25)
y1[(8+1):(8+25)] = z
y2[(18+1):(18+25)] = z

xcor2(y1, y2, DT=1, PLOT=TRUE)

y1A = y1+rnorm(length(y1), mean=0, sd=.2)
y2A = y2+rnorm(length(y2), mean=0, sd=.2)

xcor2(y1A, y2A, DT=1, PLOT=TRUE)

y1B = y1+rnorm(length(y1), mean=0, sd=.5)
y2B = y2+rnorm(length(y2), mean=0, sd=.5)

xcor2(y1B, y2B, DT=1, PLOT=TRUE)



##############################################
##############################################


######## interpolating irregular spaced data

make some data:

plot(c(0, 10), c(4,10), type="n")
g = locator(10, type='p')


plot(g$x, g$y, type="p")

alin = approx( g$x,  g$y, seq(from=min(g$x), to=max(g$x),  length=100) , method = "linear"  )
lines(alin$x, alin$y)

aspl = spline(g$x,  g$y, xmin=min(g$x), n=100, method = "fmm")
lines(aspl$x, aspl$y)

plot(aspl$x, aspl$y, type='l')
points(g$x, g$y)
points(aspl$x, aspl$y, col=2)
points(alin$x, alin$y, col=3)

###########################


Jlynx = approx( time(lynx), lynx, seq(from=min(time(lynx)), to=max(time(lynx)),  by=1/12) , method = "linear"  )

Tlynx = ts(Jlynx$y, start=min(Jlynx$x), deltat=1/12)

YY = c( rep(0, length=12*(min(Jlynx$x)-min(time(sunspots)))) , Jlynx$y, rep(0, 12*(max(time(sunspots))-max(Jlynx$x))))

Tlynx = ts(YY, start=min(time(sunspots)), frequency=12)


W = findInterval( range(Jlynx$x), time(sunspots) )


sun1 = sunspots[c(W[1]:W[2])]





xcor2<-function(a1, a2, DT, PLOT=FALSE, LAG=100)
{
  if(missing(PLOT)) { PLOT=FALSE }

  n1 = length(a1)
  n2 = length(a2)
  n = max(c(n1,n2))

  ts1 = c(a1-mean(a1), rep(0,n-n1))
  ts2 = c(a2-mean(a2), rep(0,n-n2))
  
  b1 = ts(ts1, deltat=DT)
  b2 = ts(ts2, deltat=DT)
  
  if(PLOT==TRUE)
    {
      par(mfrow = c(3,1))  

    }
  if(missing(LAG)) { LAG=round(n/4) }

  xc =ccf(b1, b2, lag.max = LAG , type ="correlation",  plot = FALSE )
  
  if(PLOT==TRUE)
    {
      EX = DT*(1:n)
      plot(DT*(1:n), ts1, xlab="time, s", type = 'l')
      plot(DT*(1:n), ts2, xlab="time, s", type = 'l')
      k = which.max(ts2)
      mlag = xc$lag[which.max(xc$acf)]
      gex = k+mlag/DT
      if(gex>0 & gex<=n)
        {
          segments(EX[k], ts2[k], EX[gex], ts2[k], col=rgb(1,0,0))
          abline(v=EX[gex], col=rgb(1,0,0), lty=2)
        }
      else
        {
          segments(EX[n/2], ts2[k], EX[(n/2)+mlag/DT], ts2[k], col=rgb(1,0,0))
        }
      plot(xc)
      points(xc$lag[which.max(xc$acf)], max(xc$acf), col=2)
    }
  return(xc)
}


##############################################
##############################################

x = c(2,3,5,9,3,5)
mx = mean(x)
xb = (x - mean(x))/sqrt(var(x))
ac = rep(0,length(xb))
n = length(x)

v1 = var(x)
v2 = sum( (x-mx)^2)
V = sum(xb*xb)/(n)
V2 = var(x)

for(i in 1:n)
{
tau = i-1

c1 = sum(x[i:n] * x[1:(n-i+1)])
Yt = mean(x[i:n])
Ytau = mean(x[1:(n-i+1)])

cv1 = (c1-Yt*Ytau)/(n-tau)
cv2 = ((n-tau)*c1 - (sum(x[i:n])*sum(x[1:(n-i+1)]))) / ((n-tau)*(n-tau-1))
cv2 = cv2/V2

c3 = (c1 - (n-tau)*Yt*Ytau)/(n-tau-1) / v1

rk = sum((x[i:n]-mx)*(x[1:(n-i+1)]-mx))/v2

k = n-1
print(k)
###  the following gets you the same function as the acf function in R
ac[i] = sum(xb[i:n] * xb[1:(n-i+1)])/k
print(paste(cv1, cv2, c3, rk, ac[i]))


print(paste("A",  paste((i:n), collapse=' ')))
print(paste("B", paste((1:(n-i+1)), collapse=' ')))
}

n = length(x)
plot(c(1, 12), c(0,7), type='n')
abline(h=0:7, lty=2)

sx = (x-min(x))/(max(x)-min(x))
sx = 0.9*(x/max(x))

plot(c(1, 12), c(0,7), type='n', axes=FALSE, xlab='', ylab='')
abline(h=0:6, lty=2)

segments(1:(n), rep((6),length=n), 1:(n), (6)+sx, col=4)
points(1:(n), (6)+sx, col=4)

for(i in 1:5)
{
segments(i:(n+i-1), rep((n-i),length=n), i:(n+i-1), (n-i)+sx)
points(i:(n+i-1), (n-i)+sx, col=2)
}

title("Illustrating the autocorrelation function", ylab="Lag", xlab="Time")
axis(1)
axis(2, at=0:5, labels=5:0)
box()




