################################
plot.default<-function(x, y = NULL, type = "p", xlim = NULL, ylim = NULL,
    log = "", main = NULL, sub = NULL, xlab = NULL, ylab = NULL,
    ann = par("ann"), axes = TRUE, frame.plot = axes, panel.first = NULL,
    panel.last = NULL, col = par("col"), bg = NA, pch = par("pch"),
    cex = 1, lty = par("lty"), lab = par("lab"), lwd = par("lwd"),
    asp = NA, ...)
{
    xlabel <- if (!missing(x))
        deparse(substitute(x))
    ylabel <- if (!missing(y))
        deparse(substitute(y))
    xy <- xy.coords(x, y, xlabel, ylabel, log)
    xlab <- if (is.null(xlab))
        xy$xlab
    else xlab
    ylab <- if (is.null(ylab))
        xy$ylab
    else ylab
    xlim <- if (is.null(xlim))
        range(xy$x[is.finite(xy$x)])
    else xlim
    ylim <- if (is.null(ylim))
        range(xy$y[is.finite(xy$y)])
    else ylim
    plot.new()
    plot.window(xlim, ylim, log, asp, ...)
    panel.first
    plot.xy(xy, type, col = col, pch = pch, cex = cex, bg = bg,
        lty = lty, lwd = lwd, ...)
    panel.last
    if (axes) {
        axis(1, ...)
        axis(2, ...)
    }
    if (frame.plot)
        box(...)
    if (ann)
        title(main = main, sub = sub, xlab = xlab, ylab = ylab,
            ...)
    invisible()
}
