###########  %   script for doing regression analysis

#####  set up on "Fri Feb 18 13:17:41 2005"

N = 25

x = rnorm(n=N, 10, 5)

x = sort(x)

b1T = -5;
b0T = 70;

y = b0T + b1T*x ;


plot(x, y, type='p', col=4 )

y = b0T + b1T*x + runif(n=N, min=-20, max=20) ;


plot(x, y, type='p', col=4 )

sigma = 10;

low = sigma*rep(1, length=length(y))

errorbar<-function(x,y,low, hi, w, col)
{
segments(x, y-low, x, y+hi, col=col)
segments(x-w, y-low, x+w, y-low, col=col)
segments(x-w, y+hi, x+w, y+hi, col=col)

}

plot(x, y, type='p', col=2 )

errorbar(x, y, low, low, 1, 4)

###  OLD fashioned way to solve linear regression:
sumx = sum(x)
sumy = sum(y)
sumxy = sum(x*y)
sumx2 = sum(x^2)
n = length(x)

b1 = (sumxy - (sumx*sumy)/n)/(sumx2-sumx^2/n)

b0 = mean(y) - b1*mean(x)


plot(x, y, type='p', col=2 )
yhat = b1*x+b0
points(x, yhat, col=1)

segments(x[1], yhat[1], x[n], yhat[n], col=4)







library(MASS)

##  %  create design matrix

A = cbind(rep(1, length=length(x)), x)


ATA = t(A) %*%  A ;

ATAinv  = ginv(ATA);

b = ATAinv %*% t(A) %*% y ;

Yhat = A %*% b ;

plot(x,y,type='p', col=2)

points(x,Yhat, col=4)

res = y - Yhat ;

plot(x, res, type='p')

qqnorm(res)


## %%%%%%%%%%%%%%%%%%%%%%%%%%%%

##%   errors on b1 and b0


n = length(x) 
xm = (x-mean(x)) ;

sqxm = sqrt(sum( xm * xm  ) )


Eb1 = sigma/ sqrt(sum( xm * xm  ) )

tv = qt(0.025 , n-2);
###         %   or:
tv = qt(0.975 , n-2);

deltab1 = Eb1*tv ;

###%%%%%%%

x0 = seq(from=min(x), by=0.2, to=max(x))

x0m = x0-mean(x);


yhaterr = tv* sigma*sqrt(1+1/n+ (x0m*x0m)/sum( xm * xm  )) ;


b 
AH = cbind(rep(1, length(x0)), x0)

YUP = AH  %*%  b + yhaterr ;

YLO = AH  %*% b - yhaterr ;

plot(x,y)

lines(x0, YUP, col=3)
lines(x0, YLO, col=3)


###  make your own regression problem

U = locator(10)
x = U$x
y = U$y
