
ternmat<-function(V, LAB=c("1", "2", "3") )
{

#  produce a ternary diagram from
#  a matrix (nX3) and plot using Splus
#  NOTE: the matrix must be normalized to percent (0-1)
#
#  the lower left hand corner is in column 1
#  the lower right and apex is in column 2
#  the top apex is in column 3
#
  #  example: ternmat(y, LAB=c("A", "B", "C"))


  if(missing(LAB))
    {
      LAB=c("1", "2", "3")
    }

  dims=dim(V)
  g=rbind( c(1,0,0), c(0,1,0), c(0,0,1), c(1,0,0))
  
  r=matrix(ncol=2, nrow=dims[1])
  
   for (k in 1:dims[1])
     {
       r[k,1] <- (1-V[k,1]+V[k,2])/sqrt(2);
       r[k,2] <-  sqrt(2/3)*(.5-.5*V[k,1]-.5*V[k,2]+V[k,3]);
     }
  
  
  a=matrix(ncol=2, nrow=4)
   
  for( k in 1:4)
    {
       a[k,1] <- (1-g[k,1]+g[k,2])/sqrt(2);
       a[k,2] <-  sqrt(2/3)*(.5-.5*g[k,1]-.5*g[k,2]+g[k,3]);
     }
  
  plot(a, type="l", xlab="", ylab="", axes=F)
  points(r, pch="+")


  text(a[1,1], a[1,2], LAB[1], pos=2)
  text(a[2,1], a[2,2], LAB[2], pos=4)
  text(a[3,1], a[3,2], LAB[3], pos=3)
  

   r
  
}

