############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
##X##
##X##  generalfunctions for R
##X##


###
cat("sourcing: General.R\n")
### cat("sourcing /home/lees/Progs/R_stuff/.R\n")

###  
ans<-function()
{
##X##  return the last value calculated
return(.Last.value)}
###  
dnext<-function()
{
##X## go to next screen device
dev.set(dev.next())

}
###
par1<-function()
  {
##X## 
    par(mfrow=c(1,1))

  }
###
one<-function()
  {
##X## plot using only one plot per page
    par(mfrow=c(1,1))

  }

ymarginfo<-function(SIDE=1, s1=0.1, s2=0.8)
  {
    ### SIDE = 1, 3 (bottom, top)
    if(missing(SIDE)) { SIDE = 1 }
    if(missing(s1)) { s1=0.1 }
    if(missing(s2)) { s2=0.8 }
    
    u = par("usr")
    fin = par("fin")
    pin = par("pin")

    imarg = (fin[2]-pin[2])/2
    uinch =   (u[4]-u[3])/pin[2]

    if(SIDE==3)
      {
        if(par("ylog")==TRUE)
          {
            y1 = (10^(u[4]+ s1*imarg*uinch))
            y2 = (10^(u[4]+ s2*imarg*uinch))

          }
        else
          {
            y1 = (u[4]+ s1*imarg*uinch)
            y2 = (u[4]+ s2*imarg*uinch)
          }
      }
    else
      {
        if(par("ylog")==TRUE)
          {
            y1 = (10^(u[3]- s1*imarg*uinch))
            y2 = (10^(u[3]- s2*imarg*uinch))

          }
        else
          {
            y1 = ((u[3]- s1*imarg*uinch))
            y2 = ((u[3]- s2*imarg*uinch))
          }



      }

    
    
    return(c(y1, y2))
  }

################################
##  source("/home/lees/Progs/R_stuff/General.R"); save.image()


no.dimnames<-function(a)
  {
##X##    ## Print out a matrix to the screen with no dimension names
##X##    ## (copied from the R-manual )
    d = list()
    l = 0
    for(i in dim(a))
      {
        d[[l<-l+1]]<-rep("", i)
      }
    dimnames(a) = d
    a
  }


################################
color.pr<-function(color="white")
  {
##X##
    usr = par("usr")
    if(par("xlog"))
      usr[1:2] = 10^usr[1:2]
    if(par("ylog"))
      usr[3:4] = 10^usr[3:4]
    rect( usr[1], usr[3], usr[2], usr[4], col=color)

  }
################################
##
##  to change the default plotting of lines vs points, fix this

plot.default<-function(x, y = NULL, type = "p", xlim = NULL, ylim = NULL,
    log = "", main = NULL, sub = NULL, xlab = NULL, ylab = NULL,
    ann = par("ann"), axes = TRUE, frame.plot = axes, panel.first = NULL,
    panel.last = NULL, col = par("col"), bg = NA, pch = par("pch"),
    cex = 1, lty = par("lty"), lab = par("lab"), lwd = par("lwd"),
    asp = NA, ...)
{
##X##
    xlabel <- if (!missing(x))
        deparse(substitute(x))
    ylabel <- if (!missing(y))
        deparse(substitute(y))
    xy <- xy.coords(x, y, xlabel, ylabel, log)
    xlab <- if (is.null(xlab))
        xy$xlab
    else xlab
    ylab <- if (is.null(ylab))
        xy$ylab
    else ylab
    xlim <- if (is.null(xlim))
        range(xy$x[is.finite(xy$x)])
    else xlim
    ylim <- if (is.null(ylim))
        range(xy$y[is.finite(xy$y)])
    else ylim
    plot.new()
    plot.window(xlim, ylim, log, asp, ...)
    panel.first
    plot.xy(xy, type, col = col, pch = pch, cex = cex, bg = bg,
        lty = lty, lwd = lwd, ...)
    panel.last
    if (axes) {
        axis(1, ...)
        axis(2, ...)
    }
    if (frame.plot)
        box(...)
    if (ann)
        title(main = main, sub = sub, xlab = xlab, ylab = ylab,
            ...)
    invisible()
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
###
###



letter.it<-function(a, corn=1)
  {
##X##
##X##    ###  put a letter in a figure
##X##    ###  a = one of 1-26 letters 
##X##    ###  corn = corner 1 2 3 4 = Low-Left UP-Left UP-Right Low-Right
    if(missing(corn)) { corn = 1 }
    letlabs=paste("(", letters,")", sep="")	     
    aa=letlabs[a]
    u=par("usr")
    oce=par("cex")
    par(cex=1.2)
    p1em=par('cin')
    shiftx= (u[2]-u[1])*0.02
    shifty=  (u[4]-u[3])*0.02 

    if(corn==1) {
                                        #	text(u[1]+shiftx*p1em[1],u[3]+shifty*p1em[2]   ,labels=aa,  adj=0)
      text(u[1]+shiftx,u[3]+shifty   ,labels=aa, adj=c(0 ,0.5), xpd=TRUE  )
    }
 
	if(corn==2) {
#	text(u[2]-shiftx*p1em[1],u[3]+shifty*p1em[2]   ,labels=aa,  adj=1)
	text(u[2]-shiftx,u[3]+shifty   ,labels=aa, adj=c(1, 0), xpd=TRUE )
	}

	if(corn==3) {
#	text(u[2]-shiftx*p1em[1],u[4]- shifty*p1em[2]  ,labels=aa,  adj=1)
        text(u[2]-shiftx,u[4]-shifty  ,labels=aa,  adj=c(1, 0.5), xpd=TRUE )
	}
	if(corn==4) {
#	text(u[1]+shiftx*p1em[1],u[4]- shifty*p1em[2] ,labels=aa,  adj=0)
	text(u[1]+shiftx,u[4]-shifty ,labels=aa,  adj=c(0 , 0.5 ), xpd=TRUE )
	}
	par(cex=oce)
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
###
###
label.it<-function(a="", corn=1)
  {	   
##X## put a label in a figure
##X##    ###  corn = corner 1 2 3 4 = Low-Left UP-Left UP-Right Low-Right
    if(missing(corn)) { corn = 1 }
    
	aa=a
	u=par("usr")
        oce=par("cex")
        par(cex=1.2)
	p1em=par('cin')
        shiftx= (u[2]-u[1])*0.02
        shifty=  (u[4]-u[3])*0.02 

	if(corn==1) {
#	text(u[1]+shiftx*p1em[1],u[3]+shifty*p1em[2]   ,labels=aa,  adj=0)
	text(u[1]+shiftx,u[3]+shifty   ,labels=aa, adj=c(0 ,0.5)  )
	}
 
	if(corn==2) {
#	text(u[2]-shiftx*p1em[1],u[3]+shifty*p1em[2]   ,labels=aa,  adj=1)
	text(u[2]-shiftx,u[3]+shifty   ,labels=aa, adj=c(1, 0) )
	}

	if(corn==3) {
#	text(u[2]-shiftx*p1em[1],u[4]- shifty*p1em[2]  ,labels=aa,  adj=1)
        text(u[2]-shiftx,u[4]-2*shifty  ,labels=aa,  adj=c(1, 0.5) )
	}
	if(corn==4) {
#	text(u[1]+shiftx*p1em[1],u[4]- shifty*p1em[2] ,labels=aa,  adj=0)
	text(u[1]+shiftx,u[4]-shifty ,labels=aa,  adj=c(0 , 0.5 ) )
	}
	par(cex=oce)
}
###
###
addtix<-function(side=3, pos=0,   tck=0.005, at=ttics, labels=FALSE, col=2, ...)
  {
 ##X##   add tick marks to plot   
##X## ###     addtix(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=2 )
    if(missing(side)) {  side = 3 }
    if(missing(pos)) {  pos = 0 }
    if(missing(tck)) {  tck = 0 }
    if(missing(at)) {  at = 0 }
    if(missing(labels)) {  labels = FALSE }
    if(missing(col)) {  col = "black" }
    

    n = length(at)
    u = par('usr')
    lines( c(at[1], at[n]), c(pos,pos) , col=col, ...)
    ###  x0, y0, x1, y1
    
    segments(at,pos, at, pos-tck , col=col)

  }
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
   
itoxyz<-function(i, nx, ny, nlay)
  {
  ##X## given a number index in  a vector, get the 3D pixel location   
 ##X## ###  itoxyz(24, 6, 6, 1)
 ##X## ###  itoxyz(24, 6, 6, 1)
    
    

    lentop =nx*ny;
    side = (nx);

    nrem = i %% lentop;

    if(nrem == 0)
      {
        nrem = lentop;
        iz = i/lentop;
      }
    else
      {
        iz= floor(i/lentop) + 1 ;
      }

    iy=floor((nrem-1)/side)+1;
    ix=nrem-(iy-1)*nx;
    if(ix==0)
      { ix=nx;}
    return(list(ix=ix,iy=iy,iz=iz));
    

  }
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
xyztoi<-function(ix, iy, iz, nx, ny, nlay)
  {
##X##  given x, y, z get the vector index

    lentop =nx*ny;
    i = ix + nx*(iy-1)+ (iz-1)*lentop;
    return(i)
  }
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")

jgrid<-function(x,y, col=col)
  {
    nx = length(x)
    ny = length(y)
    segments(rep(x[1], ny), y, rep(x[nx], length(y)), y, col=col)
    segments(x, rep(y[1], nx), x, rep(y[ny], nx) , col=col)
    
  }
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
Fresh.Screens<-function(n)
{
##X## set up n screen devices

  graphics.off()
for(i in 1:n)
  {
    X11()
  }
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
Get.Screens<-function(n)
{
##X## set up n screens for plotting in R
  ##X## if some already exist, just add to existing group
  devl = dev.list()
 j = n-length(devl)
 if(j>0)
   {
for(i in 1:j)
  {
    X11()
  }
}
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
screens<-function(n)
{
 ##X##   set up n screens for plotting in R
  ##X##  
 devl = dev.list()
 j = n-length(devl)
 if(j>0)
   {
for(i in 1:j)
  {
    X11()
  }
}
}

############################################################
###  source("/home/lees/Progs/R_stuff/General.R")

ValBAR<-function(n, v=locator() )
{
 ##X## ###  get a value from 1:n from clicking in the button bar
 ##X## ####  n = number of bins
 ##X## ### v = locator(1)
  u  = par("usr")
  dx = (u[2]-u[1])*0.03
  dy = (u[4]-u[3])*0.1

  px1 = u[1]
  px2 = u[1]+dx

  x = v$x
  y = v$y
 ###   points(x,y,pch=11,col=5)

  

  flagx =x<px1|x>px2

  k = rep(0,length(x))

  j = seq(1,n)
  
  py1 = u[4]-j*dy-dy

  py2 = py1+dy
    
  vec = c( py2[1] , py1 )

  k = n-findInterval(y, rev(vec), all.inside = FALSE)+1

  
  k[k>n | k<=0]=0

  
 k[flagx==TRUE]=0
  

  return(k)
}


############################################################
###  source("/home/lees/Progs/R_stuff/General.R")

LabelBAR<-function(labs)
{
 ##X## ### create a button bar on the side of a plot
  u = par("usr")
  ## print(u)
  n = length(labs)
  
  dx = (u[2]-u[1])*0.03
  dy = (u[4]-u[3])*0.1
  
  for(j in 1:n)
    {
      px1 = u[1]
      px2 = u[1]+dx
      
      py1 = u[4]-j*dy-dy
      py2 = py1+dy
      pty = (py1+py2)/2
      ptx = px2+0.1*dx
      
      rect(px1 ,py1 ,px2, py2, col=j, border = NULL, lwd = -1 )
      text(px2, pty, label=labs[j], adj=c(0, 0) )
      
    }
  return(n)
###   plot(c(0,1), c(0,1))
###  LabelBAR(labs)

  
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")

##############################
rowBUTTONS<-function(labs, col=6, pch=4)
  {
 ##X## set up a row of buttons at the top of the plotting region
    
    if(missing(col)) { col= 6 }
    if(missing(pch)) { pch = 4 }
    
    u = par("usr")
    
    
    ##  v = locator(type='p', pch=4, col=5, xpd=TRUE)
    
    ## points(v$x, v$y, pch=4, col=6)

    NL = length(labs)


    if(par("xlog")==TRUE)
      {
	bx = (u[2] - u[1])*0.2/NL
        px =10^(u[2]-bx*(seq(from=1, to=NL, by=1)))
	
        x2 =10^(u[2]-bx*(seq(from=1, to=NL, by=1)-0.3))
        x1 =10^(u[2]-bx*(seq(from=1, to=NL, by=1)+0.3))

      }
    else
      {
        bx = (u[2]-u[1])*0.045
        px = u[2]-((bx+bx*0.3)*seq(1,NL))
         x1=px-bx/2
        x2=px+bx/2
        
      }

    fin = par("fin")
    pin = par("pin")

    imarg = (fin[2]-pin[2])/2
    uinch =   (u[4]-u[3])/pin[2]

    
    if(par("ylog")==TRUE)
      {
       
        py =  rep(10^(u[4]+ (0.5*imarg*uinch)), NL)
        y1 = rep(10^(u[4]+ 0.1*imarg*uinch), NL)
        y2 = rep(10^(u[4]+ 0.8*imarg*uinch), NL)

      }
    else
      {

        py =  rep((u[4]+ (0.5*imarg*uinch)), NL)
        y1 = rep((u[4]+ 0.1*imarg*uinch), NL)
        y2 = rep((u[4]+ 0.8*imarg*uinch), NL)

      }

   
    
    points(px, py, pch=pch, col=col, xpd=TRUE)
  ##      points(px, py, xpd=TRUE)

    
    buttons=list(N=length(px), labs=labs, x1=x1, x2=x2, y1=y1, y2=y2)
    rect(buttons$x1,buttons$y1 ,buttons$x2, buttons$y2,  border=col, xpd=TRUE)
    text((buttons$x1+buttons$x2)/2,buttons$y1, labels=labs, pos=3, col=col, xpd=TRUE)

    return(buttons)
    
  }
##############################
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
whichbutt<-function(v, buttons)
  {
  ##X## return which button was clicked   
    butts = rep(0, length(v$x))
    
    for(i in 1:length(butts))
      {
        
        KT = which(v$x[i]>buttons$x1 & v$x[i]<buttons$x2 & v$y[i]>buttons$y1 & v$y[i]<buttons$y2  )
        
        
        if(length(KT)>0)
          {
            
            butts[i] = KT
          }
      }
    
    return(butts)
    
  }
#############################
############################################################
###  source("/home/lees/Progs/R_stuff/General.R"); save.image()


list.funcs<-function()
  {
  ##X##    ###  list all function in position (0,or 1) that are functions
  ##X##    ###  delete these with DELETE.functions()
    allfs = ls(pos=1)
    HRM = rep(FALSE, length(allfs))
    
    for(i in 1:length(allfs))
      {
        FL = allfs[i]
     ###  print(paste(sep=' ', "this is an object", FL))
        if(is.na(FL)) next
        if(is.function(get(FL)))
          {
           ### print(paste(sep=' ', FL, "=FUNC"))
            HRM[i] = TRUE
          }
      }
    return(allfs[HRM])
  }



############################
DELETE.functions<-function()
  {
  ##X##  ###  delete local functions 
    allfs = ls(pos=1)
    HRM = rep(FALSE, length(allfs))
    
    for(i in 1:length(allfs))
      {
        FL = allfs[i]
        #### print(paste(sep=' ', "this is an object", FL))
        if(is.function(get(FL)))
          {
            print(paste(sep=' ', "this is a function", FL))
            HRM[i] = TRUE
          }


      }

    rm(list=allfs[HRM], pos=1)
    return(allfs[HRM])
  }

############################################################
###  source("/home/lees/Progs/R_stuff/General.R")


list.nonfuncs<-function()
  {
##X##    ###  list all objects in position (0,or 1) that are non-functions
##X##    ###  delete these with DELETE.functions()
    allfs = ls(pos=1)
    HRM = rep(FALSE, length(allfs))
    
    for(i in 1:length(allfs))
      {
        FL = allfs[i]
     ###  print(paste(sep=' ', "this is an object", FL))
        if(is.na(FL)) next
        if(!is.function(get(FL)))
          {
           ### print(paste(sep=' ', FL, "=FUNC"))
            HRM[i] = TRUE
          }
      }
    return(allfs[HRM])
  }
############################################################
objects.length <- function(list)
{
 #####  allfs = ls(pos=1); objects.length(allfs)

   res <- sapply(list, function(x) length(get(x)))
   names(res) <- list
   res
} 

objects.size <- function(list)
{
 #####  allfs = ls(pos=1); kk2=objects.size(allfs) ; sort(kk2)
 ##### sort(objects.size(list.nonfuncs()))
  
   res <- sapply(list, function(x) object.size(get(x)))
   names(res) <- list
   res
} 




############################################################
###  source("/home/lees/Progs/R_stuff/General.R"); save.image()

local.name<-function(nam1)
  {
    I = 0
    nam = nam1
    while(exists(nam))
      {
        I = I+1
        nam=paste(nam1,I, sep=".")	
      }
    return(nam)
  }


#################################
local.file<-function(pref, suf)
  {
##X##     ###  get a file name that is in the local directory
##X##     ### and that is free, i.e. a new file name
##X##     ###  used to avoid writing over files
    ###  e.g.:  plfname = local.file("test","eps")
    i = 0
    indchar       = formatC(i, format="d", wid=4,  flag="0")
    tfile = paste(sep='_', pref, indchar)    
    ofile = paste(sep='.', tfile, suf)
 
    vof = system(paste(sep=" ", "ls", ofile), intern=TRUE, ignore.stderr=TRUE)
    i = 0
    while(length(vof)>=1)
      {

        indchar       = formatC(i, format="d", wid=4,  flag="0")
        tfile = paste(sep='_', pref, indchar)    
        ofile = paste(sep='.', tfile, suf)
 
       ###  ofile = paste(sep='_', pref, indchar, suf)
 
        vof = system(paste(sep=" ", "ls", ofile), intern=TRUE, ignore.stderr=TRUE)
        i = i +1
      }
    return(ofile)

  }
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
################################
file.exists<-function(name)
{
##X## check to see if this file exists
  EX = rep(FALSE, length(name))
  
  for(i in 1:length(name))
    {
      
      EX[i] = system(paste("test -e ", name[i]) ,intern=FALSE)==0
      
    }
  
  return(EX)
}
############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
################################
PS.file<-function(pref="RPS_", PRINT=TRUE)
{
  ##X##  set up a postscipt file for printing
  if(missing(PRINT)) { PRINT=TRUE }
  if(missing(pref)) {  pref =  "RPS_" }
  i = 0
 
  nam <- paste(pref,formatC(i, format="d", wid=3, flag="0"), sep="")
  PSFILE = paste(nam, "eps", sep=".")
  
  while(file.exists(PSFILE)==TRUE)
    {
      i = i+1
      nam <- paste(pref,formatC(i, format="d", wid=3, flag="0"), sep="")
      PSFILE = paste(nam, "eps", sep=".")

    }

  if(PRINT)
    {
      cmd = paste("postscript(file=",PSFILE,", print.it=FALSE,  onefile=FALSE)", sep='')
      
      print(cmd)
      print("...." )
      print("dev.off()")
    }
  else
    {

      print("Do Not Forget to...." )
      print("dev.off()")
 
      postscript(file=PSFILE, print.it=FALSE,   paper = "special", onefile=FALSE)

    }
  
  return(PSFILE)

  
}

###################

wordsplit<-function(s)
  {
   ##X## split a long space separated string into words   
    A = unlist(strsplit(s,split=" "))

    return(A[!(A == "")])

  }

##########################
plotsymbols<-function()
  {
   ##X##    ### get this in the help page  help(points)
   ##X##    ###  postscript(file="Rsymbols.ps", horizontal=FALSE)
   ##X##    ##-------- Showing all the extra & some char graphics symbols ------------
     Pex <- 3 ## good for both .Device=="postscript" and "x11"
     ipch <- 1:(np <- 25+11); k <- floor(sqrt(np)); dd <- c(-1,1)/2
     rx <- dd + range(ix <- (ipch-1) %/% k)
     ry <- dd + range(iy <- 3 + (k-1)-(ipch-1) %% k)
     pch <- as.list(ipch)
     pch[25+ 1:11] <- as.list(c("*",".", "o","O","0","+","-",":","|","%","#"))
     plot(rx, ry, type="n", axes = FALSE, xlab = "", ylab = "",
          main = paste("plot symbols :  points (...  pch = *, cex =", Pex,")"))
     abline(v = ix, h = iy, col = "lightgray", lty = "dotted")
     for(i in 1:np) {
       pc <- pch[[i]]
       points(ix[i], iy[i], pch = pc, col = "red", bg = "yellow", cex = Pex)
       ## red symbols with a yellow interior (where available)
       text(ix[i] - .3, iy[i], pc, col = "brown", cex = 1.2)
     }

  }
#############################
###  source("/home/lees/Progs/R_stuff/General.R")


vline<-function(x, per=1, COL=1, NUM=FALSE, LAB=1:length(x), lwd=0, lty=1)
  {
    if(missing(COL)) { col = gray(0.8) }
    if(missing(per)) { per=1  }
    if(missing(NUM)) { NUM = FALSE }
    if(missing(LAB)) { LAB = NULL }
    if(missing(lwd)) { lwd=1  }
    if(missing(lty)) { lty=1  }
    ##  if(missing()) { =1  }



    
    u = par("usr")
    n = length(x)
    dy = u[4]-u[3]
    if(per>=0)
      {
        y1 = u[3]
        y2 = y1+per*dy
      }
    else
      {
        y1 = u[4]
        y2 = y1+per*dy  
      }
    segments(x, rep(y1,n),  x, rep(y2, n), col=COL, lwd=lwd, lty=lty)
    
    if(NUM==TRUE | !is.null(LAB)  )
      {

        if(is.null(LAB) ) { LAB=1:length(x) }
        
        if(per>=0)
          {
             text(x, rep(y1,n), labels=LAB, pos=1, xpd=TRUE)
          }
        else
          {
             text(x, rep(y1,n), labels=LAB, pos=3, xpd=TRUE)
          }
      }
  }

############################################################
###  source("/home/lees/Progs/R_stuff/General.R")
##X##

winmark<-function(a1, a2, UD=1, col=col)
{
  if(missing(col)) { col=4 }
  if(missing(UD)) { UD=1 }

  if(is.null(a1)==TRUE )
    {
      print("missing a1 in winmark")
      return(0)
    }

  if(is.null(a2)==TRUE )
    {
      print("missing a2 in winmark")
      return(0)
    }

  u = par("usr")

  if(UD==1)
    {
      bot = u[3]+0.8*(u[4]-u[3])
      top = u[3]+0.95*(u[4]-u[3])
      segments(a1, bot, a1, top, col=col)
      segments(a1, top, a2, top, col=col)
      segments(a2, bot, a2, top, col=col)
    }
  else
    {
      
      bot = u[3]+0.05*(u[4]-u[3])
      top = u[3]+0.2*(u[4]-u[3])
      segments(a1, bot, a1, top, col=col)
      segments(a1, bot, a2, bot, col=col)
      segments(a2, bot, a2, top, col=col)
    }
  
  
  
  
}
