
###########  functions for plotting paleo magnetic poles
##################################################
#########  source("/home/lees/Progs/R_stuff/Misc/PaleoMag.R")

##################################################
rotx<-function( deg )
{
  ## % create a rotation matrix about the x axis
  rad1 = deg *  pi/180;
  r = diag(3)
  r[2, 2] = cos(rad1);
  r[2, 3] = sin(rad1);
  r[3, 3] = r[2, 2];
  r[3, 2] = -r[2, 3];
  return(r)
}
#######
rotz<-function( deg )
{
  ## % rotation matrix about the z axis
  rad1 = deg * pi/180;
  r = diag(3)
  r[1, 1] = cos(rad1);
  r[1, 2] = sin(rad1);
  r[2, 2] = r[1, 1];
  r[2, 1] = -r[1, 2];
  return(r)
}
roty<-function( deg )
{
  ## % rotation matrix about y axis
  rad1 = deg *  pi/180;
  r = diag(3)
  r[1, 1] = cos(rad1);
  r[3, 1] = sin(rad1);
  r[3, 3] = r[1, 1];
  r[1, 3] = -r[3, 1];
  return(r)
}
#####################################################################
cart<-function(lam,phi)
{
  ##%    v = cart(lam, phi)
  ##%   lam = latitude (degrees)
  ##%   phi = longitude (degrees)
  ##%  given the lambda(latitude) and phi(longitude)
  ##%  find the cartesian coordinates of the vector on the sphere


  pio2 = pi/180
  flag  = abs(lam)>90
  
  ##if( (abs(lam)>90) )
  ##{
  ##   print('Warning: It does not really make sense to have latitude greater than 90 degrees'##)
  ##}
  a = lam * pio2;
  b = phi * pio2;
  v1 = cos(a) * cos(b);
  v2 = cos(a) * sin(b);
  v3 = sin(a);
  v = cbind(v1, v2, v3);
  return(v)
}
#############################################
ucart<-function(a)
{
  ## % inverse of the cart program:
  ## % given a vector a
  ## % return the values of it's lat-lon
  
  lam = 180*asin(a[3])/pi;
  phi = 180*atan2(a[2],a[1])/pi;
 
  if(phi < 0)
    {
      phi = phi + 360
    }
  v = c( lam , phi );
  return(v)
}
#############################################
Ucart<-function(a)
{
  ## % inverse of the cart program:
  ## % given a vector a
  ## % return the values of it's lat-lon
  
  lam = 180*asin(a[,3])/pi;
  phi = 180*atan2(a[,2],a[,1])/pi;
  ##lam = round(lam * 100)/100;
 ## phi = round(phi * 100)/100;

  phi = fmod(phi, 360)
  

  v = cbind( lam , phi );
  return(v)
}
#########  source("/home/lees/Progs/R_stuff/Misc/PaleoMag.R")

tect.cor<-function(I, D, strike, dip   )
{
## %
## % Usage: v = tect_cor(I, D, strike, dip   )
## %

if(I<0.0)
{
     i = -I;
}
   else
{
     i = I
}


   v1 = as.vector(cart(i, D));
   R = rotz(-1*strike) %*% rotx(-1*dip) %*%  rotz(strike);

v = ucart( R %*%  v1);

   if(I<0.0)
{
     v[1] = -1*v[1];
}
return(v)
}


##################################################
tect.cor2<-function(I, D, strike, dip   )
{
  ## % 
  ## % Usage: v = tect.cor(I, D, strike, dip   )
  ## %   v1 = tect.cor(-59, 18, 30, 60)
  ## %   v1 = tect.cor(-59, 18, 30, 60)
  
  flag = I<0
 i = I
  i[flag] = -i[flag]

  
  v1 = cart(i, D);
  ROT = rotz(-1*strike) %*% rotx(-1*dip) %*%  rotz(strike);
  
  v = Ucart( t(ROT %*%  t(v1)) );

v[ ,flag] = -1*v[ ,flag]


  return(v)
}

##################################################
##################################################
##################################################
IncDec = function(A)
  {
    ##  %   IncDec(A)
    ## % where A is a cartesian matrix (see cart(lam, phi)
    ##%  an N is the number of points
    ##  % calculate the inclination and declination of
    ##  % a set of vectors
    
    
    Rn = sum(A[,1] )
    Re = sum(A[,2] )
    Rd = sum(A[,3] )
    
    
    s = dim(A);
    N = s[1];
    
    Ir = 180*atan2(Rd, sqrt(Rn^2+Re^2))/pi;
    Dr = 180*atan2(Re, Rn)/pi;
    
    
    R = sqrt(Rn^2+Re^2+Rd^2)
    
    K = (N-1)/(N-R);
    S = 81/sqrt(K);
    
    Alpha95 = 180*acos(1- ( (N-R)*((20^(1/(N-1)))-1)/R))/pi;
    
    return(list(Ir=Ir, Dr=Dr, R=R, K=K, S=S, Alph95=Alpha95));
    
  }
##################################################
polarnet<-function(color=4)
  {
    ## %  draw an equal area stereonet with a polar aspect

    if(missing(color)) { color = rgb(.6, .6, .8) }
    pi180 = pi / 180;


    ##  % SMALL circles  (Latitudes)
    plot(c(-1,1), c(-1,1), axes=FALSE, asp=TRUE, type='n', ann =FALSE)
    
    D = pi180*(0:360);
    c = 1/sin(pi180*45);
    for(lat in seq(from=10, by=10, to=90))
      {
        r = c*sin(pi180*lat/2);
        x = r*cos(D);
        y = r*sin(D);
        
        lines(x,y, col=color);
      }
    
###%  GREAT Circles (Longitudes)
    D = pi180*seq(from=0, by=10,to=360);
    
    x1 = cos(D);
    y1 = sin(D);
    
    c = 1/sin(pi180*45);
    lat = 10;
    r = c*sin(pi180*lat/2);
    x2 =r*cos(D);
    y2 = r*sin(D);
    

    x =  c(x1, x2);
    
    y = c(y1, y2);
    
    segments(x1, y1,x2,y2, col=color)
    
    
    D = pi180*seq(from=0, by=20, to=360);

    c = 1/sin(pi180*45);
    lat = 10;
    r = c*sin(pi180*lat/2);
    x2 =r*cos(D);
    y2 = r*sin(D);
    
    x1 = rep(0, length(x2));
    y1 = rep(0, length(y2));
    
    

    segments(x1, y1,x2,y2, col=color)
  }


################################################
#########  source("/home/lees/Progs/R_stuff/Misc/PaleoMag.R")

polar.points<-function(a, color=2, pch=1, lab=NULL)
  {
    
    if(missing(color)) { color = 2 }
    if(missing(pch)) { pch = 1 }
    if(missing(lab)) { lab=NULL }  
    ## % use the pole function to plot a vector 
    ##% of poles
    lam = a[,1];
    I = a[,2];
    n = length(I);
    
    
    inc = I
    f1 = inc<0
    inc[f1] = 90+inc[f1]
   inc[!f1] =  90-inc[!f1];
    
    col = rep(color, length(inc))
    col[f1] = color+1
    
    polar.point(lam, inc, col, pch=pch, lab=lab);
    
  }
################################################
polar.point<-function(lam,delta, col=col, pch=pch,  lab=NULL)
{
  ##%      v = polar_point(lam,delta, col)
  ##%   
  ##%   lam = longitude (degrees)
  ##%   delta = latitude
  ##%  given the lambda(latitude) and phi(longitude)
  ##%  find the cartesian coordinates of the vector on the sphere
  
  if(missing(pch)) { pch = 1 }
  if(missing(col)) { col = 2 }
        if(missing(lab)) { lab=NULL }
  pi180 = pi / 180;
  c = 1/sin(pi180*45);
  
  D = (90-lam)*pi180;
  
  r = c*sin(pi180*delta/2);
  x = r*cos(D);
  y = r*sin(D);          
  
  points(x,y , type='p', pch=pch, col=col);
  if(!is.null(lab))
       {
         text(x,y, labels=lab, pos=3)

       }
  
}
################################################

ppole<-function(lam,delta, col=2, pch=1,  lab=NULL)
  {
    if(missing(col)) { col = 2 }
    if(missing(pch)) { pch = 1 }
    if(missing(lab)) { lab=NULL }
    
    pi180 = pi / 180;
    aa =  sqrt(2)*sin(pi180*(delta)/2);
    la = 90-lam;
    x = aa* (cos(pi180*la)) ;
    y = aa*( sin(pi180*la)) ;
    
    points(x,y , type='p', pch=pch, col=col);
      if(!is.null(lab))
       {
         text(x,y, labels=lab, pos=3)

       }
  }
#######################
#########  source("/home/lees/Progs/R_stuff/Misc/PaleoMag.R")

####################### 
gpole = function(lat, lon, col=2, pch=1, lab=NULL )
  {
    ###% plot a geographic point on an equal-area, equatorial projection
    ####  this is 
    ###%   lon = longitude
    ###%   lat = latitude
    ###% first get the cartesian coordinates
     if(missing(col)) { col = 2 }
       if(missing(pch)) { pch = 1 }
       if(missing(lab)) { lab=NULL }
     
raddeg = 180 / pi;
degrad = pi/ 180;
A = cart(lat, lon);
delta = raddeg*acos(A[,2]);
color = rep(col, length(lat))


color[delta > 90] = color[delta > 90]+1

delta[delta > 90] = 180 - delta[delta > 90]


D = raddeg*atan2(-A[,1],A[,3]);
v = c(D, delta)
r = sin(degrad*delta/2)/sin(degrad*45);
x = r*sin(degrad*D);
y = r*cos(degrad*D);
points(x,y,col=color);
     if(!is.null(lab))
       {
         text(x,y, labels=lab, pos=3)

       }
}

