############################################################
###  source("/home/lees/Progs/R_stuff/MiscSeis.R")
###
###
### Merapi Hidayat et al. (inlcudes Voigt and Langston)
##  determine the depth of a volcanic sopurce given two stations and their
## time differential.  plot upper and lower bound based on velocity
twostaZ<-function(dep=dep, sta1=list(d=40, r=120), sta2 = list(d=340,r=1060), vp = 3000.0, pts=pts)
{
  if(missing(dep)) {
    dep = 0:1200
  }


  if(missing(sta1)) {
    sta1 = list(d=40, r=120)
  }

  if(missing(sta2)) {
    sta2 = list(d=340,r=1060)
  }
  if(missing(vp)) {
    vp = 3000.0
  }
  if(missing(pts))
    {
      DOpts=FALSE
    }
  else
    {
      DOpts=TRUE
    }
  
  vpU=  vp+500

  vpL=   vp-500
  if(vpL<0) {  vpL = 50 }


  t1t2 = ( sqrt( (sta2$d-dep)^2+sta2$r^2)  -  sqrt( (sta1$d-dep)^2+sta1$r^2) )/vp
  t1t2U = ( sqrt( (sta2$d-dep)^2+sta2$r^2)  -  sqrt( (sta1$d-dep)^2+sta1$r^2) )/vpU
  t1t2L = ( sqrt( (sta2$d-dep)^2+sta2$r^2)  -  sqrt( (sta1$d-dep)^2+sta1$r^2) )/vpL

  plot(t1t2, dep, type='l', xlab="Time Differential, s", ylab="Depth, m")
  lines(t1t2U, dep, lty=2, col=4)
  lines(t1t2L, dep, lty=2, col=2)
  u = par('usr')
  title(main=paste(sep=' ', 'V=', vp))
  
 ##  text(u[2],u[4], labels=paste(sep=' ', 'V=', vp))
  
     if(DOpts==TRUE )
       {

         for(i in 1:length(pts))
           {
             
             dcen = d[which.min(abs(pts[i]-t1t2))]
             dU = d[which.min(abs(pts[i]-t1t2U))]
             dL = d[which.min(abs(pts[i]-t1t2L))]
             
             points( pts[i], dcen)
             error.bar(  pts[i],dcen ,dL, dU, add=TRUE)
             
             
           }
         
         

         
       }
  
  
  
  return(t1t2)
  
}


