########################################
tomo.col<-function(n)
{
    if ((n <- as.integer(n[1])) > 0) 
	{
	start=0
	end = 1
	specsize = end - start;
	 aa = 6.283185;
	 bb = 1.99647;
	lighterBlue = .5
	redHue = 0;
	dist = start +(seq(0,(n - 1)) * specsize) / (n - 1);
	tomoval = dist * 2 - 1.0;   #   /* Value in range [-1..1] */
	value = atan(aa*tomoval) * atan(aa*tomoval) / bb;

	hue = rep( redHue,length(tomoval))
	hue[tomoval<0] = lighterBlue
	value[value>1] = 1

	COL = hsv(h=hue , s=1.0, v=value)

	}	
	
    return(COL)

}
########################################
pal1.col<-function(n)
{



  
    if ((n <- as.integer(n[1])) > 0) 
	{
	start=0
	end = 1
	specsize = end - start;
	 aa = 6.283185;
	 bb = 1.99647;

        
	lighterBlue = .5
	redHue = 0;
	dist = start +(seq(0,(n - 1)) * specsize) / (n - 1);
	tomoval = dist * 2 - 1.0;   #   /* Value in range [-1..1] */

        
	value = atan(aa*tomoval) * atan(aa*tomoval) / bb;

	hue = rep( redHue,length(tomoval))
	hue[tomoval<0] = lighterBlue
	value[value>1] = 1

	COL = hsv(h=hue , s=1.0, v=value)

	}	
	
    invisible(COL)

}

#################################################
######  source("/home/lees/Progs/R_stuff/Pal.R")
###############  plot.pal(shade.col(100, acol=c(0,1,0)))
###############  plot.pal(shade.col(100, acol=c(1,0,1)))

shade.col<-function(n, acol=c(1,0,0) )
{

  if(missing(acol)) { acol=c(1,0,0) }
  
  if ((n <- as.integer(n[1])) > 0) 
    {
      r1 = acol[1];
      g1 = acol[2];
      b1 = acol[3];
      
      
      wr1 = 1.0;
      wg1 = 1.0;
      wb1 = 1.0;
      
      dr1 = wr1-r1
      dg1 = wg1-g1
      db1 = wb1-b1
      
      hr1 = (wr1-r1)/n
      hg1 = (wg1-g1)/n
      hb1 = (wb1-b1)/n
      
      
      
      nr1 = seq(from=r1, length=n, by=hr1)
      nb1 = seq(from=b1, length=n, by=hb1)
      ng1 = seq(from=g1, length=n, by=hg1)
        
COL = rgb(r=nr1, g=ng1, b=nb1)


      


	}	
	
    return(COL)

}
#################################################
######  source("/home/lees/Progs/R_stuff/Pal.R")

############### plot.pal(rainbow(100))

plot.pal1<-function(col, ypos=0, add=FALSE)
  {
  
  if(missing(ypos)) { ypos = 0 }
  if(missing(add)) { add=FALSE }


  if(add==FALSE)
    {
    plot(c(0,1), c(0,1), type='n', axes=FALSE, ann=FALSE)
  }
    
    u = par("usr")
    f = par("pin")
    raty = (u[4]-u[3])/f[2]

    
    dy = (u[4]-u[3])*.05


    
    dx = (u[2]-u[1])*.8

    LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(u[3]-dy*0.5, u[3]-dy*0.5-4*dy))


  
    
    i <- seq(along = col)
    
    BX = (LU$x[2]-LU$x[1])/length(i)
    
    x1 =LU$x[1]+(i-1)*BX
    x2 = x1+BX
  
    y1 = LU$y[1]+ypos*4*dy
    y2 =  LU$y[2]+ypos*4*dy
      
    rect(x1,y1,x2,y2,  col=col, xpd = TRUE, border=-1)
    

  }



#################################################
######  source("/home/lees/Progs/R_stuff/Pal.R")
plot.pal<-function(col, ypos=0, dy=1, add=FALSE)
  {
  
  if(missing(ypos)) { ypos = 0 }
  if(missing(add)) { add=FALSE }


  if(add==FALSE)
    {
    plot(c(0,1), c(0,1), type='n', axes=FALSE, ann=FALSE)
  }
    
    u = par("usr")

  if(missing(dy)) {  dy = (u[4]-u[3])*.05 }

    f = par("pin")

    dx = (u[2]-u[1])*.8

   ##  LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(u[3]-dy*0.5, u[3]-dy*0.5-4*dy))
   LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(ypos, ypos+dy))

    i <- seq(along = col)
    
    BX = (LU$x[2]-LU$x[1])/length(i)
    
    x1 =LU$x[1]+(i-1)*BX
    x2 = x1+BX
  
    y1 = LU$y[1]
    y2 =  LU$y[2]
      
    rect(x1,y1,x2,y2,  col=col, xpd = TRUE, border=-1)
    
  }
#################################################
######  source("/home/lees/Progs/R_stuff/Pal.R")
see.pals<-function()
  {

    TPALS = c("rainbow", "topo.colors", "terrain.colors", "heat.colors", "tomo.col")


    NCOL = 100
    Npal = length(TPALS)
    plot(c(0,1), c(0,1), type='n', axes=FALSE, ann=FALSE)

    dy = (0.8/Npal)
    py = (1/Npal)

    for(i in 1:Npal)
        {
         ##  print(TPALS[i])
         FUN = match.fun(TPALS[i])
         pal = FUN(NCOL)

         plot.pal(pal, ypos=(i-1)*py, dy=dy, add=TRUE); text(0, (i-1)*py+0.5*dy, TPALS[i], pos=4)
        }
    
   ###### plot.pal(rainbow(100), ypos=0, dy=dy, add=TRUE); text(0, 0*py+0.5*dy, "rainbow(100)", pos=4)
   ###### plot.pal(topo.colors(100), ypos=1*py , dy=dy, add=TRUE); text(0, 1*py+0.5*dy, "topo.colors(100)", pos=4)
   ###### plot.pal(terrain.colors(100), ypos=2*py , dy=dy, add=TRUE); text(0, 2*py+0.5*dy, "terrain.colors(100)", pos=4)
   ###### plot.pal(heat.colors(100), ypos=3*py , dy=dy, add=TRUE); text(0, 3*py+0.5*dy, "heat.colors(100)", pos=4)
  ######  plot.pal(tomo.colors, ypos=4*py , dy=dy, add=TRUE); text(0, 4*py+0.5*dy, "tomo.colors", pos=4)
    

    box()
    title("Pick a Palette: Click on Selection")
    abline(h=py*seq(0,Npal), lty=2, col=rgb(0.7, 0.7, 0.7))

    pik = locator(1, type='p')
    z = floor(Npal*pik$y)+1
    print(paste(sep=" ", z ,  TPALS[z]) )

   ####   FUN <- match.fun(FUN)
    FUN = match.fun(TPALS[z])
     pal = FUN(NCOL)
     invisible(pal)
  }

#################################################
######  source("/home/lees/Progs/R_stuff/Pal.R")
Gcols<-function(plow=10, phi=10,  N=100, pal="rainbow")
{
  ###   get a palette with the upper or lower parts replaced
  if(missing(plow)) { plow = 10 }
  if(missing(phi)) { phi = 10 }
  if(missing(N)) { N = 100 }
  if(missing(pal)) { pal = "rainbow" }

  
  nlow = floor(plow*N/100)
  nhi = floor(phi*N/100)
  LOW = grey(seq(from=0.5, to =1, length=nlow))
  HI  = grey(seq(from=0.5, to =1, length=nhi))
  K = N-nlow-nhi

     FUN = match.fun(pal)
     Z = FUN(K)
  #####  Z = rainbow(K)
  return(c(LOW  , Z, HI) )
}
