cat("sourcing /home/lees/Progs/R_stuff/TTPIX.R\n")

#######
###  source("/home/lees/Progs/R_stuff/TTPIX.R")

############  
READ.TTPIX<-function(fname)
{
Aev = scan(file=fname, what=list(nam='', slat=0, slon=0, yr=0, mon=0, dom=0, 
hr=0, min=0, sec=0, elat=0, elon=0, ez=0) , nlines =1)
dphases = scan(fname, skip=1, what=list(pname='', t=0, d1=0, d2=0, d3=0))

jd = getjul(Aev$yr, Aev$mon, Aev$dom)

ptimes = recdate(jd, Aev$hr, Aev$min, Aev$sec+dphases$t)

mtimes = cbind(rep(Aev$yr, length(ptimes$jday)), ptimes$jday, ptimes$hour, ptimes$min, ptimes$sec)
return(list(pname=dphases$pname, ptimes=ptimes, mtimes=mtimes))


}
#####################
############  #######
###  source("/home/lees/Progs/R_stuff/TTPIX.R")


TTPIX.MATN<-function(GFIL, stalist, YN, sel=1:YN)
  {
    if(missing(sel)) { sel=1:YN }
    for(ista in stalist)
      {
        ## vpo = match(sekssta$name[m],ista)

        ## vpo = vpo[!is.na(vpo)]

        vpo = match(ista, GFIL$STNS[sel])
       vp2 = match( GFIL$STNS[sel], ista)


        ifil = paste(sep=".", ista, "PIX")


        APIX = READ.TTPIX(ifil)
        j=vpo

        jd = getjul(GFIL$info$yr[j],GFIL$info$mo[j] , GFIL$info$dom[j])

        pix = secdif(jd, GFIL$info$hr[j], GFIL$info$mn[j], GFIL$info$sec[j]+GFIL$info$msec[j]/1000+GFIL$info$t1[j]-GFIL$info$off[j],
          APIX$ptimes$jday,   APIX$ptimes$hour,  APIX$ptimes$min, APIX$ptimes$sec)

        flg  = (seq(1,length(pix))%%4)
        dy = 1/YN
        J = seq(1, YN)
        J = J[!is.na(vp2)]
        for(k in J)
          {
            y1 = 1-k*dy
            y2 = y1+dy-(0.1*dy*flg)
            segments(pix, rep(y1, length(pix)) , pix, y2, col=gray(0.85))
          }
        
        
    
        y1 = 1-j*dy
        y2 = y1+dy-(0.1*dy*flg)

        segments(pix, rep(y1, length(pix)) , pix, y2, col=gray(0.85))
        text(pix, y2, labels=APIX$pname, adj=0)


      }



  }
#####################
############  #######
###  source("/home/lees/Progs/R_stuff/TTPIX.R")


TTLOC.MATN<-function(GFIL, stalist, TPIX, YN=1, sel=1:YN)
  {
    if(missing(YN)) {  YN=1 }
    if(missing(sel)) { sel=1:YN }

    tns = names(TPIX)

    for(ista in stalist)
      {
        ## vpo = match(sekssta$name[m],ista)

        ## vpo = vpo[!is.na(vpo)]

        vpo = match(ista, GFIL$STNS[sel])
        vp2 = match( GFIL$STNS[sel], ista)

        
        APIX = TPIX[[which(tns == ista)]]
        j=vpo

        jd = getjul(GFIL$info$yr[j],GFIL$info$mo[j] , GFIL$info$dom[j])

        pix = secdif(jd, GFIL$info$hr[j], GFIL$info$mn[j], GFIL$info$sec[j]+GFIL$info$msec[j]/1000+GFIL$info$t1[j]-GFIL$info$off[j],
          APIX$mtimes[,2],   APIX$mtimes[,3],  APIX$mtimes[,4], APIX$mtimes[,5])

        flg  = (seq(1,length(pix))%%4)
        dy = 1/YN
        J = seq(1, YN)
        J = J[!is.na(vp2)]
        for(k in J)
          {
            y1 = 1-k*dy
            y2 = y1+dy-(0.1*dy*flg)
            segments(pix, rep(y1, length(pix)) , pix, y2, col=gray(0.85))
          }
        
        
    
        y1 = 1-j*dy
        y2 = y1+dy-(0.1*dy*flg)

        segments(pix, rep(y1, length(pix)) , pix, y2, col=gray(0.85))
        text(pix, y2, labels=APIX$pname, adj=0)


      }



  }
######################################################
#####################################################3
###   source("/home/lees/Progs/R_stuff/TTPIX.R")

gett1d<-function(velmod, InEv, InSta)
  {
    ###  get the P and S travel times
    ###   given event LLZ and station LLZ
    ###   and velmodel
    ###   z is positive down for events and positive up for stations
    dis = distaz(InEv$lat, InEv$lon, InSta$lat, InSta$lon)
    km  = dis$dist
    cmnd = paste(sep=" ", "jtt1d", velmod, InEv$z, InSta$z, km)
    
    TTout  = system(cmnd, intern=TRUE)
    Tp1 = grep("P-wave", TTout)
    KS = unlist(strsplit(TTout[Tp1], ' '))
    PnodeN = KS[4]
    Pt1 = unlist(strsplit(KS[7], "="))
    Ptt = as.numeric(Pt1[2])
    Tp1 = grep("S-wave", TTout)
    KS = unlist(strsplit(TTout[Tp1], ' '))
    PnodeN = KS[4]
    Pt1 = unlist(strsplit(KS[7], "="))
    Stt = as.numeric(Pt1[2])

    return(list(Tp=Ptt, Ts=Stt))
  }
######################################
#####################################################3
###   source("/home/lees/Progs/R_stuff/TTPIX.R")

TTLOC<-function(velmod, ev, stas, DATUM=0)
  {
    ###  calculate the travel times to a set of station locations
    if(missing(DATUM) ) DATUM=0
    RTT = as.list(1:length(stas$nm))

    nev = length(ev$lat)
    for(i in 1:length(stas$nm))
      {
        phases = rep(NA, nev*2)
        tt  = rep(NA, nev*2)
        ###  rtimes = as.list(1:(nev*2))
        mtimes = matrix(rep(0,5*nev*2), nrow = nev*2, ncol=5)

        for(j in 1:nev)
          {
            InSta=list(lat=stas$lat[i], lon=stas$lon[i]%%360, z=DATUM)
            InEv=list(lat=ev$lat[j], lon=ev$lon[j]%%360, z=-ev$depth[j])
            TT = gett1d(velmod, InEv, InSta)
            jd = getjul(ev$yr[j], ev$mon[j], ev$dom[j])
            ptime1 = recdate(jd, ev$hr[j], ev$min[j], ev$sec[j]+c( TT$Tp))
            ptime2 = recdate(jd, ev$hr[j], ev$min[j], ev$sec[j]+c( TT$Ts))
            
            ##  list(pname=dphases$pname, ptimes=ptimes))
            k = (j-1)*2+1
            phases[k] = "P"
            phases[k+1] = "S"
            tt[k] = TT$Tp
            tt[k+1] = TT$Ts
           ###  rtimes[[k]] =ptime1
           ###  rtimes[[k+1]] =ptime2
            mtimes[k,] = c(ev$yr[j], ptime1$jday, ptime1$hour, ptime1$min, ptime1$sec)
            mtimes[k+1,] = c(ev$yr[j], ptime2$jday, ptime2$hour, ptime2$min, ptime2$sec)
            
          }
        RTT[[i]] = list(name=stas$nm[i], pname=phases,tt=tt, mtimes=mtimes)
      }
    names(RTT) = stas$nm
    return(RTT)
  }
#####################################################3
###   source("/home/lees/Progs/R_stuff/TTPIX.R")
