######  BOSAI R Stuff
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

###########  major modifications 2003.12.10
###########  major modifications Thu Feb 12 12:12:56 EST 2004
###########                 added in earthquake hyocenter comparison

###########   major modifications  changed:   "Thu May 20 08:42:50 2004"
###                   remove all Japan references
########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")


#################################################
################################################
get.dump.res<-function(file, sta=stafile)
{
  ##  appropriate for residuals from dumping from a ray-path file
  if(missing(sta))
    {
     sta=stas
    }
	a = scan(file=file, list(id=' ', sta=' ', trutim=0,
		ttq=0,ster=0,nnod=0,lolev=0,layz=0,ifl=0, 
		res=0, scor=0))
	res =split(a$res, a$sta)
	len = sapply(res, length)
	nms = names(res)
	mns=sapply(res, mean)
	mds=sapply(res, median)
	ista = match(nms, sta$nm)
return(list(res=res, nms=nms, len=len, mns=mns, mds=mds, ista=ista))

}
########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

get.lq.res<-function(infile="residuals.P", sta=stafile)
{
  ###  for use after running
  ###     unix:   cat all_the_data.pix |  uw_resid_stat P  > hisresfuj1P
  ###   then run   hp = histores(pa$res, disp=c(5,3))

  if(missing(sta))
    {
      sta=stas
    }
a  = scan(file=infile, list(id=' ',sec=0,lat=0, lon=0,  sta=' ',res=0, iwt=0 ))

	res =split(a$res, a$sta)
        iwt = split(a$iwt, a$sta)
	len = sapply(res, length)
	nms = names(res)
	mns=sapply(res, mean)
	mds=sapply(res, median)
	ista = match(nms, sta$nm)
return(list(res=res, iwt=iwt, nms=nms, len=len, mns=mns, mds=mds, ista=ista))

}
#################################################
DO.map.res<-function(files, dir='/home/lees/Site/Fuji/UW/ATEST')
  {
    ## plot maps of residuals at stations on an event by event basis
    ## plot a large scale map and detail limited by the station array
    ##
    # files = c(20020205195723p,  20020410150216p,  20020410184005p,  20020411105235p)
    ##  need to get a list of pickfiles:
    #    f = system(paste(sep = ' ', 'ls' ,dir) ,intern=TRUE)
    #  DO.map.res(files, dir='/home/lees/Site/Fuji/UW/ATEST')
    
  for(i in 1:length(files))
    {
      f1 = paste(sep='/', dir, files[i])
      system(paste(sep=' ', 'uw_resid_stat <',f1, ' > JUNK' ))
      
      map.map1.res('residuals.P')
      locator()
      
## system( 'cat residuals.P') 
    }

  }

########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

map.lq.res<-function(pa, MAP=JAPmap, sta=stas,  ZLOC=MLOC, cmp=rainbow(100) )
  {
    if(missing(cmp)) { cmp=rainbow(100) }
    if(missing(MAP)) { MAP=JAPmap }
     if(missing(ZLOC)) { ZLOC=MLOC  }
   
  if(missing(sta))
    {
     sta=stas
    }

    
    ps = pa$ista
    
    
    pxy = GLOB.XY(sta$lat[ps], sta$lon[ps] )
    
    exy =  GLOB.XY( rs$lat[1], rs$lon[1])
    
    blat = range(c(sta$lat[ps], rs$lat[1]))
    blon = range(c(sta$lon[ps], rs$lon[1]))
    
    bxy = GLOB.XY(blat,blon)
    
    BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)
   
    PROJmap(JAPmap, WIN=ZLOC, ADD=FALSE, ASP=TRUE, COL=TRUE)
    AXESmap( JAPmap, GRID=TRUE,  WIN=ZLOC)
    box()
    PROJpoints(sta$lat, sta$lon)


  }

################################################
map.map1.res<-function(file, MAP=JAPmap, sta=stafile,  cmp=rainbow(100) )
  {
    ## map.map1.res('/home/beer/lees/DATA/BOSAI/INV3/residuals.P')
   ###  plot and contour the residuals from one event:
   ## in UNIX, dump out one UW file with residuals:
   ## uw_resid_stat P < 020205.195723.062.p
   ##  read in teh data into R
    if(missing(cmp)) { cmp=rainbow(100) }
    if(missing(MAP)) { MAP=JAPmap }
  if(missing(sta))
    {
     sta=stas
    }
    
    
   rs = scan(file=file, list(id=' ',sec=0,lat=0, lon=0,  sta=' ',res=0 ))
   ## find station locations:
   ps = match(rs$sta, sta$nm)
   ## project data:
   pxy = GLOB.XY(sta$lat[ps], sta$lon[ps] )
   exy =  GLOB.XY( rs$lat[1], rs$lon[1])
   
   blat = range(c(sta$lat[ps], rs$lat[1]))
   blon = range(c(sta$lon[ps], rs$lon[1]))

   bxy = GLOB.XY(blat,blon)

   BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)
   
   PROJmap(MAP, WIN=MLOC,  ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=FALSE)
  
   ##  J = jcont(pxy$x, pxy$y,rs$res, d=5)

   if(length(rs$res)<10)
     {
       
       nc = length(cmp)*(rs$res-min(rs$res))/(max(rs$res)-min(rs$res))
       
       points(pxy$x, pxy$y, col=cmp[nc], pch=21, cex=2 ) 
     }
   else
     {
       J = jimag(pxy$x, pxy$y,rs$res, d=5, col=cmp )
     }
   
   PROJmap(MAP, WIN=BLOC,  ADD=TRUE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
   
   points(pxy$x, pxy$y)
   points(exy$x, exy$y, pch=8, cex=2, col=2)
   
   text(pxy$x, pxy$y, labels=format.default(rs$res, digits=4), pos=3)
   # text(pxy$x, pxy$y, labels=sta$nm[ps], pos=4)
   
   AXESmap( MAP, GRID=TRUE,  WIN=BLOC)
   
   box()

dev.set(dev.next())
       PROJmap(MAP,  ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=FALSE)
  
   ##  J = jcont(pxy$x, pxy$y,rs$res, d=5)

   if(length(rs$res)<10)
     {
       
       nc = length(cmp)*(rs$res-min(rs$res))/(max(rs$res)-min(rs$res))
       
       points(pxy$x, pxy$y, col=cmp[nc], pch=21, cex=2 ) 
     }
   else
     {
       J = jimag(pxy$x, pxy$y,rs$res, d=5, col=cmp )
     }
   
   PROJmap(MAP,  ADD=TRUE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
   
   points(pxy$x, pxy$y)
   points(exy$x, exy$y, pch=8, cex=2, col=2)
   
   text(pxy$x, pxy$y, labels=format.default(rs$res, digits=4), pos=3)
   # text(pxy$x, pxy$y, labels=sta$nm[ps], pos=4)
   
   AXESmap( MAP, GRID=TRUE)
   
   box()




    
  }

###### 
#########################
plot.map.res<-function(res, kind=1)
{
if(missing(kind)) { kind=1; }




if(kind==1)
{
vals = res$mns
}else
{
vals = res$mds

}


d =   round(RESCALE(vals, 1, 50, min(vals) , max(vals)))
points(sta$lon[res$ista],sta$lat[res$ista], pch=15, cex=1.5, col=col[d])
image.SCALE( vals,  col = col , x=scale.loc$x  ,  labels="breaks" ,  nlab=10 )



}
###################################
###################################
###################################
########################
######  source("TTRESID.R"); save.image()


prep.ROSE<-function(infile, sta=stafile)
  {
   #####   preparation of the residule files: 
   ## cd /home/lees/Site/BOS
   ## uw_resid_stat P < lq4.1992.rloc > ho

   ##  returns a structure used in other programs


if(missing(sta))
  {
     sta=stas
    }


TNAME = is.null(sta$name)

TSTN=is.null(sta$stn)

if(is.null(sta$nm))
  {
    if(!TNAME) { sta$nm = sta$name }
    if(!TSTN) { sta$nm = sta$stn }


  }

inrs =  scan(file=infile, list(id=' ',sec=0,lat=0, lon=0,  sta=' ',res=0, wt=0 ))

## need here to weed out bad data

stam =  match( inrs$sta, sta$nm)

flg =   inrs$lon==0.0 | inrs$lat==0.0 | is.na(stam) | inrs$wt>4


rs =list(id=inrs$id[!flg],sec=inrs$sec[!flg],lat=inrs$lat[!flg], lon=inrs$lon[!flg],  sta=inrs$sta[!flg],res=inrs$res[!flg], wt=inrs$wt[!flg] )


res = split(rs$res, rs$sta)

nres= names(res)

rlat = split(rs$lat, rs$sta)
rlon = split(rs$lon, rs$sta)

rs$stam=  match( rs$sta, sta$nm)

rs$stlat = sta$lat[rs$stam]
rs$stlon = sta$lon[rs$stam]



##  plot(c(rs$stlon,rs$lon) , c(rs$stlat, rs$lat) , type='p', pch='.')
##  flg =   rs$lon==0.0 | rs$lat==0.0
##  plot(c(rs$stlon[flg],rs$lon[flg]) , c(rs$stlat[flg], rs$lat[flg]) , type='p', pch='.')

##  plot(c(rs$stlon[!flg],rs$lon[!flg]) , c(rs$stlat[!flg], rs$lat[!flg]) , type='p', pch='.')

##  segments(rs$stlon, rs$stlat, rs$lon, rs$lat)


rs$baz=  greatAz( rs$stlat , rs$stlon, rs$lat, rs$lon)


##  plot(c(rs$stlon[is.na(rs$baz)],rs$lon[is.na(rs$baz)]) , c(rs$stlat[is.na(rs$baz)], rs$lat[is.na(rs$baz)]) , type='p', pch='.')

##  segments(rs$stlon, rs$stlat, rs$lon, rs$lat)


##   plot(c(rs$stlon,rs$lon) , c(rs$stlat, rs$lat) , type='p', pch='.', xlab='Lon', ylab='Lat', main='input data for residual analysis')

rs$int = findInterval( rs$baz, seq(from=-180, to=180, by=10), all.inside = TRUE)


raz =  split(rs$baz, rs$sta)

rint=  split(rs$int, rs$sta)


return(list(rs=rs, res=res, names=nres, rlat=rlat, rlon=rlon,  raz=raz, rint=rint))

}
######  source("/home/lees/Progs/R_stuff/TTRESID.R")
######  source("/home/lees/Progs/R_stuff/circ.R")

STA.ROSE<-function(sta=stafile)
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA.ROSE()
  if(missing(sta))
    {
     sta=stas
    }

  for(i in 1:length(nres))
    {
      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]
      dev.set(dev.next())
      par(mfrow=c(2,1))

    ##   Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"))
       hist(r[abs(r)<10],  breaks=100, xlab="s", col=2)
      
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))


      dev.set(dev.next())

      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      
      bxy = GLOB.XY(elat,elon)
      points(bxy$x, bxy$y, col=4, pch='.')
   #     points(bxy$x[r>=0.4], bxy$y[r>=0.4], col=2, pch='.')
   #     points(bxy$x[r<0.4], bxy$y[r<0.4], col=4, pch='.')

      

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

      readline()
    }
}
########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")
STA1.ROSE<-function(i)
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA1.ROSE(i)


      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]

      dev.set(dev.next())
      par(mfrow=c(1,1))
      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      


      rxy = GLOB.XY(elat,elon)
      points(rxy$x, rxy$y, col=4, pch='.')
   #     points(bxy$x[r>=0.4], bxy$y[r>=0.4], col=2, pch='.')
   #     points(bxy$x[r<0.4], bxy$y[r<0.4], col=4, pch='.')

      

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

          dev.set(dev.next())
      par(mfrow=c(2,1))

    ##   Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"))
     
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))

       hr = hist(r[abs(r)<10],  breaks=100, xlab="s", col=2)

      xsec  = locator()
      abline(v=xsec$x, col=2:(2+length(xsec$x)))

      efs = c(min(r), xsec$x, max(r))

      hcol = rep(2,length(hr$breaks))
      kj = length(efs)-1
      for( j in 1:kj)
        {
          flag <- hr$breaks>=efs[j]&hr$breaks<efs[j+1]
          hcol[flag] = col=2+(j-1)
        }
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))

      hist(r[abs(r)<10],  breaks=100, xlab="s", col=hcol)
      
      
      dev.set(dev.next())
    
      for( j in 1:kj)
        {
      flag <- r>=efs[j]&r<efs[j+1]
      points(rxy$x[flag], rxy$y[flag], col=2+(j-1), pch=16, cex=0.5)
    }
    
 
}
########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")
STA.ALL.ROSE<-function()
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA.ROSE()

  for(i in 1:length(nres))
    {
      STA1.ROSE(i)
      readline()
    }
}





MAP.ROSE<-function()
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##  see above for preparation: STA.ROSE()


 
  for(i in 1:length(nres))
    {
      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]
      dev.set(dev.next())
      par(mfrow=c(2,1))

      Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"), plot=TRUE)
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"), plot=TRUE)
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))


      dev.set(dev.next())

      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)

      PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      


      bxy = GLOB.XY(elat,elon)
      points(bxy$x, bxy$y, col=4, pch='.')

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

      u = par('usr')
      ufac = (u[2]-u[1])*0.1

      
      prose(kros, ex=bxy$x, why=bxy$y, prop=ufac, perim=FALSE, add=TRUE, style=1)

      
      readline()
    }
}
#########################
######  source("TTRESID.R"); save.image()

MAPALL.ROSE<-function(nres, sta, WIN=win, ROSES=MROSE, rscale=1)
{

  if(missing(rscale)) { rscale=1 }
 ###  if(missing(MAP)) { MAP=JAPmap }
  if(missing(WIN))
    {
      ista = match(nres,	sta$nm)
      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      
      blat = range(c(sta$lat[ista]))
      blon = range(c(sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)
    }
  else
    {
      BLOC=WIN
    }
  
  NCOL = 20
  lens = sapply(res, "length")
  rlens = range(lens)
  
  RAIN = rev(heat.colors(NCOL))
  rcols = RAIN[findInterval(lens, seq(from=rlens[1], to=rlens[2], length=NCOL))]
  
  ##  PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
  ##    AXESmap( MAP, GRID=TRUE,  WIN=BLOC)
  
  
  u = par('usr')
  ufac = (u[2]-u[1])*0.1

  if(missing(ROSES))
    {
      Roses = as.list(length(nres))
      for(i in 1:length(nres))
        {
          ista = match(nres[i],	sta$nm)
          r = res[[i]]
          ri = rint[[i]]
          rz = raz[[i]]
          Roses[[i]] = Krose.jml(pi*(90-rz)/180, abs(r) , rscale=rscale, bins=36, LABS= c("N", "S", "W", "E"), plot=FALSE)
          Roses[[i]]$name = sta$nm[ista]
        }

    }
  else
    {
      Roses =ROSES
    }


  
  for(i in 1:length(nres))
    {

      ista = match(nres[i],	sta$nm)
      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)

   
      
     prose(Roses[[i]], ex=bxy$x, why=bxy$y, prop=ufac, perim=FALSE, add=TRUE, style=1, col=rcols[i])
      
    }
  box()
  HOZscale(lens, RAIN,units="N" )

  invisible(Roses)

}
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")


#########################
pageohist<-function(res)
{
  par(mfrow=c(5,2))


  k = 1
  
  for(i in 1:length(res$nms))
  {
	for(j in 1:10)
	{


	if(k>length(res$nms)) break
	tag = paste(sep=" ", res$nms[k], k, length(res$nms),res$len[k] )  
	hist(res$res[[k]],  main=tag , breaks=20, xlab="s")
	points(c(res$mns[k], res$mds[k]), c(-.5 , -.5), pch=c(1,2), col=c(2,4))
	k=k+1
	}
	
    locator(1)
        if(k>length(res$nms)) break  
   }
}
#########################
#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

######   histores(
######

histores<-function(res, disp=c(5,2), xlim=xlim)
{
  LIM=TRUE
  if(missing(disp)) { disp =c(5,2) }
  if(missing(xlim)) {  LIM=FALSE }
  
  histppage = disp[1]*disp[2]

  Get.Screens(1)

  opar = par(no.readonly = TRUE)
  par(mfrow=disp)

  
  k = 1
  nms = names(res)
  len = sapply(res, length)
  mns = sapply(res, 'mean')
  mds = sapply(res, median)

  N = length(nms)

  newmd = rep(0, N)
  newmn = rep(0, N)
  
  pages = ceiling(N/histppage)
  
  for(i in 1:pages)
  {
    n = (i-1)*histppage
    m = min(N-n,histppage)
    #  print(paste(sep=' ',n,m,i,k))
    print(paste(sep=' ','Page',i, 'of', pages))
	for(j in 1:m)
	{


	if(k>length(nms)) break
        tN = paste(sep='', 'N=',len[k])
        ti = paste(sep='', 'i=', k)
        tt = paste(sep='/', k, N)
        
	tag = paste(sep='  ', nms[k], ti, tN, tt )
        ptag = paste(sep=' ', tag, format(mns[k]), mds[k])
        print(ptag)


        tem  = res[[k]]
        
       
        xr = tem[abs(tem)<20]

        if(LIM==TRUE)
          {
            xr = tem[tem>xlim[1]&&tem<xlim[2]]
            bks = c(min(xr), seq(from=xlim[1], to=xlim[2], length=100), max(xr))
            if(length(xr)==0) next;
          }

        
        m1 = mean(xr)
        m2 = median(xr)
        newmd[k] = m2
        newmn[k] = m1

          
        print(paste(sep=" ", "SEGMENTS:", m1, m2))
        
          
        if(LIM==FALSE)
          { 
            
            hist(xr,  main=tag , breaks=100, xlab="s", col=2)
          }
        else
          {
            
            hist(xr,  main=tag , breaks=bks, xlab="s", col=2)
            
          }
        u = par('usr')
	points(c(m1, m2), c(0 , 0), pch=c(1,2), col=c(2,4), cex=1.2, xpd=TRUE)
        segments(c(m1, m2), c(u[3] , u[3]),c(m1, m2), c( u[4] , u[4]), col=c(2,4) )

        
	k=k+1
	}
	
    readline()
   }
  par(opar)

  invisible(list(nms=nms, meds=mds, means=mns, lens=len, newmd=newmd, mewmn=newmn))
  
  ## hr = histores(res, disp=c(6,4))
  ## plot(hr$meds, hr$means, type='p')
  
}
#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

###  ac2splus.prl < /home/beer/lees/DATA/BOSAI/UW/Pdata.ac > Pbos.ac.R
###  ac2splus.prl < Pdata.ac > Pdata.ac.R
### aclq = getac("Pdata.ac.R")
###  acbos  = getac("Pbos.ac.R")

#########################
###########   earthquake hyocenter comparison
####### compac(aclq, acbos)
####### zoo = locator(2)
#######  compac(aclq, acbos, zoom=zoo)
####### acstats(aclq, flag=flag)
####### acstats(aclq, flag=!flag)
####### acstats(acbos, flag=!flag)

acstats<-function(aclq, flag=TRUE, pch=pch, col=col)
  {
    if(missing(flag)) { flag = rep(TRUE, length(aclq$id)) }
    if(missing(pch)) { pch = 1}
    if(missing(col)) { col = 1}

    
    NS  = names(aclq)
    va = c(5,7,9, 10, 11, 12)
    labs = NS[va]
    
 U = cbind(aclq[[va[1] ]][flag], aclq[[va[2]]][flag],   aclq[[va[3] ]][flag], aclq[[va[4]]][flag],   aclq[[va[5] ]][flag], aclq[[va[6]]][flag])
    
   
    pairs(U, labels=labs,  pch=pch, col=col)

   ###   U = cbind(aclq$depth[flag], aclq$nump[flag], aclq$nums[flag], aclq$delta[flag], aclq$rms[flag], aclq$err[flag])
   

    
  }
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

#######
getac<-function(fn)
  {
    a = scan(file=fn, list(id='', sec=0, latdd=0, londd=0, depth=0, mag=0, nump=0, nums=0, gap=0, delta=0, rms=0, err=0, q1='', q2=''))
    pxy = GLOB.XY(a$latdd, a$londd)
    a$x = pxy$x
    a$y = pxy$y
     
    return(a)
  }
#######
#######
compac<-function(aclq, acbos, lim=rep(TRUE, length(aclq$id)), zoom=list(x=c(0,1), y=c(0,1))  )
{

  if(is.null(aclq$x)) { aclq$x =aclq$londd }
  if(is.null(aclq$y)) { aclq$y =aclq$latdd }

  if(is.null(acbos$x)) { acbos$x =acbos$londd }
  if(is.null(acbos$y)) { acbos$y =acbos$latdd }

  if(missing(lim)) { lim= rep(TRUE, length(aclq$id)) }
  
  rx = range(c(aclq$x[lim],acbos$x[lim]))
  ry = range(c(aclq$y[lim],acbos$y[lim]))
  rz = range(c(aclq$depth[lim],acbos$depth[lim]))

  if(missing(zoom)) { zoom = list(x=rx, y=ry) }

  #  par(mfrow=c(2,2))
  
  plot( rx[lim] ,  ry[lim] ,xlim=zoom$x, ylim=zoom$y,xlab="Km", ylab="Km",  type='n', asp=1)
  u = par('usr')
  points(aclq$x[lim], aclq$y[lim], pch=1, col=4)
  
  points(acbos$x[lim], acbos$y[lim], pch=3, col=2)
  
  segments(aclq$x[lim], aclq$y[lim], acbos$x[lim], acbos$y[lim] , col=gray(0.8))
  
  legend( u[1], u[4], c("aclq", "acbos"), pch=c(1,3), col=c(4,2)  )

 
  

##   nf <- layout(matrix(c(1,2,3,4),2,2,byrow=TRUE), c(3,3,3), c(1,1,1), TRUE)

}
#######
#######
compac1<-function(aclq, acbos, lim=rep(TRUE, length(aclq$id)), zoom=list(x=c(0,1), y=c(0,1))  )
{

  if(is.null(aclq$x)) { aclq$x =aclq$londd }
  if(is.null(aclq$y)) { aclq$y =aclq$latdd }

  if(is.null(acbos$x)) { acbos$x =acbos$londd }
  if(is.null(acbos$y)) { acbos$y =acbos$latdd }

  if(missing(lim)) { lim= rep(TRUE, length(aclq$id)) }
  
  rx = range(c(aclq$x[lim],acbos$x[lim]))
  ry = range(c(aclq$y[lim],acbos$y[lim]))
  rz = range(c(-aclq$depth[lim],-acbos$depth[lim]))

  if(missing(zoom)) { zoom = list(x=rx, y=ry) }

  par(mfrow=c(2,2))
  
  plot( rx[lim] ,  ry[lim] ,xlim=zoom$x, ylim=zoom$y,xlab="Km", ylab="Km",  type='n', asp=1)
  u = par('usr')
  points(aclq$x[lim], aclq$y[lim], pch=1, col=4)
  
  points(acbos$x[lim], acbos$y[lim], pch=3, col=2)
  
  segments(aclq$x[lim], aclq$y[lim], acbos$x[lim], acbos$y[lim] , col=gray(0.8))
  
  legend( u[1], u[4], c("aclq", "acbos"), pch=c(1,3), col=c(4,2)  )
  ## 
  plot( rz ,  ry ,xlab="Km", ylab="Km",  type='n')
 
  points(-aclq$depth[lim], aclq$y[lim], pch=1, col=4)
  
  points(-acbos$depth[lim], acbos$y[lim], pch=3, col=2)
  
  segments(-aclq$depth[lim], aclq$y[lim], -acbos$depth[lim], acbos$y[lim] , col=gray(0.8))
  ## 
  plot( rx ,  rz ,xlab="Km", ylab="Km",  type='n')
 
  points(aclq$x[lim], -aclq$depth[lim], pch=1, col=4)
  
  points(acbos$x[lim], -acbos$depth[lim], pch=3, col=2)
  
  segments(aclq$x[lim], -aclq$depth[lim], acbos$x[lim], -acbos$depth[lim] , col=gray(0.8))
  
 

##   nf <- layout(matrix(c(1,2,3,4),2,2,byrow=TRUE), c(3,3,3), c(1,1,1), TRUE)

}
#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")


compacf<-function(aclq1, aclq0)
{
AB1 = aclq1$q1=="A" | aclq1$q1=="B"  | aclq1$q1=="C"
AB2 = aclq1$q2=="A" | aclq1$q2=="B" | aclq1$q2=="C"

nam1 = aclq1$file
nam2 = aclq0$file

if(is.null(nam1)) { nam1="First"; }
if(is.null(nam2)) { nam2="Second"; }

fgood = AB1 & AB2
ngood = length(fgood[fgood])
#################
par(mfrow=c(2,2))
plot(aclq1$depth, aclq0$depth, main="Depth", xlab=nam1, ylab=nam2)
points(aclq1$depth[fgood], aclq0$depth[fgood], col=4)
abline(0,1)

plot(aclq1$gap, aclq0$gap, main="Gap", xlab=nam1, ylab=nam2)
points(aclq1$gap[fgood], aclq0$gap[fgood], col=4)
abline(0,1)


plot(aclq1$rms, aclq0$rms, main="RMS", xlab=nam1, ylab=nam2)
points(aclq1$rms[fgood], aclq0$rms[fgood], col=4)
abline(0,1)
}

#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")


fix.delays<-function(pix="FQ1.pickfiles", fin="fuj1.del")
{
 ## update the residuals for lquake
  ##  current residual file is in fin
  
##  uw_resid_stat P < FQ1.pickfiles  > hoP
## uw_resid_stat S < FQ1.pickfiles  > hoS

  
  system(paste(sep=" "," uw_resid_stat P <", pix, "> hoP"))
  system(paste(sep=" "," uw_resid_stat S <", pix, "> hoS"))

  
  aP = get.lq.res('residuals.P')

  aS = get.lq.res('residuals.S')


  curres <- scan(file=fin, list(name="", p=0, s=0))


  pup = list(nms=aP$nms[aP$len>200], mds=aP$mds[aP$len>200])
  sup = list(nms=aS$nms[aS$len>200], mds=aS$mds[aS$len>200])

  curres$p[match(pup$nms, curres$name)] = curres$p[match(pup$nms, curres$name)]+pup$mds

  curres$s[match(sup$nms, curres$name)] = curres$s[match(sup$nms, curres$name)]+sup$mds


  cat( file="update.del",paste(sep="", formatC(curres$name, wid=-7), formatC(curres$p, wid=10) , formatC(curres$s, wid=10) ), sep="\n")


}
#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")






GSTA.ROSE<-function(sta=stafile, map=mapfunc)
{
##  cycle through the stations stored in residualsP and plot map and rose diagrams
##   graphics.off(); X11(); X11()
##   
##  
##   STA.ROSE()
  if(missing(sta))
    {
     sta=stas
    }

  for(i in 1:length(nres))
    {
      nres[i]
      r = res[[i]]
      ri = rint[[i]]
      rz = raz[[i]]
      dev.set(dev.next())
      par(mfrow=c(2,1))

    ##   Krose.jml(pi*(90-rz)/180,           bins=36, LABS= c("N", "S", "W", "E"))
       hist(r[abs(r)<10],  breaks=100, xlab="s", col=2)
      
      kros = Krose.jml(pi*(90-rz)/180, abs(r) , bins=36, LABS= c("N", "S", "W", "E"))
      title(main=paste(sep=' ', nres[i], length(r), i, 'of', length(nres)))


      dev.set(dev.next())

      elat = rlat[[i]]
      elon = rlon[[i]]
      ista = match(nres[i],	sta$nm)

      blat = range(c(elat, sta$lat[ista]))
      blon = range(c(elon,  sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)



      ## domap()
      
       #  plot(bxy$x, bxy$y, type='n')

     #  PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
      
      bxy = GLOB.XY(elat,elon)
      points(bxy$x, bxy$y, col=4, pch='.')
   #     points(bxy$x[r>=0.4], bxy$y[r>=0.4], col=2, pch='.')
   #     points(bxy$x[r<0.4], bxy$y[r<0.4], col=4, pch='.')

      

      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)
      text(bxy$x, bxy$y, labels=nres[i], pos=3, col=4)

      readline()
    }
}


#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")
######  source("TTRESID.R"); save.image()


GMAPALL.ROSE<-function(RES, sta=sta, WIN=win, ROSES=MROSE, rscale=1)
{

  if(missing(rscale)) { rscale=1 }


  nres = RES$names
  res = RES$res
  rint= RES$rint
  raz= RES$raz


  if(is.null(sta$nm))
    {
      sta$nm = sta$name
    }
  if(is.null(sta$nm))
    {
      sta$nm = sta$stn
    }
  if(is.null(sta$nm))
    {
      print("No station names")
      return(NULL)
    }

  
  
  if(missing(WIN))
    {
      ista = match(nres,	sta$nm)
      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      
      blat = range(c(sta$lat[ista]))
      blon = range(c(sta$lon[ista] ))
      bxy = GLOB.XY(blat,blon)
      BLOC = list(x=bxy$x, y=bxy$y, lat=blat, lon=blon)
    }
  else
    {
      BLOC=WIN
    }

  

  NCOL = 20
  lens = sapply(res, "length")
  rlens = range(lens)

  RAIN = rev(heat.colors(NCOL))
  rcols = RAIN[findInterval(lens, seq(from=rlens[1], to=rlens[2], length=NCOL))]

 ##  domap()

  
##   PROJmap(MAP, WIN=BLOC, ADD=FALSE, ASP=TRUE, COL=TRUE, PLOT=TRUE)
##    AXESmap( MAP, GRID=TRUE,  WIN=BLOC)
 
  
  u = par('usr')
  ufac = (u[2]-u[1])*0.1

  if(missing(ROSES))
    {
      Roses = as.list(length(nres))
      for(i in 1:length(nres))
        {
          ista = match(nres[i],	sta$nm)
          r = res[[i]]
          ri = rint[[i]]
          rz = raz[[i]]
          Roses[[i]] = Krose.jml(pi*(90-rz)/180, abs(r) , rscale=rscale, bins=36, LABS= c("N", "S", "W", "E"), plot=FALSE)
          Roses[[i]]$name = sta$nm[ista]
        }

    }
  else
    {
      Roses =ROSES
    }


  
  for(i in 1:length(nres))
    {

      ista = match(nres[i],	sta$nm)
      bxy = GLOB.XY(sta$lat[ista],sta$lon[ista])
      points(bxy$x, bxy$y, col=2, pch=6)

   
      
     prose(Roses[[i]], ex=bxy$x, why=bxy$y, prop=ufac, perim=FALSE, add=TRUE, style=1, col=rcols[i])
      
    }
  box()
  HOZscale(lens, RAIN,units="N" )

  invisible(Roses)

}
#########################
#########################
######  source("/home/lees/Progs/R_stuff/TTRESID.R")

