#  read in UW pickfile records
# source("/home/lees/Progs/R_stuff/UWFILES.R")
###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

setstas<-function(stafile)
{
  M = scan(file=stafile, list(name="", lat=0, lon=0, Z=0))
  invisible(M)
}
###############################################
printmc<-function(MC)
  {
print(paste(sep=" ", "F=", MC$F$az , MC$F$dip ,  "G=", MC$G$az , MC$G$dip,  "U=",  MC$U$az , MC$U$dip ,  "V=", MC$V$az , MC$V$dip ,  "P=", MC$P$az , MC$P$dip ,  "T=", MC$T$az , MC$T$dip ))

  }
###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

getmcard<-function(pf)
{
M = scan(file="MCARD", list(id="", F="", az1=0, d1=0, G="", az2=0, d2=0, 
U="", uaz=0, ud=0, V="", vaz=0, vd=0, P="", paz=0, pd =0, T="", taz=0, td=0))
}
###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")
#### A 200406270357 30.03  0N4156  77W5069 12.00  4.1  0/000   0  0 0.00  0.0XX EC
writeAcard<-function(LOC)
  {
    ## A 200406270357 30.03  0N4156  77W5069 12.00  4.1  0/000   0  0 0.00  0.0XX EC
    ############ writeAcard(P$LOC)
    
      ID = paste(sep="",
        formatC(LOC$yr, format="d", wid=4),
        formatC(LOC$mo, format="d", wid=2), 
	formatC(LOC$da, format="d", wid=2), 
	formatC(LOC$hr, format="d", wid=2,  flag="0"), 
	formatC(LOC$mn, format="d", wid=2,flag="0"))

      L = abs(LOC$lat)
      LAT1 = floor(L)
      LAT2 = round((L - LAT1)*6000)
      if(LOC$lat<0){LATNS="S"}  else  {LATNS="N"}
          
      L = abs(LOC$lon)
      LON1 = floor(L)
      LON2 = round((L - LON1)*6000)
      if(LOC$lon<0) {LONEW="W"} else  {LONEW="E"}
          
      if(is.na(LOC$mag)) { LOC$mag=0 }
      if(is.na(LOC$z)) { LOC$z=0 }

### print(paste(sep=' ', LAT1, LATNS, LAT2, LON1, LONEW, LON2))
      
      AC = paste(sep='', "A ", ID, formatC(LOC$se, format="f", digits=2, width=6, flag=" "), 
        formatC(LAT1, format="d", wid=2, flag=" "),LATNS,formatC(LAT2, format="d", width=4, flag="0")," ",
        formatC(LON1, format="d", wid=3, flag=" "),LONEW,formatC(LON2, format="d", width=4, flag="0"),
        formatC(LOC$z, format="f", digits=2, wid=6, flag=" "), " ", formatC(LOC$mag, format="f", digits=1, wid=4, flag=" "),
          "  0/000   0  0 0.00  0.0XX EC"
        )

      return(AC)

  }
######
writeDOTcard<-function(STAS)
  {

    sdots =  vector(length=length(STAS), mode="character")
    for(i in 1:length(STAS))
      {
        tag = paste(sep='', "\.", paste(sep="\.", STAS$name[i], STAS$c3[i]))
        
        sdots[i] = paste(sep=" ", tag , " (P", "P", STAS$ppol[i] ,STAS$parr[i], STAS$pflg[i], STAS$perr[i], STAS$pres[i]  , ")") 
      }
    return(sdots)
  }
###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")
unpackAcard<-function(AC)
{
  ### unpackAcard(AC)
#### A 200406270357 30.03  0N4156  77W5069 12.00  4.1  0/000   0  0 0.00  0.0XX EC
#### c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
  yr = as.numeric(substr(AC, 3, 6))
  mo = as.numeric(substr(AC, 7, 8))
  da = as.numeric(substr(AC, 9, 10))
  hr = as.numeric(substr(AC, 11, 12))
  mn = as.numeric(substr(AC, 13, 14))
  se  = as.numeric(substr(AC, 15, 20))
  LAT1 = as.numeric(substr(AC, 21, 23))
  LATNS = substr(AC, 24, 24)
  LAT2 = as.numeric(substr(AC, 25, 28))
  lat = LAT1+LAT2/(6000)


  LON1 = as.numeric(substr(AC, 30, 32))
  LONEW = substr(AC, 33, 33)
  LON2 = as.numeric(substr(AC, 34, 37))
  lon = LON1+LON2/(6000)

lat[LATNS=="S"] = -lat[LATNS=="S"]
lon[LONEW=="W"] = -lon[LONEW=="W"]
 
MAG  = substr(AC, 45, 48)

MAG = as.numeric(MAG)

  

  
  Z =   as.numeric(substr(AC, 38, 43))

  return(list(yr=yr, mo=mo, da=da, hr=hr, mn=mn, se=se, lat=lat, lon=lon, z=Z, mag=MAG))
}
###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")


getacards<-function(pf)
{
  
  APF  = scan(file=pf, what="", sep="\n", quiet =TRUE)

  EQ =  unpackAcard(APF)
  invisible(EQ)

}
###############################################
getpfile<-function(pf)
{
  APF  = scan(file=pf, what="", sep="\n", quiet =TRUE)
  flg = substr(APF, 0,1)
  ACARD = APF[flg=="A"]
  LOC = unpackAcard(ACARD)


PICS = APF[flg=="."]

  if(length(PICS)<1)
    {
      return(NULL)
    }



  
  MCARD = APF[flg=="M"]
  if(length(MCARD)>1)
    {
      F = list(az=0, dip=0)
      F$az = as.numeric(substr(MCARD, 5, 7))
      F$dip = as.numeric(substr(MCARD,8, 10))

      G = list(az=0, dip=0)
      G$az = as.numeric(substr(MCARD, 14, 16))
      G$dip = as.numeric(substr(MCARD,17, 19))

      U = list(az=0, dip=0)
      U$az = as.numeric(substr(MCARD, 22, 25))
      U$dip = as.numeric(substr(MCARD, 26, 28))

      V = list(az=0, dip=0)
      V$az = as.numeric(substr(MCARD, 32, 34))
      V$dip = as.numeric(substr(MCARD, 35, 37))

      P = list(az=0, dip=0)
      P$az = as.numeric(substr(MCARD, 41, 43))
      P$dip = as.numeric(substr(MCARD, 44, 46))

      T  = list(az=0, dip=0)
      T$az = as.numeric(substr(MCARD, 50, 52))
      T$dip = as.numeric(substr(MCARD, 53, 55))


      MC = list(F=F, G=G, U=U, V=V, P=P, T=T)
    }
  else
    {
      MC = NULL
    }


  FCARD = APF[flg=="F"]
if(length(FCARD)>=1)
  {
    FF = as.numeric(unlist(strsplit(FCARD, " ")))
    FF = FF[!is.na(FF)]
    phi = c(FF[2], FF[5], FF[8])
    lam = c(FF[1], FF[4], FF[7])
    valeig = c(FF[3], FF[6], FF[9])
    
    v = TOCART(phi, lam)

    LIP = v
    
    ## check vectors
   ##  sum(v[,3] * v[,2])
    ## sum(v[,2] * v[,1])
    ## sum(v[,3] * v[,1])

    
  }
  else
    {
      LIP = NA
    }
  ECARD = APF[flg=="E"]
  if(length(ECARD)>=1)
    {
      E = list()
      
      E$LOC = as.character(substr(ECARD, 2+1, 2+2))
      E$rms = as.numeric(substr(ECARD, 4+1, 4+6))
      E$meanres = as.numeric(substr(ECARD, 10+1, 10+6))
      E$sdres = as.numeric(substr(ECARD, 16+1, 16+6))
      E$sdmean = as.numeric(substr(ECARD, 22+1, 22+6))
      E$sswres = as.numeric(substr(ECARD, 28+1, 28+8))
      E$ndf = as.numeric(substr(ECARD, 37+1, 37+3))
      E$fixflgs= as.character(substr(ECARD, 41+1, 41+4))

      E$sterrx= as.numeric(substr(ECARD, 45+1, 45+5))
      E$sterry= as.numeric(substr(ECARD, 50+1, 50+5))
      E$sterrz = as.numeric(substr(ECARD, 55+1,  55+5))     
      E$sterrt= as.numeric(substr(ECARD, 60+1, 60+5))

      ##  these might be non-numeric
      E$mag  = as.numeric(substr(ECARD, 65+1, 65+5))    
      E$sterrmag= as.numeric(substr(ECARD, 70+1, 70+5))
      
    }
  else
    {
      E = NA
    }
    
PICS = APF[flg=="."]

  if(length(PICS)<1)
    {
      return(NULL)
    }

##  fpics = substr(PICS, 0,1)

STAS = list(tag="", name="", comp="", c3="", ppol="", parr=0, pflg=0, perr=0, pres=0, sarr=0, sflg=0, serr=0, sres=0 )
for( i in 1:length(PICS))
  {
    card = PICS[i]
    AS1  = unlist(strsplit(card," "))

    AS1 = sub("_", NA, AS1)

    
    ppacs = which(AS1=="(P"|AS1=="(p")
    ### ppacs = which(AS1=="(p")

    
    pkind = AS1[ppacs+1]

    ppics = ppacs[pkind=="P"]
    
    if(length(ppics)>0)
      {
    ppol = as.numeric(AS1[ppics+2])
    parr = as.numeric(AS1[ppics+3])
    pflg = as.numeric(AS1[ppics+4])
    perr = as.numeric(AS1[ppics+5])
   
    kl = charmatch(")", unlist(strsplit(split='',AS1[ppics+6])))
    if(is.na(kl)) {
	pres = as.numeric(AS1[ppics+6])
      }
    else {
	pres = as.numeric(substr(AS1[ppics+6], 1, kl-1))
      }
  }

    
    spics = ppacs[pkind=="S"]

    if(length(spics)>0)
      {
    
    sarr = as.numeric(AS1[spics+3])
    sflg = as.numeric(AS1[spics+4])
    serr = as.numeric(AS1[spics+5])
    
    kl = charmatch(")", unlist(strsplit(split='',AS1[spics+6])))
    
    if(is.na(kl))
      {
	sres = as.numeric(AS1[spics+6])
      }
    else
      {
	sres = substr(AS1[spics+6], 1, kl-1)
      }

  }



    AS2 = AS1[1]
    AS3 = unlist(strsplit(AS2,"\\."))

    STAS$name[i] = AS3[2]
    STAS$c3[i] = AS3[3]

    AS4 = unlist(strsplit(AS3[3], split=''))
    STAS$comp[i] = AS4[length(AS4)]

    STAS$tag[i] = AS2
    if(length(ppics)>0)
      {
        STAS$ppol[i] = ppol
        STAS$parr[i] = parr
        STAS$pflg[i] = pflg
        STAS$perr[i] = perr
        STAS$pres[i] = pres

      }
    else
      {
        STAS$ppol[i] = NA
        STAS$parr[i] = NA
        STAS$pflg[i] = NA
        STAS$perr[i] = NA
        STAS$pres[i] = NA



      }

    if(length(spics)>0)
      {
        STAS$sarr[i] = sarr
        STAS$sflg[i] = sflg
        STAS$serr[i] = serr
        STAS$sres[i] = sres

      }
    else
      {
        STAS$sarr[i] = NA
        STAS$sflg[i] = NA
        STAS$serr[i] = NA
        STAS$sres[i] = NA

      }
    


  }


return(list(PF=APF, AC=ACARD, LOC=LOC, MC=MC, STAS=STAS, LIP=LIP, E=E ))
}

###############################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

Grake<-function(MC)
{
ang2 = GetRakeSense(MC$U$az, MC$U$dip, MC$V$az, MC$V$dip, MC$P$az, MC$P$dip, MC$T$az, MC$T$dip)

RAK = GetRake(MC$F$az-90, MC$F$dip,   MC$G$az-90,  MC$G$dip , ang2)
RAK$P = list(az=MC$P$az, dip=MC$P$dip)
RAK$T = list(az=MC$T$az, dip=MC$T$dip)

RAK$U = list(az=MC$U$az, dip=MC$U$dip)
RAK$V = list(az=MC$V$az, dip=MC$V$dip)

RAK$UP = FALSE

return(RAK)

}

GOALLM<-function(Mpf)
{
  for(i in 1:length(Mpf))
    {
      pfile = Mpf[i]
      A = getpfile(pfile)
      RAK = Grake(A$MC)
      Simplefoc(RAK)
      text(-0.9,-0.9, pfile, pos=3)
      locator(1)
    }

  return(RAK)
}
########################################
Get1Dvel<-function(infile)
  {
   v =  scan(file=infile, skip=2, list(zp=0, vp=0, ep=0, zs=0, vs=0, es=0), quiet =TRUE)
    #

    plot(c(v$vp,v$vs), c( -v$zp,-v$zs), type='n', xlab="Velocity, km/s", ylab="Depth, km") 
    lines(v$vp, -v$zp, type='s', col=4)
    lines(v$vs, -v$zs, type='s', col=3)
   title(infile)
   u = par('usr')
   LEG = jlegend( u[1], u[4], c("Vp", "Vs"), lwd=2, col=c(4,3), plot=FALSE  )
   jlegend( u[1], u[3]+LEG$rect$h, c("Vp", "Vs"), lwd=2, col=c(4,3), plot=TRUE  )
    
    v$name = infile
    return(v)
  }
########################################
Plot1Dvel<-function(v)
  {
    plot(c(v$vp,v$vs), c( -v$zp,-v$zs), type='n', xlab="Velocity, km/s", ylab="Depth, km")
     u = par('usr')
    lines(v$vp, -v$zp, type='s', col=4)
    lines(v$vs, -v$zs, type='s', col=3)
    grid()
    title(v$name)

    LEG = jlegend( u[1], u[4], c("Vp", "Vs"), lwd=2, col=c(4,3), plot=FALSE  )
    jlegend( u[1], u[3]+LEG$rect$h, c("Vp", "Vs"), lwd=2, col=c(4,3), plot=TRUE  )
    

  }
########################################
Comp1Dvel<-function(v, v2)
  {
    plot(c(v$vp,v$vs, v2$vp, v2$vs), c( -v$zp,-v$zs, -v2$zp,-v2$zs), type='n', xlab="Velocity, km/s", ylab="Depth, km")
     u = par('usr')
    lines(v$vp, -v$zp, type='s', col=4)
    lines(v$vs, -v$zs, type='s', col=3)

    lines(v2$vp, -v2$zp, type='s', col=4)
    lines(v2$vs, -v2$zs, type='s', col=3)

    grid()
    title(v$name)
  }

# v = Get1Dvel("/home/lees/Site/BOS/jap2.vel")
# v2 = Get1Dvel("/home/lees/Site/NAndes/Ecuador/KL2.vel")

########################################


# source("/home/lees/Progs/R_stuff/UWFILES.R")

# source("/home/lees/Progs/R_stuff/radiation.R")
# source("/home/lees/Progs/R_stuff/net.R")


jlegend<-function (x, y, legend, fill, col = "black", lty, lwd, pch, angle = NULL,
    density = NULL, bty = "o", bg = par("bg"), pt.bg = NA, cex = 1,
    xjust = 0, yjust = 1, x.intersp = 1, y.intersp = 1, adj = 0,
    text.width = NULL, merge = do.lines && has.pch, trace = FALSE,
    ncol = 1, horiz = FALSE, plot=TRUE)
{
    if (is.list(x)) {
        if (!missing(y)) {
            if (!missing(legend))
                stop("`y' and `legend' when `x' is list (need no `y')")
            legend <- y
        }
        y <- x$y
        x <- x$x
    }
    else if (missing(y))
        stop("missing y")
    if (!is.numeric(x) || !is.numeric(y))
        stop("non-numeric coordinates")
    if ((nx <- length(x)) <= 0 || nx != length(y) || nx > 2)
        stop("invalid coordinate lengths")
    xlog <- par("xlog")
    ylog <- par("ylog")
    rect2 <- function(left, top, dx, dy, angle, ...) {
        r <- left + dx
        if (xlog) {
            left <- 10^left
            r <- 10^r
        }
        b <- top - dy
        if (ylog) {
            top <- 10^top
            b <- 10^b
        }
        rect(left, top, r, b, angle = angle, density = density,
            ...)
    }
    segments2 <- function(x1, y1, dx, dy, ...) {
        x2 <- x1 + dx
        if (xlog) {
            x1 <- 10^x1
            x2 <- 10^x2
        }
        y2 <- y1 + dy
        if (ylog) {
            y1 <- 10^y1
            y2 <- 10^y2
        }
        segments(x1, y1, x2, y2, ...)
    }
    points2 <- function(x, y, ...) {
        if (xlog)
            x <- 10^x
        if (ylog)
            y <- 10^y
        points(x, y, ...)
    }
    text2 <- function(x, y, ...) {
        if (xlog)
            x <- 10^x
        if (ylog)
            y <- 10^y
        text(x, y, ...)
    }
    if (trace)
        catn <- function(...) do.call("cat", c(lapply(list(...),
            formatC), list("\n")))
    cin <- par("cin")
    Cex <- cex * par("cex")
    if (is.null(text.width))
        text.width <- max(strwidth(legend, u = "user", cex = cex))
    else if (!is.numeric(text.width) || text.width < 0)
        stop("text.width must be numeric, >= 0")
    xc <- Cex * xinch(cin[1], warn.log = FALSE)
    yc <- Cex * yinch(cin[2], warn.log = FALSE)
    xchar <- xc
    yextra <- yc * (y.intersp - 1)
    ymax <- max(yc, strheight(legend, u = "user", cex = cex))
    ychar <- yextra + ymax
    if (trace)
        catn("  xchar=", xchar, "; (yextra,ychar)=", c(yextra,
            ychar))
    if (!missing(fill)) {
        xbox <- xc * 0.8
        ybox <- yc * 0.5
        dx.fill <- xbox
    }
    do.lines <- (!missing(lty) && (is.character(lty) || any(lty >
        0))) || !missing(lwd)
    n.leg <- length(legend)
    n.legpercol <- if (horiz) {
        if (ncol != 1)
            warning("horizontal specification overrides: Number of columns := ",
                n.leg)
        ncol <- n.leg
        1
    }
    else ceiling(n.leg/ncol)
    if (has.pch <- !missing(pch)) {
        if (is.character(pch) && nchar(pch[1]) > 1) {
            if (length(pch) > 1)
                warning("Not using pch[2..] since pch[1] has multiple chars")
            np <- nchar(pch[1])
            pch <- substr(rep(pch[1], np), 1:np, 1:np)
        }
        if (!merge)
            dx.pch <- x.intersp/2 * xchar
    }
    x.off <- if (merge)
        -0.7
    else 0
    if (xlog)
        x <- log10(x)
    if (ylog)
        y <- log10(y)
    if (nx == 2) {
        x <- sort(x)
        y <- sort(y)
        left <- x[1]
        top <- y[2]
        w <- diff(x)
        h <- diff(y)
        w0 <- w/ncol
        x <- mean(x)
        y <- mean(y)
        if (missing(xjust))
            xjust <- 0.5
        if (missing(yjust))
            yjust <- 0.5
    }
    else {
        h <- n.legpercol * ychar + yc
        w0 <- text.width + (x.intersp + 1) * xchar
        if (!missing(fill))
            w0 <- w0 + dx.fill
        if (has.pch && !merge)
            w0 <- w0 + dx.pch
        if (do.lines)
            w0 <- w0 + (2 + x.off) * xchar
        w <- ncol * w0 + 0.5 * xchar
        left <- x - xjust * w
        top <- y + (1 - yjust) * h
    }
    if (bty != "n") {
        if (trace)
            catn("  rect2(", left, ",", top, ", w=", w, ", h=",
                h, "...)", sep = "")
        rect2(left, top, dx = w, dy = h, col = bg, angle = NULL)
    }
    xt <- left + xchar + (w0 * rep(0:(ncol - 1), rep(n.legpercol,
        ncol)))[1:n.leg]
    yt <- top - (rep(1:n.legpercol, ncol)[1:n.leg] - 1) * ychar -
        0.5 * yextra - ymax
    if (!missing(fill)) {
        fill <- rep(fill, length.out = n.leg)
        rect2(left = xt, top = yt + ybox/2, dx = xbox, dy = ybox,
            col = fill, angle = angle)
        xt <- xt + dx.fill
    }
    if (has.pch || do.lines)
        col <- rep(col, length.out = n.leg)
    if (do.lines) {
        seg.len <- 2
        if (missing(lty))
            lty <- 1
        ok.l <- is.character(lty) | lty > 0
        if (missing(lwd))
            lwd <- par("lwd")
        lty <- rep(lty, length.out = n.leg)
        lwd <- rep(lwd, length.out = n.leg)
        if (trace)
            catn("  segments2(", xt[ok.l] + x.off * xchar, ",",
                yt[ok.l], ", dx=", seg.len * xchar, ", dy=0, ...)",
                sep = "")
        segments2(xt[ok.l] + x.off * xchar, yt[ok.l], dx = seg.len *
            xchar, dy = 0, lty = lty[ok.l], lwd = lwd[ok.l],
            col = col[ok.l])
        xt <- xt + (seg.len + x.off) * xchar
    }
    if (has.pch) {
        pch <- rep(pch, length.out = n.leg)
        pt.bg <- rep(pt.bg, length.out = n.leg)
        ok <- is.character(pch) | pch >= 0
        x1 <- (if (merge)
            xt - (seg.len/2) * xchar
        else xt)[ok]
        y1 <- yt[ok]
        if (trace)
            catn("  points2(", x1, ",", y1, ", pch=", pch[ok],
                "...)")
        points2(x1, y1, pch = pch[ok], col = col[ok], cex = cex,
            bg = pt.bg[ok])
        if (!merge)
            xt <- xt + dx.pch
    }
    xt <- xt + x.intersp * xchar
    text2(xt, yt, labels = legend, adj = adj, cex = cex)
    invisible(list(rect = list(w = w, h = h, left = left, top = top),
        text = list(x = xt, y = yt)))
}
########################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

# source("/home/lees/Progs/R_stuff/radiation.R")
# source("/home/lees/Progs/R_stuff/net.R")
########################################


# source("UWFILES.R"); save.image()



GetUW<-function(fname)
  {
    ### read in a W file that is dumped with uw_ascii
    ### check to make sure the file exists
    ### fname = "/home/lees/Site/Krafla/W/2004070722114W"
    if(file.exists(fname)==FALSE) { return(NULL) }
    cmd = paste(sep=' ', "uw_ascii", fname)
    
    system(cmd)
HH = unlist(strsplit(fname, split="/"))
Hname = HH[length(HH)]

    ### this creates two files
    f1 = paste(sep='.', Hname, "INFO")
    f2 = paste(sep='.', Hname, "DATA")

    
    T1 = scan(file=f1, nmax=6, nlines=1, skip=1, list(yr=0, mo=0, dom=0, hr=0, mn=0, sec=0), quiet =TRUE)

    
    N1 = scan(file=f1, n=3,  skip=2, list(n=0, j=0, j=0), quiet =TRUE)
 ###   59  P22  SHE  none AH   4999      0    0      -140 499.999 F 20040707 22:11:40.000
 ###  chano, chname, compflg, chid, src, len, lta, trig, bias, srate, type,
 ###      tim.yr, tim.mon, tim.day, tim.hr, tim.min, tim.sec, corr_flag
STA = scan(file=f1, skip=6, list(i=0, name="", comp="", chid="", src="", len=0, lta=0, trig=0, bias=0, sps=0, type="", t1="", t2=""), quiet =TRUE)

    N2 = length(STA$name)
    D1 = scan(file=f2, quiet =TRUE)

    ma = N2
  info = list(fn=rep(NA, length(ma)), name=rep(NA, length(ma)), yr=rep(NA, length(ma)), jd=rep(NA, length(ma)), mo=rep(NA, length(ma)), dom=rep(NA, length(ma)), hr=rep(NA, length(ma)), mn=rep(NA, length(ma)),sec=rep(NA, length(ma)), msec=rep(0, length(ma)),dt=rep(0, length(ma)),t1=rep(0, length(ma)) ,t2=rep(0, length(ma)), off=rep(0, length(ma)), n1=rep(0, length(ma)), n2=rep(0, length(ma)), n3=rep(0, length(ma)), n=rep(0, length(ma)) )
  ###  fill up data structure and information
    k1 = 0
    k2 = 0

      ascd = as.list(1:N2)
  notes = rep(NA, length(ma))
     stns = rep(NA, length(ma))
  comps = rep(NA, length(ma))

    
  for(j in 1:N2)
	{
         
	  ima = j


         ### k1 = ((j-1)*STA$len[ima]+1)
         ### k2 = k1+STA$len[ima]

          k1 = k1+1
	  k2 = k1+(STA$len[ima]-1)
	 ###  print(paste(sep=' ', ima, j, STA$name[ima], STA$len[ima], k1, k2))
	  ascd[[j]] = D1[k1:k2]
	  k1 = k2
	  notes[j] = paste(sep=' ', STA$name[ima], STA$comp[ima])
	  stns[j] = STA$name[ima]
	  comps[j] = STA$comp[ima]
	  info$fn[j] = fname
	  info$name[j] = f1
	  info$yr[j] = as.numeric(substr(STA$t1[ima], 1, 4))
	 
	  info$mo[j] = as.numeric(substr(STA$t1[ima], 5, 6))
	  info$dom[j] = as.numeric(substr(STA$t1[ima], 7, 8))
          
           info$jd[j] =getjul(info$yr[j], info$mo[j], info$dom[j])


           hms=   as.numeric(unlist(strsplit(split=":",STA$t2[ima])))
	  info$hr[j] = hms[1]
	  info$mn[j] = hms[2]
	  info$sec[j] = hms[3]
	  info$msec[j] = 0
	  info$dt[j] = 1/STA$sps[ima]

 	  info$t1[j] = 0
 	  info$t2[j] = info$dt[j]*(length(ascd[[j]])-1)
           
           
	  info$off[j] = 0
	  info$n1[j] =  length(ascd[[j]])
	  info$n2[j] =  info$n1[j]
 	  info$n3[j] =  info$n1[j]
 	  info$n[j] =  info$n1[j]
          
	}
   wintim=  info$jd[1] + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)
 ex = seq(0,length(ascd[[1]])-1)*info$dt[1]
 dat=NULL
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    USTA= unique(stns)
    nn = N2
    pcol=rep(1, N2)
    for(m in 1:length(USTA))
      {
        pcol[!is.na(match( stns, USTA[m]))] = 2+m
      }
    ok = order(notes)
    
  GFIL = list(JSTR=ascd, STNS=stns, dir=dir, ifile=f1, COMPS=comps, dt=info$dt, KNOTES=notes, info=info,dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim,  ftime=ftime )
  
  invisible(GFIL)
  
  }


###    fname = "/home/lees/Site/Krafla/W/2004070722114W"
###### GU = GetUW(fname)
######    YN = PLOT.SEISN(GU)
######    YN = PLOT.SEISN(GU, sel=which(GU$COMP=="SHV"), notes = GU$KNOTES[which(GU$COMP=="SHV")])


GetUW0<-function(fname)
  {
    ### 
    ### check to make sure the file exists
    ### fname = "/home/lees/Site/Krafla/W/2004070722114W"
  
HH = unlist(strsplit(fname, split="/"))
Hname = HH[length(HH)]

    ### this creates two files
    f1 = paste(sep='.', Hname, "INFO")
    f2 = paste(sep='.', Hname, "DATA")

    
    T1 = scan(file=f1, nmax=6, nlines=1, skip=1, list(yr=0, mo=0, dom=0, hr=0, mn=0, sec=0), quiet =TRUE)

    
    N1 = scan(file=f1, n=3,  skip=2, list(n=0, j=0, j=0), quiet =TRUE)
 ###   59  P22  SHE  none AH   4999      0    0      -140 499.999 F 20040707 22:11:40.000
 ###  chano, chname, compflg, chid, src, len, lta, trig, bias, srate, type,
 ###      tim.yr, tim.mon, tim.day, tim.hr, tim.min, tim.sec, corr_flag
STA = scan(file=f1, skip=6, list(i=0, name="", comp="", chid="", src="", len=0, lta=0, trig=0, bias=0, sps=0, type="", t1="", t2=""), quiet =TRUE)

    N2 = length(STA$name)
    D1 = scan(file=f2, quiet =TRUE)

    ma = N2
  info = list(fn=rep(NA, length(ma)), name=rep(NA, length(ma)), yr=rep(NA, length(ma)), jd=rep(NA, length(ma)), mo=rep(NA, length(ma)), dom=rep(NA, length(ma)), hr=rep(NA, length(ma)), mn=rep(NA, length(ma)),sec=rep(NA, length(ma)), msec=rep(0, length(ma)),dt=rep(0, length(ma)),t1=rep(0, length(ma)) ,t2=rep(0, length(ma)), off=rep(0, length(ma)), n1=rep(0, length(ma)), n2=rep(0, length(ma)), n3=rep(0, length(ma)), n=rep(0, length(ma)) )
  ###  fill up data structure and information
    k1 = 0
    k2 = 0

      ascd = as.list(1:N2)
  notes = rep(NA, length(ma))
     stns = rep(NA, length(ma))
  comps = rep(NA, length(ma))

    
  for(j in 1:N2)
	{
         
	  ima = j


         ### k1 = ((j-1)*STA$len[ima]+1)
         ### k2 = k1+STA$len[ima]

          k1 = k1+1
	  k2 = k1+(STA$len[ima]-1)
	 ###  print(paste(sep=' ', ima, j, STA$name[ima], STA$len[ima], k1, k2))
	  ascd[[j]] = D1[k1:k2]
	  k1 = k2
	  notes[j] = paste(sep=' ', STA$name[ima], STA$comp[ima])
	  stns[j] = STA$name[ima]
	  comps[j] = STA$comp[ima]
	  info$fn[j] = fname
	  info$name[j] = f1
	  info$yr[j] = as.numeric(substr(STA$t1[ima], 1, 4))
	 
	  info$mo[j] = as.numeric(substr(STA$t1[ima], 5, 6))
	  info$dom[j] = as.numeric(substr(STA$t1[ima], 7, 8))
          
           info$jd[j] =getjul(info$yr[j], info$mo[j], info$dom[j])


           hms=   as.numeric(unlist(strsplit(split=":",STA$t2[ima])))
	  info$hr[j] = hms[1]
	  info$mn[j] = hms[2]
	  info$sec[j] = hms[3]
	  info$msec[j] = 0
	  info$dt[j] = 1/STA$sps[ima]

 	  info$t1[j] = 0
 	  info$t2[j] = info$dt[j]*(length(ascd[[j]])-1)
           
           
	  info$off[j] = 0
	  info$n1[j] =  length(ascd[[j]])
	  info$n2[j] =  info$n1[j]
 	  info$n3[j] =  info$n1[j]
 	  info$n[j] =  info$n1[j]
          
	}
   wintim=  info$jd[1] + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)
 ex = seq(0,length(ascd[[1]])-1)*info$dt[1]
 dat=NULL
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    USTA= unique(stns)
    nn = N2
    pcol=rep(1, N2)
    for(m in 1:length(USTA))
      {
        pcol[!is.na(match( stns, USTA[m]))] = 2+m
      }
    ok = order(notes)
    
  GFIL = list(JSTR=ascd, STNS=stns, dir=dir, ifile=f1, COMPS=comps, dt=info$dt, KNOTES=notes, info=info,dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim,  ftime=ftime )
  
  invisible(GFIL)
  
  }





########################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

DORAKMAP<-function(RAK, mapfunc=NULL)
{
if(missing(mapfunc)) { mapfunc = NULL }

 if(!is.null(mapfunc))
   {
     mapfunc <- match.fun(mapfunc)
     mapfunc()
     LJ = length(RAK$PTS$name)
     
     xy = GLOB.XY(RAK$evlat, RAK$evlon)
     Pxy = GLOB.XY(RAK$PTS$lat, RAK$PTS$lon)
     
     
     segments( rep( xy$x , LJ ), rep( xy$y , LJ ), Pxy$x, Pxy$y, col=rgb(0.3, 0, 0) )
   }
}
########################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")
plotPF<-function(GU, P, YN, sel)
  {
      stns = GU$STNS[sel]
      comps = GU$COMPS[sel]

      W =paste(sep=".",GU$STNS, GU$COMPS)
      V =paste(sep=".",P$STAS$name, P$STAS$c3)
      
       ama = match(V, W)

      ## cat(sep="\n", paste(sep=' ',P$STAS$name, GU$STNS[ama]))
      ## cat(sep="\n", paste(sep=' ',P$STAS$name, stns[jma]))

      k = ama
      tees = as.numeric(P$STAS$parr)
      jd =getjul(P$LOC$yr, P$LOC$mo,P$LOC$da )
      tadd =  secdif(GU$info$jd[k], GU$info$hr[k], GU$info$mn[k], GU$info$sec[k], jd, P$LOC$hr, P$LOC$mn, tees)



      WP = which(!is.na(match(k, sel)))
      KP = k[WP]

      jma = match(KP, sel)
      
      
        ##  YN = PLOT.SEISN(GU, sel=sel, WIN=NULL, notes = GU$KNOTES[sel])
      
      ys1 = (YN$n-jma)*YN$dy
      ys2 =  ys1+YN$dy
      x = tadd[WP]
      segments(x, ys1, x, ys2, col=2)

      errs = as.numeric(P$STAS$perr)[WP]
      pres = as.numeric(P$STAS$pres)[WP]

    ####  print(errs)

      segments(x-errs/2, ys2, x+errs/2, ys2, col=rgb(1,0.5, 0.5) )
      segments(x-errs/2, ys2-YN$dy*.2, x-errs/2, ys2, col=rgb(1,0.5, 0.5) )
      segments(x+errs/2, ys2-YN$dy*.2, x+errs/2, ys2, col=rgb(1,0.5, 0.5) )



  ####  print(pres)
      segments(x,ys2- YN$dy*.2, x+pres, ys2- YN$dy*.2, col=rgb(0.5,0.5, 1) )


  }

########################################
# source("/home/lees/Progs/R_stuff/UWFILES.R")

seePF<-function(wfiles, cut=c(0,1), FOC=FALSE, MAP=FALSE )
{
  if(missing(cut)) { cut=NULL }
  if(missing(FOC)) {  FOC=FALSE}
  if(missing(MAP)) { MAP=FALSE }

  if(FOC==TRUE)
    {
      Get.Screens(3)
    }
  
  for(ii in 1:length(wfiles))
    {

      if(FOC==TRUE)
	{
	  dev.set(4)
	}
  

      fname = wfiles[ii]
      nc = nchar(fname)
      aname = substr(fname, 1, nc-1)
      pname = paste(sep='', aname, "p")
      P = getpfile(pname)

      
      GU = GetUW(fname)
      ## system(paste(sep=' ', "cat", pname))
#### cat(sep="\n", paste(sep=' ',P$STAS$name, tees))
#### cat(sep="\n", paste(sep=' ',1:length(P$STAS$name), P$STAS$name, P$STAS$parr, P$STAS$ppol, P$STAS$pflg, P$STAS$perr))
      
      tees = as.numeric(P$STAS$parr)
      
#### sel=which(GU$STNS=="P17" & GU$COMP=="SHV")
####  sel=which(GU$COMP=="SHV")
      sel=which(GU$COMP=="SHV")
      
      stns = GU$STNS[sel]
      
      jma = match(P$STAS$name, stns)
      
      pma = match( stns, P$STAS$name)
      
      ##  stns[pma]
      
      
      jd =getjul(P$LOC$yr, P$LOC$mo,P$LOC$da )
      
      k =sel[jma]
      ## cat(sep="\n", paste(sep=' ',P$STAS$name, GU$STNS[k]))
      
      
      tadd =  secdif(GU$info$jd[k], GU$info$hr[k], GU$info$mn[k], GU$info$sec[k], jd, P$LOC$hr, P$LOC$mn, tees)
      
#### cat(sep="\n", paste(sep=' ',P$STAS$name, P$STAS$parr, tadd))
      win = c(max(min(tadd)-1, 0) , max(tadd)+1)
      
      if(is.null(cut)==TRUE)
	{
	  win = NULL
	}
      else
	{
	  win = c(max(min(tadd)-cut[1], 0) , max(tadd)+cut[2])
	}
      
####  win = NULL
      
      KP = k
      YN = PLOT.SEISN(GU, sel=KP, WIN=win, notes = GU$KNOTES[KP])
      
      ys1 = (YN$n-1:YN$n)*YN$dy
      ys2 =  ys1+YN$dy
      x = tadd
      segments(x, ys1, x, ys2, col=2)

      errs = as.numeric(P$STAS$perr)
      pres = as.numeric(P$STAS$pres)

    ####  print(errs)

      segments(x-errs/2, ys2, x+errs/2, ys2, col=rgb(1,0.5, 0.5) )
      segments(x-errs/2, ys2-YN$dy*.2, x-errs/2, ys2, col=rgb(1,0.5, 0.5) )
      segments(x+errs/2, ys2-YN$dy*.2, x+errs/2, ys2, col=rgb(1,0.5, 0.5) )



  ####  print(pres)
      segments(x,ys2- YN$dy*.2, x+pres, ys2- YN$dy*.2, col=rgb(0.5,0.5, 1) )




      if(MAP==TRUE)
	{

	}
      if(FOC==TRUE)
	{
	  
	  RAK = see1M( pname ,MAP=TRUE)


	  Fmotion(RAK)


#### 	  RAK = seeMech(pfile, stafile="/home/lees/Site/Krafla/krafsta.llz",
#### 	    velfile="/home/lees/Site/Krafla/PICKS/krafla1.vel")
#### 	  Fmotion(RAK)
	  
	}

      locator()
    }
}
########################################
				# source("UWFILES.R"); save.image()
########################################
########################################
read1UW<-function(fname)
  {
    
    HH = unlist(strsplit(fname, split="/"))
    Hname = HH[length(HH)]
    
    
    nc = nchar(fname)
    aname = substr(fname, 1, nc-1)
    pname = paste(sep='', aname, "p")
    
    P = getpfile(pname)
    
    GU = GetUW(fname)
    
    GU$COMPS=substr(GU$COMPS, 3,3)
    
    sel=which(GU$COMP=="V")
    
    
    
###  YN = PLOT.SEISN(GU, sel=sel, notes = GU$KNOTES[sel])
    
    
    JDAY = getjul(P$LOC$yr, P$LOC$mo , P$LOC$da)
    
    PPX = as.list(1:length(P$STAS$parr[P$STAS$comp=="V"]))
    
    j=1
    for(J in 1:length(P$STAS$parr))	
      {
        if(P$STAS$comp[J]=="V")
          {
            PPX[[j]] = list( pick=c(P$LOC$yr, JDAY, P$LOC$hr, P$LOC$mn, P$STAS$parr[J]), kind="P", sta=P$STAS$name[J] , comp=P$STAS$comp[J], col=rgb(1.0, .3, .4))
            j = j+1
          }
        
      }
    
    
    P$STAS$name[rev(order(P$STAS$parr))]
    
    P$STAS$comp[rev(order(P$STAS$parr))]
    
    order(P$STAS$parr[which(P$STAS$comp=="V")])
    
    
    
    Vsta = P$STAS$name[which(P$STAS$comp=="V")]
    Varr = P$STAS$parr[which(P$STAS$comp=="V")]
    
    osta = Vsta[(order(Varr))]
    msta = match(osta, GU$STNS)
    
    sel = msta 
    
    
    YP = PICK.GEN(GU, sel=sel, APIX=PPX, PADDLAB=PADDLAB)
    return(YP)
  }
########################################
				# source("UWFILES.R"); save.image()
########################################
########################################
contPfile<-function(fname, STALOC)
  {
    
    HH = unlist(strsplit(fname, split="/"))
    Hname = HH[length(HH)]
    
    
    nc = nchar(fname)
    aname = substr(fname, 1, nc-1)
    pname = paste(sep='', aname, "p")
    
    P = getpfile(pname)
    ###  P$STAS$name

    picknam = P$STAS$name[P$STAS$comp=="V"]
    pickarr = P$STAS$parr[P$STAS$comp=="V"]

    
  
    MAT = match( picknam, STALOC$NAMS)
    
    GOODMAT = MAT[!is.na(MAT)]

    
    picknam=picknam[!is.na(MAT)]
    pickarr=pickarr[!is.na(MAT)]


     if( length(pickarr)< 1 )
      {
        plot(0,0, main=paste(sep=' ',fname, "NOT ENOUGH PICKS"))
        print(paste(sep=' ',fname, "NOT ENOUGH PICKS"))
        return()
      }

    
    lon = STALOC$LONS[GOODMAT]
    lat = STALOC$LATS[GOODMAT]
    nam = STALOC$NAMS[GOODMAT]

    setPROJ(2, mean(lat),mean(lon))
    TXY = GLOB.XY(lat, lon)


        if( length(pickarr)< 5 )
      {
        plot(TXY$x, TXY$y,, main=paste(sep=' ',fname, "NOT ENOUGH PICKS"))
        print(paste(sep=' ',fname, "NOT ENOUGH PICKS"))
        return()
      }

    

    tims = pickarr-min(pickarr)
   
    EX = seq(from=min(TXY$x), to=max(TXY$x), length=100)
    WHY = seq(from=min(TXY$y), to=max(TXY$y), length=100)

 

    
    ####  plot(TXY$x, TXY$y, type='p')
 
   ####   text(TXY$x, TXY$y, labels=nam, col=4 , pos=3)
    ####  text(TXY$x, TXY$y, labels=format.default(tims, digits =3), pos=1)

   ####   print(paste(sep=' ', "TEST:", length(TXY$x),length(tims)))
    
    
    if(length(tims)!=length(TXY$x))
      {
        print("error in file")

      }
    PAC <-  data.frame(cbind(x=TXY$x, y=TXY$y, z=tims))

    SAVPAC<<-list(PAC=PAC, NAM=nam)
    
    print(PAC)

    ## ZZ = interp.new(PAC$x, PAC$y, PAC$z, xo=EX, yo=WHY, linear=FALSE, extrap=TRUE)
     ZZ = interp(PAC$x, PAC$y, PAC$z, xo=EX, yo=WHY)

 
    
    ####  PAC.kr <- surf.gls(2, expcov, PAC$x, PAC$y, PAC$z, d=0.7)

    
    ####
    ####   
    ####    prsurf <- prmat(PAC.kr,   min(PAC$x), max(PAC$x), min(PAC$y), max(PAC$y) ,100)

  ####   d =  dim(prsurf$z)

  ##  CH = chull(TXY$x, TXY$y)

 ##   POL = list(x=TXY$x[CH] , y= TXY$y[CH] )
    ##  lines(TXY$x[CH] , TXY$y[CH])
  ####    xpo = matrix(rep(prsurf$x,length(prsurf$y)), ncol=length(prsurf$x),  nrow = length(prsurf$y))

  ####     ypo = matrix(rep(prsurf$y,length(prsurf$x)), ncol=length(prsurf$x),  nrow = length(prsurf$y), byrow=TRUE)



   ##   ds2 = as.points(as.vector(xpo), as.vector(ypo) )
    
   ##  tru <- inout(ds2, cbind( c(POL$x,POL$x[1]), c(POL$y,POL$y[1]) ) , quiet=FALSE)


    
    plot(TXY$x, TXY$y, type='n',xlab="East, km", ylab="North, km", asp=TRUE)
    ## image(prsurf, col = gray((0:100)/100) , add=TRUE)
    ## image(prsurf, col = terrain.colors(100) , add=TRUE)

   ##  prsurf$z[!tru] =  NA
    


    ###   image(prsurf, col = topo.colors(100) , add=TRUE)
   ###   contour(prsurf, levels=seq(min(PAC$z), max(PAC$z), length=10), add=TRUE)
  ###     antipolygon(POL$x, POL$y, col=rgb(1,1,1) )
    image(ZZ, col = topo.colors(100) , add=TRUE)
    contour(ZZ, levels=seq(min(PAC$z), max(PAC$z), length=10), add=TRUE)
        

    points(TXY$x, TXY$y, col=4)
    text(TXY$x, TXY$y, labels=nam, col=4 , pos=3)
    text(TXY$x, TXY$y, labels=format.default(tims, digits =3), pos=1)
    title(main=fname)

}
########################################
				# source("UWFILES.R"); save.image()
