#########  R code for autpopicking seismic traces
####  source("/home/lees/Progs/R_stuff/autopix.R")

###  needs GET.seis prepGG3 ratcurve butfilt 


## thresh = 2
## Tthresh2 = 125
## deltat = 0.008
## LEN = 1000
STLTcurve<-function(y, dt=0.008, fwlen =  125,  bwlen  = 125, stretch=1000, MED=255, PLOT=FALSE)
{
###  do automatic picking on a trace
###  scale y so it can be used as an integer array

     if(missing(dt))  {  dt=0.008 }

  if(missing(fwlen))  {   fwlen =  1000 }
  if(missing(bwlen))  {   bwlen =  1000 }
  if(missing(stretch))  {  stretch =  1000 }

  if(missing(MED))  {  MED = 255 }
     
   if(missing(PLOT))  {  PLOT=FALSE }
 
  lx = length(y)
  r = range(y)

  rat = rep(0, length(y))

  logflg = 0

     ###   precondition the seismogram

##########################################################
############     ####  this is old way of doing things:
#############s =  abs(y-mean(y))
############
#############rs = range(s)
############
#############s = 10*(0.5+(s-rs[1])/(rs[2]-rs[1]))
##########################################################

##########################################################
############     ###  this is how it is done for picking in snaps:
############ ###  s = abs(10000*(y))

############ ###    s = 10*s
############ ###   s[s>0] = s[s>0] +0.5
############ ###   s[s<0] = s[s<0] -0.5
##########################################################

     #######  new preconditioning

     ey = envelope(y-mean(y))
     ##########apply a robust smoothing filter (running median)
     print(paste(sep=' ', "################ in STLT ", lx)) 
     s = runmed(ey, MED, algorithm ="Stuetzle")    
     rs = range(s)
     s = stretch*(0.5+(s-rs[1])/(rs[2]-rs[1]))     


     ####  here we need to rectify problems associate with very large variations

   ####  kappa = mean(s)+2*sd(s)

  ####   s[s>kappa] = kappa

     ###  need to look for changes in s
     ###  s should be flat in the noise region and then start rising
     ###   where the signal starts - need to capture that point.
     

  quack = .C("CALL_DFBRAT",
    as.double(s),  as.double(rat),
    as.integer(lx),as.integer(fwlen), as.integer(bwlen), as.integer(logflg) )


     ####   plot.ts(quack[[2]], ylab="ratio")
      
  ix = which.max(quack[[2]])


     if(PLOT==TRUE)
       {
         opar <- par(no.readonly = TRUE)
         x = seq(1:length(y))
         
         par(mfrow=c(3,1))
         plot(x, y, type='n')
         abline(v=ix, col=2)
         lines(x,y)
         
         plot(x, s, type='n')
         abline(v=ix, col=2)
         lines(x,s)
         
         plot(x, quack[[2]], ylab="ratio", type='n')
         abline(v=ix, col=2)
         lines(x, quack[[2]])
         title(paste(sep=' ', "Ratio Curve=", fwlen, bwlen))

      u = par("usr")
         L = 0
         z = u[3]+0.95*(u[4]-u[3])
      segments(L, z, L+bwlen, z, col=2, lwd=3)
      segments(L+bwlen+1000, z,  L+bwlen+1000+fwlen, z, col=4, lwd=3)
         invisible( par(opar))
 
       }

  return(list(ind=ix, rat=quack[[2]]))
}

##########################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

PSTLTcurve<-function(y, dt=0.008, fwlen =  125,  bwlen  = 125, perc=0.05, stretch=1000, MED=255, PLOT=FALSE)
{
###  do automatic picking on a trace
###  scale y so it can be used as an integer array

     if(missing(dt))  {  dt=0.008 }

  if(missing(fwlen))  {   fwlen =  1000 }
  if(missing(bwlen))  {   bwlen =  1000 }
  if(missing(stretch))  {  stretch =  1000 }

  if(missing(MED))  {  MED = 255 }
  if(missing(perc))  {  perc = 0.05  }
     
   if(missing(PLOT))  {  PLOT=FALSE }
 
  lx = length(y)

     if(lx<(fwlen+bwlen+MED))
       {

         return(list(ind=1, eye=1, rat=1))

       }

     
  r = range(y)

  rat = rep(0, length(y))

  logflg = 0


     #######  new preconditioning

     ey = envelope(y-mean(y))

     
     ##########apply a robust smoothing filter (running median)
     print(paste(sep=' ', "################ in PSTLT ", lx)) 
     s = runmed(ey, MED, algorithm ="Stuetzle", endrule ="constant")    
     rs = range(s)
     s = stretch*(0.5+(s-rs[1])/(rs[2]-rs[1]))


     quack = .C("CALL_DFBRAT",
       as.double(s),  as.double(rat),
       as.integer(lx),as.integer(fwlen), as.integer(bwlen), as.integer(logflg) )


####   plot.ts(quack[[2]], ylab="ratio")
      ###  this is the maximum of the ratio curve:
     therat = quack[[2]]
     ix = which.max(therat)
     mix = ix

     if(1 == 1 )
       {
     prat = peaks(therat)
     ####print(therat[prat])
     mrat = mean(c(mean(therat), therat[ix]), na.rm=TRUE)
      ####print(mrat)
     rx =   which(prat)
     #### print(rx)
     gx = rx[therat[rx]>=mrat]
     ####print(gx)
     mix = min(gx, na.rm=TRUE)
   }
     if(is.na(mix)) { mix = ix }
     
     ###  need to look for changes in s
     ###  s should be flat in the noise region and then start rising
     ###   where the signal starts - need to capture that point.
     
     s2 = runmed(ey, 4*MED+1, algorithm ="Stuetzle", endrule ="constant")    
     rs = range(s2)
     s2 = stretch*(0.5+(s2-rs[1])/(rs[2]-rs[1]))
     ex = seq(1,length(s2))

     M = fwlen
     el = s2[1:M]
     
     if(length(el)<1)
       {
         print(paste(sep=' ',"problem in PSTLTcurve", M) )
         return(NA)
       }

     if(length(which(is.na(el)))>1)
       {
         print(paste(sep=' ',"problem in PSTLTcurve", M) )
         return(NA)
       }
     
     m2 = sqrt(var(el))
     mel = stats(el)
     ### abline(h=mel$mean, col=3)
     ### abline(h=mel$mean+6*mel$std, col=4)
 
     m1 = mean(el)
     m3 = max(s2)
                     ####  source("/home/lees/Progs/R_stuff/autopix.R")

     kap = (m1+perc*(m3-m1))
     ef = s2>kap&ex>M

     if(length(ex[ef])>2)
       {
         eye1 = min( ex[ef])
         ###  if eye1 is greater than mix....look in a different way
         if(eye1 >(mix))
           {
             M = max(M, eye1-2*M)
             el = s2[1:M]
            
                ### abline(h=mel$mean, col=3)
                ### abline(h=mel$mean+6*mel$std, col=4)
             m1 = mean(el)
             m3 = max(s2)
     
             kap = (m1+perc*(m3-m1))

            ### kap = max(el)
            ### kap = kap+0.1*(kap-mel$mean)
             ef = s2>kap&ex>M

           }
       }       

     if(length(ex[ef])>2)
       {
         eye = min( ex[ef])
       }
     else
       {
         eye = ix
       }

     SNR = 0
     isig1 = ix+1
     isig2 = min(c((ix+fwlen), length(ex)))
     inois1 = ix-1
     inois2 = max(c((ix-fwlen), 1))

     nois = y[inois1:inois2]
     if(length(nois)>2)
       {
         nois2 = sum(nois^2)
         if(nois2>0)
           {
             sig2 = sum(y[isig1:isig2]^2)
             if(sig2>=0)
               {
                 SNR = sig2/nois2
               }
           }
       }

     

     if(PLOT==TRUE)
       {
         opar <- par(no.readonly = TRUE)
         x = seq(1:length(y))
         
         par(mfrow=c(3,1))
         plot(x, y, type='n')
         abline(v=ix, col=2)
         abline(v=eye, col=4)
         abline(v=mix, col=3)
         lines(x,y)
         
         plot(x, s, type='n')
         abline(v=ix, col=2)
         abline(v=mix, col=3)        
         abline(h=kap, lty=2, col=3)

         
         lines(x,s)
         lines(x,s2, col=5)

         abline(v=eye, col=4)
         abline(v=eye1, col=rgb(1, .5, .5) )

         
         plot(x, therat, ylab="ratio", type='n')
         abline(v=ix, col=2)
         abline(v=eye, col=4)
         abline(v=mix, col=3)         
         lines(x, therat)
         title(paste(sep=' ', "Ratio Curve=", fwlen, bwlen, " SNR=", format.default(SNR, digits=5)))

      u = par("usr")
         L = 0
         z = u[3]+0.95*(u[4]-u[3])
         
     ######    print(paste(sep=' ', "psegments 1", L, z, L+bwlen, z))
         
      segments(L, z, L+bwlen, z, col=2, lwd=3)

    ######    print(paste(sep=' ', "psegments 2",L+bwlen+100, z,  L+bwlen+100+fwlen, z))
         
      segments(L+bwlen+100, z,  L+bwlen+100+fwlen, z, col=4, lwd=3)
         ## invisible( par(opar))
 
       }

  return(list(flag=1, ind=ix, eye=eye, mix=mix, SNR=SNR,  s2=s2, rat=therat))
}

##########################################################
####  source("autopix.R"); save.image()


####  source("/home/lees/Progs/R_stuff/autopix.R")


####################################################
####################################################
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

Thresh.J<-function(y, thresh)
  {
      x = 1:length(y)
      ##  determine cut off for ratio curve
      ##  this may not be a great idea:  Athresh = min(thresh, 0.8*max(y))
       Athresh = thresh
      k = y>Athresh
      G = rep(0,length(y))
      G[k] =  y[k]
      if(length(y[k])<1) { return(NA) }
      h = x[k]
      dd = diff(h)
      wd = which(dd>1)
      nw = length(wd)

      ## if there is only one sequence (all ones), return the first value of that sequence
      if(nw<1) { return(list(J=h[1], L=h[1])) }
      J = c(h[1], h[wd[1:(length(wd))]+1])
      
      L = c(h[wd[1:(length(wd))]],  h[length(h)])

      

      return(list(J=J, L=L) )
  }
####################################################
####################################################
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

pickit<-function(ay, deltat=0.008 ,  FRWD=8,  BKWD=8,  sbef=1, saft=6, thresh=2, Tthresh2=7, stretch=1000, flo=0.1, fhi=5.0, Kmin=7)
  {
    if(missing(deltat)) { deltat=0.008 }
    if(missing(FRWD)) { FRWD=8 }
    if(missing(BKWD)) { BKWD=8 }
    
    if(missing(sbef)) { sbef = 1 }
    if(missing(saft)) { saft = 6 }
    if(missing(thresh)) { thresh=2 }
    if(missing(Tthresh2)) { Tthresh2= (sbef+saft) }
    if(missing(stretch)) { stretch=1000 }
    if(missing(flo)) { flo = .1 }
    if(missing(fhi)) { fhi=5.0 }
    if(missing(Kmin)) { Kmin = 7 }

    if(fhi > 1/(2*deltat)) { fhi = (1/(2*deltat))- 0.05*(1/(2*deltat)) }

    
    ##########   bandpass filter the data, if both flo and fhi are negative, do not filter
    if(flo>0 & fhi>0)
      {
        fy = butfilt(ay , flo , fhi , deltat , "BP" , "BU" )
      }
    else
      {
        fy = ay
      }
    
    LEN1 = FRWD/deltat
    LEN2 = BKWD/deltat

    
    A = STLTcurve(fy, dt=deltat, fwlen = LEN1,  bwlen  = LEN2, stretch=stretch, MED=255, PLOT=FALSE)
###        A = STLTcurve(fy, dt=deltat, fwlen = LEN1,  bwlen  = LEN2, PLOT=TRUE)


    x = 1:length(A$rat)

    J = Thresh.J(A$rat,thresh)
    
    Kthresh2 = Tthresh2/deltat
    
    Z = J$J[(J$L-J$J)>Tthresh2]

    ##  lower thresh hold until have a minimum number of picks and are above 1.01 S/N
    ##  thresh drops below 1.01 then we are picking noise.
    ##  the min number of picks (7) should be a parameter to adjust to dataset
    while(length(Z)<Kmin & thresh>1.01)
      {
        thresh = thresh-0.01
        J = Thresh.J(A$rat,thresh)
        
        Z = J$J[(J$L-J$J)>Kthresh2]
      }


    
    a1 = x[J$J]-sbef/deltat
    a2 = x[J$L]+saft/deltat

###  get rid of overlapping traces
    tt4 = rep(0, length(x))
    for(j in 1:length(a1))
      {
        tt4[x>=a1[j]&x<=a2[j]] = 1
      }
    
    J = Thresh.J(tt4,.5)
    a1 = x[J$J]
    a2 = x[J$L]

    return(list(RAT=A$rat, x=x, ay=ay, fy=fy, deltat=deltat, J=J$J , Z=Z, a1=a1, a2=a2, thresh=thresh, Tthresh2=Tthresh2, Kmin=Kmin) )
  }
####################################################
####################################################
####################################################
plot.pickit<-function(PP4)
{

  par(mfrow=c(3,1))
  plot(PP4$x, PP4$ay, type='l')
  winmark(PP4$a1,PP4$a2,col=4)
  
  plot(PP4$x, PP4$fy, type='l')
  winmark(PP4$a1,PP4$a2,col=4)
  plot(PP4$x, PP4$RAT, type='l', axes=FALSE, xlab='')
  abline(v=PP4$x[PP4$J], col=2)
  abline(h=PP4$thresh, col=3, lty=2)
  axis(2)
  box()
      winmark(PP4$a1,PP4$a2,col=4)

  A = rep(0, length=length(PP4$RAT))
  A[PP4$RAT>PP4$thresh] = 1

  ##  points(PP4$x[PP4$RAT>PP4$thresh] 
  

}


####################################################
####################################################
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

ETECT1<-function(fnames4 , FRWD=8,  BKWD=8, sbef=1, saft=6, thresh=2, Tthresh2=7, stretch=1000, flo=0.1, fhi=5.0, Kmin=7, kind=1)
{ 
#######    do automatic picking on single traces
#######  fnames4=names of files to read in
#######  FRWD=forward window in seconds
#######  BKWD=backward window in seconds
#######  sbef=before window in seconds
#######  saft=back window in seconds
#######  thresh=threshhold
#######  Tthresh2=window threshhold
#######  stretch=stretching factor to multiply prior i=to rat curve
#######  flo=low freq cutoff for band pass
#######  fhi=high freq for  bandpass 

    if(missing(FRWD)) { FRWD=8 }
    if(missing(BKWD)) { BKWD=8 }
    if(missing(sbef)) { sbef = 1 }
    if(missing(saft)) { saft = 6 }
    if(missing(thresh)) { thresh=2 }
    if(missing(Tthresh2)) { Tthresh2=2 }
   if(missing(stretch)) { stretch=1000 }
    if(missing(flo)) { flo = .1 }
    if(missing(fhi)) { fhi=5.0 }
        if(missing(Kmin)) { Kmin = 7 }
if(missing(kind)) { kind=1 }
    

    
  
  for(i in 1:length(fnames4))
    {
      ##  GET.seis(fnames, kind=1, PLOT=FALSE)
      GG4 = GET.seis(fnames4[i], kind=kind, PLOT=FALSE)
      GH4=prepGG3(GG4)
      ay4 = GH4$JSTR[[1]]
      deltat = GH4$dt[1]

     
      PP4 = pickit(ay4, deltat=deltat, FRWD=FRWD,  BKWD=BKWD, sbef=sbef, saft=saft, thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin)

      par(mfrow=c(3,1))
      plot(PP4$x, ay4, type='l')
      winmark(PP4$a1,PP4$a2,col=4)

      plot(PP4$x, PP4$fy, type='l')
      winmark(PP4$a1,PP4$a2,col=4)
      plot(PP4$x, PP4$RAT, type='n', axes=FALSE, xlab='')
      abline(v=PP4$x[PP4$J], col=3)
      axis(2)
      box()
      winmark(PP4$a1,PP4$a2,col=4)
      abline(h=PP4$thresh, col=2, lty=2)
      lines(PP4$x, PP4$RAT)
  
      
      locator()
      
    }
    invisible(PP4)
}
########
########
GETPAD<-function(RT)
  {
    N = length(RT)

    zeeb = rep(0,length=N)
    zeea = rep(0,length=N)

  gtim1 = rep(NA, N)
  gtim2 = rep(NA, N)
  gn = rep(NA, N)
  gdt  = rep(NA, N)
    

  ####  prepare some of the stats on the times of the waveforms
  for(i in 1:N)
    {
      
      dt = round(1000*RT[[i]]$dt)/1000
      n = RT[[i]]$n
      
      gtim1[i]  = RT[[i]]$jd+RT[[i]]$hr/24+RT[[i]]$mn/(24*60)+(RT[[i]]$sec +RT[[i]]$msec/1000+ RT[[i]]$t1)/(24*3600)
      gtim2[i]  = gtim1[i]+RT[[i]]$n*RT[[i]]$dt/(24*3600)
      
      gn[i] = n
      gdt[i] = dt
      ## gfn[i] = RT[[i]]$fn
      print(paste(sep=' ', i, RT[[i]]$n, RT[[i]]$dt, RT[[i]]$jd, RT[[i]]$hr, RT[[i]]$mn, RT[[i]]$sec, RT[[i]]$msec,RT[[i]]$t1 ))

    }

    wmin = which.min(gtim1)
    wmax = which.max(gtim2)

####  set up the padding
  r1 =  round((gtim1-gtim1[wmin])*24*3600/gdt)
  r2 = round((gtim2[wmax]-gtim2)*24*3600/gdt)
  BigR = r1+gn+r2
  ma = 1:length(gdt)
   
  K = BigR[ma[1]]


    return(list(r1=r1, r2=r2, K=K))
    
  }



####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

ETECT3<-function(fnames4, fnames5, fnames6, FRWD=8,  BKWD=8,  sbef=1, saft=6, DFRWD=.5,  DBKWD=.5, thresh=2,  Tthresh2=7, stretch=1000, flo=0.1, fhi=5.0, PLOT = FALSE, Kmin=7, perc=0.05, kind=1)
{ 
#######    do automatic picking on 3 component traces
#######  fnames4, fnames5, fnames6=names of files to read in vertical north east
#######  FRWD=forward window in seconds
#######  BKWD=backward window in seconds
#######  sbef=before window in seconds
#######  saft=back window in seconds
#######  thresh=threshhold
#######  Tthresh2=window threshhold
#######  stretch=stretching factor to multiply prior i=to rat curve
#######  flo=low freq cutoff for band pass
#######  fhi=high freq for  bandpass 
  if(missing(FRWD)) { FRWD=8 }
  if(missing(BKWD)) { BKWD=8 }
  if(missing(DFRWD)) { DFRWD=.5 }
  if(missing(DBKWD)) { DBKWD=.5 }

  if(missing(sbef)) { sbef = 1 }
  if(missing(saft)) { saft = 6}
  if(missing(thresh)) { thresh=2 }
  if(missing(Tthresh2)) { Tthresh2= (sbef+saft) }
  if(missing(stretch)) { stretch=1000 }
  if(missing(flo)) { flo = .1 }
  if(missing(fhi)) { fhi=5.0 }
  if(missing(PLOT)) {  PLOT = TRUE }
  if(missing(Kmin)) { Kmin = 7 }
  if(missing(kind)) { kind=1 }
  if(missing(perc)) { perc=0.05 }
  
  BIGN = length(fnames4)

  PTIMES = as.list(1:BIGN)


  ####  main loop
  for(i in 1:BIGN)
    {
      print("######################################################")
      print(paste(sep=' ', "ETECT3 WORKING ON i = ", i, "of ", BIGN))
      ##  GET.seis(fnames, kind=1, PLOT=FALSE)
      GG4 = GET.seis(fnames4[i], kind=kind, PLOT=FALSE)
      GH4=prepGG3(GG4)
      ay4 = GH4$JSTR[[1]]
      deltat = GH4$dt[1]
      PP4 = pickit(ay4, deltat=deltat,  FRWD=FRWD,  BKWD=BKWD,sbef=sbef, saft=saft,
        thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin)
      
        ###############    
      GG5 = GET.seis(fnames5[i], kind=kind, PLOT=FALSE)
      GH5=prepGG3(GG5)
      ay5 = GH5$JSTR[[1]]
      deltat = GH5$dt[1]
      PP5 = pickit(ay5, deltat=deltat,  FRWD=FRWD,  BKWD=BKWD, sbef=sbef, saft=saft,
        thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin)
      
        ###############    

      GG6 = GET.seis(fnames6[i], kind=kind, PLOT=FALSE)
      GH6=prepGG3(GG6)
      ay6 = GH6$JSTR[[1]]
      deltat = GH6$dt[1]
      PP6 = pickit(ay6, deltat=deltat,  FRWD=FRWD,  BKWD=BKWD, sbef=sbef, saft=saft,
        thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin)

      ###############  create a series of ones for hits on the STLT algor

      ## this needs to be fixed:


      STARTS = list( GH4$info, GH5$info , GH6$info)
      tees = GETPAD(STARTS)
      
      
            tt4 = rep(0, length(PP4$x))

      for(j in 1:length(PP4$a1))
        {
          tt4[PP4$x>=PP4$a1[j]&PP4$x<=PP4$a2[j]] = 1
        }
        tt4 = c(rep(0, tees$r1[ 1 ]) , tt4,    rep(0, tees$r2[1]))
     ###############
     
       tt5 = rep(0, length(PP5$x))

      for(j in 1:length(PP5$a1))
        {
          tt5[PP5$x>=PP5$a1[j]&PP5$x<=PP5$a2[j]] = 1
        }
        tt5 = c(rep(0, tees$r1[ 2 ]) , tt5,    rep(0, tees$r2[2]))
     ###############
      tt6 = rep(0, length(PP6$x))
      
      for(j in 1:length(PP6$a1))
        {
          tt6[PP6$x>=PP6$a1[j]&PP6$x<=PP6$a2[j]] = 1
        }
        tt6 = c(rep(0, tees$r1[ 3]) , tt6,    rep(0, tees$r2[3]))
      
     ####  source("/home/lees/Progs/R_stuff/autopix.R")

      
     ###############
      ## weight all three components the same
     ##### if( length(tt4) != length(tt5) != length(tt6) )
     #####   {
     #####     print("error in tt4+tt5+tt6")
     #####   }

      print( tees$r1)
       print( tees$r2)
     
 print(paste(sep=' ',"ETECT3 lengths PPa:", length(PP4$a1), length(PP5$a1), length(PP6$a1) ))
 
 print(paste(sep=' ',"ETECT3 lengths PP:", length(PP4$x), length(PP5$x),  length(PP6$x) ))
        
 print(paste(sep=' ',"ETECT3 lengths tt:", length(tt4), length(tt5),  length(tt6) ))
      
      ALLP = tt4+tt5+tt6

                                        #  weight the vertical more than the horizontals
      ## ALLP = 2.0*tt4+ tt5+ tt6
      
      JJ = Thresh.J(ALLP, 2.5)
###   JJ = Thresh.J(ALLP,1.5)
      NJ = length(JJ$J)
      if(NJ<1)
        {

          detpix=0
          next;
        }
      detpix = rep(0,length(JJ$J))
      
      for(j in 1:NJ)
        {
          ## print(paste(sep=" ", "****************** sub win=", i, j, "of ", NJ, BIGN))
          ##  b1 = (JJ$J[j]-sbef/deltat)
          ##  b2 = (JJ$L[j]+saft/deltat)
          b1 = (JJ$J[j]-75)
          b2 = (JJ$L[j]+200)

          if(b2>length(PP4$fy)) b2 = length(PP4$fy)
          if(b1<1) b1 = 1
          z4= PP4$fy[b1:b2]

          ##  z5= PP5$fy[b1:b2]
          ## z6= PP6$fy[b1:b2]
          
          xz = PP4$x[b1:b2]

          if(length(z4)<375)
            {
              print("Very short window")
              detpix[j] = 0
              next

            }

####  here do the detailed picking to find a good first arrival

     ####     RATP = ratcurve(z4, dt=PP4$deltat, fwlen =  75,  bwlen  =200, PLOT=TRUE)
          ifrwd  =  round(DFRWD/PP4$deltat)
          ibkwd  =   round(DBKWD/PP4$deltat)    

          RATP = PSTLTcurve(z4, dt=PP4$deltat, fwlen=ifrwd,  bwlen=ibkwd, perc=perc, stretch=1000 , MED=21, PLOT=FALSE)

          
          detpix[j] = xz[1]-1+RATP$eye
          ## locator(1)
          
          ## plot(xz, z4, type='l')
          ## print(paste(" ", "RATP=",RATP$ind))
          
          ## abline(v=detpix[j], col=2)
          ## plot(xz, z5, type='l')
          ## plot(xz, z6, type='l')
        }

      PTIMES[[i]] = recdate(GH4$info$jd, GH4$info$hr, GH4$info$mn, GH4$info$sec+GH4$info$msec/1000+GH4$info$t1+detpix*deltat)
      PTIMES[[i]]$yr = rep(GH4$info$yr, length=length(detpix))
      


      if(PLOT==TRUE)
        {
          par(mfrow=c(3,1))
          
          plot(PP4$x, PP4$fy, type='l')

          abline(v=detpix, col=rgb(.5, 1, .5))

          winmark(PP4$a1,PP4$a2,col=4)
          ## winmark(JJ$J-sbef/deltat, JJ$L+saft/deltat, UD=2, col=2)
          winmark(JJ$J, JJ$L, UD=2, col=2)

          
          plot(PP5$x, PP5$fy, type='l')
          winmark(PP5$a1,PP5$a2,col=4)
          
          ## winmark(JJ$J-sbef/deltat, JJ$L+saft/deltat, UD=2, col=2)
          winmark(JJ$J, JJ$L, UD=2, col=2)

          plot(PP6$x, PP6$fy, type='l')
          winmark(PP6$a1,PP6$a2,col=4)
          u = par("usr")
          segments(PP6$x[1], .8*u[4], PP6$x[LEN2], .8*u[4], col=2, lwd=3)
          segments(PP6$x[LEN2+1], .8*u[4], PP6$x[LEN2+1+LEN1], .8*u[4], col=4, lwd=3)
          ##  winmark(JJ$J-sbef/deltat, JJ$L+saft/deltat, UD=2, col=2)
          winmark(JJ$J, JJ$L, UD=2, col=2)

          title(paste(sep=' ', "i = ", i, "of ", BIGN))
          
          points(PP6$x, rep(u[3]+0.1*(u[4]-u[3]), length(PP6$x)) , col=ALLP)

          
          locator(1)

        }
      
      
      
      

      
    }

    return(list(PTIMES=PTIMES, JJ=JJ, TEE=tees, Names=list(fnames4, fnames5, fnames6), PP=list(PP4, PP5, PP6) ))
}
######
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

quicksee<-function(fnames4, fnames5, fnames6, kind=1)
  {
    if(missing(kind)) { kind=1 }
    
    BIGN = length(fnames4)

    for(i in 1:BIGN)
      {
        print("######################################################")
        print(paste(sep=' ', "quicksee WORKING ON i = ", i, "of ", BIGN))
        ##  GET.seis(fnames, kind=kind, PLOT=FALSE)
        GG4 = GET.seis(fnames4[i], kind=kind, PLOT=FALSE)
        GH4=prepGG3(GG4)
        ay4 = ts(GH4$JSTR[[1]], deltat=GH4$dt[1])
        
        GG5 = GET.seis(fnames5[i], kind=kind, PLOT=FALSE)
        GH5=prepGG3(GG5)
        
        ay5 = ts(GH5$JSTR[[1]], deltat=GH5$dt[1])
        
        GG6 = GET.seis(fnames6[i], kind=kind, PLOT=FALSE)
        GH6=prepGG3(GG6)
        ay6 =  ts(GH6$JSTR[[1]], deltat=GH6$dt[1])
        
        par(mfrow=c(3,1))
        
        plot.ts(ay4, main=GH4$ifile)
        plot.ts(ay5, main=GH5$ifile)
        plot.ts(ay6, main=GH6$ifile)
        locator(1)
      }
  }

####  source("/home/lees/Progs/R_stuff/autopix.R")

quickseeL<-function(FAM=list(fnames4, fnames5, fnames6), kind=1)
  {
    if(missing(kind)) { kind=1 }
    
    K1 = length(FAM)
  
    fnames4 = FAM[[1]]
  
    BIGN = length(fnames4)

    for(i in 1:BIGN)
      {

   for(M in 1:K1)
        {
          M3 = M+3
          nam1 = paste("GG",M3, sep="")
          
    ##  GET.seis(fnames, kind=1, PLOT=FALSE)
          assign(nam1, GET.seis(FAM[[M]][i], kind=kind, PLOT=FALSE))

          
          nam2 = paste("GH",M3, sep="")
          
          assign(nam2, prepGG3(get(nam1)))
          
          nam3 = paste("ay", M3, sep="")
          G = get(nam2)
          
          assign(nam3, G$JSTR[[1]] )
          
        }

   #######  rm(ay4, ay5, ay6)

   
   par(mfrow=c(K1,1))
   for(M in 1:K1)
     {
       M3 = M+3
       nam2 = paste("GH",M3, sep="")
       G = get(nam2)
       nam3 = paste("ay", M3, sep="")
       ay = get(nam3)
       plot.ts(ay, main=G$ifile)

     }
   
        locator(1)
      }
  }






####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

################   do a whole directory of SEGY files:

PICKSEGY<-function(dir, i1, i2)
  {

 ### example:   PICKSEGY("/data/love/beer/lees/Karymsky/kar99/Day250", 17, 20)

###  list and store all files:
### dir = "/data/love/beer/lees/Karymsky/kar99/Day250"
    c0 = paste(sep=' ', "ls", dir)
    kname = system(c0, intern=TRUE)

    ## extract the station names:
    k1 = substr(kname, i1, i2)
    ##  get unique stations:
    ksta = unique(k1)


    for(II in 1:length(ksta))
      {
        stname = ksta[II]
     print(paste(sep=' ', "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"))
        print(paste(sep=' ', "working on",  stname))
   
        c1 = paste(sep=' ', "ls", paste(sep='', dir, "/*", stname, "*.4"))

        knames4 = system(c1, intern=TRUE)

        c1 = paste(sep=' ', "ls", paste(sep='', dir, "/*", stname, "*.5"))

        knames5 = system(c1, intern=TRUE)

        c1 = paste(sep=' ', "ls", paste(sep='', dir, "/*", stname, "*.6"))

        knames6 = system(c1, intern=TRUE)

        
        seeit = FALSE

        KPIX =  ETECT3(knames4, knames5, knames6,  FRWD=20, BKWD=20, sbef = 10, saft = 35, thresh = 1.2, Tthresh2 = 2, , flo=1
          , fhi=10.0,stretch=1000, PLOT=seeit, Kmin=10)

      

        ##  fout1 = paste(sep='', "wpix", stname)

        fout1 = local.file("wpix", stname)

        zz <- file(fout1, "w")
        icol = 14+(II-1)

        for(i in 1:length(KPIX))
          {
            zed = KPIX[[i]]

            moday = getmoday(zed$jday, zed$yr)

            L = paste(sep=' ', "wpix", icol, zed$yr, zed$jday,moday$mon, moday$dom, zed$hour, zed$min, zed$sec, "30")
            print(L)
            cat(file=zz, L, sep="\n")
          }
        close(zz)


      }




  }
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

P2wpix<-function(KPIX, stname)
  {
    fout1 = local.file("wpix", stname)

    zz <- file(fout1, "w")
    icol = 14+(II-1)

    for(i in 1:length(KPIX))
      {
        zed = KPIX[[i]]

        moday = getmoday(zed$jday, zed$yr)

        L = paste(sep=' ', "wpix", icol, zed$yr, zed$jday,moday$mon, moday$dom, zed$hour, zed$min, zed$sec, "30")
        print(L)
        cat(file=zz, L, sep="\n")
      }
    close(zz)

  }

####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

ETECTL<-function(FAM=list(fnames4, fnames5, fnames6), FRWD=8,  BKWD=8,  sbef=1, saft=6, DFRWD=.5,  DBKWD=.5, thresh=2,  Tthresh2=7, stretch=1000, flo=0.1, fhi=5.0, PLOT = FALSE, Kmin=7, perc=0.05, kind=1)
{ 
#######    do automatic picking on 3 component traces
#######  fnames4, fnames5, fnames6=names of files to read in vertical north east
#######  FRWD=forward window in seconds
#######  BKWD=backward window in seconds
#######  sbef=before window in seconds
#######  saft=back window in seconds
#######  thresh=threshhold
#######  Tthresh2=window threshhold
#######  stretch=stretching factor to multiply prior i=to rat curve
#######  flo=low freq cutoff for band pass
#######  fhi=high freq for  bandpass 
  if(missing(FRWD)) { FRWD=8 }
  if(missing(BKWD)) { BKWD=8 }
  if(missing(DFRWD)) { DFRWD=.5 }
  if(missing(DBKWD)) { DBKWD=.5 }

  if(missing(sbef)) { sbef = 1 }
  if(missing(saft)) { saft = 6}
  if(missing(thresh)) { thresh=2 }
  if(missing(Tthresh2)) { Tthresh2= (sbef+saft) }
  if(missing(stretch)) { stretch=1000 }
  if(missing(flo)) { flo = .1 }
  if(missing(fhi)) { fhi=5.0 }
  if(missing(PLOT)) {  PLOT = TRUE }
  if(missing(Kmin)) { Kmin = 7 }
  if(missing(kind)) { kind=1 }

  if(missing(perc)) { perc=0.05 }


  K1 = length(FAM)
  
  fnames4 = FAM[[1]]
  
  BIGN = length(fnames4)

  PTIMES = as.list(1:BIGN)


  ####  main loop
  for(i in 1:BIGN)
    {
      print("######################################################")
      print(paste(sep=' ', "ETECT3 WORKING ON i = ", i, "of ", BIGN))

      for(M in 1:K1)
        {
          M3 = M+3
          nam1 = paste("GG",M3, sep="")
          
    ##  GET.seis(fnames, kind=1, PLOT=FALSE)
          assign(nam1, GET.seis(FAM[[M]][i], kind=kind, PLOT=FALSE))
          nam2 = paste("GH",M3, sep="")
          assign(nam2, prepGG3(get(nam1)))

          nam3 = paste("ay",M3, sep="")

           G = get(nam2)
          
          assign(nam3, G$JSTR[[1]] )
          
          nam4 = paste("PP",M3, sep="")
          
              assign(nam4, pickit(G$JSTR[[1]] , deltat=deltat,  FRWD=FRWD,  BKWD=BKWD,sbef=sbef, saft=saft,
            thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin))
        }

      

      deltat = GH4$dt[1]
      
      ###############  create a series of ones for hits on the STLT algor

      ## this needs to be fixed:
      STARTS = as.list(1:K1)

      for(M in 1:K1)
        {
          M3 = M+3
          nam2 = paste("GH",M3, sep="")
          G = get(nam2)
          STARTS[[M]] = G$info
        }


     ###   print(STARTS)
      print(length(STARTS ))
      
      tees = GETPAD(STARTS)
      print( tees$r1)
      print( tees$r2)
  

      for(M in 1:K1)
        {
          M3 = M+3
          nam4 = paste("PP",M3, sep="")
          PP = get(nam4)
          nam5 = paste("tt",M3, sep="")
          
          assign(nam5, rep(0, length(PP$x)))
          tt  = get(nam5)
          for(j in 1:length(PP$a1))
            {
              tt[PP$x>=PP$a1[j]&PP$x<=PP$a2[j]] = 1
            }
          tt = c(rep(0, tees$r1[ M ]) , tt,    rep(0, tees$r2[M]))
          assign(nam5, tt)
        }


      PR = "ETECT3 lengths PPa:"
      for(M in 1:K1)
        {
          M3 = M+3
          nam4 = paste("PP",M3, sep="")
          PP = get(nam4)
          PR=paste(sep= ' ', PR, length(PP$a1))
        }
      print(PR)

      PR = "ETECT3 lengths PP:"
      for(M in 1:K1)
        {
          M3 = M+3
          nam4 = paste("PP",M3, sep="")
          PP = get(nam4)
          PR=paste(sep= ' ', PR, length(PP$x))
        }
      print(PR)


      PR = "ETECT3 lengths tt:"
      for(M in 1:K1)
        {
          M3 = M+3
          nam4 = paste("tt",M3, sep="")
          PP = get(nam4)
         PR= paste(sep= ' ', PR, length(PP))
        }
      print(PR)



      
     ###############
      ## weight all three components the same
     ##### if( length(tt4) != length(tt5) != length(tt6) )
     #####   {
     #####     print("error in tt4+tt5+tt6")
     #####   }

   
      
    ###   ALLP = tt4+tt5+tt6
      nam5 = paste("tt",4, sep="")
      ALLP  = get(nam5)
      if(K1>1)
        {
          for(M in 2:K1)
            {
              M3 = M+3
              nam5 = paste("tt",M3, sep="")
              tt = get(nam5)
              ALLP = ALLP+tt
            }
        }

                                        #  weight the vertical more than the horizontals
      ## ALLP = 2.0*tt4+ tt5+ tt6
      
      JJ = Thresh.J(ALLP, K1-0.5)
###   JJ = Thresh.J(ALLP,1.5)
      NJ = length(JJ$J)
      if(NJ<1)
        {

          detpix=0
          next;
        }
      detpix = rep(0,length(JJ$J))
      nam4 = paste("PP",4, sep="")
      PP = get(nam4)
      ###  for each PICK get a detailed pick on the vertical component

      
      for(j in 1:NJ)
        {
          ## print(paste(sep=" ", "****************** sub win=", i, j, "of ", NJ, BIGN))
          ##  b1 = (JJ$J[j]-sbef/deltat)
          ##  b2 = (JJ$L[j]+saft/deltat)
          b1 = (JJ$J[j]-75)
          b2 = (JJ$L[j]+200)

          if(b2>length(PP$fy)) b2 = length(PP$fy)
          if(b1<1) b1 = 1
          z4= PP$fy[b1:b2]

          ##  z5= PP5$fy[b1:b2]
          ## z6= PP6$fy[b1:b2]
          
          xz = PP$x[b1:b2]

          if(length(z4)<375)
            {
              print("Very short window")
              detpix[j] = 0
              next

            }

####  here do the detailed picking to find a good first arrival

     ####     RATP = ratcurve(z4, dt=PP4$deltat, fwlen =  75,  bwlen  =200, PLOT=TRUE)
          ifrwd  =  round(DFRWD/PP$deltat)
          ibkwd  =   round(DBKWD/PP$deltat)    

          RATP = PSTLTcurve(z4, dt=PP$deltat, fwlen=ifrwd,  bwlen=ibkwd, perc=perc, stretch=1000 , MED=21, PLOT=FALSE)

          
          detpix[j] = xz[1]-1+RATP$eye
        
        }


      
      nam2 = paste("GH",4, sep="")
      GH = get(nam2)
      PTIMES[[i]] = recdate(GH$info$jd, GH$info$hr, GH$info$mn, GH$info$sec+GH$info$msec/1000+GH$info$t1+detpix*deltat)
      PTIMES[[i]]$yr = rep(GH$info$yr, length=length(detpix))
      

 print(paste("going to plotting", K1))
      if(PLOT==TRUE)
        {
           print(paste("in plotting", K1))
          par(mfrow=c(K1,1))
          
          for(M in 1:K1)
            {
              print(paste("plotting", M))
              
              M3 = M+3
              nam4 = paste("PP",M3, sep="")
              PP = get(nam4)
              
              plot(PP$x, PP$fy, type='l', xlab = PP$ifile)

              abline(v=detpix, col=rgb(.5, 1, .5))

              winmark(PP$a1,PP$a2,col=4)
              ## winmark(JJ$J-sbef/deltat, JJ$L+saft/deltat, UD=2, col=2)
              winmark(JJ$J, JJ$L, UD=2, col=2)
              if(M==K1)
                {

                  u = par("usr")
                  segments(PP$x[1], .8*u[4], PP$x[LEN2], .8*u[4], col=2, lwd=3)
                  segments(PP$x[LEN2+1], .8*u[4], PP$x[LEN2+1+LEN1], .8*u[4], col=4, lwd=3)
                  ##  winmark(JJ$J-sbef/deltat, JJ$L+saft/deltat, UD=2, col=2)
                  winmark(JJ$J, JJ$L, UD=2, col=2)

                  title(paste(sep=' ', "i = ", i, "of ", BIGN))
                  
                  points(PP$x, rep(u[3]+0.1*(u[4]-u[3]), length(PP$x)) , col=ALLP)


                }
            }
          
         
          
          locator(1)

        }
      
      
      
      

      
    }

  
      PPALL = as.list(1:K1)

      for(M in 1:K1)
        {
          M3 = M+3
          nam2 = paste("PP",M3, sep="")
          P = get(nam2)
          PPALL[[M]] = P
        }



  
    return(list(PTIMES=PTIMES, JJ=JJ, TEE=tees, Names=FAM, PP=PPALL ))
}
######
####################################################
####################################################
####################################################
getb1b2<-function(J, L, zwin, maxx, max2 )
  {
    wdif = L-J
    b1 = (J-zwin)
    b2 = (L+zwin)
    if(b2>max2) b2 = max2
    if(b1<1) b1 = 1
    
    if((b2-b1)>maxx) { return(c(b1, b2)) }

    while((b2-b1)<maxx)
      {
        b1 = b1-10
        b2 = b2 +10
        if(b2>max2) b2 = max2
        if(b1<1) b1 = 1
        
        if((b2-b1)>maxx) { return(c(b1, b2)) }
 
      }

    return(c(1,1)) 
    
  }

####  source("/home/lees/Progs/R_stuff/autopix.R")
GETARAIC<-function(z4, deltat=0.008, Mar=8, O1=2, O2=0.2, WW= 2, T1=1 , PLOT=FALSE   )
  {
    if(missing(deltat)) {  deltat=0.008 }
    if(missing(Mar)) {  Mar = 8 }
    if(missing(O1)) { O1=2; }
    if(missing(O2)) { O2=0.2; }
    if(missing(WW)) { WW= 2 }
    if(missing(PLOT)) { PLOT=FALSE }
    

    
    Nz4 = length(z4)
    if(missing(T1)) { T1 = floor(Nz4/2) }
  
    aout = rep(0, Nz4)
      
             
              ary = .C("CALL_ARAIC", as.double(z4), as.integer(Nz4),as.double(deltat), as.integer(Mar),
                as.integer(T1), as.double(O1), as.double(O2), as.double(WW), as.double(aout)) 

              kaic = ary[[9]]
              kaic[kaic==0]=NA
              Taic =TFIN=  which.min(kaic)


    if(PLOT==TRUE)
      {
        par(mfrow=c(2,1))
        plot.ts(z4)
        xkaic = 1:length(kaic)
        plot(xkaic,kaic, type='l')
        lm1 = lm(kaic ~ cbind(xkaic, xkaic^2, xkaic^3, xkaic^4))
        lines(xkaic[!is.na(kaic)], lm1$fitted.values, col=2)
        vline(Taic, COL=rgb(.4,.8,1) )
        
      }
    
    return(Taic)
  }

ETECTG<-function(GH, sel=sel, FRWD=8,  BKWD=8,  sbef=1, saft=6, DFRWD=.5,  DBKWD=.5, thresh=2,  Tthresh2=7, stretch=1000, flo=0.1, fhi=5.0, PLOT = FALSE, Kmin=7, perc=0.05, kind=1)
{ 
#######    do automatic picking on 3 component traces
#######  fnames4, fnames5, fnames6=names of files to read in vertical north east
#######  FRWD=forward window in seconds
#######  BKWD=backward window in seconds
#######  sbef=before window in seconds
#######  saft=back window in seconds
#######  thresh=threshhold
#######  Tthresh2=window threshhold
#######  stretch=stretching factor to multiply prior i=to rat curve
#######  flo=low freq cutoff for band pass
#######  fhi=high freq for  bandpass 
  if(missing(FRWD)) { FRWD=8 }
  if(missing(BKWD)) { BKWD=8 }
  if(missing(DFRWD)) { DFRWD=.5 }
  if(missing(DBKWD)) { DBKWD=.5 }

  if(missing(sbef)) { sbef = 1 }
  if(missing(saft)) { saft = 6}
  if(missing(thresh)) { thresh=2 }
  if(missing(Tthresh2)) { Tthresh2= (sbef+saft) }
  if(missing(stretch)) { stretch=1000 }
  if(missing(flo)) { flo = .1 }
  if(missing(fhi)) { fhi=5.0 }
  if(missing(PLOT)) {  PLOT = TRUE }
  if(missing(Kmin)) { Kmin = 7 }
  if(missing(kind)) { kind=1 }
  if(missing(sel)) { 1:length(GH$JSTR) }
  if(missing(perc)) { perc=0.05 }
  DOARAIC = FALSE
  N1 = length(GH$JSTR)
  
  PTIMES = as.list(1:N1)


  ####  main loop

  for(M in 1:length(sel) )
    {
      M3 = sel[M]
      
      nam3 = paste("ay",M, sep="")
      
      assign(nam3, GH$JSTR[[M3]] )
      g = get(nam3)
      g[is.na(g)] = mean(g, na.rm=TRUE)
      
      nam4 = paste("PP",M, sep="")
      

      assign(nam4, pickit(g , deltat=deltat,  FRWD=FRWD,  BKWD=BKWD,sbef=sbef, saft=saft,
                          thresh=thresh, Tthresh2 =  Tthresh2, flo=flo, fhi=fhi, stretch=stretch, Kmin=Kmin))
      v = get(nam4)
      v$STNS = GH$STNS[M3]
      v$COMPS = GH$COMPS[M3]

      assign(nam4, v)

      if(PLOT==TRUE)
        {
###  plotting
          par(mfrow=c(2,1))
      
          plot.ts(v$ay)
          winmark(v$a1,v$a2,col=4)	
          plot.ts(v$RAT)

          winmark(v$a1,v$a2,col=4)
          abline(h=v$thresh, col=3)
          locator(1)
        }
      
###     ls(pat='PP')
###	rm(list=ls(pat='PP'))

    }

  ###   end initial detection


  
  for(M in 1:length(sel) )
    {
      nam4 = paste("PP",M, sep="")
      v = get(nam4)
      print(paste(" ", "ETECTG",  v$STNS, v$COMPS, length(v$RAT)) )
      nam5 = paste("tt",M, sep="")
      assign(nam5, rep(0, length(v$x)))
      tt  = get(nam5)
      for(j in 1:length(v$a1))
        {
          tt[v$x>=v$a1[j]&v$x<=v$a2[j]] = 1
        }
      assign(nam5, tt)
###     ls(pat='tt')
###	rm(list=ls(pat='tt'))

      
    }	
      ###############  create a series of ones for hits on the STLT algor

     ###############
      ## weights: might weigh certain stations more? 

  K1 = length(sel)
      
    ###   ALLP = tt4+tt5+tt6
      nam5 = paste("tt",1, sep="")
      ALLP  = get(nam5)
      if(K1>1)
        {
          for(M in 2:K1)
            {
              M3 = M
              nam5 = paste("tt",M3, sep="")
              tt = get(nam5)
              ALLP = ALLP+tt
            }
        }
  
   ## plot.ts(ALLP)
  
                                        #  weight the vertical more than the horizontals
      ## ALLP = 2.0*tt4+ tt5+ tt6
      
      JJ = Thresh.J(ALLP, K1-0.5)
###   JJ = Thresh.J(ALLP,1.5)
  NNALLP = length(ALLP)
      NJ = length(JJ$J)
      if(NJ<1)
        {

          detpix=0
          next;
        }


  for(M in 1:length(sel) )
    {
      K = sel[M]
      deltat = GH$info$dt[K]
      namdp = paste("DP",M, sep="")
      assign( namdp , rep(0,length(JJ$J)))
      detpix = get(namdp)
      namtp = paste("TP",M, sep="")
      
      nam4 = paste("PP",M, sep="")
      PP = get(nam4)

      ifrwd  =  round(DFRWD/PP$deltat)
      ibkwd  =  round(DBKWD/PP$deltat)    

      zwin = max(c(ifrwd, ibkwd))
###  for each PICK-WINDOW get a detailed pick on each component

      for(j in 1:NJ)
        {
          ## print(paste(sep=" ", "****************** sub win=", i, j, "of ", NJ, BIGN))
          ##  b1 = (JJ$J[j]-sbef/deltat)
          ##  b2 = (JJ$L[j]+saft/deltat)

          B = getb1b2(JJ$J[j], JJ$L[j], zwin, 375,  NNALLP )
          b1 = B[1]
          b2 = B[2]

          if(is.na(b1) | is.na(b2) ) { next }
          
          z4= PP$fy[b1:b2]
          
          xz = PP$x[b1:b2]

          if(length(z4)<375)
            {
              
              print(paste(sep=" " , "Very short window",M, j, length(z4), b1, b2)   )
              detpix[j] = 0
              next
            }
####  here do the detailed picking to find a good first arrival
####     RATP = ratcurve(z4, dt=PP4$deltat, fwlen =  75,  bwlen  =200, PLOT=TRUE)
          print("ETECTG Going to PSTLTcurve")
          RATP = PSTLTcurve(z4, dt=PP$deltat, fwlen=ifrwd,  bwlen=ibkwd, perc=perc, stretch=1000 , MED=77, PLOT=FALSE)
          if(is.na(RATP[[1]]) )
            {
              next;
            }
          ## locator(1)
          T1=TFIN=RATP$eye;

          if(DOARAIC==TRUE)
            {
              Nz4 = length(z4)
              Mar = 8
              O1=2; 
              O2=0.2; 
              WW=2
              aout = rep(0, Nz4)
              deltat = PP$deltat[1]
              plot.ts(z4)
              locator(1)

              ary = .C("CALL_ARAIC", as.double(z4), as.integer(Nz4),as.double(deltat), as.integer(Mar),
                as.integer(T1), as.double(O1), as.double(O2), as.double(WW), as.double(aout)) 

              kaic = ary[[9]]
              kaic[kaic==0]=NA
              Taic =TFIN=  which.min(kaic)

              xkaic = 1:length(kaic)
              plot(xkaic,kaic, type='l')
              lm1 = lm(kaic ~ cbind(xkaic, xkaic^2, xkaic^3, xkaic^4))
              lines(xkaic[!is.na(kaic)], lm1$fitted.values, col=2)

              vline(c(RATP$eye, RATP$ind, RATP$mix), per=-1,  LAB=c("eye", "ind", "mix"), COL=c(2,3,5))
              vline(which.min(kaic), COL=rgb(.4,.8,1) )
            }
          
          detpix[j] = xz[1]-1+TFIN
          
        }


      
      assign( namdp , detpix)
      detpix=get(namdp)
      PTIMES = recdate(GH$info$jd[K], GH$info$hr[K], GH$info$mn[K],
        GH$info$sec[K]+GH$info$msec[K]/1000+GH$info$t1[K]+detpix*GH$info$dt[K])
      PTIMES$yr = rep(GH$info$yr[K], length=length(detpix))
      PTIMES$STAID = list(stn=GH$STNS[K] , comp=GH$COMPS[K])
      
      assign( namtp , PTIMES)

      
    }


###     ls(pat='^TP')
###	rm(list=ls(pat='^TP'))

  
  ###     ls(pat='^DP')
###	rm(list=ls(pat='^DP'))

  
  if(PLOT==TRUE)
    {
      print(paste("going to plotting", K1))
      
      ##  PLOT.SEISN(GH, sel = sel, notes=GH$KNOTES[sel]);  gin = locator(2)
      ##  gin = locator(2)


###  PICK.GEN(GH, sel=sel)
###  y = PICK.GEN(GH, sel=sel, WIN=gin)

    ###  gin = locator(2)
      gin = NULL

      one()
      PLOT.SEISN(GH, sel = sel, notes=GH$KNOTES[sel], WIN=gin)

      
      for(M in 1:length(sel) )
        {
          K = sel[M]
          namtp = paste("TP",M, sep="")
          tp = get(namtp)

          ypos = (length(sel)-M+0.5)/length(sel)

          zloc = list(x=rep(NA, length(tp$jday)),  y=rep(ypos, length(tp$jday))  )
          
          zloc$x = secdif(GH$info$jd[K], GH$info$hr[K], GH$info$mn[K], GH$info$sec[K]+GH$info$msec[K]/1000+GH$info$t1[K],
            tp$jday, tp$hour, tp$min, tp$sec)
          
          
          PPIX(zloc, YN=length(sel), col=4, lab='P')
        }

      

    }

      PPALL = as.list(1:K1)
      PPTIM = as.list(1:K1)

      for(M in 1:K1)
        {
          M3 = sel[M]
          nam2 = paste("PP",M, sep="")
          P = get(nam2)
          PPALL[[M]] = P

          namtp = paste("TP",M, sep="")
          ptims = get( namtp)
          PPTIM[[M]] = ptims

        }
  
    return(list(sel=sel, JJ=JJ, PPTIM=PPTIM, PP=PPALL))
  
}
######
######
####################################################
####################################################
####################################################
####  source("/home/lees/Progs/R_stuff/autopix.R")

PLOT.DTECT<-function(ZGH, GH, sel, dwin=10)
{

  if(missing(dwin)) { dwin = 10 }

  
  Npicks = length(ZGH$PPTIM[[1]]$sec)
  for(J in 1:Npicks)
    {
      tp = ZGH$PPTIM[[1]]
      gloc = list(x=rep(NA, 2),  y=rep(NA, 2)  )
      px = secdif(GH$info$jd[1], GH$info$hr[1], GH$info$mn[1], GH$info$sec[1]+GH$info$msec[1]/1000+GH$info$t1[1],
        tp$jday[J], tp$hour[J], tp$min[J], tp$sec[J])


      gloc$x = px+c(-dwin, dwin)


      print(paste(sep=" ",J, px, tp$jday[J], tp$hour[J], tp$min[J], tp$sec[J] ))
    
      dev.set(which=dev.next())

      vline(px, per=-.1, COL=2, LAB=J)
      
      dev.set(which=dev.next())
      one()
      PLOT.SEISN(GH, sel = sel, notes=GH$KNOTES[sel], WIN=gloc)
      ##  Y = PICK.GEN(GH, sel = sel, WIN=gloc)
      ##  plot(Y$x, Y$y, type='l')
      
      
      title(main=paste(sep=' ',"pick No:", J, "/", Npicks))

      for(M in 1:length(sel) )
        {
          K = sel[M]
          
          tp = ZGH$PPTIM[[M]]

          ypos = (length(sel)-M+0.5)/length(sel)

          zloc = list(x=rep(NA, length(tp$jday)),  y=rep(ypos, length(tp$jday))  )
          
          zloc$x = secdif(GH$info$jd[K], GH$info$hr[K], GH$info$mn[K], GH$info$sec[K]+GH$info$msec[K]/1000+GH$info$t1[K],
            tp$jday, tp$hour, tp$min, tp$sec)
          
          
          PPIX(zloc, YN=length(sel), col=4, lab='P')
####dev.set(2)
#### PPIX(zloc, YN=length(sel), col=2, lab='P')
        
        }
      locator(1)
      
    }



}


####################################################
####################################################
####################################################




ZAR<-function(MOD, x)
  {
    
    ar = MOD$ar
    p = az1$order
    n = length(x)
    xint = mean(x)
    pred = rep(0, length=n)
    res  = rep(0, length=n)
    
    for(i in (p+1):n)
      {
        pred[i] = sum(ar * x[i - (1:p)]) + xint
        res[i] = x[i] - pred[i]
      }

    return(list(pred=pred, res=res, xint=xint) )
  }



####  source("/home/lees/Progs/R_stuff/autopix.R")

ARAIC<-function(y1, deltat, T1=1, O1=O1, O2=O2, W=W, PLOT=FALSE)
{
  ##plot.ts(ts(y1, deltat=0.008) )

  if(missing(O2)) { O2 = 0.0 }
  if(missing(O1)) {  O1 = 2.0}
   if(missing(W)) { W = 4.0}
   if(missing(PLOT)) {  PLOT=FALSE }
   if(missing(T1)) { T1 = length(y1)/2 }

  

  ##   plot.ts(y1)
  ##   T1 = round(v$x[1])
   ##  abline(v=T1, col=2)



  I1 = round(O1/deltat)
  I2 = round(O2/deltat)

  IW = round(W/deltat)

  N = length(y1)


  ##########  NOISE : 1
  
  i1 = T1-(I1+IW)+1
  i2 = i1+IW
  z1 = y1[i1:i2]
  z1 = z1-mean(z1)
  az1  = ar.mle(z1, aic=FALSE, order.max = 8)

  ## SIGNAL MODEL: 2
  i1 = T1+1
  i2 = i1+IW

  z2 = y1[i1:i2]
  z2 = z2-mean(z2)
  
  az2  = ar.mle( z2 , aic=FALSE, order.max = 8)

  ##   abline(v=c(i1,i2), col=4)

  kout = rep(NA, length(y1))
  ##  wout = rep(NA, length(y1))


  IZ = 2/deltat
  

  M = 8
  
  k1 = 2*M+1
  k2 = N-(2*M+1)
  
  for(K in k1:k2)
    {

      p1 = M
      p2 = K+1
      q1 = K
      q2 = N-M
      n1 = K-M
      n2 = N-M-K

     ##  noise part:
     z1 = y1[p1:q1]
     z1 = z1-mean(z1)
     w1 = ZAR(az1, z1)

     j1 = i+1
     j2 = j1+IW
     
     z2 = y1[p2:q2]
     z2 = z2-mean(z2)
     w2 = ZAR(az2, z2)

     s1 = (sum(w1$res^2))
     s2 = (sum(w2$res^2))
 
      kout[K] = n1*log(s1) + n2*log(s2)

    }

  ##par(mfrow=c(2,1))
  ##plot.ts(y1)
  ##plot.ts(kout)

  if(PLOT==TRUE)
    {
      kx = RESCALE(kout, min(y1,  na.rm = TRUE),   max(y1, na.rm = TRUE),
        min(kout, na.rm = TRUE), max(kout, na.rm = TRUE))
      par(mfrow=c(1,1))
      plot.ts(y1)
      lines(kx, col=rgb(1, .4, .4))
      abline(v=which.min(kout), col=4)
    }
 return(list(AIC=kout))

}

####  source("/home/lees/Progs/R_stuff/autopix.R")
