#  source("/home/lees/Progs/R_stuff/particle_motion.R")
#  source("/home/lees/Progs/R_stuff/Part.Mo.R")
# lat1=h1$evla[1]; lon1=h1$evlo[1];  lat2=h1$stla[1] ;  lon2=h1$stlo[1] ; 
#
# baz =
############## 
##a1 = getUWwin(Mpf[4])
# rbaz = grotseis(baz, flip=FALSE)
# abaz= ascd %*% rseis
#  HODO(a1)
#  X11(); X11() 
#
#

doHODO<-function(FLS, rot=FALSE, PS=TRUE)
  {
##X##  plot alot of hodo grams, files listed in FLS
##X##  rot = default  = FALSE
    ##X##  PS=TRUE  plot a postscript file
    if(missing(rot)) { rot=FALSE }
    if(missing(PS))  { PS=FALSE }
    
    print(paste("PS=", PS))
    
    for(j in 1:length(FLS))
      {

        a1 = getUWwin(FLS[j])
        HODO(a1, rot=rot,  PS=PS)
        locator()
      }
  }

autoHODO<-function(FLS, rot=FALSE, PS=TRUE)
  {
    if(missing(rot)) { rot=FALSE }
    if(missing(PS))  { PS=FALSE }
    
    print(paste("PS=", PS))
    
    for(j in 1:length(FLS))
      {

        a1 = getUWwin(FLS[j])
        HODO(a1, rot=rot,  PS=PS)
        locator()
      }
  }

#


HODO<-function(a1, WIN=c(0,1), rot=FALSE, PS=FALSE)
  {
##X##    ##  plot hodo gram of a 3-D trace
##X##    ##  input:  a1 = structure list(data , t, evla, stla)
##X##    ##  data = n by 3  data matrix cbind(vert, north, east)
##X##    ##   t - time vector = seq(from=0, length=dim(data)[1], by=deltat)
##X##    ##   evla = vector of event latitude
##X##    ##   evlo = vector of event longitude
##X##    ##  stla  = vector of event lat
##X##    ##   vector of event long
    
    if(missing(rot))  { rot=FALSE }
    if(missing(WIN))  { WIN=NULL }
     
     if(missing(PS))  { PS=FALSE }
    
   
    lat1=a1$evla[1]; lon1=a1$evlo[1];  lat2=a1$stla[1] ;  lon2=a1$stlo[1] ;
    GBAZ = distaz(lat2, lon2, lat1, lon1)
    baz=GBAZ$baz

    rbaz = grotseis(baz, flip=FALSE)
    inpfile = a1$info$fn[1]
    if(rot==TRUE)
      {
        abaz= a1$data  %*%  rbaz
        labs=c("Vertical", "Radial", "Transvers")
        PMOtrace(abaz, tim=a1$t, WIN=WIN, labs=labs, PS=PS, ID=inpfile )
      }  else
      {
        abaz= a1$data
        labs=c("Vertical", "North", "East" )
        PMOtrace(abaz, tim=a1$t, WIN=WIN, labs=labs, PS=PS, ID=inpfile )
      }

    
  }
######
######
ptrace3<-function(ain, HODO=FALSE, rot=FALSE  )
  {
##X##     #  plot three components and plot hodograms next to them
##X##     #  plot 4 hodo's depending on the P, S, T1, T2 arrival picks
##X##     #  rotate seismograms to radial transverse if requested
##X##     ##   this program is set up special for Coso picks that have
##X##     ##   been picked previously
##X##
    
##X##  #    ain = output of getUWwin(pfile)  structure described there
##X##  #   ptrace3(ain, HODO=TRUE)
    if(missing(HODO)) { HODO=FALSE;}
    if(missing(rot)) { rot=FALSE }

    if(rot)
      {
        lat1=ain$evla[1]; lon1=ain$evlo[1];  lat2=ain$stla[1] ;  lon2=ain$stlo[1] ;
        GBAZ = distaz(lat2, lon2, lat1, lon1)
        baz=GBAZ$baz
        rbaz = grotseis(baz, flip=FALSE)
        abaz= ain$data  %*%  rbaz
        labs=c( "Transverse", "Radial",  "Vertical")
       
      }else
    {
        abaz= ain$data
        labs = c("East", "North", "Vert")
       
    }
    
    tr1 = 0.05
    tr2 = .7
    
    alen=length(abaz[,1])
    dt=ain$info$dt[1]
    fil = ain$info$fn[1]
    
    a2 = abaz
    comp = ain$comp
    sta = ain$sta[1]
    ascd = abaz
   
    mn = apply(ascd, 2, "mean")
    b2 = sweep(ascd, 2, mn)
    
    rn = apply(b2, 2, "range")
    dn = diff(rn)
    deltan = max(dn)
    ttics = pretty(ain$t )

    dy = 1/3
    y1 = 0
    y2 = y1+dy
    y3 = y2 + dy
    
   vert = RESCALE(a2[,1], y3, y3+dy, min(a2[,1]), max(a2[,1]) )
   north = RESCALE(a2[,2], y2, y2+dy, min(a2[,2]), max(a2[,2]))
   east  = RESCALE(a2[,3], y1, y1+dy, min(a2[,3]), max(a2[,3]))

    
   ex   = RESCALE( ain$t, tr1 , tr2, min(ain$t), max(ain$t) )
   xtics = RESCALE( ttics , tr1 , tr2, min(ain$t), max(ain$t))
    
    plot(c(0,1 ), c(0,1),  type="n", axes=FALSE, xlab="", ylab="")

    # box()
    axis(1,tck=.03,at=xtics,lab=ttics, las=1,   mgp=c(.1,.1,0))


    lines(ex,vert, type='l', col=1)
    # points(rex[flag],a2[flag,1], col=2)
    lines(ex,north, col=1)
    lines(ex , east, col=1)
     ex1 = rep(0, 3)
    why2 =  c(y1+dy/2, y2+dy/2, y3+dy/2)
    
     text(ex1, why2, labs, adj=.5,  srt=90)
    
     ex1 = tr2
    why2 = y3+dy
     text(ex1, why2, labels=fil, pos=2)

    mtext("Time, s", at=(max(xtics)-min(xtics))/2, adj=0.5, side=1, line=1)

    plabs = c("P", "T1", "S", "T2")
    picks = c(ain$p[1], ain$T1[1], ain$s[1],  ain$T2[1])
          picks[picks==(-999.0)] = NA
          JI = 1:4
          JI[is.na(picks)] = NA

	for( J  in 1:4)
	{
          if(is.na(JI[J])) { next(); }
            xp   = RESCALE( picks[J], tr1 , tr2, min(ain$t), max(ain$t))
            lines(c(xp, xp), c(0, 1), col=J, lty=4)
            text(xp, 1, labels=plabs[J], col=J, pos=4)

        }

    
    if(HODO==TRUE)
      {
    dx = (1-.76)/2
    x = c(0.76,  0.76+dx)
    dy = (1)/4
    fudgey = dy/20
    fudgex = dx/6
    # y = c(0, dy, 2*dy, 3*dy)
   
    y = c(3*dy, 2*dy, dy, 0)

    Nscale =range(abaz[,2])
    Escale =range(abaz[,3])
    Vscale = range(abaz[,1])
    Hscale = range(sqrt(abaz[,2]^2+abaz[,3]^2))
    for( J  in 1:4)
	{
          if(is.na(JI[J])) { next(); }
            W = c(picks[J], picks[J]+50*dt)
          # print(W)
          nbaz = abaz[ain$t>=W[1] & ain$t<W[2] , ]
          V = nbaz[,2]
          E = nbaz[,3]
          len = floor(length(V)/4)
          v = RESCALE( V , y[J], y[J]+dy, Nscale[1],  Nscale[2]  )
          e = RESCALE( E , x[1], x[1]+dx,  Escale[1],  Escale[2]  )
          lines(e,v)
          points(e[1], v[1], pch=2)
          arrows(e[len], v[len], e[len+1], v[len+1], length=.05)
          arrows(e[2*len], v[2*len], e[2*len+1], v[2*len+1], length=.05)
          arrows(e[3*len], v[3*len], e[3*len+1], v[3*len+1], length=.05)
          arrows(e[4*len], v[4*len], e[4*len+1], v[4*len+1], length=.05)
          Ly = y[J]+dy-2*fudgey
          Lx = x[1]+dx/10
          text(Lx, Ly, labels=plabs[J], pos=2)
          Ly = y[J]+fudgey
          Lx = (x[1]+dx+x[1])/2
          text(Lx, Ly, labels=labs[1], pos=4)
          Ly =  y[J]+dy/4
          Lx = x[1]
          text(Lx, Ly, labels=labs[2], pos=4, srt=90)

          V = nbaz[,1]
          E = sqrt(nbaz[,3]^2+nbaz[,2]^2)
         
          v = RESCALE( V , y[J], y[J]+dy, Vscale[1],  Vscale[2]  )
          e = RESCALE( E , x[2], x[2]+dx,  Hscale[1],  Hscale[2]  )
          lines(e,v)
          points(e[1], v[1], pch=2)
          arrows(e[len], v[len], e[len+1], v[len+1], length=.05)
          arrows(e[2*len], v[2*len], e[2*len+1], v[2*len+1], length=.05)
          arrows(e[3*len], v[3*len], e[3*len+1], v[3*len+1], length=.05)
          arrows(e[4*len], v[4*len], e[4*len+1], v[4*len+1], length=.05)
          Ly = y[J]+dy
          Lx = x[2]+dx/10
          # text(Lx, Ly, labels=plabs[J], pos=2)
          Ly = y[J]+fudgey
          Lx = (x[2]+dx+x[2])/2
          text(Lx, Ly, labels="Hoz", pos=4)
          Ly = (y[J]+dy+y[J])/2
          Lx = x[2]+dx
          text(Lx, Ly, labels="Vert", pos=4, srt=90)

          Ly = y[J]
          
          Lx = x[2]+dx          
          lines(c(x[1], x[2]+dx), c(Ly, Ly))
          
          xp   = RESCALE( picks[J], tr1 , tr2, min(ain$t), max(ain$t))
          xp2   = RESCALE(picks[J]+50*dt , tr1 , tr2, min(ain$t), max(ain$t))
          lines(c(xp, xp, xp2, xp2), c(.06, 0, 0, 0.06), col=J, lty=1, lwd=2)

          
          
        }
      }



    
    
  }



########
plot3comp<-function(ain)
  {
##X##  plot three components from UW file
        opar=par(no.readonly = TRUE)
	alen=length(ain$data[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$data


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
        xtics=pretty(ex, n=10)

        par(mfrow=c(3,1))
  par(mai=c(0.1, .5, 0.1, 0.5) )
  for(i in 1:3)
    {
      if(i==3)
        {
          par(mai=c(0.15, .5, 0.1, 0.5) )
        }
      plot(ex,dat[,i], axes=FALSE, xlab="",ylab="", type="n")
      lines(ex,dat[,i],type="l")
      axis(1,tck=.03,at=xtics,lab=FALSE)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

  
      tcomp=fixcompname(comp[i])

      
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
       plot.ps(ain)
       plot.t1t2(ain)
      
      # letter.it(i,2)

    }	
 axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  }
#######  source("/home/lees/Progs/R_stuff/particle_motion.R")
#######  source("/home/lees/Progs/R_stuff/Part.Mo.R")
######
plot3co<-function(ain)
  {
	opar=par(no.readonly = TRUE)
	alen=length(ain$data[,1])
	dt=ain$info$dt[1]
	ex = ain$t

	dat = ain$data


	comp = ain$comp
	sta = ain$sta[1]


	ascd = ain$data
	fil = ain$info$fn[1]
	pfil  = "" 
	id = ain$info$fn[1]
	sec = ain$info$sec
 	az = ain$az
        xtics=pretty(ex, n=10)

        par(mfrow=c(3,1))
  par(mai=c(0.1, .5, 0.1, 0.5) )
  for(i in 1:3)
    {
      if(i==3)
        {
          par(mai=c(0.15, .5, 0.1, 0.5) )
        }
      plot(ex,dat[,i], axes=FALSE, xlab="",ylab="", type="n")
      lines(ex,dat[,i],type="l")
      axis(1,tck=.03,at=xtics,lab=FALSE)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=FALSE)
      box()
      locy=0.8*max(ascd[,i])

      if(comp[i]=="SHV"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="SHN"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="SHE" || comp[i]=="6") tcomp="East"
      if(comp[i]=="V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="E" || comp[i]=="6") tcomp="East"
       if(comp[i]=="G1V"||comp[i]=="4" ) tcomp="Vertical"
      if(comp[i]=="G1N"|| comp[i]=="5") tcomp="North"
      if(comp[i]=="G1E" || comp[i]=="6") tcomp="East"
     
      text(ex[1], locy,paste(sta,tcomp,sep=" : ") ,cex=.8, adj=0)
      
       plot.ps(ain)
       plot.t1t2(ain)
      
      # letter.it(i,2)

    }	
 axis(1,at=xtics,tck=.03, las=1,   mgp=c(.1,.1,0))

  }
############
############
######
tracepick<-function( ascd, ex, labs=labs, ID="")
  {
    if(missing(ID)) { ID="" }
    if(missing(labs)) { labs=c("Vertical", "North", "East") }
    xtics= pretty(ex)
    opar=par(no.readonly = TRUE)
    # par(mfrow=c(3, 1))
    i=1
    # par(mfrow=c(3,1))
    par(mar=c(0,5,1,1)+ 0.1)
    plot(ex,ascd[,i],axes=FALSE, main=ID , xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, tck=FALSE, labels=FALSE )
    axis(3,tck=.03,at=xtics,lab=FALSE)
    mtext(labs[i], side=2, line=1)
    box()
   
    i=2
    par(mar=c(0,5,1,1)+ 0.1)
    plot(ex,ascd[,i],axes=FALSE, main="" , xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
   axis(2, tck=FALSE, labels=FALSE )
    axis(3,tck=.03,at=xtics,lab=FALSE)
       mtext(labs[i], side=2, line=1)
    box()
    
    i=3
    par(mar=c(2,5,1,1)+ 0.1)
    plot(ex,ascd[,i],axes=FALSE, main="", xlab="Time, s",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=TRUE)
   axis(2, tck=FALSE, labels=FALSE )
    axis(3,tck=.03,at=xtics,lab=FALSE)
       mtext(labs[i], side=2, line=1)
    box()

    # par(opar)
  }

######
PMOtrace<-function(ascd, tim=1, WIN=NULL, labs=LAB, PS=FALSE, ID="")
  {
 
    if(missing(labs)) { labs=c("Vertical", "North", "East") }
    if(missing(PS)) { PS=FALSE }
    if(missing(ID))
      {
         PSFileName = paste(sep=".", "PM","hodo.ps")
      ID=""
    }else
    {
      PSFileName = paste(sep=".", ID,"hodo.ps")
    }
        
    
    if(missing(tim))
      {
        ex = 1:length(ascd[,1])
      }
    else
      {

        ex = tim
      }
   if(missing(WIN)) { WIN = range(ex) }

    
    opar=par(no.readonly = TRUE)
    par(mfrow=c(1, 1) )
    ###   tracepick( ascd, ex, labs, ID=ID)
    PLOT.MATN(ascd, tim=ex, dt=dt, WIN=WIN, notes =labs, COL=c(4,2,2) )

    lx = plocator()
    u = par("usr")

        if(is.null(lx)) {
      print("NO PICKS")
      return(0)
    }
   ###   n = number of picks
    n = floor(length(lx$x)/2 )

    if(n<1) {
      print("NO PICKS")
      return(0)
    }
    
    par(opar)

   ###OLD:   nf <- layout(matrix(c(1,2,3,4,5,0,6,7,0),3,3,byrow=FALSE), heights=c(1,1,1), widths=c(3, 1, 1), TRUE)

    nf <- layout(matrix(c(rep(1,6),2,3,4,5, 6, 7),3,4,byrow=FALSE), heights=c(1,1,1), widths=c(1,1, 1, 1), TRUE)

    #### layout.show(nf)

    
    xtics= pretty(ex)

   ####  tracepick( ascd, ex, labs, ID=ID)
    
   PLOT.MATN(ascd, tim=ex, WIN=lx$x  , dt=dt, notes =labs, COL=c(1,1,1) )

    for(j in 1:n)
      {
        k = j*2-1
       
        ind1=lx$x[k]
        ind2 = lx$x[k+1]
        why1 = u[3]+(u[4]-u[3])*.1
        why2 = why1+(u[4]-u[3])*.1
        drawx = c(ind1, ind1, ind2, ind2)
        drawy = c(why2, why1, why1, why2)
       lines(drawx, drawy, col=j+1)
        text(ind2, why1, letters[j], pos=4)
      }



    xx = range(ascd[,3])
    yy = range(ascd[,2])

        
    for(j in 1:n)
      {
        k = j*2-1
       
        ind1=lx$x[k]
        ind2 = lx$x[k+1]
          
        nex = ex[ ex>=ind1 & ex<ind2]
        nbaz = ascd[ ex>=ind1 & ex<ind2 , ]

        pmotion(nbaz, 3, 2 , labs=labs, xlim=xx, ylim=yy, tit=letters[k], PLPOINTS=TRUE)

        pmotion(nbaz, 2, 1 , labs=labs, xlim=xx, ylim=yy, tit=letters[k+1], PLPOINTS=TRUE)
        
      }
        print(paste(sep=" ", "PS= ", PS))

####  POstscript #####
    if(PS==TRUE)
      {
        print(paste(sep=" ", "WORKING ON POSTSCRIPT FILE: n= ", n))
        
       
        
        postscript(file = PSFileName, width=7, height=10, horizontal=FALSE, onefile=FALSE  ,print.it=FALSE)

        nf <- layout(matrix(c(1,2,3,4,5,0,6,7,0),3,3,byrow=FALSE), heights=c(1,1,1), widths=c(3, 1, 1), TRUE)
        
        tracepick( ascd, ex, labs, ID=ID)
        
       
    for(j in 1:n)
      {
        k = j*2-1
       
        ind1=lx$x[k]
        ind2 = lx$x[k+1]
        why1 = u[3]+(u[4]-u[3])*.1
        why2 = why1+(u[4]-u[3])*.1
        drawx = c(ind1, ind1, ind2, ind2)
        drawy = c(why2, why1, why1, why2)
       lines(drawx, drawy, col=j+1)
        text(ind2, why1, letters[j], pos=4)
      }



    xx = range(ascd[,3])
    yy = range(ascd[,2])

        
    for(j in 1:n)
      {
        k = j*2-1
       
        ind1=lx$x[k]
        ind2 = lx$x[k+1]
          
        nex = ex[ ex>=ind1 & ex<ind2]
        nbaz = ascd[ ex>=ind1 & ex<ind2 , ]

        pmotion(nbaz, 3, 2 , labs=labs, xlim=xx, ylim=yy, tit=letters[k])
         pmotion(nbaz, 2, 1 , labs=labs, xlim=xx, ylim=yy, tit=letters[k+1], PLPOINTS=TRUE)
        
      }


        dev.off()
        dev.set(dev.next())
      }


    return(lx$x)
    
  }
######
ptrace<-function(ascd, tim=1, labs=LAB)
  {

  # nf <- layout(matrix(c(1,2,3),3,1,byrow=TRUE), c(3,3,3), c(1,1,1), TRUE)
    if(missing(labs)) { labs=c("Vertical", "North", "East") }
    
    nf <- layout(matrix(c(1,2,3,4,5,0),3,2,byrow=TRUE), heights=c(1,1,1), widths=c(3, 1), TRUE)
    
    layout.show(nf)
    
 if(missing(tim))
    {
    ex = 1:length(ascd[,1])
  }
    else
      {

ex = tim
      }
    xtics= pretty(ex)

    i=1
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i], xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd, 2, 1, labs=labs)
    i=2
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i] , xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd, 2, 3 , labs=labs)
    i=3
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i], xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    
    u = par("usr")
   #  print(u)
    lx = locator(2)
  #   print(paste(sep=" ", u[2],  lx$x[1]))
    
   
    #  (lx$x[1]<u[2])
       {
         nex = ex[ ex>=lx$x[1] & ex<lx$x[2]]
        nbaz = ascd[ ex>=lx$x[1] & ex<lx$x[2] , ]
        arrows(lx$x[1], u[3], lx$x[1], u[4], col=2)
        arrows(lx$x[2], u[3], lx$x[2], u[4], col=2)

        dv = dev.cur()

    dev.set(which = dev.next() )
    ptraceA(nbaz, nex)
        dev.set(which = dv )
       #  ptrace(ascd[ ex>lx$x[1] & ex<lx$x[2] , ], tim=ex[ ex>lx$x[1] & ex<lx$x[2]] )
        #  slider.hodo(nbaz, nex)
    
  #    pmotion(nbaz, 2, 1)
    
      #  return(list(abaz = nbaz, ex=nex) )

     #     lx = locator(2)
     #        print(paste(sep=" ", u[2],  lx$x[1]))
       }


    
  }
ptraceA<-function(ascd, tim=1, labs=LABS)
  {

  # nf <- layout(matrix(c(1,2,3),3,1,byrow=TRUE), c(3,3,3), c(1,1,1), TRUE)
    if(missing(labs)) { labs=c("Vertical", "North", "East")}
    nf <- layout(matrix(c(1,2,3,4,5,0),3,2,byrow=TRUE), heights=c(1,1,1), widths=c(3, 1), TRUE)
    layout.show(nf)
 if(missing(tim))
    {
    ex = 1:length(ascd[,1])
  }
    else
      {

ex = tim
      }
    xtics= pretty(ex)

    i=1
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i], xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd, 2, 1, labs=labs)
    i=2
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i], xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd, 2, 3, labs=labs )
    i=3
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main=labs[i], xlab="",ylab="", type="l")
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    

    
  }



seltrace<-function(ascd)
  {

pseis2(ascd)

lx = locator(2)
x  = round(lx$x)

return(ascd[x[1]:x[2], ])

  }
############################
#  source("/home/lees/Progs/R_stuff/particle_motion.R")

############################
DO.PMOT.ARR<-function(E, N)
  {
    len = floor(length(N)/4)
    for(jarr in 1:4)
      {
        karr = (jarr)*len
        harr = hypot(E[karr], N[karr], E[karr+1], N[karr+1])
        
       ######  print(paste(sep=' ', jarr, karr, harr))
        if(!is.na(harr) & harr>(10^-8))
          {
            arrows(E[karr], N[karr], E[karr+1], N[karr+1], length=.06)
          }
      }

  }
############################
#  source("/home/lees/Progs/R_stuff/particle_motion.R")

############################
pmotion<-function(ascd, X, Y , xlim=c(-1,1), ylim=c(-1,1), labs=labs, tit=TIT, PLPOINTS=FALSE, COL=0)
  {
##X##  plot particle motion
##X## INPUT:
##X##  ascd = N by 3 matrix of seismic velocity or displacement
##X##    X = number of the component to plot on the X axis
##X##    Y = number of the component to plot on the Y axis   
##X##    xlim, ylim = vectors, constrain the x and y axes to these values     
##X##    labs = labels for the components
##X##    tit  = over title 
##X##    PLPOINTS = T/F  whether to plot points
##X##   COL = color
    
    if(missing(labs)) { labs=c("Vertical", "North", "East")}
     if(missing(tit)) { tit=paste(sep="-",labs[X], labs[Y])}
     if(missing(xlim)) { xlim=range(ascd[, X])}
     if(missing(ylim)) { ylim=range(ascd[, Y])}
       if(missing(PLPOINTS)) { PLPOINTS=FALSE}
       if(missing(COL)) { COL=0}

    #  N is the up down axis, E is the horizontal
    N = ascd[,Y]
    E = ascd[,X]
    par(mar=c(0,0,1,1)+0.1)
    plot(E,N, type='l', asp=1, xlim=xlim, ylim=ylim, xlab="", ylab="", axes=FALSE)
    axis(4)
    axis(1)
    pu=par("usr")
    
    if(PLPOINTS==TRUE)
      {
        points(E, N, pch=4, col=2)
      }

    if(COL>0)
      {
        n = length(N)
        dcols = n/COL
        cols = rep(1,length=n)
        for(jj in 1:COL)
          {
            j1 = (jj-1)*dcols+1
            cols[j1:(j1+dcols-1) ] = jj+1

          }
        
        lines(E,N)
        segments(E[1:(n-1)],N[1:(n-1)],E[2:n],N[2:n], col=cols)
      }
    else
      {
        lines(E,N, col=1)
      }
    
    
    len = floor(length(N)/4)
    points(E[1], N[1], pch=2, col=3)
    DO.PMOT.ARR(E, N)
    
    why1 = pu[3]+(pu[4]-pu[3])*.05
    ex1 = pu[2]-(pu[2]-pu[1])*.1
    text(ex1, why1, labs[X], adj=1)
    ex1 = pu[1]+(pu[2]-pu[1])*.1
    why2 =  pu[4]-(pu[4]-pu[3])*.1
    
    text(ex1, why2, labs[Y], adj=1,  srt=90)
    

    ex1 = pu[2]-(pu[2]-pu[1])*.05
    why2 =  pu[4]-(pu[4]-pu[3])*.05
    
    text(ex1, why2, tit, pos=2, cex=1.2 )
    
    

    box()
  }
############################
#  source("/home/lees/Progs/R_stuff/particle_motion.R")

############################
pmot3<-function(ascd, X, Y , xlim=xx, ylim=yy, labs=labs, tit=TIT)
  {
    if(missing(labs)) { labs=c("Vertical", "North", "East")}
     if(missing(tit)) { tit=paste(sep="-",labs[X], labs[Y])}
     if(missing(xlim)) { xlim=range(ascd[, X])}
     if(missing(ylim)) { ylim=range(ascd[, Y])}
  
    #  N is the up down axis, E is the horizontal
N = ascd[,Y]
E = ascd[,X]

plot(E,N, type='l', asp=1, xlim=xlim, ylim=ylim, xlab="", ylab="", axes=FALSE)
     pu=par("usr")
  #   axis(1, xlab=labs[X])
   #  axis(4,  ylab=labs[Y] )
# put in direction arrows
len = floor(length(N)/4)
points(E[1], N[1], pch=2)
arrows(E[len], N[len], E[len+1], N[len+1], length=.1)
arrows(E[2*len], N[2*len], E[2*len+1], N[2*len+1], length=.1)
arrows(E[3*len], N[3*len], E[3*len+1], N[3*len+1], length=.1)
arrows(E[4*len], N[4*len], E[4*len+1], N[4*len+1], length=.1)

    why1 = pu[3]+(pu[4]-pu[3])*.05
    ex1 = pu[2]-(pu[2]-pu[1])*.1
        text(ex1, why1, labs[X], adj=1)
     ex1 = pu[1]+(pu[2]-pu[1])*.1
    why2 =  pu[4]-(pu[4]-pu[3])*.1
    
     text(ex1, why2, labs[Y], adj=1,  srt=90)
     

     ex1 = pu[2]-(pu[2]-pu[1])*.05
    why2 =  pu[4]-(pu[4]-pu[3])*.05
    
     text(ex1, why2, tit, pos=2, cex=1.2 )
   
    

box()
  }

#########################################################################
ptraceB<-function(ascd, K, tim=1)
  {

  # nf <- layout(matrix(c(1,2,3),3,1,byrow=TRUE), c(3,3,3), c(1,1,1), TRUE)
    nf <- layout(matrix(c(1,2,3,4,5,0),3,2,byrow=TRUE), heights=c(1,1,1), widths=c(3, 1), TRUE)
    layout.show(nf)

    
 if(missing(tim))
    {
    ex = 1:length(ascd[,1])
  }
    else
      {

        ex = tim
      }
 if(missing(K))
    {
    K = max(ex)
  }


    
    xtics= pretty(ex)

    i=1
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main="Vertical", xlab="",ylab="", type="n")
    lines(ex[ex<=K],ascd[ex<K,i], col=2)
    lines(ex[ex>K],ascd[ex>K,i], col=1)

    
    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd[ex<=K,], 2, 1)
    i=2
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main="Radial", xlab="",ylab="", type="n")
    lines(ex[ex<=K],ascd[ex<K,i], col=2)
    lines(ex[ex>K],ascd[ex>K,i], col=1)

    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    pmotion(ascd[ex<=K,], 2, 3 )
    i=3
    par(mar=c(0,1,1,1))
    plot(ex,ascd[,i],axes=FALSE, main="Transverse", xlab="",ylab="", type="n")
    lines(ex[ex<=K],ascd[ex<K,i], col=2)
    lines(ex[ex>K],ascd[ex>K,i], col=1)

    axis(1,tck=.03,at=xtics,lab=FALSE)
    axis(2, las=1)
    axis(3,tck=.03,at=xtics,lab=FALSE)
    box()
    
    u = par("usr")
    

  }

#########################################################################
ptrace2<-function(ascd, K, tim=1)
  {


    
    if(missing(tim))
      {
        ex = 1:length(ascd[,1])
      }
    else
      {

        ex = tim
      }
    if(missing(K))
      {
        K = max(ex)
      }

    flag = (ex<=K)
    a2 = ascd
    mn = apply(ascd, 2, "mean")
    b2 = sweep(ascd, 2, mn)
    
    rn = apply(b2, 2, "range")
    dn = diff(rn)
    deltan = max(dn)
    
    

    xtics= pretty(ex)

    a2[,1] =   3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(dn[1]/deltan)
    a2[,2] =   2+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(dn[2]/deltan)
    a2[,3] =   1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(dn[3]/deltan)

    xtend = max(ex) + diff(range(ex))*0.25

    rex = 4*(ex-min(ex))/(diff(range(ex)))
    rtend = 4*(xtend-min(ex))/(diff(range(ex)))
    rtics = 4*(xtics-min(ex))/(diff(range(ex)))


    plot(range(c(rex, rtend) ), range(a2), asp=1, type="n", axes=FALSE, xlab="Time, s", ylab="Component")
    axis(1,tck=.03,at=rtics,lab=xtics )
    axis(2,tck=.03,at=c(1.5, 2.5, 3.5), lab=c("T", "R", "V") )

    box()

    g1 = max(rex)+ diff(range(rex))*0.05
    g2 = rtend 
    fudge = (g2-g1)*.01

    f1 = 1.5
    f2 = f1+(g2-g1)

    f3 = 2.5
    f4 = f3+(g2-g1)

    rad =  g1+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(g2-g1) 

    vert = f3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(f4-f3)
    
    tran = f1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(f2-f1)

    rect(g1-fudge , f3-fudge, g2+fudge, f4+fudge)
    rect(g1-fudge , f1-fudge, g2+fudge, f2+fudge)

    text(g1-fudge, f4+fudge, "Vert", pos=3)
    text(g1-fudge, f2+fudge, "Trans", pos=3)
    text((g1+g2)/2, f1, "Radial", pos=1)

    

    
    lines(rex[flag],a2[flag,1], type='l', col=2)
    points(rex[flag],a2[flag,1], col=2)
    lines(rex[flag],a2[flag,2], col=2)
    lines(rex[flag],a2[flag,3], col=2)
    lines(rex[!flag],a2[!flag,1], col=1)
    lines(rex[!flag],a2[!flag,2], col=1)
    lines(rex[!flag],a2[!flag,3], col=1)

    lines(rad[flag],vert[flag])
    lines(rad[flag], tran[flag])
    

  }

#########################################################################
slider.hodo<-function(abaz, ex)
{

  tt <- tktoplevel()
  bb<-max(ex)
  img <-tkrplot(tt, hscale=1.5, vscale=1.5, function() ptrace2(abaz, bb, tim=ex))
  f<-function(...) {
    b <- as.numeric(tclvalue("bb"))
    if (b != bb) {
      bb <<- b
      tkrreplot(img)
    }
  }
  s <- tkscale(tt, command=f, from=min(ex), to=max(ex) , variable="bb",length=500,
               showvalue=TRUE, resolution=0.008, orient="horiz")
  tkpack(img,s)


}
#########################################################################
pmosel<-function(dat, ex, title="", PS=FALSE)
{
  if(missing(PS)) { PS=FALSE }
  if(missing(title)) { title="" }
#  source("/home/lees/Progs/R_stuff/particle_motion.R")
  
  W =ptraceW(dat, c(min(ex), max(ex)) , tim=ex)
  title(main=title, sub="Click twice to window particle motion")
  g=plocator(2)
  gwin  = g$x
  wex  =(gwin*(diff(range(ex))/4)+min(ex))

  while(length(gwin)>=2)
    {
      owex = wex
      oW =W
      wex  =(gwin*(diff(range(ex))/4)+min(ex))
      W = ptraceW(dat, wex, tim=ex)
      title(main=title, sub="Click twice to window particle motion")
      
      g=plocator(2)
      abline(v=gwin)
      gwin  = g$x
    }

  return(list(win=owex, s=oW))

}

#########################################################################
ptraceW<-function(ascd, K, tim=1)
  {
###  plot a 3 component seismogram and click in
 ###    window to set bounds for particle motion

    ###  ascd = NX3 matrix of seismic signal
    ###   K = windowing flag
    ###       x axis timing

    
    if(missing(tim))
      {
        ex = 1:length(ascd[,1])
      }
    else
      {

        ex = tim
      }
    if(missing(K))
      {
        K = c(min(ex), max(ex))
      }

    flag = ex>K[1] & ex<=K[2]



    a2 = ascd
    mn = apply(ascd, 2, "mean")
    b2 = sweep(ascd, 2, mn)
    
    rn = apply(b2, 2, "range")
    dn = diff(rn)
    deltan = max(dn)
    
    

    xtics= pretty(ex)

    a2[,1] =   3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(dn[1]/deltan)
    a2[,2] =   2+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(dn[2]/deltan)
    a2[,3] =   1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(dn[3]/deltan)

    xtend = max(ex) + diff(range(ex))*0.25

    rex = 4*(ex-min(ex))/(diff(range(ex)))
    rtend = 4*(xtend-min(ex))/(diff(range(ex)))
    rtics = 4*(xtics-min(ex))/(diff(range(ex)))


    plot(range(c(rex, rtend) ), range(a2), type="n", axes=FALSE, xlab="Time, s", ylab="Component")
    axis(1,tck=.03,at=rtics,lab=xtics )
    axis(2,tck=.03,at=c(1.5, 2.5, 3.5), lab=c("T", "R", "V") )

    box()

    g1 = max(rex)+ diff(range(rex))*0.05
    g2 = rtend 
    fudge = (g2-g1)*.01

    f1 = 1.5
    f2 = f1+(g2-g1)

    f3 = 2.5
    f4 = f3+(g2-g1)

    rad =  g1+((b2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))*(g2-g1) 

    vert = f3+((b2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))*(f4-f3)
    
    tran = f1+((b2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))*(f2-f1)

    rect(g1-fudge , f3-fudge, g2+fudge, f4+fudge)
    rect(g1-fudge , f1-fudge, g2+fudge, f2+fudge)

    text(g1-fudge, f4+fudge, "Vert", pos=3)
    text(g1-fudge, f2+fudge, "Trans", pos=3)
    text((g1+g2)/2, f1, "Radial", pos=1)
    

    lines(rex,a2[,1], col=1)
    lines(rex,a2[,2], col=1)
    lines(rex,a2[,3], col=1)


    lines(rex[flag],a2[flag,1], type='l', col=2)
                                        #  points(rex[flag],a2[flag,1], col=2)
    lines(rex[flag],a2[flag,2], col=2)
    lines(rex[flag],a2[flag,3], col=2)

    radhodo = rad[flag]
    verthodo = vert[flag]
    tranhodo = tran[flag]
    N = length(radhodo)
    
    lines(radhodo,verthodo)
    lines(radhodo, tranhodo)
    points(radhodo, tranhodo, col=4, cex=0.6)

    points(radhodo[1], tranhodo[1], col=2, cex=0.6, pch=7)
    points(radhodo[N], tranhodo[N], col=5, cex=0.6, pch=2)
    
    
    
    invisible(list(rex=rex, rad=rad, tran=tran, flag=flag))

  }
####################################
