#################################
#################################
###   source("/home/lees/Progs/R_stuff/seis.R")cat("sourcing /home/lees/Progs/R_stuff/seis.R\n")
parseFN2STA<-function(fn)
  {
    ###  get the station name and the component name from the file name
    ### function assumes that the station name and the component name
      ###  are the last  items on the finle name seperated by a period
    ## first get the file name from the full path name

    ##   could make this more general by adding options 

    f1 = unlist(strsplit(fn, "/"))
    fn1 = f1[length(f1)]
    f2 = unlist(strsplit(fn1, "\\."))
    sta = f2[length(f2)-1]
    comp = f2[length(f2)]
    return(list(sta=sta, comp=comp) )
  }
#################################
###   source("/home/lees/Progs/R_stuff/seis.R")
getSEGY<-function(file)
{
  cmd = paste(sep=" ", "segy2asc ", file, "> outsegyasc")

  system(cmd)
  segy.h = scan("outsegyasc", nlines=60, what="", sep="\n" )
  segy.d = scan("outsegyasc", skip=60)
  segy.tot =   fillsegy(segy.h)
  segy.tot$data = segy.d
  return(segy.tot)
}
#################################
###   source("/home/lees/Progs/R_stuff/seis.R")
fillsegy<-function(SEGY.h)
{


                                        # plot(SEGY.d, type='l')
  STR = unlist(strsplit(SEGY.h[17], "\t"))
  dt = as.numeric(STR[length(STR)])/1000000

  STR = unlist(strsplit(SEGY.h[23], "\t"))
  yr = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[24], "\t"))
  day = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[25], "\t"))
  hour = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[26], "\t"))
  min = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[27], "\t"))
  sec = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[28], "\t"))
  msec = as.numeric(STR[length(STR)]) 
  STR = unlist(strsplit(SEGY.h[21], "\t"))
  scalefac= as.numeric(STR[length(STR)]) 

  return(list(yr=yr,day =day,hour=hour, min=min, sec=sec,  msec=msec ,scalefac=scalefac, dt=dt ))

}
#################################
#################################
###   source("/home/lees/Progs/R_stuff/seis.R")

seisrot<-function(dat, sleeper=0.002)
{
  #####  rotate a seismogram in increments, with pause in between
if(missing(sleeper)) {  sleeper = 0.002 }
for(i in 1:360)
{
ang = i
rseis=grotseis(ang, flip=FALSE)
ascd<-dat %*% rseis
pseis(ascd)
system("sleep 0.002")
title(paste(sep=" ", "Angle =", i))
}
}
### 
srot<-function(dat, i, plot=FALSE)
{
###  rotate a seismogram by i degrees
###  input is Nx3 matrix with vertical, N-S, E-W components
  if(missing(plot)) { plot=FALSE }
  
  ang = i
  rseis=grotseis(ang, flip=FALSE)
  ascd<-dat %*% rseis
  if(plot==TRUE)
    {
      pseis2(ascd)
      title(paste(sep=" ", "Angle =", i))
    }
  invisible(ascd)
}



###   srot(ascd, i)
#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")
pseis<-function(dat)
{
 ###########  plot 3 component seismogram as matrix
  ###  better see also:  PLOT.MATN
  par(mfrow=c(3,1))
  ex = 1:length(dat[,1])
  xtics= pretty(ex)
  for(i in 1:3)
    { 
      plot(ex,dat[,i],axes=F, xlab="",ylab="", type="l")
      axis(1,tck=.03,at=xtics,lab=F)
      axis(2, las=1)
      axis(3,tck=.03,at=xtics,lab=F)
      box()
      locy=0.8*max(dat[,i])
      letter.it(i,2) 
    }	
}
### 
#####################################################
pseis2<-function(ascd)
{
 ###########  plot 3 component seismogram as matrix
  ###  better see also:  PLOT.MATN
PLOT.MATN(ascd)
}
### 
#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")

seisglyph<-function(ampv, xz, inx1, inx2, iny1, iny2, lcol=0,  border=1, rcol=1)
  {
    ### plot time series as an insert to an existing plot
    ###  ampv = time series amplitude
    ###  xz =   x-axis
    ###  inx1, inx2, iny1, iny2 = location in plot where ts should be plotted
    ### lcol=0,  border=1, rcol=1 color of line, border of rect and rect fill
    ###  seisglyph(ampv, xz, inx1, inx2, iny1, iny2)
    

    if(missing(border)) { border=0 }
    if(missing(rcol)) { rcol=1 }
    if(missing(lcol)) { lcol=0 }
    

       z = RESCALE(ampv, iny1, iny2, min(ampv), max(ampv) )
       xz = RESCALE(xv,inx1,inx2, min(xv), max(xv))  

       rect(inx1, iny1, inx2, iny2, col=rcol, border=border)
       lines(xz,z, col=lcol)

       tx=pretty(xv)
       tx = tx[tx<=max(xv)&tx>=min(xv)]
       txp = RESCALE(tx,inx1,inx2, min(xv), max(xv))
       segments(txp,rep(iny1, length(txp)), txp, rep(iny1+0.02*(iny2-iny1), length(txp)))
       segments(txp,rep(iny2, length(txp)), txp, rep(iny2-0.02*(iny2-iny1), length(txp)))
       text(txp,rep(iny2, length(txp)), labels=tx, pos=3)
       
  }
#####################################################3
###   source("/home/lees/Progs/R_stuff/seis.R")
################################################
###   dyn.load("/home/lees/Progs/Rc/get_seis.so")

GET.seis<-function(fnames, kind=1, PLOT=FALSE)
{
  ###  get a bunch of AH files from a directory and store in structure
  ####  kind 1=segy, 2=sac, 3=AH
  
  if(missing(PLOT)) { PLOT=FALSE }
  if(missing(kind)) { kind=3 }

  GIVE = as.list(1:length(fnames))

  ii = 1

  DATIM =  rep(0,length=4)
  n=1
  dt=0.025000
  sec = 0
  thesta="XXXXX"
  thecomp="XXXXX"


  for(i in 1:length(fnames))
    {

      fn = fnames[i]
      infile = fn
      print(fn);
      ###  if this file doeas not exist, exit!
      if(file.exists(infile)==FALSE)
        {
         print(paste(sep=' ', "file does not exist", fn) ); 
          next;
        }
      else
        {
          print(paste(sep=' ', "file exists", fn) );

        }
      
      barfa = .C("CALL_SETSEIS", infile,
        as.integer(kind),
        as.integer(n),
        as.double(dt), 
        as.integer(DATIM),   
        as.double(sec),
        thesta , thecomp
        )
      
      
      N = barfa[[3]]
      dt = barfa[[4]]
      DATIM = barfa[[5]]
      sec = barfa[[6]]
      
      thesta=barfa[[7]]
      thecomp=barfa[[8]]

      

      if(kind==2)
        {
          if(thesta=="-12345")
            {
              stn = parseFN2STA(infile)
              thesta=stn$sta
              thecomp=stn$comp
            }
        }

      print(paste(sep=' ', infile, thesta, thecomp, N, dt, sec))

      
      x = rep(0,length=N)
      infile = fn
      

      barf = .C("CALL_GETSEIS", infile,
        as.integer(kind),
        as.double(x),
        as.integer(n),
        as.double(dt), 
        as.integer(DATIM),   
        as.double(sec)
        )



      x = barf[[3]]
      N = barf[[4]]
      dt = barf[[5]]
      DATIM = barf[[6]]
      sec = barf[[7]]

      md = getmoday(DATIM[2], DATIM[1])

      t1 = 0
      t2 = dt*(N-1)
      

      tstart = list(yr=DATIM[1], jd=DATIM[2] , mo=md$mon, dom=md$dom, hr=DATIM[3], mn=DATIM[4], sec=sec, msec=0, dt=dt, t1=t1,
        t2=t2, off=0)


      if(is.null(thesta))   thesta="XXX"

      
      if(is.null(thecomp))  thecomp="X"

     
      GIVE[[i]] = list(fn=fn, sta=thesta, comp=thecomp, dt=dt, DATTIM=tstart, N=N, amp=x) 
      if(PLOT==TRUE)
        {
          plot(barf[[3]], type='l', main=paste(sep=' ', thesta, thecomp))
          print("CLICK in WINDOW for NEXT TRACE:")
          locator()
        }
    }
  invisible(GIVE)
}
################################################
###   dyn.load("/home/lees/Progs/Rc/get_seis.so")
###   source("/home/lees/Progs/R_stuff/seis.R")
testGG<-function(GG)
  {

  for(i in 1:length(GG))
    {
      n = length(GG[[i]]$amp)
      print(paste(sep=' ', i, GG[[i]]$sta, GG[[i]]$comp, GG[[i]]$N, GG[[i]]$DATTIM$dt, n))
      print(paste(sep=' ', i,GG[[i]]$DATTIM$jd, GG[[i]]$DATTIM$hr, GG[[i]]$DATTIM$mn, GG[[i]]$DATTIM$sec))
    }


  }

#####################################################3
###   source("/home/lees/Progs/R_stuff/seis.R")
prepGG3<-function(GG)
{
  ###  prepare a list of seismic information after reading in segy/sac/ah files
  ###    using SEE.ahseis(fnames, kind=1, PLOT=TRUE)
  gstas = rep(NA, length(GG))
  gcomps = rep(NA, length(GG))
  
  gtim1 = rep(NA, length(GG))
  gtim2 = rep(NA, length(GG))
  gn = rep(NA, length(GG))
  gdt  = rep(NA, length(GG))
    ## gfn  = rep(NA, length(GG))


  ####  prepare some of the stats on the times of the waveforms
  for(i in 1:length(GG))
    {
      ### gstas[i] = GG[[i]]$sta
      dt = round(1000*GG[[i]]$DATTIM$dt)/1000
      n = length(GG[[i]]$amp)
      GG[[i]]$DATTIM$dt = dt
      gtim1[i]  = GG[[i]]$DATTIM$jd+GG[[i]]$DATTIM$hr/24+GG[[i]]$DATTIM$mn/(24*60)+GG[[i]]$DATTIM$sec/(24*3600)
      gtim2[i]  = gtim1[i]+GG[[i]]$N*GG[[i]]$DATTIM$dt/(24*3600)
      gn[i] = n
      gdt[i] = dt
      ## gfn[i] = GG[[i]]$fn
      print(paste(sep=' ', i, GG[[i]]$sta, GG[[i]]$comp, GG[[i]]$N, n, GG[[i]]$DATTIM$dt, GG[[i]]$DATTIM$jd, GG[[i]]$DATTIM$hr, GG[[i]]$DATTIM$mn, GG[[i]]$DATTIM$sec))

    }

    wmin = which.min(gtim1)
    wmax = which.max(gtim2)

####  set up the padding
  r1 =  round((gtim1-gtim1[wmin])*24*3600/gdt)
  r2 = round((gtim2[wmax]-gtim2)*24*3600/gdt)
  BigR = r1+gn+r2
  ma = 1:length(gdt)
   
  K = BigR[ma[1]]
  ascd = as.list(1:length(GG))
   
  dt = gdt
  notes = rep(NA, length(ma))
  stns = rep(NA, length(ma))
  comps = rep(NA, length(ma))
  
  info = list(fn=rep(NA, length(ma)), name=rep(NA, length(ma)), yr=rep(NA, length(ma)), jd=rep(NA, length(ma)), mo=rep(NA, length(ma)), dom=rep(NA, length(ma)), hr=rep(NA, length(ma)), mn=rep(NA, length(ma)),sec=rep(NA, length(ma)), msec=rep(0, length(ma)),dt=rep(0, length(ma)),t1=rep(0, length(ma)) ,t2=rep(0, length(ma)), off=rep(0, length(ma)), n1=rep(0, length(ma)), n2=rep(0, length(ma)), n3=rep(0, length(ma)), n=rep(0, length(ma)) )
  ###  fill up data structure and information
  for(j in 1:length(ma))
	{
	  ima = ma[j]          
	  ascd[[j]] = c(rep(NA, r1[ ima ]) , GG[[ima]]$amp,    rep(NA,r2[ ima ]))
	  notes[j] = paste(sep=' ', GG[[ima]]$sta, GG[[ima]]$comp)
	  stns[j] = GG[[ima]]$sta
	  comps[j] = GG[[ima]]$comp
	  info$fn[j] = GG[[ima]]$fn
	  info$name[j] = GG[[ima]]$fn
	  info$yr[j] = GG[[ima]]$DATTIM$yr
	  info$jd[j] = GG[[ima]]$DATTIM$jd
	  info$mo[j] = GG[[ima]]$DATTIM$mo
	  info$dom[j] = GG[[ima]]$DATTIM$dom
	  info$hr[j] = GG[[ima]]$DATTIM$hr
	  info$mn[j] = GG[[ima]]$DATTIM$mn
	  info$sec[j] = GG[[ima]]$DATTIM$sec
	  info$msec[j] = 0
	  info$dt[j] = gdt[ima]

 	  info$t1[j] = 0
 	  info$t2[j] = gdt[ima]*(length(ascd[[j]])-1)
           
           
	  info$off[j] =  r1[ ima ]*gdt[ima]
	  info$n1[j] =  length(ascd[[j]])
	  info$n2[j] =  info$n1[j]
 	  info$n3[j] =  info$n1[j]
 	  info$n[j] =  info$n1[j]
          
	}
 
    f1 = unlist(strsplit(info$fn[1], "/"))
    fn1 = f1[length(f1)]
    dir = paste(collapse="\/", c(f1[1:(length(f1)-1)]) )

  USTA= unique(stns)
  nn =length(ma)
  pcol=rep(1, nn)
  for(m in 1:length(USTA))
    {
      pcol[!is.na(match( stns, USTA[m]))] = 2+m
    }
  
  ok = order(notes)
  wintim=  info$jd[1] + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)
  ex = seq(0,length(ascd[[1]])-1)*info$dt[1]

  dat=NULL
    
  ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
  
  GFIL = list(JSTR=ascd, STNS=stns, dir=dir, ifile=fn1, COMPS=comps, dt=dt, KNOTES=notes, info=info,dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim,  ftime=ftime )
  
  invisible(GFIL)
  
}

################################################
###   dyn.load("/home/lees/Progs/Rc/get_seis.so")

glueseis<-function(GG)
{
###  prepare a list of seismic information after reading in segy/sac/ah files
###    using SEE.ahseis(fnames, kind=1, PLOT=TRUE)
  gstas = rep(NA, length(GG))
  gcomps = rep(NA, length(GG))
  
  gtim1 = rep(NA, length(GG))
  gtim2 = rep(NA, length(GG))
  gn = rep(NA, length(GG))
  gdt  = rep(NA, length(GG))
  ## gfn  = rep(NA, length(GG))


####  prepare some of the stats on the times of the waveforms
  for(i in 1:length(GG))
    {
### gstas[i] = GG[[i]]$sta
      dt = round(1000*GG[[i]]$DATTIM$dt)/1000
      n = length(GG[[i]]$amp)
      GG[[i]]$DATTIM$dt = dt
      gtim1[i]  = GG[[i]]$DATTIM$jd+GG[[i]]$DATTIM$hr/24+GG[[i]]$DATTIM$mn/(24*60)+GG[[i]]$DATTIM$sec/(24*3600)
      gtim2[i]  = gtim1[i]+GG[[i]]$N*GG[[i]]$DATTIM$dt/(24*3600)
      gn[i] = n
      gdt[i] = dt
      ## gfn[i] = GG[[i]]$fn
      print(paste(sep=' ', i, GG[[i]]$sta, GG[[i]]$comp, GG[[i]]$N, n, GG[[i]]$DATTIM$dt, GG[[i]]$DATTIM$jd, GG[[i]]$DATTIM$hr, GG[[i]]$DATTIM$mn, GG[[i]]$DATTIM$sec))

    }

  wmin = which.min(gtim1)
  wmax = which.max(gtim2)

####  set up the padding
  r1 =  round((gtim1-gtim1[wmin])*24*3600/gdt)
  r2 = round((gtim2[wmax]-gtim2)*24*3600/gdt)
  BigR = r1+gn+r2
  ma = 1:length(gdt)
  
  K = BigR[ma[1]]
  ascd = as.list(1:length(GG))
  
  dt = gdt

  zed = rep(NA, K)

  for(j in 1:length(ma))
    {
      ima = ma[j]  
      zed[(r1[ ima ]+1):(r1[ ima ]+gn[ima])] =   GG[[ima]]$amp 
### ascd[[j]] = c(rep(NA, r1[ ima ]) , GG[[ima]]$amp,    rep(NA,r2[ ima ]))
      
      
    }
  
  return(zed)
  
}


################################################
###   dyn.load("/home/lees/Progs/Rc/get_seis.so")
plotGG3<-function(GG)
{
  gstas = rep(NA, length(GG))
  gtim1 = rep(NA, length(GG))
  gtim2 = rep(NA, length(GG))
  gn = rep(NA, length(GG))
  gdt  = rep(NA, length(GG))

  for(i in 1:length(GG))
    {
      gstas[i] = GG[[i]]$sta
      dt = round(1000*GG[[i]]$DATTIM$dt)/1000
      n = length(GG[[i]]$amp)
      GG[[i]]$DATTIM$dt = dt
      gtim1[i]  = GG[[i]]$DATTIM$jd+GG[[i]]$DATTIM$hr/24+GG[[i]]$DATTIM$mn/(24*60)+GG[[i]]$DATTIM$sec/(24*3600)
      gtim2[i]  = gtim1[i]+GG[[i]]$N*GG[[i]]$DATTIM$dt/(24*3600)
      gn[i] = n
      gdt[i] = dt
      print(paste(sep=' ', i, GG[[i]]$sta, GG[[i]]$comp, GG[[i]]$N, n, GG[[i]]$DATTIM$dt, GG[[i]]$DATTIM$jd, GG[[i]]$DATTIM$hr, GG[[i]]$DATTIM$mn, GG[[i]]$DATTIM$sec))

    }

    wmin = which.min(gtim1)
    wmax = which.max(gtim2)


  r1 =  round((gtim1-gtim1[wmin])*24*3600/gdt)
  r2 = round((gtim2[wmax]-gtim2)*24*3600/gdt)
  BigR = r1+gn+r2

  usta = unique(gstas)

  for(i in 1:length(usta))
    {
    
      ma = which(usta[i]==gstas)
      K = BigR[ma[1]]
      ascd = matrix(nrow=K, ncol=length(ma))
      dt = gdt[ma[1]]
      notes = rep(NA, length(ma))
      stns = rep(NA, length(ma))

      info = list(yr=rep(NA, length(ma)), jd=rep(NA, length(ma)), mo=rep(NA, length(ma)), dom=rep(NA, length(ma)), hr=rep(NA, length(ma)), mn=rep(NA, length(ma)),sec=rep(NA, length(ma)), msec=rep(0, length(ma)) ,t1=rep(0, length(ma)), off=rep(0, length(ma)) )

      for(j in 1:length(ma))
	{
	  ima = ma[j]
	  ascd[,j] = c(rep(NA, r1[ ima ]) , GG[[ima]]$amp,    rep(NA,r2[ ima ]))
	  notes[j] = paste(sep=' ', GG[[ima]]$sta, GG[[ima]]$comp)
	  stns[j] = GG[[ima]]$sta

	  info$yr[j] = GG[[ima]]$DATTIM$yr
	  info$jd[j] = GG[[ima]]$DATTIM$jd
	  info$mo[j] = GG[[ima]]$DATTIM$mo
	  info$dom[j] = GG[[ima]]$DATTIM$dom

	  info$hr[j] = GG[[ima]]$DATTIM$hr
	  info$mn[j] = GG[[ima]]$DATTIM$mn
	  info$sec[j] = GG[[ima]]$DATTIM$sec
	  info$off[j] =  r1[ ima ]*gdt[ima]

	}
      
      GFIL = list(JMAT=ascd, STNS=stns, dt=dt, KNOTES=notes, info=info )
      
      YN = PLOT.MATN(GFIL$JMAT, WIN=c(700, 1500), dt=GFIL$dt, notes =GFIL$KNOTES, COL=c(4,2,2)  )
      TTPIX.MATN(GFIL,  stns , YN$n)
      
      vp = plocator()
      if(length(vp$x)>1)
	{
	  YN = PLOT.MATN(GFIL$JMAT, WIN=c(vp$x[1], vp$x[2]), dt=GFIL$dt, notes =GFIL$KNOTES, COL=c(4,2,2)  )
	  TTPIX.MATN(GFIL,  stns , YN$n)
	  
	  vp = plocator()

	}
      
    }
  
  
}
######################################################
#####################################################3
###   source("/home/lees/Progs/R_stuff/seis.R"); save.image()

PLOT.SEISN<-function(GH, tim=1, dt=1,  sel=sel, WIN=WIN, labs=LABS, notes=notes, sfact=1, LOG="", COL=col, add=1, pts=FALSE, YAX=FALSE, TIT=NULL)
{
  ### plot a matrix of seismograms on a simple panel display
  ###   GH = structure of traces

  ###  add = 1,2,3  if add=1 plot and add traces
   ###                  add =2 plot, but no traces
  ###                   add = 3 no plot, but add traces

  ###   sfact >= 2 = scale by window

  if(missing(sel)) { sel = 1:length(GH$JSTR) }
  if(missing(sfact)) { sfact=1}
  
  if(missing(dt)) { dt=rep(GH$info$dt[1],length(GH$JSTR)) }
  
  if(missing(LOG)) { LOG=""  }
  
  if(missing(add)) { add=1 }
  if(missing(pts)) {  pts=FALSE  }
  if(missing(YAX)) {  YAX=FALSE  }
  if(missing(TIT)) { TIT=NULL }

  if(missing(tim))
    {
      tim = GH$dt[1]*seq(from=0,to=length(GH$JSTR[[1]])-1)
    }

  if(missing(WIN))
    {
      WIN =range(tim)
    }
  if(missing(notes))
    {
      note.flag = FALSE
    }
  else
    {
      note.flag = TRUE
    }

  if(is.list(WIN)==TRUE)
    {
      WIN = WIN$x
    }

  if(is.null(WIN)==TRUE){ WIN =range(tim) }
  ###  print(paste(sep=' ', "WIN", WIN[1], WIN[2]))
  ###  this following does not work as I expected it to.
  ### if(exists(deparse(substitute(WIN)))==FALSE){ WIN =range(tim) }
  
  ###  print(paste(sep=' ', "WIN", WIN[1], WIN[2]))
  
  tflag = tim>=WIN[1]&tim<=WIN[2]
  
  tr1 = 0.05
  tr2 = .9
  
  nn = length(sel)
  
  if(missing(COL)) { COL=rep(1, nn)  }
if(length(COL)<nn) {  COL=c(COL, rep(1, nn-length(COL))) }
  
    if(missing(labs)) { labs=rep(NA, nn) }
  
  ttics = pretty(tim[tflag], n=10 )
  atics = ttics
  if(LOG=='x')
    {
      periods = c(30,20,10,5,2,1)
      hz = 1/periods
      at1 = c(pretty(1:10), pretty(tim))
      at2 = at1[at1>0&at1<max(tim)]
      ttics = c(hz, at2 )
      
      btics = c(periods, at2 )
      atics = as.character(btics)
      atics[length(atics)] = paste(sep=' ', atics[length(atics)],"Hz")
      
      atics[btics==1] = paste(sep=' ', atics[btics==1],"Hz")
           atics[1] = paste(sep=' ', atics[1],"s")
 
      
    }
  dy = (1/nn)
  maxS = rep(0,nn)
  minS = rep(0,nn)
  diffS = rep(0,nn)

  
  for(i in 1:length(sel))
    {
      ii = sel[i]
      tim = GH$dt[ii]*seq(from=0,to=length(GH$JSTR[[ii]])-1)
      tflag = tim>=WIN[1]&tim<=WIN[2]
      amp = GH$JSTR[[ii]][tflag]
     ###  print(range(amp[!is.na(amp)]))
      lamp = length(amp[!is.na(amp)])
     
      if(lamp<1)
        {
          maxS[i] = 0
          minS[i] = 0
          diffS[i] = 0

        }
      else
        {
          
          maxS[i] = max(amp, na.rm=TRUE)
          minS[i] = min(amp, na.rm=TRUE)
          diffS[i] = maxS[i]-minS[i]
        }
    }
      ##  abs waiting using only COMP
  KDIFF = which.max(diffS)
  
  if(sfact>=2)
    {
      MAXy = max(maxS, na.rm=TRUE)
      MINy = min(minS, na.rm=TRUE)
      
      maxS =rep(MAXy, nn)
      minS =rep(MINy, nn)
    }

  if(add==1)
    {
      plot(range(tim[tflag]), c(0,1), type='n', axes=FALSE, xlab="", ylab="", log=LOG)
       
    }
  if(add==2)
    {
      plot(range(tim[tflag]), c(0,1), type='n', axes=FALSE, xlab="", ylab="", log=LOG)

    }


######print(maxS)
######  print(minS)
  
          #########################  plotting  ####################
   box(col=grey(0.8))

  upar = par("usr")
  
  for(i in 1:length(sel))
    {
      ii = sel[i]
      tim = GH$dt[ii]*seq(from=0,to=length(GH$JSTR[[ii]])-1)
      tflag = tim>=WIN[1]&tim<=WIN[2]
      amp = GH$JSTR[[ii]][tflag]
      lamp = length(amp[!is.na(amp)])
      ###### print(paste(sep=' ',i, ii, lamp))
      if(lamp<1)
        {

          next;
        }

      ###  here I tried removing the mean value before plotting....this is wrong
      ###  amp = amp-mean(amp[!is.na(amp)])

      
      y3 = 1-(dy*i)
      if(sfact==1)
        {
          minamp =  min(amp[!is.na(amp)]);
          maxamp= max(amp[!is.na(amp)]);
        }
      else
        {
          minamp =  minS[i];
          maxamp= maxS[i];

        }

           ###  print( paste(sep=' ', "IN PLOT.SEISN", minamp, maxamp))

      if(add!=3) addtix(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=gray(0.8) )
      z = RESCALE(amp, y3, y3+dy, minamp, maxamp )

      
      if(add!=3)abline(h=y3, lty=2, col=grey(0.8))
      if(add!=2)lines(tim[tflag], z, col=COL[i])
      if(pts==TRUE)points(tim[tflag], z, col=COL[i], pch=4)
      
   ###  print( paste(sep=' ', "IN PLOT.SEISN", y3, y3+dy, minamp, maxamp))
      
      cmm = c(minamp, maxamp)
      lcmm = length(cmm[!is.na(cmm)])
      dmm = maxamp-minamp
      if( lcmm < 2   | dmm<=0)
        {
          
                                        #   print( paste(sep=' ', "IN PLOT.SEISN", "PROBLEMS", lcmm ,dmm ))
          next;
        }
      yy = pretty(cmm, n = 5)
      
      flg = yy>minamp & yy<maxamp
      yt = yy[flg]
      yts = RESCALE(yt, y3, y3+dy, minamp, maxamp )
      
       ### print(paste(sep =  ' ' ,minamp,maxamp,  paste(collapse=" ", yt) ))
                                        #

      if(YAX == TRUE) axis(2, pos= upar[1] ,tck=-0.005 , at=yts, labels=yt, las=2 , line=0.1 )

      
      if(i==KDIFF)
        {
          if(add!=3)axis(2, pos= upar[1] ,tck=-0.005 , at=yts, labels=yt, las=2 , line=0.1 )
        }
      else
        {
          bnum = paste(sep='', "X", format.default(diffS[KDIFF]/diffS[i], digits=4))
          blab=bnum 
          if(add!=3)text(min(tim[tflag]), y3+0.75*dy, labels=blab, adj=0)
        }

      
      
      # axis(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=2 )
      
      ylab = labs[i]
      mtext(side=2, at=y3+dy/2, text=ylab , line=1)
                                        #    print( paste(sep=' ', "IN PLOT.SEISN",note.flag))
      
      if(note.flag==TRUE)
        {
                                        #  print( paste(sep=' ', "IN PLOT.MATN", notes[i]))
          
          if(add!=3)text(max(tim[tflag]), y3+dy-dy*0.1, notes[i], adj=1)
          
        }
      if(add!=3)text(max(tim[tflag]), y3+dy/2, labels=i, pos=4, col=gray(0.8))
      
    }
               ###  end plotting

  
  if(add!=3)
    {
      axis(side=1, tck=0.01, at=ttics, labels=FALSE)
      axis(side=1, tick=FALSE,  at=ttics, labels=atics, line=-1)
      
      
      moretics = seq(from=min(ttics), to=max(ttics), by=1)
      if(length(moretics)<500)
        {
          axis(side=3, tck=0.01, at=moretics, labels=FALSE)
        }
      title(xlab='Time (s)', line=1.4, cex=1.2) 
    }
  

  u = par("usr")
  ftime = Zdate(GH$info, sel[1], WIN[1])
  mtext( ftime, side = 3, at = u[1] , line=0.5, adj=0)

  ftime = Zdate(GH$info, sel[1], 0)
  mtext( ftime, side = 1, at = u[1] , line=1.5, adj=0)

  if(!is.null(TIT))
    {

       mtext( TIT, side = 1, at = u[2] , line=1.5, adj=1)

    }

  invisible(list(n=nn, dy=dy,  minS=minS, maxS=maxS, DX=range(tim[tflag]) ))
  
 

}
######################################################
######################################################
PIX.SEISN<-function(GH, PPTIM, ksel)
{
TP = PPTIM

     for(M in 1:length(ksel) )
        {
          K = ksel[M]

	tp = TP[[M]]
          

          ypos = (length(ksel)-M+0.5)/length(ksel)

          zloc = list(x=rep(NA, length(tp$jday)),  y=rep(ypos, length(tp$jday))  )

          zloc$x = secdif(GH$info$jd[K], GH$info$hr[K], GH$info$mn[K], GH$info$sec[K]+GH$info$msec[K]/1000+GH$info$t1[K],
            tp$jday, tp$hour, tp$min, tp$sec)


          PPIX(zloc, YN=length(ksel), col=4, lab='P')
        }

}
######################################################
######################################################
Zdate<-function(info, sel, t1)
  {
    if(is.null(t1)) { t1 = 0 }
    rd = recdate(info$jd[sel], info$hr[sel], info$mn[sel], info$sec[sel]+info$msec[sel]/1000+info$t1[sel]-info$off[sel]+t1)
    sec = floor(rd$sec)
    msec = 1000*(rd$sec-sec)
    t1 =   (msec-floor(msec))/1000
    msec = floor(msec)
    
    ftime = paste(sep=":", info$yr[sel], rd$jday, rd$hour, rd$min, sec, msec)
    
    return(ftime)
    
  }
#####################################################
PMOT.SEISN<-function(GH, sel=1:length(GH$dt), WIN=NULL)
  {
    if(missing(WIN)) { WIN = NULL }
    if(missing(sel)) { sel = 1:length(GH$dt)}
  
    a = ZOOM.SEISN(GH, sel=1:length(GH$dt), WIN=NULL)

    flag = GH$ex>=a$x[1]&GH$ex<=a$x[2]

    

    AA = srot(kraf1$dat[flag , ], 114.5)
    ex = GH$ex[flag]

    F = pmosel(AA, ex, PS=TRUE)

  }

#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")
ZOOM.SEISN<-function(GH, sel=1:length(GH$dt), WIN=NULL)
{
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
  
  labs = c("STOP", "zoom out", "zoom in", "restore", "saveWIN")
  
  YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  #### ftime = Zdate(GH$info, sel[1],0)
  #### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
 ####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs)
  
  ####  NV = LabelBAR(labs)
  zloc = plocator(COL=rgb(1,0.8, 0.8))
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)

  sloc = zloc

  while(Nclick>0)
    {

      if(K[Nclick] == 1)
        {
          break;
        }

      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
            
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
        ####  ftime = Zdate(GH$info, sel[1], 0)
        ####  mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
        ####  next;
          
        }

      if(K[Nclick]==4)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(Nclick>1 & K[Nclick]==0)
        {

          WIN  = zloc$x[c( Nclick-1, Nclick)]
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }
      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==5)
        {
          
          print(paste(sep=" " , "WIN=",sloc$x))
          

          
        }
          
      buttons = rowBUTTONS(labs)
     ###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8))
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
      ### K = ValBAR(NV, zloc)
     ###  print(paste(sep=" ", "K=",K))
      
    }
  return(sloc)
}		
#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")
QL.SEISN<-function(GH, sel=1:length(GH$dt), WIN=NULL, FILT=list(ON=FALSE, fl=5, fh=35.0, type="BP", proto="BU"), ang=114.5)
{
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
   if(missing(FILT)) { FILT = list(ON=FALSE, fl=5, fh=35.0, type="BP", proto="BU")}
   if(missing(ang)) { ang=114.5  }

  
  labs = c("STOP", "zoom out", "zoom in", "restore", "filter", "rotate", "replot", "PMOT")

  GHTEM = GH
  
  YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  #### ftime = Zdate(GH$info, sel[1],0)
  #### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
 ####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs)
  
  ####  NV = LabelBAR(labs)
  zloc = plocator(COL=rgb(1,0.8, 0.8))
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)

  sloc = zloc

  while(Nclick>0)
    {

      if(K[Nclick] == 1)
        {
          break;
        }

      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
            
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
        ####  ftime = Zdate(GH$info, sel[1], 0)
        ####  mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
        ####  next;
          
        }

      if(K[Nclick]==4)
        {
          GH = GHTEM
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(Nclick>1 & K[Nclick]==0)
        {

          WIN  = zloc$x[c( Nclick-1, Nclick)]
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }
      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==5)
        {
          
          FH = FILT.SEISN(GH, sel=sel, FILT=FILT   )
          GH = FH
          YN = PLOT.SEISN(FH, WIN=WIN, dt=FH$dt, sel=sel , notes=FH$KNOTES[sel])
          
        }
          
        if(K[Nclick]==6)
        {

          dat = cbind(GH$JSTR[[1]],GH$JSTR[[2]], GH$JSTR[[3]])
          print(paste(sep=' ', "Rotation Angle=", ang))
          rseis=grotseis(ang, flip=FALSE)
          ascd<-dat %*% rseis

          GH$JSTR[[1]] = ascd[,1]
          GH$JSTR[[2]] = ascd[,2]
          GH$JSTR[[3]] = ascd[,3]

          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          
        }

            if(K[Nclick]==7)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(K[Nclick]==8)
        {
          x1 = GH$dt*(0:(length(GH$JSTR[[1]])-1))
          fex = x1>=WIN[1]&x1<WIN[2]
          AA = cbind(GH$JSTR[[1]],GH$JSTR[[2]], GH$JSTR[[3]])
          F = pmosel(AA[fex,], x1[fex], PS=FALSE)
        }
      
          
      buttons = rowBUTTONS(labs)
     ###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8))
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
      ### K = ValBAR(NV, zloc)
     ###  print(paste(sep=" ", "K=",K))
      
    }
  return(sloc)
}		

#####################################################3
###   source("/home/lees/Progs/R_stuff/seis.R")
PICK.SEISN<-function(GH, sel=1:length(GH$dt), WIN=NULL)
{
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
  
  labs = c("DONE", "zoom out", "zoom in", "restore", "FirstPix", "AccPIX", "CHUGPIX", "plotPIX")
  
  YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
  u = par("usr")
  sloc = list(x=c(u[1],u[2]))
  ppick  = NA
  spick  = NA
  xpick = NA
  #### ftime = Zdate(GH$info, sel[1],0)
  #### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
 ####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs)
  
  ####  NV = LabelBAR(labs)
  zloc = plocator(COL=rgb(1,0.8, 0.8))
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)

  sloc = zloc

  while(Nclick>0)
    {

      if(K[Nclick] == 1)
        {
          break;
        }

      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
            
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
        ####  ftime = Zdate(GH$info, sel[1], 0)
        ####  mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
        ####  next;
          
        }

      if(K[Nclick]==4)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(Nclick>1 & K[Nclick]==0)
        {

          WIN  = zloc$x[c( Nclick-1, Nclick)]
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }
      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      if(K[Nclick]==5)
        {  
         ppick = zloc$x[Nclick-1]
         abline(v=ppick, col=3)
        }
      if(K[Nclick]==6)
        {
          
### print(paste(sep=" " , "WIN=",sloc$x))
          spick = zloc$x[Nclick-1]
          abline(v=spick, col=2)
          
        }
      if(K[Nclick]==7)
        {
          
###   print(paste(sep=" " , "WIN=",sloc$x))
          xpick = zloc$x[1:(Nclick-1)]
          abline(v=xpick, col=4)
        }

      if(K[Nclick]==8)
        {
          
          abline(v=ppick, col=3)
          abline(v=spick, col=2)
          abline(v=xpick, col=4)
          
        }


      
            
      buttons = rowBUTTONS(labs)
     ###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8))
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
      ### K = ValBAR(NV, zloc)
     ###  print(paste(sep=" ", "K=",K))
      
    }
  return(list(win=sloc, ppix=ppick, spix=spick, xpix=xpick) )
}		
###############################################
#####################################################3
###   source("/home/lees/Progs/R_stuff/seis.R")
PICK.CHUGZ<-function(GH, sel=1:length(GH$dt), WIN=NULL)
{
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
  
  labs = c("DONE", "zoom out", "zoom in", "replot", "restore", "FirstPix", "AccPIX", "CHUGPIX", "plotPIX", "clearPIX")
  
  YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
  u = par("usr")
  oloc = list(x=c(u[1],u[2]))
  sloc = list(x=c(u[1],u[2]))
  ppick  = NA
  spick  = NA
  xpick = NA

  ppick.n  = NA
  spick.n = NA
  xpick.n = NA

  
  #### ftime = Zdate(GH$info, sel[1],0)
  #### mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
  
 ####  title("LEFT 0 Click = done; 1 Click=replot;   2 Click=zoom")
  buttons = rowBUTTONS(labs)
  zloc = plocator(COL=rgb(1,0.8, 0.8), YN=length(sel) )
  Nclick = length(zloc$x)
  if(is.null(zloc$x)) { return(NULL) }
  K = whichbutt(zloc ,buttons)

  sloc = zloc

  while(Nclick>0)
    {

      if(K[Nclick] == 1)
        {
          break;
        }

      
      if(Nclick==1 & K[Nclick]==0)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
            
          u = par("usr")
          
          sloc = list(x=c(u[1],u[2]))
          
        ####  ftime = Zdate(GH$info, sel[1], 0)
        ####  mtext( ftime, side = 3, at = 0, line=0.5, adj=0)
        ####  next;
          
        }
      if(K[Nclick]==4)
        {
          WIN = oloc
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(K[Nclick]==5)
        {
          WIN = NULL
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
          u = par("usr")
          L = length(sloc$x)
          if(L>1)
            {
              abline(v=sloc$x[c(L-1,L)], col=gray(0.8), lty=2)
            }
          sloc = list(x=c(u[1],u[2]))
          
        }

      if(Nclick>1 & K[Nclick]==0)
        {

          WIN  = zloc$x[c( Nclick-1, Nclick)]
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)
          sloc = zloc
        }
      
      if(K[Nclick]==2)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]-DX, u[2]+DX))
          WIN  = zloc$x
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
       if(K[Nclick]==3)
        {
          u = par("usr")
          DX = (u[2]-u[1])*0.3
          zloc = list(x= c(u[1]+DX, u[2]-DX))
          WIN  = zloc$x
         
          YN = PLOT.SEISN(GH, WIN=WIN, dt=GH$dt, sel=sel , notes=GH$KNOTES[sel])
         #### ftime = Zdate(GH$info, sel[1], WIN[1])
         ####  mtext( ftime, side = 3, at = WIN[1], line=0.5, adj=0)

          sloc = zloc
        }
      if(K[Nclick]==6)
        {  
         ppick = zloc$x[Nclick-1]
         ppick.n = zloc$n[Nclick-1]
         abline(v=ppick, col=3)
        }
      if(K[Nclick]==7)
        {
          
### print(paste(sep=" " , "WIN=",sloc$x))
          spick = zloc$x[Nclick-1]
          spick.n = zloc$n[Nclick-1]
          abline(v=spick, col=2)
          
        }
      if(K[Nclick]==8)
        {
          
###   print(paste(sep=" " , "WIN=",sloc$x))

          if(length(xpick)>1)
            {
              xpick = c(xpick, zloc$x[1:(Nclick-1)])
              xpick.n = c(xpick.n, zloc$n[1:(Nclick-1)])
            }
          else
            {
              xpick = zloc$x[1:(Nclick-1)]
               xpick.n  = zloc$n[1:(Nclick-1)]
            }

          
          abline(v=xpick, col=4)
        }

      if(K[Nclick]==9)
        {
          
          abline(v=ppick, col=3)
          abline(v=spick, col=2)
          abline(v=xpick, col=4)
          
        }

      if(K[Nclick]==10)
        {
          
          ppick  = NA
          spick  = NA
          xpick = NA
          ppick.n  = NA
          spick.n = NA
          xpick.n = NA
          
          
        }

      buttons = rowBUTTONS(labs)
     ###  NV = LabelBAR(labs)
      zloc = plocator(COL=rgb(1,0.8, 0.8), YN=length(sel))
      Nclick = length(zloc$x)
      if(is.null(zloc$x)) { return(sloc) }
      K =  whichbutt(zloc ,buttons)
      ### K = ValBAR(NV, zloc)
     ###  print(paste(sep=" ", "K=",K))
      
    }
  return(list(win=sloc, ppix=ppick, spix=spick, xpix=xpick, panels=list(np=ppick.n,ns=spick.n, nx=xpick.n) ) )
}		
###############################################

#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")

CUT.SEISN<-function(GH, sel=1:4, WIN=NULL)
{
  if(missing(WIN)) { WIN = NULL }
  if(missing(sel)) { sel = 1:length(GH$dt)}
 
  NEWH = GH

  zloc  = ZOOM.SEISN(GH, sel, WIN=WIN)
  
  if(is.null(zloc$x))
    {
        
      zloc = WIN
      
    }


  if(is.list(zloc)==FALSE)
    {
      zloc = list(x=zloc)
    }

  for(i in 1:length(GH$dt))
    {
      ii = i
      tim = GH$dt[ii]*seq(from=0,to=length(GH$JSTR[[ii]])-1)
      tflag = tim>=zloc$x[1]&tim<=zloc$x[2]
      amp = GH$JSTR[[ii]][tflag]
      NEWH$JSTR[[ii]] = amp
      NEWH$info$t1[ii] = zloc$x[1]
    }
  invisible(NEWH)
  
}
#####################################################
###   source("/home/lees/Progs/R_stuff/seis.R")

CHOP.SEISN<-function(GH, sel=1:4, WIN=NULL)
{

  if(missing(sel)) { sel = 1:length(GH$dt)}
 
  NEWH = GH


  if(missing(WIN))
    {
      WIN = NULL
      zloc  = ZOOM.SEISN(GH, sel, WIN=WIN)
    }
  else
    {
  

      zloc = WIN
      
    }


  if(is.list(zloc)==FALSE)
    {
      zloc = list(x=zloc)
    }

  for(i in 1:length(GH$dt))
    {
      ii = i
      tim = GH$dt[ii]*seq(from=0,to=length(GH$JSTR[[ii]])-1)
      tflag = tim>=zloc$x[1]&tim<=zloc$x[2]
      amp = GH$JSTR[[ii]][tflag]
      n1 = length(amp)
      NEWH$JSTR[[ii]] = amp
      NEWH$info$t1[ii] = zloc$x[1]
      NEWH$info$t2[ii] =  NEWH$info$t1[ii]+n1*GH$dt[ii]
    }
  NEWH$ex = NEWH$dt[1]*seq(from=0,to=length(NEWH$JSTR[[1]])-1)
  invisible(NEWH)
  
}


#####################################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####################################################################

FILT.SEISN<-function(TH, sel=1:length(TH$JSTR), FILT=list(ON=FALSE, fl=0.5, fh=7.0, type="HP", proto="BU"))
  {
    ###  TH = seismic structure
    ###  sel = vector of selected time series in structure
    ###   FILT   filter defined by:
    ### FILT = list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU")
    ### FILT = list(ON=FALSE, fl=0.5, fh=7.0, type="HP", proto="BU")
    
    ### FILT = list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU")
    ### FILT = list(ON=FALSE, fl=0.5, fh=7.0, type="HP", proto="BU")
    
    ### FILT = list(ON=FALSE, fl=6.0 , fh=20.0, type="BP", proto="BU")
    ### FILT = list(ON=FALSE, fl=0.5, fh=7.0, type="HP", proto="BU")

    if(missing(sel)) { sel = 1:length(TH$JSTR) }
    if(missing(FILT)) { FILT = list(ON=FALSE, fl=0.5, fh=7.0, type="HP", proto="BU")  }
    
    
    NEWH = TH
    
    for(i in 1:length(sel))
      {
        ii = sel[i]
        
        y = TH$JSTR[[ii]]
        dt = TH$dt[ii]
        ny = is.na(y)
        ry = y[!ny]
        fy = butfilt(ry,FILT$fl, FILT$fh , dt, FILT$type , FILT$proto )
        ## ex = dt*0:(length(y)-1)
        ##  plot(ex, fy, type='l')
        NEWH$JSTR[[ii]][!ny] =  fy
        
      }
    invisible(NEWH)
  }
###  source("/home/lees/Progs/R_stuff/seis.R")
#####################################################################
#####################################################################
EVOL.SEISN<-function(GH, sel=1:length(GH$dt), WIN=NULL, ygrid=TRUE, Nfft=4096, Ns=250, Nov=240, fl=0, fh=10  )
{
####  WIN = chugs$WIN

  K = length(sel)
  if(missing(Nfft)) {  Nfft=4096 }
  if(missing(Ns))  { Ns=250}
  if(missing(Nov))  {  Nov=240}
  if(missing(fl)) {  fl=0}
  if(missing(fh)) {  fh=10}
  if(missing(ygrid)) { ygrid=TRUE}
    
  
  for(i in sel)
    {
      a1 = GH$JSTR[[i]]

      amp = a1[GH$ex>WIN[1]&GH$ex<=WIN[2]]
      ## x = GH$ex[GH$ex>WIN[1]&GH$ex<=WIN[2]]

      DEV = evolfft(amp,  GH$dt[1], Nfft=Nfft, Ns=Ns , Nov=Nov,  fl=fl, fh=fh)

      plotevol(DEV, log=1, fl=fl, fh=fh, col=rainbow(50), ygrid=ygrid)

      if(K>1)
        {
          locator(1)
        }

    }

}
#####################################################################
########  pointer, picker and locator functions
#####################################################################
###  source("/home/lees/Progs/R_stuff/seis.R")

PPIX<-function(zloc, YN=NULL, col=1, lab='')
  {
    if(missing(YN)) { YN = 1 }
    if(missing(col)) { col = 1 }
    if(missing(lab)) { lab = NA }
    
    du = 1/(YN)
    j = floor((zloc$y)/du)
    y1 = j*du
    y2 = y1+du
    segments(zloc$x, y1, zloc$x, y2, col=col)
    if(!is.na(lab))
      {
        text(zloc$x, y2, labels=lab, pos=4)
      }
    
  }

#####################################################################
#####################################################################
###  source("seis.R"); save.image()


plocator<-function(COL=1, NUM=FALSE, YN=NULL, style=0)
  {
    ###   put a small vertical bar on the plot where you pick
    if(missing(COL)) { COL = 1 }
    if(missing(NUM)) { NUM = FALSE }
    if(missing(YN)) { YN = 1 }
    if(missing(style)) { style  = 0 }

    u = par("usr")
    # du = (u[4]-u[3])/(YN)
    du = 1/(YN)
    
    n = 0
    xsave = NULL
    ysave = NULL
    zloc = locator(1)
    while(length(zloc$x)>0)
      {
        xsave = c(xsave, zloc$x)
         ysave = c(ysave, zloc$y)

        ##  j = floor(YN*(zloc$y-u[3] )/(u[4]-u[3]))
        j = floor((zloc$y)/du)
       
        y1 = j*du
        y2 = y1+du
        
#  print(paste(sep=' ', j, y1, y2))

        if(style==(-1))
          {
            points(zloc$x, zloc$y,  pch=23, col=COL)
          }     
          if(style==0)
            {
              abline(v=zloc$x[1], col=COL)
            }
          if(style==1)
            {
              segments(zloc$x, y1, zloc$x, y2, col=COL)
            }
          if(style==2)
            {
              abline(v=zloc$x[1], col=gray(0.88))
              segments(zloc$x, y1, zloc$x, y2, col=COL)
            }
          if(style==3)
            {
              abline(v=zloc$x[1], col=gray(0.88))
              segments(zloc$x, y1, zloc$x, y2, col=COL)
              segments(u[1], zloc$y, u[2], zloc$y, col=COL)
              
            }
        

       
        #  abline(v=zloc$x[1], col=COL)
        n = n+1
        if(NUM==TRUE)
          {
            text(zloc$x[1], u[4], labels=n, pos=3, xpd=TRUE)

          }
        zloc = locator(1)
      }

    jj = YN-floor(ysave*YN)

    
    return(list(x=xsave, y=ysave, n=jj))
  }

#####################################################################
maxpick<-function(NH, x, sel=1, tol=10 )
  {
    ###  given a set of picks, find the maxima (peaks) near selected pix
   amp =  NH[[sel]]
   dt = NH$dt[sel]
   
   
  }



######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
dlocator<-function()
  {
    x = plocator(COL=rgb(1, 0.8, 0.8))
    dx = diff(x$x)
    return(dx)
  }


#####################################################################
vlocator<-function(COL=1, NUM=FALSE)
  {
    if(missing(COL)) { col = gray(0.8) }
    if(missing(NUM)) { NUM = FALSE }

    u = par("usr")
    n = 0
    xsave = NULL
    ysave = NULL
    zloc = locator(1)
    while(length(zloc$x)>0)
      {
        xsave = c(xsave, zloc$x)
         ysave = c(ysave, zloc$y)
       
        abline(v=zloc$x[1], col=COL)
        n = n+1
        if(NUM==TRUE)
          {
            text(zloc$x[1], u[4], labels=n, pos=3, xpd=TRUE)

          }
        zloc = locator(1)
      }

    return(list(x=xsave, y=ysave))
  }
#####################################################################
zlocator<-function(COL=1, ID=FALSE, NUM=FALSE, YN=NULL, style=0)
  {
    ###   put a small vertical bar on the plot where you pick
    if(missing(COL)) { COL = 1 }
    if(missing(NUM)) { NUM = FALSE }
    if(missing(YN)) { YN = 1 }
    if(missing(style)) { style  = 0 }
    if(missing(ID)) { ID = FALSE }
    
    u = par("usr")
    # du = (u[4]-u[3])/(YN)
    du = 1/(YN)
    
    n = 0
    xsave = NULL
    ysave = NULL
    zloc = locator(1)
    while(length(zloc$x)>0)
      {
        xsave = c(xsave, zloc$x)
         ysave = c(ysave, zloc$y)

        ##  j = floor(YN*(zloc$y-u[3] )/(u[4]-u[3]))
        j = floor((zloc$y)/du)

        inout = (zloc$y>=u[3] & zloc$y<=u[4] &zloc$x>=u[1] &zloc$x<=u[2])
        
        y1 = j*du
        y2 = y1+du
        
#  print(paste(sep=' ', j, y1, y2))
          if(style==0)
            {
              abline(v=zloc$x[1], col=COL)
            }
          if(style==1)
            {
              segments(zloc$x, y1, zloc$x, y2, col=COL)
            }
          if(style==2)
            {
              abline(v=zloc$x[1], col=gray(0.88))
              segments(zloc$x, y1, zloc$x, y2, col=COL)
            }
        

       
        #  abline(v=zloc$x[1], col=COL)
        n = n+1
        if(NUM==TRUE)
          {
            text(zloc$x[1], u[4], labels=n, pos=3, xpd=TRUE)

          }

        ##  if(ID==TRUE & inout==TRUE)
        if(ID==TRUE)
          {
            
            alabs = format.default(zloc$x[1], digits=3)
            mtext(alabs,at=zloc$x[1], side=3, line=0, srt=45)

          }
        
        zloc = locator(1)
      }

    jj = YN-floor(ysave*YN)

    
    return(list(x=xsave, y=ysave, n=jj))
  }



######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
pixplotter<-function(X, COL=1, NUM=FALSE, YN=NULL)
  {
    if(missing(YN)) { YN = 1 }
    du = 1/(YN)
    j = X$y
    y1 = j*du
    y2 = y1+du 
    segments(X$x, y1, X$x, y2, col=COL)
  }

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")


readwpix<-function(fn)
  {
    OUT = scan(file=fn, list(junk='', col=0, yr=0, jday=0, mon=0, day=0, hr=0, min=0, sec=0, slen=0))
    return(OUT)
    
  }

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")


autopick<-function(y, cen=as.integer(length(y)/2))
{
###  do automatic picking on a trace
###  scale y so it can be used as an integer array

  
  if(missing(cen))  {  cen=as.integer(length(y)/2) }
   lx = length(y)
   r = range(y)

   XAUTOIN = (floor( 10000*((y-r[1])/diff(r)) ))
   tar = cen
   epik = 0
   polar = 0
   pikwt = 0
   ipik = 0

    #########  
  
quack = .C("CALL_JPIKI",
      as.integer(epik),
      as.integer(polar),
      as.integer(pikwt),
      as.integer(XAUTOIN),
      as.integer(lx),as.integer(tar),as.integer(ipik))


      return(list(ind=quack[[7]], err=quack[[1]], pol=quack[[2]], wt=quack[[3]]))
   }


ratcurve<-function(y, dt=0.008, fwlen =  125,  bwlen  = 125, PLOT=FALSE)
{
###  do automatic picking on a trace
###  scale y so it can be used as an integer array

     if(missing(dt))  {  dt=0.008 }

  if(missing(fwlen))  {   fwlen =  125 }
  if(missing(bwlen))  {   bwlen =  125 }
   if(missing(PLOT))  {  PLOT=FALSE }
 

  
  lx = length(y)
  r = range(y)


  rat = rep(0, length(y))

  logflg = 0

  s = abs(10000*y)

  s = 10*s
  s[s>0] = s[s>0] +0.5
  s[s<0] = s[s<0] -0.5


  quack = .C("CALL_DFBRAT",
    as.double(s),  as.double(rat),
    as.integer(lx),as.integer(fwlen), as.integer(bwlen), as.integer(logflg) )

  ix = which.max(quack[[2]])


     if(PLOT==TRUE)
       {
         opar <- par(no.readonly = TRUE)

         par(mfrow=c(2,1))
         plot.ts(y)
         abline(v=ix, col=2)
         plot.ts(quack[[2]], ylab="ratio")
         abline(v=ix, col=2)
         title(paste(sep=' ', "Ratio Curve=", fwlen, bwlen))
         invisible( par(opar))

       }

  return(list(ind=ix, rat=quack[[2]]))
}
######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")

DXDT<-function(xk, deltat)
{
###  differentiate a time series
N = length(xk)
Xm = fft(xk)
m = floor(N/2)+1

f = seq(from=0, to=0.5, length=m )*(1/(deltat))
ef = c(f, -rev(f[2:(length(f)-1)]))

i = complex(real=0, imaginary=1)
dXm = i*ef*Xm
dxdt = Re(fft(dXm, inverse=TRUE)/length(xk))
return(dxdt)
}

#############################################
#############################################
INTX<-function(xk, deltat)
{
###  integrate a time series
N = length(xk)
Xm = fft(xk)
m = floor(N/2)+1

f = seq(from=0, to=0.5, length=m )*(1/(deltat))
ef = c(f, -rev(f[2:(length(f)-1)]))

i = complex(real=0, imaginary=1)
J = length(Xm)
###  be careful not to divide by zero
IXm = Xm[2:J]/(i*ef[2:J])
###  add in something at the beginning so the length is the same
IXm = c(complex(real=1, imaginary=0), IXm)


##  inverse fourier transform (remember to divide by N)
Ix = Re(fft(IXm, inverse=TRUE)/length(xk))

return(Ix)

}




######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")



getseis24<-function(Kname, kind)
  {

    gtim1 = rep(NA, length(Kname))  ###  beginning of trace in julian days
    gtim2 = rep(NA, length(Kname))  ###  end of trace
    gday = rep(NA, length(Kname))  ###  julian day
    ghour = rep(NA, length(Kname))  ###  hour
    gsec  = rep(NA, length(Kname))  ### second 
    sigs = as.list(1:length(Kname))  ### trace amplitudes (time series) 
    gdt   = rep(NA, length(Kname))  ###  sample rate in seconds
    gnam  = rep(NA, length(Kname))  ### name/component
    gyear = rep(NA, length(Kname))  ###  year
    gamp = rep(NA, length(Kname)) ###   amplitude spread of trace
    gfile  = rep(NA, length(Kname))
    for(i in 1:length(Kname))
      {
        print(paste(sep=' ',"###########################",i))
	GG = GET.seis(Kname[i], kind = kind, PLOT = FALSE)
        gdt[i] = GG[[1]]$dt
        gnam[i] = paste(sep=".",GG[[1]]$sta, GG[[1]]$comp)
        gyear[i] = GG[[1]]$DATTIM$yr
        gday[i] = GG[[1]]$DATTIM$jd
        ghour[i] = GG[[1]]$DATTIM$hr
        gsec[i] = GG[[1]]$DATTIM$mn*(60)+GG[[1]]$DATTIM$sec
        gtim1[i]  = GG[[1]]$DATTIM$jd+GG[[1]]$DATTIM$hr/24+GG[[1]]$DATTIM$mn/(24*60)+GG[[1]]$DATTIM$sec/(24*3600)
        gtim2[i]  = gtim1[i]+GG[[1]]$N*GG[[1]]$DATTIM$dt/(24*3600)
	sigs[[i]] = GG[[1]]$amp
        gamp[i] = abs(max(GG[[1]]$amp, na.rm=TRUE)-min(GG[[1]]$amp, na.rm=TRUE))
        gfile[i] = Kname[i]
      }


    return(list(gyear=gyear, gtim1=gtim1,gtim2=gtim2, gday=gday, ghour=ghour,gsec=gsec, gamp=gamp,   gdt=gdt, gnam=gnam, gfile=gfile , sigs=sigs ))

  }


#########
seis24<-function(year, gday, ghour, dt, gtim1, gtim2, sigs, sel=1:length(gday), dy=1/6, FIX=24, SCALE=0, FILT=list(ON=FALSE, fl=0.05 , fh=20.0, type="BP", proto="BU"))
  {
    if(missing(sel)) { sel=1:length(gday) }
    if(missing(dy)) { dy  = 1/6 }
       if(missing(FIX)) { FIX=24 }
    

    if(missing(SCALE
               )) { SCALE = 0 }  ###   SCALE=0 scale by trace, !=0 scale by page

    if(missing(FILT)) { FILT = list(ON=FALSE, fl=0.05 , fh=20.0, type="BP", proto="BU") }
   
 
    if(FIX==0)
      {
        
        h = 1+diff(range(gday[sel]+ghour[sel]/24))*24
        m1 = min(gday[sel]+ghour[sel]/24)
        ry = range(gday[sel]+ghour[sel]/24)
      }
    else
      {
        h = FIX
        m1 = median(gday[sel])
        ry =  range(c(m1, m1+23.999/24) )
      }

    xa = seq(from=0, length=3600/dt, by=dt)
    mx1 = min(xa)
    mx2 = max(xa)
    
    bcol = rgb(1, .8, .8)
    gcol = rgb(.8, 1, .8)
   
   ##  rcol = c(rgb(0.2, .2, 1), rgb(1, .2, .2))
    rcol = c(rgb(0.2, .2, 1), rgb(.2, .2, .2))
    
    par(mar=c(5, 4, 4, 4)+0.1,  xaxs='i', yaxs='i', lwd=0.5, bty="u")
    plot( c(0, 3600), -ry  , type='n', xpd=TRUE, axes=FALSE, xlab="Time,s", ylab="")
##  90:100
    box(col=grey(0.7) )
    tix = rep(NA, length=h)
    
    ####  cycle through the hours
    
    for(i in 1:h )
      {
        N2 = (i%%2)+1

        icol = rcol[ N2 ]
        
        a1 = m1 + (i-1)/24
        a2 = m1 + (i)/24
        ##print(paste(a1, a2))
        w1 = which(gtim1>=a1&gtim1<=a2)
        w2 = which(gtim2>=a1&gtim2<=a2)
        
          ## ## print(w1)
        ##     print(w2)
        
        w = sort(unique(c(w1,w2)))

        ##  lines(c(mx1, mx2) , c(a1, a1)   , col=bcol )
       ##  print(paste(sep=' ', i, N2, icol, length(w)))

        ###   here glue the seismograms together to make an hour record
        
        if(length(w)>1)
          {
            
            zed = rep(NA, length=3600/dt)
            ex =  a1+xa/(24*3600)
            
            for(j in 1:length(w))
              {
                
                k = w[j]
                t1 = gtim1[k]
                t2 = gtim2[k]
                
                f1 = ex>=t1&ex<=t2
                ##  print(paste(sep=' ', j, length(f1) )) 
                U = any(f1)

                if(U)
                  {

                    s = sigs[[k]]
                    lex = gtim1[k]+seq(from=0, by=dt, length=(length(s)))/(24*3600)
                    tem = lex>=a1&lex<=a2
                   ## print(paste(sep=' ', j, length(zed[f1]) , length(s[tem])))
                    s2 = s[tem]
                    zed[f1] = s2[1:length(zed[f1])]
                    ## print(U)
                  }
              }

            y1 = -a1
            amean = mean(zed, na.rm=TRUE )
            
            ##   zed=zed-amean

            
            zna = is.na(zed)
            if(any(zna))
              {
                zed[is.na(zed)] = 0.0
              }
            if(FILT$ON==TRUE)
              {
                fy = butfilt(zed,FILT$fl, FILT$fh , dt, FILT$type , FILT$proto )
                fy = fy-mean(fy)
              }
            else
              {
                fy = zed
                fy = fy-mean(fy, na.rm=TRUE)
              }

            if(SCALE==0)
              {
                zee  = RESCALE(fy,  -1,   1, min(fy, na.rm=TRUE), max(fy, na.rm=TRUE))
              }
            else
              {
                rat = abs(max(fy, na.rm=TRUE)-min(fy, na.rm=TRUE))/SCALE
                ####  print(paste(sep=' ', i, rat))

                ####  safeguard against a signal being too big
                ###  make ratio small and paint it a different color
               #### if(rat>10)
               ####   {
               ####     rat = 1
               ####     icol = rgb(0.7, 1, 0.7)
               ####   }


                
                zee  = RESCALE(fy,  -rat,   rat, min(fy, na.rm=TRUE), max(fy, na.rm=TRUE))       
              }
            tmean = mean(zee, na.rm=TRUE)
            
            zee = dy*(zee-tmean)
                  
            zee[zna] = NA
            
            tix[i] = y1
            lines(c(mx1, 50) , c(y1, y1)   , col=bcol )
            
            lines(xa,y1+zee, col=icol, xpd=TRUE)
          }
        else
          {
            y1 = -a1
            lines(c(mx1, 50) , c(y1, y1)   , col=bcol )

          }
      }

    ##  print(paste("tix=", tix))
    
    axis(1)
   ##  print(ry)
    
   ##  days = -pretty(ry)
    days = floor(abs(tix[!is.na(tix)]))
    
  ##   print(days)
    modays = getmoday(days, year)

    tlocs = abs(tix[!is.na(tix)])
   ##  print(tlocs)

    labs1 = paste(sep="/", modays$mon, modays$dom)
    print(labs1)
    if(length(labs1)>=2)
      {
        ilab =  seq(from=2, to=length(labs1)-1, by=2)
        labs1[ilab] = days[ilab]
      
        axis(2, at=tix[!is.na(tix)], labels=labs1)
      }
    labs2 = format.default(1+round(24*(tlocs  - floor(tlocs))), digits=2)
    ## axis(4, at=tix[!is.na(tix)], labels=abs(days) )

    axis(4, at=tix[!is.na(tix)], labels=labs2, las=1)
    ## box()

  }

#############################
###
setseis24<-function(year, gday, ghour, dt, gtim1, gtim2, sigs, sel=1:length(gday))
  {
    if(missing(sel)) { sel=1:length(gday) }


    m1 = min(gday[sel]+ghour[sel]/24)

    h = 1+diff(range(gday[sel]+ghour[sel]/24))*24



    xa = seq(from=0, length=3600/dt, by=dt)
    mx1 = min(xa)
    mx2 = max(xa)
    bcol = rgb(1, .8, .8)
    dy  = 1/12
    FILT = list(ON=FALSE, fl=0.1 , fh=10.0, type="BP", proto="BU")
    par( xaxs='i', yaxs='i')
    
    plot( c(0, 3600), -range(gday[sel]+ghour[sel]/24)  , type='n', axes=FALSE, xlab="Time,s", ylab="")

    for(i in 1:h)
      {
        a1 = -(m1 + (i-1)/24)
        a2 = m1 + (i)/24
        lines(c(mx1, mx2) , c(a1, a1)   , col=bcol )
      }

    axis(1)

    days = -pretty(range(gday[sel]+ghour[sel]/24))
    modays = getmoday(-days, year)
 
    axis(2, at=days, labels=paste(sep="/", modays$mon, modays$dom))
    axis(4)
    box()

  }

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")

Iseis24<-function(Yname, JY)
  {
    ss = 0
    iset = 0


    dev.set(2)
    u = par("usr")
    
    L = locator(n=1, type='p', col=2)
    
    while(length(L$x)>0 & L$x>u[1] & L$x<u[2] & L$y>u[3] & L$y<u[4])
      {
    psec = abs(L$x)
    pLy = abs(L$y)
    pday = floor(pLy)
    phour = round(24*(pLy-pday))
    
    ptime = pday+phour/24+psec/(24*3600)

   
    W = which(ptime>=JY$gtim1&ptime<JY$gtim2)


    w1 = JY$gtim1[W]
    w2 = JY$gtim2[W]

    wd1 = floor(w1)
    wh1 = floor(24*(w1-wd1))

    wrest = 24*(w1-wd1)-wh1
    secs1 = wrest*3600
    y1 = wd1+wh1/24

    wd2 = floor(w2)
    wh2 = floor(24*(w2-wd2))

    wrest2 = 24*(w2-wd2)-wh2
    secs2 = wrest2*3600
    y2 = wd2+wh2/24

    ## abline(v=c(secs1,secs2) , col=c(5,3) )
    points(c(secs1, secs2), c(-y1, -y2), col=5)

    KG4 = GET.seis(c(Yname[W]) , kind = 1, PLOT = FALSE)

    KH=prepGG3(KG4)
    dev.set(3)
    one()
    Y = PICK.GEN(KH, sel=1)

    dev.set(2)
    L = locator(n=1, type='p', col=2)
    
  }
    
  }
######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")

### 
#########
fseis24<-function(year, gday, ghour, dt, gtim1, gtim2, sigs, sel=1:length(gday), dy=1/6, SCALE=0, FILT=list(ON=FALSE, fl=0.05 , fh=20.0, type="BP", proto="BU"))
  {
    if(missing(sel)) { sel=1:length(gday) }
    if(missing(dy)) { dy  = 1/6 }
    if(missing(SCALE)) { SCALE = 0 }  ###   SCALE=0 scale by trace, !=0 scale by page

    if(missing(FILT)) { FILT = list(ON=FALSE, fl=0.05 , fh=20.0, type="BP", proto="BU") }
   
    m1 = min(gday[sel]+ghour[sel]/24)

    h = 1+diff(range(gday[sel]+ghour[sel]/24))*24



    xa = seq(from=0, length=3600/dt, by=dt)
    mx1 = min(xa)
    mx2 = max(xa)
    
    bcol = rgb(1, .8, .8)
    gcol = rgb(.8, 1, .8)
   
   ##  rcol = c(rgb(0.2, .2, 1), rgb(1, .2, .2))
    rcol = c(rgb(0.2, .2, 1), rgb(.2, .2, .2))
    
    par( xaxs='i', yaxs='i', lwd=0.5)
    plot( c(0, 3600),-range(gday[sel]+ghour[sel]/24)  , type='n', xpd=TRUE, axes=FALSE, xlab="Time,s", ylab="")
##  90:100
    for(i in 1:h )
      {
        icol = rcol[ (i%%2)+1 ]
        a1 = m1 + (i-1)/24
        a2 = m1 + (i)/24
        ##print(paste(a1, a2))
        w1 = which(gtim1>=a1&gtim1<=a2)
        w2 = which(gtim2>=a1&gtim2<=a2)
        
          ## ## print(w1)
        ##     print(w2)
        
        w = sort(unique(c(w1,w2)))

        ##  lines(c(mx1, mx2) , c(a1, a1)   , col=bcol )
        if(length(w)>1)
          {
            
            zed = rep(NA, length=3600/dt)
            ex =  a1+xa/(24*3600)
            
            for(j in 1:length(w))
              {
                
                k = w[j]
                t1 = gtim1[k]
                t2 = gtim2[k]
                
                f1 = ex>=t1&ex<=t2
                ##  print(paste(sep=' ', j, length(f1) )) 
                U = any(f1)

                if(U)
                  {

                    s = sigs[[k]]
                    lex = gtim1[k]+seq(from=0, by=dt, length=(length(s)))/(24*3600)
                    tem = lex>=a1&lex<=a2
                   ## print(paste(sep=' ', j, length(zed[f1]) , length(s[tem])))
                    s2 = s[tem]
                    zed[f1] = s2[1:length(zed[f1])]
                    ## print(U)
                  }
              }

            y1 = -a1
            amean = mean(zed, na.rm=TRUE )
            
            zed=zed-amean

            
            zna = is.na(zed)

            
            if(any(zna))
              {
                zed[is.na(zed)] = 0.0
              }

            
            if(FILT$ON==TRUE)
              {

                fy = butfilt(zed,FILT$fl, FILT$fh , dt, FILT$type , FILT$proto )
                fy = fy-mean(fy)
                
             
                gy = zed
                gy = gy-mean(gy, na.rm=TRUE)
              }




            zee  = RESCALE(gy,  -1,   1, min(gy, na.rm=TRUE), max(gy, na.rm=TRUE))
            fzee  = RESCALE(fy,  -1,   1, min(fy, na.rm=TRUE), max(fy, na.rm=TRUE))
            
              
            tmean = mean(zee, na.rm=TRUE)
            ftmean = mean(fzee, na.rm=TRUE)
            
            zee = dy*(zee-tmean)
            fzee = dy*(fzee-ftmean)
            
            #######
            ### dev.set(3)
           ### print(paste(sep=' ', i, tmean))
           ### plot(xa, zee, type='l')
           ### locator(1)
           ### dev.set(2)
           #######
            
            zee[zna] = NA
            fzee[zna] = NA
            
          
            
            lines(c(mx1, 50) , c(y1, y1)   , col=bcol )
            
            
            lines(xa,y1+zee, col=rgb(.7, .8, .7) , xpd=TRUE)
            lines(xa,y1+fzee, col=icol, xpd=TRUE)


            
          }
        else
          {
            y1 = -a1
            lines(c(mx1, 50) , c(y1, y1)   , col=bcol )

          }
      }

    axis(1)
    days = -pretty(range(gday[sel]+ghour[sel]/24))
    modays = getmoday(-days, year)
 
    axis(2, at=days, labels=paste(sep="/", modays$mon, modays$dom))
    axis(4, at=days, labels=abs(days) )
    ## box()

  }

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R")
#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")

Hseis24<-function(JY, sel=1)
  {
    if(missing(sel)) { sel = 1:length(JY$gtim1) }
    ss = 0
    iset = 0

    dev.set(2)
    u = par("usr")
    
    dt = JY$gdt[sel][1]

    xa = seq(from=0, length=3600/dt, by=dt)
    L = locator(n=1, type='p', col=2)
    
    while(length(L$x)>0 & L$x>u[1] & L$x<u[2] & L$y>u[3] & L$y<u[4])
      {
        psec = abs(L$x)
        pLy = abs(L$y)
        pday = floor(pLy)
        phour = round(24*(pLy-pday))
        
        ptime = pday+phour/24+psec/(24*3600)

        
        a1 = pday+phour/24
        a2 = a1+1/24
        ##print(paste(a1, a2))
        w1 = which(JY$gtim1>=a1&JY$gtim1<=a2)
        w2 = which(JY$gtim2>=a1&JY$gtim2<=a2)
        
        ## ## print(w1)
        ##     print(w2)
        
        w = sort(unique(c(w1,w2)))

        ##  lines(c(mx1, mx2) , c(a1, a1)   , col=bcol )
        if(length(w)>1)
          {
            
            zed = rep(NA, length=3600/dt)
            ex =  a1+xa/(24*3600)
            
            for(j in 1:length(w))
              {
                
                k = w[j]
                t1 = JY$gtim1[k]
                t2 = JY$gtim2[k]
                
                f1 = ex>=t1&ex<=t2
                ##  print(paste(sep=' ', j, length(f1) )) 
                U = any(f1)

                if(U)
                  {

                    s = JY$sigs[[k]]
                    lex = JY$gtim1[k]+seq(from=0, by=dt, length=(length(s)))/(24*3600)
                    tem = lex>=a1&lex<=a2
                    ## print(paste(sep=' ', j, length(zed[f1]) , length(s[tem])))
                    s2 = s[tem]
                    zed[f1] = s2[1:length(zed[f1])]
                    ## print(U)
                  }
              }

            
            amean = mean(zed, na.rm=TRUE )
            
            zee=zed-amean

            zna = is.na(zed)
            
            zee[zna] = NA
            
            modays = getmoday(JY$gday[w[1]], JY$gyear[w[1]])
            
            tstart = list(yr=JY$gyear[w[1]], jd=JY$gday[w[1]] , mo=modays$mon, dom=modays$dom, hr=phour, mn=0, sec=0, msec=0, dt=dt, t1=0,
              t2=3600, off=0)

            anam = JY$gnam[w[1]]
            knam = unlist(strsplit(anam, split=".", fixed=TRUE))

            GG = list(1)
            
            GG[[1]] = list(fn="TEMP", sta=knam[1], comp=knam[2], dt=dt, DATTIM=tstart, N=length(zee), amp=zee)

            
            KH =   prepGG3(GG)
            dev.set(3)
            PADDLAB=c( "PPIX", "Pinfo", "XPIX", "CPIX", "NOPIX")

            Y = PICK.GEN(KH, sel=1, PADDLAB=PADDLAB)

            dev.set(2)
            L = locator(n=1, type='p', col=2)
            
          }
        
      }
    invisible(Y)
  }

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R"); save.image()

#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")

Gseis24<-function(JY, sel=1, pday, phour)
  {
    if(missing(sel)) { sel = 1:length(JY$gtim1) }
    ss = 0
    iset = 0

   
    dt = JY$gdt[sel][1]

    xa = seq(from=0, length=3600/dt, by=dt)
   
    
   ###   while(length(L$x)>0 & L$x>u[1] & L$x<u[2] & L$y>u[3] & L$y<u[4])
      {
       
        a1 = pday+phour/24
        a2 = a1+1/24
        ##print(paste(a1, a2))
        w1 = which(JY$gtim1>=a1&JY$gtim1<=a2)
        w2 = which(JY$gtim2>=a1&JY$gtim2<=a2)
        
        ## ## print(w1)
        ##     print(w2)
        
        w = sort(unique(c(w1,w2)))

        ##  lines(c(mx1, mx2) , c(a1, a1)   , col=bcol )
        if(length(w)>1)
          {
            
            zed = rep(NA, length=3600/dt)
            ex =  a1+xa/(24*3600)

            minex = min(ex)
            
            for(j in 1:length(w))
              {
                
                k = w[j]
                t1 = JY$gtim1[k]
                t2 = JY$gtim2[k]
                
                f1 = ex>=t1&ex<=t2
                ##  print(paste(sep=' ', j, length(f1) )) 
                U = any(f1)

                if(U)
                  {

                    s = JY$sigs[[k]]
                    lex = JY$gtim1[k]+seq(from=0, by=dt, length=(length(s)))/(24*3600)
                    tem = lex>=a1&lex<=a2
                    ## print(paste(sep=' ', j, length(zed[f1]) , length(s[tem])))
                    s2 = s[tem]
                    zed[f1] = s2[1:length(zed[f1])]
                    print(min(ex[f1]))
                    minex = min(c(minex, ex[f1]))
                    ## print(U)
                  }
              }

            
            amean = mean(zed, na.rm=TRUE )
            
            zee=zed-amean

            zna = is.na(zed)
            
            zee[zna] = NA

            startdate = recdate(minex, 0, 0, 0)
            
            modays = getmoday(startdate$jday, JY$gyear[w[1]])
            
            tstart = list(yr=JY$gyear[w[1]], jd=startdate$jday , mo=modays$mon, dom=modays$dom, hr=startdate$hour, mn=startdate$min, sec=startdate$sec, msec=0, dt=dt, t1=0,
              t2=3600, off=0)

            anam = JY$gnam[w[1]]
            knam = unlist(strsplit(anam, split=".", fixed=TRUE))

            GG = list(1)
            
            GG[[1]] = list(fn="TEMP", sta=knam[1], comp=knam[2], dt=dt, DATTIM=tstart, N=length(zee), amp=zee)

            
            KH =   prepGG3(GG)
            
            PADDLAB=c( "PPIX", "Pinfo", "XPIX", "CPIX", "NOPIX")

            ## Y = PICK.GEN(KH, sel=1, PADDLAB=PADDLAB)

            
            
          }
        
      }
    invisible(KH)
  }

######################################################
###  source("seis.R"); save.image()

NOW<-function()
  {
d   = as.character(Sys.time())


dat = unlist(strsplit( d, split=" "))

dnow = as.numeric(unlist(strsplit(dat[1], split="-")))
tnow = as.numeric(unlist(strsplit(dat[2], split=":")))


return(c(dnow, tnow))


  }


#### 
PICK.CREATE<-function(A, deltat)
{
####  given a couple of time series, create a structure

  K = length(A)

  fn =rep("", K)
  
name =rep("", K)
TD = NOW()
yr = rep(TD[1], K)
  
jday = getjul(TD[1], TD[2], TD[3])
  jd =rep(jday,K)
  mo=rep(TD[2], K);
  dom= rep(TD[3],K);
  hr= rep(TD[4],K);
  mn=rep(TD[5],K);
  sec=rep(TD[6],K);
  msec=0;
  dt=rep(deltat, K);
  
  t1=rep(0, K);
 
  off=rep(0, K);
  n=unlist(lapply(A, length))
  n1=n
  n2=n
  n3=n
  t2=(n-1)*deltat
  
  ginfo = list(fn=fn, name=name, yr=yr, jd=jd, mo=mo, dom=dom,    hr=hr,     mn=mn,
    sec=sec,    msec=msec, dt=dt,     t1=t1, t2=t2,
    off=off,   n1=n1,     n2=n2,     n3=n3,     n=n) 

  JSTR = A
  wd = system("pwd",intern=TRUE )
 
  STNS=rep("STA", K); dir=rep(wd, K); ifile=rep("STA", K); 
  COMPS=rep("V", K); dt=dt; KNOTES=rep("STA", K); 
  info=ginfo;

  dat = matrix(unlist(A), ncol=length(A))

  nn=length(A); ex=seq(0, length=n[1], by=deltat);
  pcol=rep(4, K); ok=rep(4, K); wintim=c(t1,t2);
  ftime=rep("", K)
  
  GFIL = list(JSTR=JSTR, STNS=STNS, dir=dir, ifile=ifile, 
    COMPS=COMPS, dt=dt, KNOTES=KNOTES, 
    info=ginfo,
    dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim,  ftime=ftime )
  
  invisible(GFIL)
  
}

######################################################
###  source("seis.R"); save.image()

#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")

PICK.MERGE<-function(IH, VH)
{
####  merge two structures together

ginfo = list(fn=c(IH$info$fn,VH$info$fn), name=c(IH$info$name,VH$info$name), yr=c(IH$info$yr,VH$info$yr), jd=c(IH$info$jd,VH$info$jd), mo=c(IH$info$mo,VH$info$mo), dom=c(IH$info$dom,VH$info$dom),    hr=c(IH$info$hr,VH$info$hr),     mn=c(IH$info$mn,VH$info$mn),     sec=c(IH$info$sec,VH$info$sec),    msec=c(IH$info$msec,VH$info$msec), dt=c(IH$info$dt,VH$info$dt),     t1=c(IH$info$t1,VH$info$t1), t2=c(IH$info$t2,VH$info$t2), off=c(IH$info$off,VH$info$off),   n1=c(IH$info$n1,VH$info$n1),     n2=c(IH$info$n2,VH$info$n2),     n3=c(IH$info$n3,VH$info$n3),     n=c(IH$info$n,VH$info$n)) 


 GFIL = list(JSTR=c(IH$JSTR, VH$JSTR), STNS=c(IH$STNS, VH$STNS), dir=c(IH$dir, VH$dir), ifile=c(IH$ifile, VH$ifile), 
    COMPS=c(IH$COMPS, VH$COMPS), dt=c(IH$dt, VH$dt), KNOTES=c(IH$KNOTES, VH$KNOTES), 
     info=ginfo,
     dat=c(IH$dat, VH$dat), nn=c(IH$nn, VH$nn), ex=IH$ex, pcol=c(IH$pcol, VH$pcol), ok=IH$ok, wintim=IH$wintim,  ftime=IH$ftime )

  invisible(GFIL)

}

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R"); save.image()

#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/seis.R")
PICK.FILT<-function(IH, VH)
{


ginfo = list(fn=c(IH$info$fn,VH$info$fn), name=c(IH$info$name,VH$info$name), yr=c(IH$info$yr,VH$info$yr), jd=c(IH$info$jd,VH$info$jd), mo=c(IH$info$mo,VH$info$mo), dom=c(IH$info$dom,VH$info$dom),    hr=c(IH$info$hr,VH$info$hr),     mn=c(IH$info$mn,VH$info$mn),     sec=c(IH$info$sec,VH$info$sec),    msec=c(IH$info$msec,VH$info$msec), dt=c(IH$info$dt,VH$info$dt),     t1=c(IH$info$t1,VH$info$t1), t2=c(IH$info$t2,VH$info$t2), off=c(IH$info$off,VH$info$off),   n1=c(IH$info$n1,VH$info$n1),     n2=c(IH$info$n2,VH$info$n2),     n3=c(IH$info$n3,VH$info$n3),     n=c(IH$info$n,VH$info$n)) 


 GFIL = list(JSTR=c(IH$JSTR, VH$JSTR), STNS=c(IH$STNS, VH$STNS), dir=c(IH$dir, VH$dir), ifile=c(IH$ifile, VH$ifile), 
    COMPS=c(IH$COMPS, VH$COMPS), dt=c(IH$dt, VH$dt), KNOTES=c(IH$KNOTES, VH$KNOTES), 
     info=ginfo,
     dat=c(IH$dat, VH$dat), nn=c(IH$nn, VH$nn), ex=IH$ex, pcol=c(IH$pcol, VH$pcol), ok=IH$ok, wintim=IH$wintim,  ftime=IH$ftime )

  invisible(GFIL)

}

######################################################
###  source("/home/lees/Progs/R_stuff/seis.R"); save.image()

#####  dyn.load("/home/lees/Progs/Rc/jpiki.so")
###  source("/home/lees/Progs/R_stuff/seis.R")
FILTKH3<-function(KH,fl=c(0.02,0.02,0.02,0.02,0.02,0.02 ), fh=c(1/15,1/10,1/5,1/3, 1/2, 1), KSEL=1 )
{
  ###  prepare a list of seismic information 
  ###    
if(missing(fl)) { fl=c(0.02,0.02,0.02,0.02,0.02,0.02 ) }
if(missing(fh)) { fh=c(1/15,1/10,1/5,1/3, 1/2, 1) }

 if(missing(KSEL)) { KSEL = 1 }

  
  FH = FILT.spread( KH$ex, KH$JSTR[[KSEL]], KH$dt[KSEL], fl=fl, fh=fh, sfact=2, WIN=NULL, PLOT=FALSE )


  N = length(FH$Notes)

  
  gstas = rep(NA, N)
  gcomps = rep(NA, N)
  
  gtim1 = rep(NA, N)
  gtim2 = rep(NA, N)
  gn = rep(NA, N)
  gdt  = rep(NA, N)
    ## gfn  = rep(NA, N)
 

  ####  prepare some of the stats on the times of the waveforms
  for(i in 1:N)
    {
     
      dt = KH$dt[KSEL]
      n = length( KH$JSTR[[KSEL]] )
    
      gtim1[i]  = KH$info$jd[KSEL]+KH$info$hr[KSEL]/24+KH$info$mn[KSEL]/(24*60)+KH$info$sec[KSEL]/(24*3600)
      gtim2[i]  = gtim1[i]+KH$info$n[KSEL]*dt/(24*3600)
      gn[i] = n
      gdt[i] = dt
      ## gfn[i] = GG[[i]]$fn
     
    }

    wmin = which.min(gtim1)
    wmax = which.max(gtim2)

####  set up the padding
  r1 =  round((gtim1-gtim1[wmin])*24*3600/gdt)
  r2 = round((gtim2[wmax]-gtim2)*24*3600/gdt)
  BigR = r1+gn+r2
  ma = 1:length(gdt)
   
  K = BigR[ma[1]]
  ascd = as.list(1:N)
   
  dt = gdt
  notes = rep(NA, length(ma))
  stns = rep(NA, length(ma))
  comps = rep(NA, length(ma))
  
  info = list(fn=rep(NA, length(ma)), name=rep(NA, length(ma)), yr=rep(NA, length(ma)), jd=rep(NA, length(ma)), mo=rep(NA, length(ma)), dom=rep(NA, length(ma)), hr=rep(NA, length(ma)), mn=rep(NA, length(ma)),sec=rep(NA, length(ma)), msec=rep(0, length(ma)),dt=rep(0, length(ma)),t1=rep(0, length(ma)) ,t2=rep(0, length(ma)), off=rep(0, length(ma)), n1=rep(0, length(ma)), n2=rep(0, length(ma)), n3=rep(0, length(ma)), n=rep(0, length(ma)) )
  ###  fill up data structure and information
  for(j in 1:length(ma))
	{
	  ima = ma[j]          
	  ascd[[j]] = FH$FMAT[,j]
	  notes[j] = FH$Notes[j]
	  stns[j] = KH$STNS[KSEL]
	  comps[j] = KH$COMPS[KSEL]
	  info$fn[j] = KH$info$fn[KSEL]
	  info$name[j] =  KH$info$name[KSEL]
	  info$yr[j] =  KH$info$yr[KSEL]
	  info$jd[j] = KH$info$jd[KSEL]
	  info$mo[j] = KH$info$mo[KSEL]
	  info$dom[j] =KH$info$dom[KSEL]
	  info$hr[j] = KH$info$hr[KSEL]
	  info$mn[j] = KH$info$mn[KSEL]
	  info$sec[j] =  KH$info$sec[KSEL]
	  info$msec[j] =  KH$info$msec[KSEL]
	  info$dt[j] = KH$info$dt[KSEL]

 	  info$t1[j] = KH$info$t1[KSEL]
 	  info$t2[j] = KH$info$t2[KSEL]
           
           
	  info$off[j] =  KH$info$off[KSEL]
	  info$n1[j] =  KH$info$n1[KSEL]
	  info$n2[j] =  KH$info$n2[KSEL]
 	  info$n3[j] =  KH$info$n3[KSEL]
 	  info$n[j] = KH$info$n[KSEL]
          
	}
 
    f1 = unlist(strsplit(info$fn[1], "/"))
    fn1 = f1[length(f1)]
    dir = paste(collapse="\/", c(f1[1:(length(f1)-1)]) )

  USTA= unique(stns)
  nn =length(ma)
  pcol=rep(1, nn)
  for(m in 1:length(USTA))
    {
      pcol[!is.na(match( stns, USTA[m]))] = 2+m
    }
  
  ok = order(notes)
  wintim=  info$jd[1] + info$hr[1]/24+ info$mn[1]/(24*60)+(info$sec[1]+info$msec[1]/1000+info$t1[1]-info$off[1])/(24*3600)
  ex = seq(0,length(ascd[[1]])-1)*info$dt[1]

  dat=NULL
    
  ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
  
  GFIL = list(JSTR=ascd, STNS=stns, dir=dir, ifile=fn1, COMPS=comps, dt=dt, KNOTES=notes, info=info,dat=dat, nn=nn, ex=ex, pcol=pcol, ok=ok, wintim=wintim,  ftime=ftime )
  
  invisible(GFIL)
  
}
#########################################################
#########################################################
#########################################################

####  calculate the RSAM values for a sequence of hourly recordings
getrsam<-function(JIN,rsamdt = 2*60, hrs = 1, FILT=list(ON=TRUE, fl=0.05 , fh=20.0, type="BP", proto="BU") )
{
###  if(missing()) { }
  if(missing(rsamdt)) { rsamdt = 2*60 }
  if(missing(FILT)) { FILT=list(ON=FALSE, fl=0.05 , fh=20.0, type="BP", proto="BU") }
  if(missing(hrs)) { hrs = 1:length(JIN$sigs) }
### hrs = sel
###    hrs = 1:140
  nrms = length(hrs)*3600/rsamdt
  
  rsamx = rep(NA, nrms)
  rsamy = rep(NA, nrms)
  
  k = 1
  for(i in hrs)
    {
      y = JIN$sigs[[i]]
      deltat = JIN$gdt[i]
      x = seq(from=0, length=length(y), by=deltat)
      jinc = rsamdt/deltat
      ## plot(x,y, type='l')
      if(FILT$ON==FALSE)
        {
          fy=y
        }
      else
        {
          fy = butfilt(y, FILT$fl, FILT$fh , deltat, FILT$type , FILT$proto )
      
          fy = fy-mean(fy)
        }
      print(paste("working on hour:", i))
      for(j in seq(from=1, to=length(y), by=jinc))
        {
          j1 = j
          j2 = j+jinc-1
          ram = sqrt(mean(fy[j1:j2]^2, na.rm = TRUE))
          x1 = x[floor((j1+j2)/2)]

          rsamx[k] = JIN$gtim1[i]+x1/(24*60*60)
          rsamy[k] = ram
          k = k +1 

        }

    }
return(list(x=rsamx, y=rsamy))
}
######################################################
###  source("/home/lees/Progs/R_stuff/seis.R"); save.image()


plotrsam<-function(A, LOG=FALSE, XHRS=24, YLIM=NULL, co=rainbow(100))
  {
    if(missing(LOG))  log=FALSE
    if(missing(XHRS))    XHRS=0
    if(missing(YLIM))    YLIM=NULL
    if(missing(co)) co=rainbow(100)
  ###   if(missing(pal)) { pal = "rainbow" }


    Y = A$y
    X = A$x

    logflag=''
   if(LOG==TRUE)
    {
      logflag='y'
    }
   
    bb = boxplot(Y, plot = FALSE)


   ####  plot(X, Y, type='n', ylim=c(bb$stats[1,1], bb$stats[5,1]*5))
    ####    plot(X, Y, type='n', log='y', ylim=c(bb$stats[1,1], bb$stats[5,1]*5))

    
     dx = range(X, na.rm=TRUE)
    DX = diff(dx)
    hrs = DX*24
    
    if(XHRS==24 & hrs<24)
      {
        xlim = c(dx[1],dx[1]+1) 
      }
    else
      {
        xlim=NULL

      }
    


    
    plot(X, Y, xlim=xlim, ylim=YLIM, type='n', log=logflag, xlab="Julian Day", ylab="RSAM")

###co = rev(terrain.colors(100))

    ### FUN = match.fun(pal)
    ### co = FUN(100)

    
   ###  GC = Gcols(plow=10, phi=0,  N=100, pal=pal)
    ###  co = GC

    abline(h=bb$stats[,1], col=4)
    lines(X, Y)

    yrr = range(Y, na.rm = TRUE)


    clen = length(co)


    if(logflag=='y')
      {

        if(is.null(YLIM))
          {
            gy = log(Y)
            gyrr = range(gy, na.rm = TRUE)
            
            yrcol = floor( (clen-1)*(gy-gyrr[1])/diff(gyrr))+1
          }
        else
          {
            gy = log(Y)
            gyrr = log(YLIM)
            yrcol = floor( (clen-1)*(gy-gyrr[1])/diff(gyrr))+1

          }


        
        
      }
    else
      {
        yrcol = floor( (clen-1)*(Y-yrr[1])/diff(yrr))+1
      }
    
    points(X, Y, type='h', col=co[yrcol])


    abline(h=bb$stats[,1], col=grey(0.8) )
    lines(X, Y)

    kday = unique(floor(X[!is.na(X)]))

    tax = rep(seq(from=0, length=24, by=1), length(kday))

    tax1 = (seq(from=kday[1], by=1/24, length=length(kday)*24))


    
###  hax =  floor(fmod((tax1- kday[1])*24 , 24 ))

    axis(3, at=tax1, labels=tax)

  }
######################################################
###  source("/home/lees/Progs/R_stuff/seis.R"); save.image()
