cat("sourcing /home/lees/Progs/R_stuff/stromb.R\n")

### source("/home/lees/Progs/R_stuff/stromb.R")

###  NEED these libraries to run this code
### library(modreg)
###
###  depends on:
### dyn.load("/home/lees/Progs/Rc/LLNfilt.so")
###
###  system("ls $DUMPING_GROUND/*INFO* ")


###
###   for more general plotting schemes from dump data see /home/lees/Progs/R_stuff/DUMPSEIS.R
###


##########################################
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
###

dump.NLOOK<-function(mSW, COMP=c(1:4), FV=NULL, RMINST=RMINST, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, sfact=1, Pause=0 )
  {
### dump.LOOK(mSW)
    
    
    if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
    
    if(missing(INTEG))
      {        
        INTEG=FALSE
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    if(missing(Pause))
      {
        Pause = 0
      }
    
                                        # print(COMP)
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        if(missing(COMP)){COMP = seq(from=1, to=length(GG$info$name))}
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)        
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        titname = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec))
        title(titname)
        if(Pause>0)
          {
            Sys.sleep(Pause)
          }
        else
          {
            L = locator()
            if(length(L$x)>=2)
              {
                dump.Nplot(GG, COMP=COMP,  WIN=c(L$x[1], L$x[2]), RMINST=RMINST, INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
                title(titname)
                L = locator()
              }
          }
      }
  }
##########################################
##########################################
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
###

dump.LOOK<-function(mSW, STA="", FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, rot=FALSE, sfact=1, Pause=0 )
  {
### dump.LOOK(mSW)
    if(missing(STA))
      {     
        STA="for"  
      }
    if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
    
    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
          if(missing(Pause))
      {
        Pause = 0
      }
  
        if(missing(rot))
      {
        
        rot=FALSE
      }
    
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = seq(from=1, to=length(GG$STN))
        COMP=ncomp[GG$STN==STA]
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=rot, CINTEG=CINTEG, sfact=sfact)
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        titname = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(titname)
                if(Pause>0)
          {
            Sys.sleep(Pause)
          }
        else
          {
        L = locator()
        if(length(L$x)>=2)
          {
            print(paste(sep=" ", "WINDOW:", L$x[1], L$x[2],L$x[2]- L$x[1]))
            
            dump.Nplot(GG, COMP=COMP,  WIN=c(L$x[1], L$x[2]), RMINST=RMINST, INTEG=INTEG, FILT=FV , rot=rot, CINTEG=CINTEG, sfact=sfact)
            title(titname)
            L = locator()
          }
      }
      }

  }
###############################


##########################################

dump.CLOOK<-function(mSW, STA="", FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, sfact=1 )
  {
### dump.LOOK(mSW)
    if(missing(STA))
      {     
        STA="for"  
      }
     if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    
    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    RET=as.list(mSW)
    names(RET)=mSW

    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = seq(from=1, to=length(GG$STN))
        COMP=ncomp[GG$chaname==STA]
        
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        RST = dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        ename = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(ename)
        RET[[i]] = list(stat=matrix(NA, nrow=length(COMP), ncol=2), COMP=COMP, Click=-1)
        L = locator()
        if(length(L$x)>=2)
          {

            print(paste(sep=" ", "WINDOW:", L$x[1], L$x[2],L$x[2]- L$x[1]))
            
            RST = dump.Nplot(GG, COMP=COMP,  WIN=c(L$x[1], L$x[2]), RMINST=RMINST, INTEG=INTEG, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
            title(ename)
            L = locator()
            nL = length(L$x)           
           RET[[i]] = list(stat=RST, COMP=COMP, Click=nL)
            
          }
      }
        return(RET)
        
  }
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")

##########################################
dump.SPIN<-function(mSW, STA="", FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),  INTEG=FALSE, rot=FALSE, sfact=1 )
  {
### dump.LOOK(mSW)
    if(missing(STA))
      {     
        STA="for"  
      }
      if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }
        if(missing(RMINST))
      {
        RMINST = FALSE
      }
    
    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
        if(missing(rot))
      {
        
        rot=FALSE
      }
    
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = seq(from=1, to=length(GG$STN))
        COMP=ncomp[GG$STN==STA]
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        CINTEG=rep("TRUE", length(COMP))
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        dev.set(2)
        dump.Nplot(GG, COMP=COMP, RMINST=RMINST,  INTEG=INTEG, FILT=FV , rot=rot, CINTEG=CINTEG, sfact=sfact)
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        titname = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(titname)
        dev.set(3)
        print(COMP)
        chaname= GG$chaname[COMP]
        
        chnorth = chaname=="North"
        cheast = chaname=="East"
        chvert = chaname=="Vertical"
        print(c(COMP[chvert],COMP[chnorth], COMP[cheast]))
        
        for(j in 1:length(holes$name))
          {
        
            stromb.rot(GG, comps=c(COMP[chvert],COMP[chnorth], COMP[cheast]) ,
                       vent=j, STA=stastromb, FILT=FALSE, rot=TRUE, sfact=2)
            
            
            locator(1)
          }
    
      }
   

    
  }
### source("/home/lees/Progs/R_stuff/stromb.R")


### source("/home/lees/Progs/R_stuff/stromb.R")

##########################################
##########################################

dump.Nplot<-function(FIG, COMP=c(1:4), WIN=c(0,1), RMINST=FALSE, INTEG=FALSE, FILT=f, rot=FALSE, CINTEG=c(FALSE), LABS=LABS, sfact=1)
{
###
  if(missing(COMP)){COMP = seq(from=1, to=length(info$name))}
  if(missing(sfact)) { sfact=1}
  if(missing(rot)){ rot = FALSE }
  if(missing(LABS)){  LABS = c("Infrasonic", "Vertical", "North", "East") }
  if(missing(FILT)) { FILT = list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE)) }
  if(missing(INTEG)){ INTEG = FALSE }
  if(missing(RMINST))  {   RMINST = FALSE }
  if(missing(CINTEG))  { CINTEG = rep(TRUE, length(COMP)) }
  
  info = FIG$info
  dat = FIG$dat
  
  PROC = ""
  
  if(exists("FIG$ex"))
    {
      ex = FIG$ex
    }
  else
    {
      dt = info$dt[ COMP[1] ]
      d = dim(dat)
      ex = dt*seq(0,d[1]-1)
    }
  
  if(missing(WIN))
    {
      WIN=c(min(ex), max(ex))
    }
  
  nn = length(COMP)
  
  if(RMINST == TRUE)
    {
      
      for(j in 1:nn)
        {
          
          k = COMP[j]
          
          if(FIG$chans[k] == "40T")
            {
              y = dat[,k]
              dt = info$dt[k ]
              y = y-mean(y)
              y = detrend(y)
              y = applytaper(y)
              dy  = deconinst(y, dt, Kal,1, Calibnew, waterlevel=1.e-8)
              ty = applytaper(dy-mean(dy), p=0.05)
              tapy = detrend(ty)
              fy = tapy-mean(tapy)
              dat[,k] = fy*1000000
              FIG$units[k]  = "muM/s"
              
            }
          
          if(FIG$chans[k] == "3T")
            {
              y = dat[,k]
              dt = info$dt[k ]
              y = y-mean(y)
              y = detrend(y)
              y = applytaper(y)
              dy  = deconinst(y, dt, Kal,2, Calibnew, waterlevel=1.e-8)
              ty = applytaper(dy-mean(dy), p=0.05)
              tapy = detrend(ty)
              fy = tapy-mean(tapy)
              dat[,k] = fy*1000000
              FIG$units[k]  = "muM/s"
            }

          if(FIG$chans[k] == "LD" | FIG$chans[k] == "MIC")
            {
            sense = FIG$sense[k]
            dat[,k] =   dat[,k]/sense
            FIG$units[k]  = "Pa"
          }
        }
      PROC = paste(sep=' ', PROC, "REM.INST")
    }
  
  if(INTEG == TRUE)
    {
      
      for(j in 1:nn)
        {
          if(CINTEG[j]==TRUE)
            {
              k = COMP[j]
              y = dat[,k]
              dt = info$dt[k ]
              fy = trapz(y, dt)
              dat[,k] = fy
              if(FIG$units[k]=="m/s") { FIG$units[k]  = "m" }
            }
        }
            PROC = paste(sep=' ', PROC, "INTEG")
    }
  
  if(FILT$ON == TRUE)
    {
      
      for(j in 1:nn)
        {
          if(FILT$vec[j]==TRUE)
            {
              k = COMP[j]
              y = dat[,k]
              dt = info$dt[k ]
              fy = butfilt(y,FILT$fl, FILT$fh , dt, FILT$type , FILT$proto )
              dat[,k] = fy
            }
        }
      PROC = paste(sep=' ', PROC, "FILT")
    }
  
  if(rot==TRUE)
    {
      STA = STROMB.STA
      chaname= FIG$chaname[COMP]
      
      chnorth = chaname=="North"
      cheast = chaname=="East"
      chvert = chaname=="Vertical"
      
      m = COMP[chnorth]
      ist = which(STA$name==FIG$STN[m])
      vent = 1
      evla=holes$lat[vent]
      evlo=holes$lon[vent]
      evel=holes$el[vent]
      stla=STA$lat[ist];
      stlo=STA$lon[ist];
      stel=STA$el[ist];
      
      lat1=evla;
      lon1=evlo;
      
      lat2=stla ;
      lon2=stlo ;
      
      GBAZ = distaz(lat2, lon2, lat1, lon1)
      baz=GBAZ$baz
      
      dprint = paste(sep=' ', vent, evla, evlo,evel, ist, FIG$STN[m] , stla, stlo, stel, baz )
      
      print(dprint)
      
      
      rbaz = grotseis(baz, flip=FALSE)

      ascd = dat[ , c(COMP[chvert], COMP[chnorth], COMP[cheast]) ]
      ascd = ascd  %*%  rbaz

      dat[ , c(COMP[chvert], COMP[chnorth], COMP[cheast])] =  ascd


      
      if(length(COMP) == 4)
        {
          FIG$chaname[COMP]=c("Infrasonic", "Vertical", "Radial", "Transvers")
        }
      else
        {
          FIG$chaname[COMP]=c("Vertical", "Radial", "Transvers")
        }

      
      PROC = paste(sep=' ', PROC, "ROT")
    }
  
  
  par(mfrow=c(1,1))
  
### par(mai=c(0.1, .7, 0.1, 0.5) )
  
  ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
  
  flag2 = ex>=WIN[1] & ex<=WIN[2]
  
  xtics = pretty(ex[flag2], n = 20)
  dy = 1/nn
  
  plot(range(ex[flag2]), c(0,1), type='n', axes=FALSE, xlab="", ylab="")
  rstats = matrix(NA, nrow=nn, ncol=2)

  STA = STROMB.STA
  chaname= FIG$chaname[COMP]
  
  chnorth = chaname=="North"
  cheast = chaname=="East"
  chvert = chaname=="Vertical"
  chinf = chaname=="Infrasonic"

  
  maxS = apply(dat[flag2,], 2, "max")
  minS = apply(dat[flag2,], 2, "min")
  for(i in 1:nn)
    {
      if( is.na(maxS[i]) ||  is.na(minS[i]) )
         {
           tem = dat[flag2,]
           maxS[i]= max(tem[!is.na(tem)])
            minS[i]= min(tem[!is.na(tem)])
          
         }
    }
 
  if(sfact==2)
    {
      ##  abs weighting using only COMP
      MAXy = max(maxS)
      MINy = min(minS) 
      maxS[COMP] =MAXy
      minS[COMP] = MINy
    }
  if(sfact==3)
    {
      ##  exclude the infrasonic components
      MAXy = max(maxS[!chinf])
      MINy = min(minS[!chinf]) 
      maxS[!chinf] =  MAXy
      minS[!chinf] =  MINy
    }
  
  for(i in 1:nn)
    {
      m = COMP[i]
###if(i==nn) {  par(mai=c(0.3, .7, 0.1, 0.5) ) }
      
      ylab = FIG$units[m]
      
      lab = paste(sep =" ",FIG$STN[m], FIG$chaname[m], FIG$chans[m])

      amp = dat[flag2,m]
      amp = amp-mean(amp[!is.na(amp) ])
      y3 = 1-(dy*i)

      
      # print(paste(sep=' ', "RESCAL:", y3, y3+dy, minamp, maxamp))

      if(sfact!=1)
        {
          minamp =  minS[i]; maxamp= maxS[i];
        }
      else
        {
         maxamp = max(amp[!is.na(amp)])
         minamp = min(amp[!is.na(amp)])
        }

    
      if(minamp>=maxamp)
        {
          next;
        }
      
      
      z = RESCALE(amp, y3, y3+dy, minamp, maxamp )
      abline(h=y3, lty=2, col=grey(0.8))
      lines(ex[flag2], z)
             
      yy = pretty(c(minamp, maxamp), n = 5)
      flg = yy>minamp & yy<maxamp
      yt = yy[flg]
      yts = RESCALE(yt, y3, y3+dy, minamp, maxamp )
                                  
      axis(2, tck=0.01 , at=yts, labels=yt, las=2 , line=0.1 )
      mtext(side=2, at=y3+dy/2, text=ylab , line=3)
      
      text(max(ex[flag2]), y3+dy*.1, labels=lab , pos=2, cex=1)
      rstats[i,1] = min(amp)
      rstats[i,2] = max(amp)
    }
          
  axis(side=1, tck=0.01, at=xtics, labels=FALSE)
  axis(side=1, tick=FALSE,  at=xtics, labels=xtics, line=-1)
  
  title(xlab='Time (s)', line=1.4, cex=1.2) 
  u = par("usr")
  
  
  #  text(u[1]+(u[2]-u[1])*.05 , u[3]+(u[4]-u[3])*.05, labels=paste(sep = " ", ftime[i], PROC) , pos=4)

  mtext(paste(sep = " ", ftime[i], PROC), side=1, line=2, adj=0, at=u[1]+(u[2]-u[1])*.05)

  
  
  box(col=grey(0.8))
    return(rstats)
  
}
### source("/home/lees/Progs/R_stuff/stromb.R")

#########################################
##########  get the last token in a long file name
ename<-function(NNN)
{
  n = length(NNN)
  NOUT = rep(" ", n)
  for(i in 1:n)
    {
      KN = unlist(strsplit(NNN[i], "\\/"))
      kn = length(KN)
      NOUT[i] = KN[kn]
    }
  return(NOUT)
}

##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")

stromb.rot<-function(SIN, comps=c(2,3,4), vent=1, STA=stastromb, INTEG=FALSE, FILT=FALSE, rot=FALSE, sfact=1)
  {
###   the comp vector signifies the location of the   
###   three componenets in the original matrix: comps(vert, NS, EW)  
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=FALSE, rot=TRUE, sfact=1)
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=FALSE, rot=FALSE, sfact=1)
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=TRUE, rot=TRUE, sfact=1)
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=TRUW, rot=FALSE, sfact=1)
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=TRUE, rot=TRUE, sfact=2)
### stromb.rot(SIN, comps=c(2,3,4), vent=1, STA=stastromb, FILT=TRUE, rot=FALSE, sfact=2)
    dat = SIN$dat
    info = SIN$info
    
    ascd = dat[,comps]
    
    nn = length(info$name)
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    

    
    if(missing(FILT))
      {
        FILT = FALSE
      }
    
    
    if(missing(INTEG))
      {
        INTEG = FALSE
      }
    
    
    
    if(missing(rot))
      {
        rot = FALSE
      }
    if(missing(sfact)) { sfact=1}
    
    
    di = dim(ascd)
    ist = which(STA$name==SIN$STN[comps[1]])
    
    evla=holes$lat[vent]
    evlo=holes$lon[vent]
    evel=holes$el[vent]
    stla=STA$lat[ist];
    stlo=STA$lon[ist];
    stel=STA$el[ist];
    
    
    lat1=evla;
    lon1=evlo;
    
    lat2=stla ;
    lon2=stlo ;
    
    GBAZ = distaz(lat2, lon2, lat1, lon1)
    baz=GBAZ$baz
    
    dprint = paste(sep=' ', vent, evla, evlo,evel, ist, SIN$STN[comps[1]] , stla, stlo, stel, baz )
    print(dprint)
    
    
    rbaz = grotseis(baz, flip=FALSE)
    ex = seq(0,di[1]-1 )*info$dt[1]
    x = ex
    if(rot==TRUE)
      {
        ascd= ascd  %*%  rbaz
        labs=c("Vertical", "Radial", "Transvers")          
      }
    else
      {
        labs=c("Vertical", "North", "East")
      }


    if(FILT == TRUE)
      {
        fl = 0.5
        fh = 1.0
        for(j in 1:length(comps))
          {
            y = ascd[,j]
            info$dt[comps[j]]
            fy = butfilt(y,fl, fh , info$dt[comps[j] ], "LP", "BU" )
            ascd[,j] = fy
          }
      }

    if(INTEG == TRUE)
      {
        for(j in 1:length(comps))
          {
            y = ascd[,j]
            dt = info$dt[comps[j]]
            fy = trapz(y, dt)
            ascd[,j] = fy
          }
      }


    tit = paste(sep=' ', SIN$STN[comps[1]], 'vent=', vent, 'rot=',rot, 'filt=', FILT)

    
    PLOT.MAT3(ascd, tim=x, labs=labs, sfact=sfact)
    title(tit)
    
    
    
}
### source("/home/lees/Progs/R_stuff/stromb.R")
###
###
spin.rot<-function(SIN, comps=c(2,3,4),  angles=a, INTEG=FALSE, FILT=FALSE , sfact=1, PLOT=TRUE, LOOK=TRUE, FPARM=fparm, WIN=w)
  {
###
    if(missing(LOOK)) { LOOK = TRUE }
    if(missing(PLOT)) { LOOK = PLOT }
    if(missing(WIN)) { WIN = c(1,2) }
    
    if(missing(INTEG)) { INTEG = FALSE }
    if(missing(FILT)) { FILT = FALSE }
    if(missing(FPARM)) { FPARM = list( fl = 0.5,fh = 1.0,  kind="LP", proto="BU"  ) }

    
    srats = rep(0, length(angles))
    for(i in 1:length(angles))
      {
       srats[i] = dump.rot(SIN, comps=comps, ang=angles[i], INTEG=INTEG, FILT=FILT, PLOT=PLOT , sfact=sfact, FPARM=FPARM, WIN=WIN)
        print(paste(sep=' ', angles[i], srats[i] ))
        if(LOOK==TRUE) { locator(1) }
      }
    return(list(rat=srats,ang=angles))
    
  }
###

dump.rot<-function(SIN, comps=c(2,3,4), ang=45, INTEG=FALSE, FILT=FALSE , PLOT=TRUE, sfact=1, FPARM=fparm, WIN=w)
  {
    #####  rotate a seismogram into radial transverse  
    dat = SIN$dat
    info = SIN$info
    
    ascd = dat[,comps]
    di = dim(ascd)
    nn = length(info$name)
    ftime = paste(sep="_", info$yr,info$mo,info$dom,info$hr,info$mn,info$sec,info$msec)
    
       if(missing(WIN))
      {
       WIN = c(1,2)
      }
     
    if(missing(PLOT))
      {
        PLOT = TRUE
      }
    
    if(missing(FILT))
      {
        FILT = FALSE
      }
    
    
    if(missing(INTEG))
      {
        INTEG = FALSE
      }

    if(missing(FPARM)) { FPARM = list( fl = 0.5,fh = 1.0,  kind="LP", proto="BU"  ) }

    
    if(missing(sfact)) { sfact=1}
    baz= ang
    
    rbaz = grotseis(baz, flip=FALSE)
    ex = seq(0,di[1]-1 )*info$dt[1]
    x = ex
    
    ascd= ascd  %*%  rbaz
    labs=c("Vertical", "Radial", "Transvers")          
     
    
    if(FILT == TRUE)
      {
       
        for(j in 1:length(comps))
          {
            y = ascd[,j]
            info$dt[comps[j]]
            fy = butfilt(y,FPARM$fl , FPARM$fh , info$dt[comps[j] ], FPARM$kind, FPARM$proto )
            ascd[,j] = fy
          }
      }

    if(INTEG == TRUE)
      {

        for(j in 1:length(comps))
          {
            y = ascd[,j]
            dt = info$dt[comps[j]]
            fy = trapz(y, dt)
            ascd[,j] = fy
          }
      }


    tit = paste(sep=' ', SIN$STN[comps[1]],  'rot=',ang, 'filt=', FILT)
    flg = x>SIN$tpix[WIN[1]] & x<SIN$tpix[WIN[2]]

    
    RAT = sqrt(sum(ascd[flg,2]^2)/sum(ascd[flg,3]^2))
    if(PLOT==TRUE)
      {
        PLOT.MAT3(ascd, tim=x, labs=labs, sfact=sfact)
        title(tit)
      }
    return(RAT)
    
  }
######################################
###
###
ROTSTROM<-function(SALL, lens , CMP, ANGS)
{
###  FOR.G = ROTSTROM(SALL, lens , CMP, ANGS)

  RET = as.list(SALL)

  for(i in 1:length(SALL))
    {
      if(CMP[1]>lens[i]) {  next; }
      GG = get(SALL[i])
      GGhp = spin.rot(GG, comps=CMP,  angles=ANGS, INTEG=TRUE, FILT=TRUE ,
        sfact=2, LOOK=FALSE , PLOT=FALSE, FPARM=list( fl = 1.0 ,fh = 10.0,
                                            kind="BP", proto="BU"  ), WIN=c(1,2))
      GGlp = spin.rot(GG, comps=CMP,  angles=ANGS, INTEG=TRUE, FILT=TRUE ,
        sfact=2, LOOK=FALSE , PLOT=FALSE, WIN=c(1,3) )
      
      plot(c(GGhp$ang,GGlp$ang), c(GGhp$rat, GGlp$rat) )
      points(GGlp$ang, GGlp$rat, col=2)
      
                                        #  p = peaks(GGlp$rat, span=3)
      
                                        # abline(v=GGlp$ang[peaks(GGlp$rat, span=3)])
                                        # abline(v=GGhp$ang[peaks(GGhp$rat)], col=2)

      abline(v=GGlp$ang[which.max(GGlp$rat)], col=2)
      abline(v=GGhp$ang[which.max(GGhp$rat)])

      GLIST = list(SRC=SALL[i], comps=CMP, STN=GG$STN[CMP],   anglp=GGlp$ang, anghp=GGhp$ang, rathp=GGhp$rat, ratlp=GGlp$rat, Mang=c(GGlp$ang[which.max(GGlp$rat)], GGhp$ang[which.max(GGhp$rat)]    ), Mrat=c(GGlp$rat[which.max(GGlp$rat)], GGhp$rat[which.max(GGhp$rat)]    )  )
      

      
     ### assign(paste(sep="","G", i), GLIST)
      
      RET[[i]] = GLIST
                                        #  locator()
    }

  return(RET)
}
SEESTROM<-function(SALL, lens , CMP, ANGS)
{
###  FOR.G = ROTSTROM(SALL, lens , CMP, ANGS)

  
  dv = dev.list()
  if(length(dv)<4)
    {
      for(i in 1:(4-length(dv)))
        {
          X11()
        }
    }
  for(i in 1:length(SALL))
    {
     
      GG = get(SALL[i])
print(paste(sep=" ",SALL[i]))

      dev.set(2)
      dump.rot(GG, comps=CMP,  ang=ANGS[i,1], INTEG=TRUE, FILT=TRUE , sfact=2 , PLOT=TRUE, FPARM=list( fl = 1.0 ,fh = 10.0,  kind="BP", proto="BU"  ))

    ###   locator()
       dev.set(3)
 dump.rot(GG, comps=CMP,  ang=ANGS[i,2], INTEG=TRUE, FILT=TRUE , sfact=2 , PLOT=TRUE )
      
      dev.set(4)
      dump.rot(GG, comps=CMP,  ang=ANGS[i,2], INTEG=TRUE, FILT=FALSE, sfact=2 , PLOT=TRUE )
      
      dev.set(5)
      
      pstromb(STRMAP, lonrange, latrange, STA=stastromb)
      
      msta = match( GG$STN[CMP[1]],  stastromb$name)
      points(stastromb$lon[msta], stastromb$lat[msta], pch=6)
      
      r = 0.2*sqrt( (lonrange[2]-lonrange[1])^2 + (latrange[2]-latrange[1])^2  )

      ang=90-ANGS[i,2]
      
      sx = stastromb$lon[msta]+r*cos((ang)*pi/180)
      sy = stastromb$lat[msta]+r*sin((ang)*pi/180)
      
      arrows(stastromb$lon[msta], stastromb$lat[msta], sx,sy, col=2)

      ang=90-ANGS[i,1]
      
      sx = stastromb$lon[msta]+r*cos((ang)*pi/180)
      sy = stastromb$lat[msta]+r*sin((ang)*pi/180)
      
      arrows(stastromb$lon[msta], stastromb$lat[msta], sx,sy, col=4)
      mA = match(SALL[i], April.Code.D[,1])
      title(paste(sep=" ", "Event:",SALL[i], April.Code.D[mA,2]))
        
      locator()
    }

  
}

##########################################

### source("/home/lees/Progs/R_stuff/stromb.R")
PLOT.ADDN<-function(n, pch=1, col=1)
{
## par('usr') = c(x1, x2, y1, y2)
  u = par('usr')

  ex = rep(u[2], n)
  why = seq(from=(1/n)/2, by=1/n, length=n)
  
  
  
  points(ex,why, pch=pch, col=col, xpd=TRUE)

}
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")

PLOT.MATN<-function(ascd, tim=1, dt=1,  WIN=WIN, labs=LABS, notes=notes, sfact=1, LOG="", COL=col, add=1)
{
  ### plot a matrix of seismograms on a simple panel display
  ###   ascd = matrix(time, trace)

  ###  add = 1,2,3  if add=1 plot and add traces
   ###                  add =2 plot, but no traces
  ###                   add = 3 no plot, but add traces
  if(missing(sfact)) { sfact=1}
  if(missing(dt)) { dt=1}
  if(missing(LOG)) { LOG=""  }
  
  if(missing(add)) { add=1 }

  
  if(missing(tim))
    {
      tim = dt*seq(from=0,to=length(ascd[,1])-1)
    }

  if(missing(WIN))
    {
      WIN =range(tim)
    }
  if(missing(notes))
    {
      note.flag = FALSE
    }
  else
     {
      note.flag = TRUE
    }
  if(is.null(WIN)==TRUE){ WIN =range(tim) }

  tflag = tim>=WIN[1]&tim<=WIN[2]
  

  tr1 = 0.05
  tr2 = .9
  
  matsiz = dim(ascd)
  nn = matsiz[2]
  
  if(missing(COL)) { COL=rep(1, nn)  }
if(length(COL)<nn) {  COL=c(COL, rep(1, nn-length(COL))) }
  
    if(missing(labs)) { labs=rep(" ", nn) }
  ttics = pretty(tim[tflag], n=10 )
  atics = ttics
  if(LOG=='x')
    {
      periods = c(30,20,10,5,2,1)
      hz = 1/periods
      at1 = c(pretty(1:10), pretty(tim))
      at2 = at1[at1>0&at1<max(tim)]
      ttics = c(hz, at2 )
      
      btics = c(periods, at2 )
      atics = as.character(btics)
      atics[length(atics)] = paste(sep=' ', atics[length(atics)],"Hz")
      
      atics[btics==1] = paste(sep=' ', atics[btics==1],"Hz")
           atics[1] = paste(sep=' ', atics[1],"s")
 
      
    }
  dy = (1/nn)
  maxS = rep(0,nn)
  minS = rep(0,nn)
  diffS = rep(0,nn)

  
    for(i in 1:nn)
    {
      amp = ascd[tflag,i]
      lamp = length(amp[!is.na(amp)])
      if(lamp<1)
        {
          maxS[i] = 0
          minS[i] = 0
          diffS[i] = 0

        }
      else
        {
      
      maxS[i] = max(amp[!is.na(amp)])
      minS[i] = min(amp[!is.na(amp)])
      diffS[i] = maxS[i]-minS[i]
    }
    }
      ##  abs waiting using only COMP
  KDIFF = which.max(diffS)
  
  if(sfact>=2)
    {
      MAXy = max(maxS)
      MINy = min(minS)
      
      maxS =rep(MAXy, nn)
      minS =rep(MINy, nn)
    }

  if(add==1)
    {
      plot(range(tim[tflag]), c(0,1), type='n', axes=FALSE, xlab="", ylab="", log=LOG)
       
    }
  if(add==2)
    {
      plot(range(tim[tflag]), c(0,1), type='n', axes=FALSE, xlab="", ylab="", log=LOG)

    }

  
   box(col=grey(0.8))

  upar = par("usr")
  
    for(i in 1:nn)
    {
      amp = ascd[tflag,i]
      lamp = length(amp[!is.na(amp)])
      if(lamp<1)
        {

          next;
        }
      amp = amp-mean(amp[!is.na(amp)])
      y3 = 1-(dy*i)
      if(sfact==1)
        {
      minamp =  min(amp[!is.na(amp)]);
      maxamp= max(amp[!is.na(amp)]);
    }
      else
        {
      minamp =  minS[i];
      maxamp= maxS[i];

        }

      if(add!=3) addtix(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=gray(0.8) )
      z = RESCALE(amp, y3, y3+dy, minamp, maxamp )
      if(add!=3)abline(h=y3, lty=2, col=grey(0.8))
      if(add!=2)lines(tim[tflag], z, col=COL[i])
    #   print( paste(sep=' ', "IN PLOT.MATN", y3, y3+dy, minamp, maxamp))
      
      cmm = c(minamp, maxamp)
      lcmm = length(cmm[!is.na(cmm)])
      dmm = maxamp-minamp
      if( lcmm < 2   | dmm<=0)
        {
          
           #   print( paste(sep=' ', "IN PLOT.MATN", "PROBLEMS", lcmm ,dmm ))
          next;
        }
      yy = pretty(cmm, n = 5)
      
      flg = yy>minamp & yy<maxamp
      yt = yy[flg]
      yts = RESCALE(yt, y3, y3+dy, minamp, maxamp )
                                  
     #   axis(2, tck=0.01 , at=yts, labels=yt, las=2 , line=0.1 )

      
      if(i==KDIFF)
        {
          if(add!=3)axis(2, pos= upar[1] ,tck=-0.005 , at=yts, labels=yt, las=2 , line=0.1 )
        }
      else
        {
          bnum = paste(sep='', "X", format.default(diffS[KDIFF]/diffS[i], digits=4))
          blab=bnum 
          if(add!=3)text(min(tim[tflag]), y3+0.75*dy, labels=blab, adj=0)
        }

      
      
      # axis(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=2 )
      
      ylab = labs[i]
      mtext(side=2, at=y3+dy/2, text=ylab , line=1)
    #   print( paste(sep=' ', "IN PLOT.MATN",note.flag))
      
      if(note.flag==TRUE)
        {
         #  print( paste(sep=' ', "IN PLOT.MATN", notes[i]))
               
          if(add!=3)text(max(tim[tflag]), y3+dy-dy*0.1, notes[i], adj=1)
          
        }
      if(add!=3)text(max(tim[tflag]), y3+dy/2, labels=i, pos=4, col=gray(0.8))
      
    }
  if(add!=3)
    {
      axis(side=1, tck=0.01, at=ttics, labels=FALSE)
      axis(side=1, tick=FALSE,  at=ttics, labels=atics, line=-1)
      
      
      moretics = seq(from=min(ttics), to=max(ttics), by=1)
      if(length(moretics)<500)
        {
          axis(side=3, tck=0.01, at=moretics, labels=FALSE)
        }
      title(xlab='Time (s)', line=1.4, cex=1.2) 
    }
  

  u = par("usr")
  
  
  invisible(nn)
 
 

}
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
FILT.MATN<-function(dat, dt, FILT)
  {
    rdat = dat
    dims = dim(dat)
    nn = dims[2]
    
    for(j in 1:nn)
      {
        
        y = dat[,j]
        ny = is.na(y)
        ry = y[!ny]
        fy = butfilt(ry,FILT$fl, FILT$fh , dt, FILT$type , FILT$proto )
        rdat[!ny,j] = fy
      }         

    invisible(rdat)
  }
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
parse.pde<-function(card)
{
    ##### parse a pde card from the NEIC  website catalogue
    ####   format:
    #### PDE-W 2003   12 25 204233.72 -22.25  169.49  10 6.50 MwHRV	
    #####c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
  yr =  as.numeric(substr(card, 7, 10))
  mon = as.numeric(substr(card, 14, 15))
  day  = as.numeric(substr(card, 17, 18))
  hour  = as.numeric(substr(card, 20, 21))
  min  = as.numeric(substr(card, 22, 23))
  sec  = as.numeric(substr(card, 24, 28))
  lat= as.numeric(substr(card, 30, 35))
  lon= as.numeric(substr(card, 37, 43))
  depth= as.numeric(substr(card, 45, 47))
  mag = as.numeric(substr(card, 49, 52))
  jd = getjul(yr, mon, day)
  locdate = list(yr=yr, jday=jd, mon=mon, dom=day, hr=hour, min=min, sec=sec,  lat=lat, lon=lon, depth=depth, mag=mag)
  return(locdate)
}
########################################################
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
parse.evcard<-function(card)
{
    ##### parse a event card from SEKS catalogue
    ####  
    ####"1999/04/08 13:10:34.08    43.607  130.350 565.0 6.4" 	
    #####c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$
  yr =  as.numeric(substr(card, 1, 4))
  mon = as.numeric(substr(card, 6,7))
  day  = as.numeric(substr(card, 9,10))
  hour  = as.numeric(substr(card, 12, 13))
  min  = as.numeric(substr(card, 15,16))
  sec  = as.numeric(substr(card, 18,22))
  lat= as.numeric(substr(card, 26,32))
  lon= as.numeric(substr(card, 34,41))
  depth= as.numeric(substr(card, 43,47))
  mag = as.numeric(substr(card, 49,51))
  jd = getjul(yr, mon, day)
  locdate = list(yr=yr, jday=jd, mon=mon, dom=day, hr=hour, min=min, sec=sec,  lat=lat, lon=lon, depth=depth, mag=mag)
  return(locdate)
}
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
fix.ev<-function(ev)
  {
    if(is.na(ev$jday)==TRUE)
      {
        ev$jday = getjul(yr, mon, dom)
      }
    if(is.na(ev$mon)==TRUE)
      {
         md = getmoday(jday, yr)
         ev$mon=md$mon
         ev$dom=md$dom
      }
    
    return(ev)
  }

##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
set.ev<-function(v)
  {
    ####  set up an event structure
    #####  v = c(YYYY, MM, DD, JUL, HH, MM, SS, LATIT, LONGIT, DEPTH, MAG)
    if(is.vector(v)==TRUE)
      {
    yr=v[1]
    mon=v[2]
    dom=v[3]
    jday=v[4]
    hr=v[5]
    min=v[6]
    sec=v[7]
    lat=v[8]
    lon=v[9]
    depth=v[10]
    mag=v[11]

    if(is.na(jday)==TRUE)
      {
        jday = getjul(yr, mon, dom)
      }
    if(is.na(mon)==TRUE)
      {
         md = getmoday(jday, yr)
         mon=md$mon
         dom=md$dom
      }

    
  }
    if(is.matrix(v)==TRUE)
      {
    yr=v[,1]
    mon=v[,2]
    dom=v[,3]
    jday=v[,4]
    hr=v[,5]
    min=v[,6]
    sec=v[,7]
    lat=v[,8]
    lon=v[,9]
    depth=v[,10]
    mag=v[,11]
    
    if(length(jday[is.na(jday)])>0)
      {
    jday[is.na(jday)] = getjul(yr[is.na(jday)], mon[is.na(jday)], dom[is.na(jday)])
  }
    
    mflg = is.na(mon)
    if(length(mon[mflg])>0)
      {
        md = getmoday(jday[mflg], yr[mflg])
        mon[mflg] = md$mon
        dom[mflg]=md$dom
      }
    
      }

    ev =list(yr=yr, mon=mon, dom=dom, jday=jday, hr=hr, min=min, sec=sec, lat=lat, lon=lon, depth=depth, mag=mag)
    return(ev)
  }

### source("/home/lees/Progs/R_stuff/stromb.R")

event.card<-function(ev)
  {
    t1 = paste(sep='/',ev$yr, ev$mon, ev$dom)
    t2 = paste(sep=':',ev$hr, ev$min, ev$sec)

    return( paste(sep=' ', t1, t2, ev$lat, ev$lon, ev$depth))

  }

########################################################
##########################################
### source("/home/lees/Progs/R_stuff/stromb.R")
PLOT.LISTN<-function(ldat , N=N, tim=1,    WIN=WIN, labs=LABS, notes=notes, sfact=1,  COL=col)
{
  if(missing(sfact)) { sfact=1}
  if(missing(tim)) { tim=1  }
  if(missing(WIN))
    {
      WIN =range(tim)
    }
  if(missing(notes))
    {
      note.flag = FALSE
    }
  else
    {
      note.flag = TRUE
    }
  if(missing(N))
    {
      N = length(ldat)
    }
  if(missing(COL))
    { COL=rep(1, N)  }
  
  
  print(paste(sep=' ', "LENGTH=", N))
   H = ldat[[1]]

  minx = min(H$x[!is.na(H$x)])
  maxx = max(H$x[!is.na(H$x)])
  dx = maxx-minx
  miny =  min(H$Y[!is.na(H$x)])
  maxy = max(H$Y[!is.na(H$x)])
  
  
  for(i in 2:N)
    {
      H = ldat[[i]]
      if(!is.null(H$x))
        {
          minx = min(H$x[!is.na(H$x)])
          maxx = max(H$x[!is.na(H$x)])
          dx = max( dx , maxx-minx)
          miny = min(miny, min(H$Y[!is.na(H$x)]))
          maxy = max(maxy, max(H$Y[!is.na(H$x)]))
          
          print(paste(sep=' ', minx,maxx,  miny,  maxy))
          
          # plot(H$x, H$Y, main=H$name)
          # locator()
        }
    }
  
  plot(c(0, dx) , c(0,1), type='n', axes=FALSE, xlab="", ylab="")
  box(col=grey(0.8))
  nn = N
  dy = (1/nn)
   ttics = pretty(c(0, dx), n=10 )
  atics = ttics
  
   for(i in 1:nn)
     {
       H = ldat[[i]]
       amp = H$Y
       tim = seq(from=0,by=H$dt, length=length(amp))
       
       atem = amp[!is.na(amp)]
       amp = amp-mean(atem)
       y3 = 1-(dy*i)
       if(sfact==1)
         {
           minamp =  min(atem);
           maxamp= max(atem);
         }
       else
         {
           minamp =  miny;
           maxamp= maxy;
           
         }
       addtix(side=3, pos=y3+dy,   tck=0.005, at=ttics, labels=FALSE, col=gray(0.8) )
       z = RESCALE(amp, y3, y3+dy, minamp, maxamp )
       abline(h=y3, lty=2, col=grey(0.8))
       lines(tim, z, col=COL[i])
             yy = pretty(c(minamp, maxamp), n = 5)
      flg = yy>minamp & yy<maxamp
      yt = yy[flg]
      yts = RESCALE(yt, y3, y3+dy, minamp, maxamp )

     
       text(max(tim), y3+dy-dy*0.1, H$name, adj=1)
       
       
     }
  
         axis(side=1, tck=0.01, at=ttics, labels=FALSE)
  axis(side=1, tick=FALSE,  at=ttics, labels=atics, line=-1)
  
  
  title(xlab='Time (s)', line=1.4, cex=1.2) 
  u = par("usr")
  
  
}
### source("/home/lees/Progs/R_stuff/stromb.R")





### source("/home/lees/Progs/R_stuff/stromb.R")



PLOT.MAT3<-function(ascd, tim=1, labs=LABS, sfact=1)
{

  if(missing(labs)) { labs=c("Vertical", "North", "East")}
  if(missing(sfact)) { sfact=1}
  
  if(missing(tim))
    {
      tim = seq(0,length(ascd[,1])-1)
    }
  

  tr1 = 0.05
  tr2 = .9
  
  mn = apply(ascd, 2, "mean")
  b2 = sweep(ascd, 2, mn)
  
  rn = apply(b2, 2, "range")
  dn = diff(rn)
  deltan = max(dn)
  ttics = pretty(tim )
  
  dy = 1/3
  y1 = 0
  y2 = y1+dy
  y3 = y2 + dy
  dymarg = dy*0.05
  
  if(sfact==1)
    {
      vert = RESCALE(ascd[,1], y3+dymarg, y3+dy-dymarg,  min(ascd[,1]), max(ascd[,1]) )
      north = RESCALE(ascd[,2], y2+dymarg, y2+dy-dymarg, min(ascd[,2]), max(ascd[,2]))
      east  = RESCALE(ascd[,3], y1+dymarg, y1+dy-dymarg, min(ascd[,3]), max(ascd[,3]))
      
      ytlab=c((c(min(ascd[,1]), max(ascd[,1]))), (c(min(ascd[,2]), max(ascd[,2]))), (c(min(ascd[,3]), max(ascd[,3]))))
      

      
    }
  if(sfact==2)
    {
      miny = min(ascd)
      maxy = max(ascd)
      vert = RESCALE(ascd[,1], y3+dymarg, y3+dy-dymarg, miny, maxy )
      north = RESCALE(ascd[,2], y2+dymarg, y2+dy-dymarg,miny, maxy )
      east  = RESCALE(ascd[,3], y1+dymarg, y1+dy-dymarg, miny, maxy )
      
      ytlab=c((c(miny, maxy)), (c(miny, maxy)), (c(miny, maxy)))

      
      
    }
  

  
  ex   = RESCALE(  tim, tr1 , tr2, min(tim), max(tim) )
  xtics = RESCALE( ttics , tr1 , tr2, min(tim), max(tim))
  
  plot(c(0,1 ), c(0,1),  type="n", axes=FALSE, xlab="", ylab="")

                                        # box()
  axis(1,tck=.03,at=xtics,lab=ttics, las=1,   mgp=c(.1,.1,0))
                                        #  axis(4,tck=.03,at=ytpos,lab=ytlab, las=1,   mgp=c(.1,.1,0))


  lines(ex,vert, type='l', col=1)
                                        # points(rex[flag],ascd[flag,1], col=2)

  lines(ex,north, col=1)
  lines(ex , east, col=1)

###rect(min(ex), y3+dymarg , max(ex) , y3+dy-dymarg, lty=1 )
###rect(min(ex), y2+dymarg , max(ex) , y2+dy-dymarg, lty=1 )
###rect(min(ex), y1+dymarg , max(ex) , y1+dy-dymarg, lty=1 )

  lines( c(max(ex),  max(ex)),  c(y3+dymarg  , y3+dy-dymarg) , lty=1 )
  lines( c(max(ex),max(ex)) , c(y2+dymarg ,  y2+dy-dymarg), lty=1 )
  lines( c(max(ex) , max(ex)), c(y1+dymarg , y1+dy-dymarg), lty=1 )
  
  

                                        # axis(4,tck=.03,at=c(y3+dymarg,y3+dy-dymarg,y2+dymarg,y2+dy-dymarg,y1+dymarg,y1+dy-dymarg      ) ,lab=FALSE )

  text( rep(max(ex), 6) , c(y3+dymarg,y3+dy-dymarg,y2+dymarg,y2+dy-dymarg,y1+dymarg,y1+dy-dymarg ),
       labels= format.default(ytlab, digits=3), pos=4)

  
  ex1 = rep(0, 3)
  why2 =  c( y3+dy/2, y2+dy/2, y1+dy/2)
  
  text(ex1, why2, labs, adj=.5,  srt=90)
  
  ex1 = tr2
  why2 = y3+dy
  ## text(ex1, why2, labels=fil, pos=2)

  mtext("Time, s", at=(max(xtics)-min(xtics))/2, adj=0.5, side=1, line=1)

}

#############################################################
#############################################################
#############################################################

PLOT.MAT.Aold<-function(ascd, tim=1, labs=LABS)
{

  if(missing(labs)) { labs=c("Vertical", "North", "East")}
  if(missing(tim))
    {
      ex = 1:length(ascd[,1])
    }
  else
    {
      
      ex = tim
    }
mn = apply(ascd, 2, "mean")
a2 = sweep(ascd, 2, mn)
rn = apply(a2, 2, "range")
xtics= pretty(ex)

a2[,1] =   3+((a2[,1]-rn[1,1]) /(rn[2,1]-rn[1,1]))
a2[,2] =   2+((a2[,2]-rn[1,2])/(rn[2,2]-rn[1,2]))
a2[,3] =   1+((a2[,3]-rn[1,3])/(rn[2,3]-rn[1,3]))

plot(range(ex), range(a2), type="n", axes=FALSE, xlab="Time", ylab="Component")
axis(1,tck=.03,at=xtics,lab=TRUE)
 axis(2,tck=.03,at=c( 3.5, 2.5,  1.5 ), lab=labs )

box()

lines(ex,a2[,1])
lines(ex,a2[,2])
lines(ex,a2[,3])
	

}

### source("/home/lees/Progs/R_stuff/stromb.R")



##########################################
##########################################

PLOTSTROMB<-function(NSTRMAP, lonrange=lonrange, latrange=latrange, STA=stastromb)
{

  if(missing(STA)) { STA=stastromb}
  if(missing(lonrange))
     {
      lonr=range(c(range(NSTRMAP$lon),range(STA$lon)))
      
     }
  if(missing(latrange))
     {
      latr=range(c(range(NSTRMAP$lat),range(STA$lat)))
      
     }

  if(FALSE)
    {
      lonr=range(c(lonrange,range(STA$lon)))
      
      latr=range(c(latrange,range(STA$lat)))
    }

  plot(lonr, latr, asp=1, type='n', xlab="Lon", ylab="Lat")

  for( i in 1:length(NSTRMAP$lon))
    {
      if(NSTRMAP$kind[i]==2)
        {
          lines(unlist(NSTRMAP$lon[i]),unlist(NSTRMAP$lat[i]))
        }
      if(NSTRMAP$kind[i]==1)
        {
          points(unlist(NSTRMAP$lon[i]),unlist(NSTRMAP$lat[i]), col=2)
          text(unlist(NSTRMAP$lon[i]),unlist(NSTRMAP$lat[i]), seq(1:length(unlist(NSTRMAP$lat[i]) ) ), pos=1)
        }

    }

  points(STA$lon,STA$lat, col=2)
  text(STA$lon,STA$lat,STA$name , pos=3)


}
#####################################
#####################################
###### source("/home/lees/Progs/R_stuff/stromb.R")

###  source("/home/lees/Progs/R_stuff/interp.R")

###################################################################################
#####
strmbcont<-function(x,y,z, levs=15,  POL=POL)
{
  if(missing(POL)) {  POL=NULL }
  
  JSUR = data.frame(cbind(x=x, y=y,  z=z))
  JSUR.kr <- surf.gls(3, expcov, JSUR, d=0.7)
  prsurf <- prmat(JSUR.kr,   min(JSUR$x), max(JSUR$x), min(JSUR$y), max(JSUR$y) , 100)
  d =  dim(prsurf$z)
  INZ = matrix(ncol=d[1], nrow=d[2])
  xpo = matrix(rep(prsurf$x,length(prsurf$y)), ncol=length(prsurf$x),  nrow = length(prsurf$y))

  ypo = matrix(rep(prsurf$y,length(prsurf$x)), ncol=length(prsurf$x),  nrow = length(prsurf$y))



  
  if(!is.null(POL))
    {
      for(i in 1:d[1])
        {
          x = xpo[,i]
          y = ypo[i,]
          INZ[,i] = inpoly(x, y, POL)
        }
      
      prsurf$z[prsurf$z<0] = NA
    }
  dlev = (max(JSUR$z)-min(JSUR$z))/levs

  contour(prsurf, levels=seq(min(JSUR$z), max(JSUR$z), dlev ), add=TRUE)

  return(JSUR)


}



#####################################
#####################################
###### source("/home/lees/Progs/R_stuff/stromb.R")

pstromb<-function(STRMAP=STRMAP, lonrange=lonrange, latrange=lonrange, STA=stastromb, tight=FALSE)
{

  if(missing(STA)) { STA=stastromb}
  if(missing(tight)) { tight=FALSE}


  
  lonr=range(c(lonrange,range(STA$lon)))

  latr=range(c(latrange,range(STA$lat)))

 #  plot(lonr, latr, asp=1, type='n', xlim=lonrange,  ylim=latrange,   xlab="Lon", ylab="Lat")

  if(tight==TRUE)
    {
      plot(lonr, latr, asp=1 , type='n', xlim=lonrange,  ylim=latrange, xaxs='i',yaxs='i',  xlab="Lon", ylab="Lat")
    }
  else
    {
      plot(lonr, latr, asp=1 , type='n', xlim=lonrange,  ylim=latrange,  xlab="", ylab="", axes=FALSE)
    }

  u = par("usr")
  xax = pretty(c(u[1], u[2]), 6)
  yax = pretty(c(u[3], u[4]), 6)

   xax = xax[xax>u[1]&xax<u[2]]
    yax = yax[yax>u[3]&yax<u[4]]
 
  axis(side=3, at=xax, tck=-0.01, pos=u[3], labels=FALSE )
  axis(side=4, at=yax, tck=-0.01, pos=u[1], labels=FALSE )
  
  ## axis(side=1, at=xax, tck=FALSE,  labels=TRUE, line=-0.05  )
  ##  axis(side=2, at=yax, tck=FALSE,  labels=TRUE, line=-0.05 )

  mtext(side=2, at=yax,  text=yax , line=.2)
  mtext(side=1, at=xax,  text=xax , line=.2)

  box()
  mtext(side=2, at=(u[3]+u[4])/2, text="LAT" , line=1.2)
  mtext(side=1, at=(u[1]+u[2])/2, text="LON" , line=1)
  
  if(is.null(STRMAP) == FALSE)
    {
      for( i in 1:length(STRMAP))
        {
          if(STRMAP[[i]]$type==2)
            {
              lines(STRMAP[[i]]$lon,STRMAP[[i]]$lat)
            }
          if(STRMAP[[i]]$type==1)
            {
              points(STRMAP[[i]]$lon,STRMAP[[i]]$lat, col=2)
              ##text(STRMAP[[i]]$lon,STRMAP[[i]]$lat, seq(1:length(STRMAP[[i]]$lat ) ), pos=1)
            }
          
        }
    }
  
  points(STA$lon,STA$lat, pch=6, col=2)
  #  text(STA$lon,STA$lat,STA$name , pos=3)


}

########################################################
check.stromb<-function(SN, INTEG=FALSE, FILT=FALSE, rot=FALSE)
{


for(i in 1:length(holes$name))
{
stromb.rot(SN, comps=c(2,3,4), vent=i, STA=stastromb, INTEG=INTEG, FILT=FILT, rot=rot, sfact=2)
locator(1)
}



for(i in 1:length(holes$name))
{
stromb.rot(SN, comps=c(9,10,11), vent=i, STA=stastromb, INTEG=INTEG, FILT=FILT, rot=rot, sfact=2)
locator(1)
}


for(i in 1:length(holes$name))
{
stromb.rot(SN, comps=c(6,6,7), vent=i, STA=stastromb, INTEG=INTEG, FILT=FILT, rot=rot, sfact=2)
locator(1)
}



}
########################################################
check.stromb<-function(SN, J, INTEG=FALSE, FILT=FALSE, rot=FALSE)
{
  
  
  for(i in 1:length(holes$name))
    {
      stromb.rot(SN, comps=J, vent=i, STA=stastromb, INTEG=INTEG, FILT=FILT, rot=rot, sfact=2)
      locator(1)
    }
  
  
  
  
}

### source("/home/lees/Progs/R_stuff/stromb.R")
###################################################################################
stromb.AIN<-function(A1, J, vent, STA, INTEG=FALSE, FILT=f)
  {
    ##  prepare data for input  to particle motion programs
    ##  data is initially read in from seissig dump_ascii  action
    ## thn in R do:
    ## S3 = dump.get("SEIS_INFO_0002.dat","SEIS_DATA_0002.dat", DIR="/home/beer/lees/DUMP")
    ## S3  = get.dump.sta(S3, 6,7)
    ## dev.off()
    ##  NEED: source("/home/lees/Progs/R_stuff/kar.R")
    
    
    ##   divide by sensitivity of the Guralps, .8 v/(mm/s)
    
    ## i = (j-1)*3+1
    
    
    if(missing(FILT))
      {
        
        FILT = list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU")
        
        
      }
    
    
    if(missing(INTEG))
      {
        INTEG = FALSE
      }
    
    
    
    
    
    dat = A1$dat[,J]/.8
    nms = A1$info$name[J]
    dt = A1$info$dt[J]
    comp = c("V", "N", "E")
    t = dt[1]*0:(length(dat[,1])-1)

    sta = A1$STN[J[1]]

    ist = which(STA$name==A1$STN[J[1]])
    
    stalat = STA$lat[ist];
    stalon = STA$lon[ist];
    staZ = STA$el[ist];
    
    evlat = vent$lat[1]
    evlon = vent$lon[1]
    evZ =  vent$el[1]
    
    az1 = greatAz( stalat, stalon , evlat,evlon)


    if(az1<0) { az1=az1+180 }


    evlat = vent$lat[8]
    evlon = vent$lon[8]
    evZ =  vent$el[8]
    
    az8 = greatAz( stalat, stalon , evlat,evlon)


    if(az8<0)
      {
        az8=az8+180
      }
    
    az = c(az1,az8)
    
    
    if(FILT$ON == TRUE)
      {
        
        for(j in 1:length(J))
          {
            y = dat[,j]
            fy = butfilt(y,FILT$fl, FILT$fh , dt[j], FILT$type , FILT$proto )
            dat[,j] = fy
          }
      }
    
    if(INTEG == TRUE)
      {
        
        for(j in 1:length(J))
          {
            y = dat[,j]
            fy = trapz(y, dt[j])
            dat[,j] = fy
          }
      }

    a1 = list(pfil=A1$ifile, dir=A1$dir, data=dat, t=t,   sta=sta, comp=comp,
      info=list(dt=dt, fn=nms, id=nms,   sec=0, psec=0),
      p=0, s=0, T1=0, T2=0, az=az,
      evla=evlat, evlo=evlon , evel=evZ,
      stla=stalat, stlo=stalon,stel=staZ, tbeg=0   )
  }

###################################################################################
### source("/home/lees/Progs/R_stuff/stromb.R")
##########################################################
check.response<-function(EJALL)
  {
    ##  to see a trace plotted with NO instr removed, removal with the 
    ##  the PASSCAL filter poles-zeros,  and witrh the correct poles and zeros
    ##  from the manufacturer
    ## The main diofference is in the overal amplitude, which is corrected
    ##  by the normalization constant.  When you apply 3 poles and 3 zeros
    ##  on the CMG40T  you divide by appx -2
    for(i in 1:length(EJALL))
      {
        
        GG = get(EJALL[i])
        
        x = GG$dat[,2]
        ##  deconvolve and filter with correct Instrument response
        dt = 0.008
        amp = x
        dy  = deconinst(amp, 0.008, Kal,1, Calibnew, waterlevel=1.e-8)
        fy = dy
        fy = butfilt(dy,fchouet$fl, fchouet$fh , dt, fchouet$type , fchouet$proto )
### 	fy = butfilt(dy,fhigh$fl, fhigh$fh , dt, fhigh$type , fhigh$proto )
        fy = trapz(fy,dt)
        fy = applytaper(fy)
        why = 1000000*fy
        amp = x
        dy  = deconinst(amp, 0.008,Kal,3,Calibnew , waterlevel=1.e-8)
        fy = dy
        fy = butfilt(dy,fchouet$fl, fchouet$fh , dt, fchouet$type , fchouet$proto )
###	fy = butfilt(dy,fhigh$fl, fhigh$fh , dt, fhigh$type , fhigh$proto )
        fy = trapz(fy,dt)
        Passy = applytaper(fy)
        ## Passwhy = 1000000*Passy/abs(Kal[[1]]$Knorm)
        Passwhy = 1000000*Passy 
        
        
        ex = dt*seq(0, length(x)-1)
        famp = amp
        famp = butfilt(amp,fchouet$fl, fchouet$fh , dt, fchouet$type , fchouet$proto )
        famp = trapz(famp,dt)
        par(mfrow=c(3,1))
        plot(ex,why, ylab=expression(mu*"m/s"))
        plot(ex,Passwhy, ylab=expression(mu*"m/s"))
        plot(ex,famp, ylab='Volts')
        L= locator()
        if(length(L$x)>=2)
          {
            plot(ex[ex>=L$x[1]&ex<=L$x[2]],why[ex>=L$x[1]&ex<=L$x[2]], ylab=expression(mu*"m/s") )
            plot(ex[ex>=L$x[1]&ex<=L$x[2]],Passwhy[ex>=L$x[1]&ex<=L$x[2]], ylab=expression(mu*"m/s"))
            plot(ex[ex>=L$x[1]&ex<=L$x[2]],famp[ex>=L$x[1]&ex<=L$x[2]], ylab='Volts')
            locator()
          }
      }
  }
####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")
### source("/home/lees/Progs/R_stuff/stromb.R")


stromb.STACKER<-function(SELDA, tvert=30, prevert=7, tacoust=3, preacoust=1, WINDOWS=NULL)
  {
### select windows and create a matrix of waveforms picked by max in window


    if(missing(WINDOWS))
      {
        pickit = TRUE
      }
    else
      {
        pickit = FALSE
      }
    wins = as.list(SELDA)

    MAT.NEvert = matrix(NA, ncol=length(SELDA), nrow=125*tvert)
    MAT.NEacoust = matrix(NA, ncol=length(SELDA), nrow=125*tacoust)


    par(mfrow=c(2,1))

    for(i in 1:length(SELDA))
      {
        DA = get(SELDA[i])
                                        #  comp = 1:2
                                        #  dat = DA$dat[,comp]
        sense = DA$sense[1]
        acoust = DA$dat[,1]/sense
        vert   = DA$dat[,2]
        t = 0.008*seq(0,length(acoust)-1)


        plot(t, acoust, type='l')
        if(pickit)
          {
            La = locator()
          }
        else
          {
            La = list(x=c(WINDOWS$wins[[i]]$pix[1]-20*0.008, WINDOWS$wins[[i]]$pix[1]+20*0.008  ))
          }
        Wa = t>=La$x[1] &  t<=La$x[2]
        apix = dt*(length(t[t<La$x[1]]  )+which.max(acoust[Wa]))
        k = 2	
        y = vert
        dt = 0.008
        y = y-mean(y)
        y = detrend(y)
        y = applytaper(y)
        dy  = deconinst(y, dt, Kal,1, Calibnew, waterlevel=1.e-8)
        ty = applytaper(dy-mean(dy), p=0.05)      
        tapy = detrend(ty)
        y = tapy-mean(tapy)
        
        y  = y*1000000
	fy = trapz(y, dt)

        fy = butfilt(fy, 0.02 , 2 , dt, FILT$type , FILT$proto )
        vert = fy

        plot(t, vert, type='l')


        if(pickit)
          {
            Lv = locator()
          }
        else
          {
            Lv = list(x=c(WINDOWS$wins[[i]]$pix[2]-20*0.008, WINDOWS$wins[[i]]$pix[2]+20*0.008  ))
          }


        Wv = t>=Lv$x[1] &  t<=Lv$x[2]
        vpix = dt*(length(t[t<Lv$x[1]])+which.max(vert[Wv]))

        pixacoust = (length(t[t<La$x[1]])+which.max(acoust[Wa]))
        b1=pixacoust-125*preacoust
        pixvert = (length(t[t<Lv$x[1]])+which.max(vert[Wv]))
        b2=pixvert -(125*prevert)

        print(paste(sep=' ', i, SELDA[i], b1, b2,pixacoust, pixvert ))
        if(b1<=0)
          {
            
            N = 125*tacoust
            n = length(acoust)
            a2 = abs(b1)+1
            en = a2+N
            if(en> n) { en=n }
            ss = rep(NA, length=N)
            ss[a2:(en+a2-1)] =  vert[seq(from=1, to=en) ]
            MAT.NEacoust[,i] = ss

            
          }
        else
          {
            
            
            MAT.NEacoust[,i]= acoust[seq(from=b1, length=125*tacoust) ]
          }


        if(b2<=0)
          {
            N = 125*tvert
            n = length(vert)
            a2 = abs(b2)+1
            en = a2+N
            if(en> n) { en=n }
            ss = rep(NA, length=N)
            ss[a2:(en+a2-1)] =  vert[seq(from=1, to=en) ]
            MAT.NEvert[,i] = ss
          }
        else
          {
            
            
            MAT.NEvert[,i]= vert[seq(from=b2, length=125*tvert) ]
          }

        wins[[i]]$t = c(b1,b2)
        wins[[i]]$pix = dt*c(pixacoust, pixvert)


      }


    matplot(0.008*seq(0,125*tacoust-1), MAT.NEacoust, type='l', lty=1, col=1)
    matplot(0.008*seq(0,125*tvert-1), MAT.NEvert, type='l', lty=1, col=1)

    return(list(MAT.AC=MAT.NEacoust, MAT.V=MAT.NEvert, wins=wins, twin =c(tacoust,tvert) ))


  }
#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")
####
etna.PIX<-function(mSW, STA=seq(from=2, to=7), FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),
                   INTEG=FALSE, rot=FALSE, sfact=1, Pause=0, prev=prev  )
  {
###   pick windows for Etna DATA
### MY.etna.pix  = etna.PIX(ETA, STA=c(2:7), FV=FV, RMINST=FALSE,CINTEG=CINTEG, INTEG=FALSE)

    if(missing(STA))
      {     
        STA=seq(from=2, to=7)
      }
    if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }

    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    if(missing(Pause))
      {
        Pause = 0
      }
    
    if(missing(rot))
      {
        
        rot=FALSE
      }

    if(missing(prev))
      {
        
        prev=NULL
      }

    
    MYPIX = as.list(mSW)
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = STA
        COMP = ncomp
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        CINTEG=rep("FALSE", length(COMP))
        
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        
        dump.Nplot(GG, COMP=ncomp, RMINST=FALSE,  INTEG=FALSE, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
        
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        titname = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(titname)
        if(is.null(prev)==FALSE)
          {
            abline(v=prev[[1]], col=2)
            
          }
        if(Pause>0)
          {
            Sys.sleep(Pause)
          }
        else
          {
            L = locator()
            
            MYPIX[[i]] = L$x
            GG$PIX = L$x
            assign(mSW[i], GG)
          }
      }
    return(MYPIX)
  }
### source("/home/lees/Progs/R_stuff/stromb.R")


#################################
dump.Nstagath<-function(mSW, STA="KAC", COMP="Vertical", NUM=5, BEF=1, AFT=5, FV=NULL)
{
    if(missing(STA))
      {     
        STA="KAC"
      }
    if(missing(COMP))
      {     
        COMP="Vertical"
      }
    if(missing(BEF))
      {     
        BEF=1
      }
    if(missing(AFT))
      {     
        AFT=5
      }
    if(missing(NUM))
      {     
        NUM=5
      }

    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE))
      }
    
    kpic = 1
    KN = 0
    TSTRUC = as.list(seq(1,NUM) )
    
    for(i in 1:length(mSW))
      {
  
        
        GG = get(mSW[i])
        k = which(GG$stn==STA & GG$chaname==COMP)
        dt = GG$info$dt[k]
        T1 = GG$dat[,k]

                if(FV$ON==TRUE)
                  {
                    amp = T1
                    amp1 = butfilt(amp,FV$fl, FV$fh , dt, FV$type ,  FV$proto )
                    T1 = amp1
                  }
                

        
        ex = seq(from=0, by=dt, length=length(T1))
        pic = GG$PIX$t[GG$PIX$comp==k]
       if(is.null(pic[kpic]))
         {
           print(paste(sep=' ' , "no pics available", i, mSW[i]))
           next;

         }

        nx = floor((AFT+BEF)/dt)
        nb = floor(BEF/dt)
        na = floor(AFT/dt)

        m1 = floor(pic/dt)
        m2 =  length(T1) -  floor(pic/dt)
        
        if(nb>m1)
          {
            rxb = c( rep(NA, nb-m1), T1[ 1:m1])
          }
        else
          {
            rxb = T1[c((m1-nb):m1)]
          }
        
        if(na>m2)
          {
            rxa = c(T1[c(m1:length(T1))], rep(NA, na-m2-1))
          }
        else
          {
            rxa = T1[c(m1:(m1+na-1))]
          }


        TNEW = c(rxb, rxa)
        XNEW  = seq(from=0, by=dt, length=length( TNEW) )
       #  plot(XNEW,  TNEW)


        
       
        KN = KN +1
        Y = TNEW
        print(paste(sep=' ',"KN=", KN, "i=", i))
        # plot(ex[flag], Y, col=4)
        # locator()
        
        TSTRUC[[KN]] = list(Y=Y, x=XNEW, dt=dt, name=paste(sep=' ', mSW[i],STA,  COMP)  )
        if(KN>=NUM)
          {
            PLOT.LISTN(TSTRUC, N=KN)
            TSTRUC = as.list(seq(1,NUM) )
            KN = 0
            print(paste(sep=' ',"DONE KN=", KN))
            locator()
            # flab = readline(prompt="hit enter:")
            
          }
        

      }

        if(KN>0)
          {
            PLOT.LISTN(TSTRUC, N=KN)
            TSTRUC = as.list(seq(1,NUM) )
            KN = 0
            print(paste(sep=' ',"DONE KN=", KN))
            ## flab = readline(prompt="hit enter:")
            
          }
        

    
}
### source("/home/lees/Progs/R_stuff/stromb.R")


dump.NPIX<-function(mSW, STA=seq(from=2, to=7), FV=NULL, RMINST=FALSE, CINTEG=c(FALSE, TRUE, TRUE, TRUE),
                   INTEG=FALSE, rot=FALSE, sfact=1, Pause=0, prev=prev  )
  {
###   pick windows for Etna DATA
### MY.etna.pix  = etna.PIX(ETA, STA=c(2:7), FV=FV, RMINST=FALSE,CINTEG=CINTEG, INTEG=FALSE)

    if(missing(STA))
      {     
        STA=seq(from=2, to=7)
      }
    if(missing(sfact)) { sfact=1}
    if(missing(FV))
      {
        FV=list(ON=FALSE, fl=0.5, fh=1.0, type="LP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    if( missing(CINTEG))
      {
        CINTEG=c(FALSE, TRUE, TRUE, TRUE)
      }

    if(missing(INTEG))
      {
        
        INTEG=FALSE
      }
    if(missing(RMINST))
      {
        RMINST = FALSE
      }
    if(missing(Pause))
      {
        Pause = 0
      }
    
    if(missing(rot))
      {
        
        rot=FALSE
      }

    if(missing(prev))
      {
        
        prev=NULL
      }

    
    MYPIX = as.list(mSW)
    for(i in 1:length(mSW))
      {
        GG = get(mSW[i])
        ncomp = STA
        COMP = ncomp
        print(paste(sep=" ", i, mSW[i]))
        print(COMP)
        CINTEG=rep("FALSE", length(COMP))
        
        CINTEG[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        FV$vec =rep("TRUE", length(COMP))
        
        FV$vec[GG$chaname[COMP]=="Infrasonic"] = "FALSE"
        
        dump.Nplot(GG, COMP=ncomp, RMINST=FALSE,  INTEG=FALSE, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
        
        
        Gi = GG$info
        jd  = jday( Gi$yr[1], Gi$mo[1], Gi$dom[1])
        t = recdate(jd , Gi$hr[1], Gi$mn[1], Gi$sec[1]+Gi$msec[1]/1000+Gi$t1[1])
        titname = paste(sep="_", mSW[i], Gi$yr[1], Gi$mo[1], t$jday, t$hour, t$min, floor(t$sec), GG$CODE)
        title(titname)

        ###  plot existing picks if they are in structure
        if(!is.null(GG$PIX))
          {
            GG$PIX$comp
            p1 = (length(ncomp)-match( GG$PIX$comp, ncomp))/length(ncomp)
            p2 = p1 + 1/length(ncomp)
            segments(GG$PIX$t, p1, GG$PIX$t, p2, col=2)           
          }
        
        if(is.null(prev)==FALSE)
          {
            abline(v=prev[[1]], col=2)
            
          }
        
        L = locator(type='p', col=4)
        if(length(L$x)>=1)
          {
            y = L$y
            fy = length(ncomp)-floor(y*length(ncomp))
                 
            MYPIX[[i]] = list(comp=ncomp[fy], t=L$x)
            GG$PIX = MYPIX[[i]]
            assign(mSW[i], GG, env = .GlobalEnv)
          }
      }
    return(MYPIX)
  }

#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")
####
####

etna.Xtract<-function(mSW, STA=2, Wlen=30, FV=FV, sfact=1, Pause=0, PLT=FALSE )
  {
###   pick windows for Etna DATA
### 
    ##
    if(missing(STA))  {STA=2 ;}
    if(missing(sfact)) {sfact=1;}
    if(missing(Pause)) {Pause = 0 ; }
    if(missing(PLT)) {PLT=FALSE ;}
    if(missing(Wlen)) {Wlen = 30  ; }
    if(missing(FV))
      {
        FV=list(ON=TRUE, fl=1/50, fh=1/2, type="BP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    
    print(paste(sep=' ', STA, sfact, Pause, PLT, Wlen))
    
    for(i in 1:length(mSW))
      {
        
        GG = get(mSW[i])
        amp = GG$dat[,STA]
        dt = GG$info$dt[STA]
        Mlen = Wlen/dt
       
        tim = dt*seq(from=0, length=length(amp))
        
        NUMP = (length(GG$PIX)/2)
        
        klen = Mlen

        JMAT = matrix(NA, nrow=klen, ncol=NUMP)
        IDS =  rep("",NUMP)
        TIMS =  rep(0,NUMP)
        
        for(kpix in 1:NUMP)
          {
            j = 2*(kpix-1)+1
            
            WIN = c(GG$PIX[j], GG$PIX[j+1])
            
            fy = butfilt(amp,FL, FH , dt, "BP" , "BU" )
            
            temp = fy[tim>=WIN[1]&tim<=WIN[2]]

            wmax = which.max(temp)
            tmax = min(tim[tim>=WIN[1]&tim<=WIN[2]])+wmax*dt

            K1 = (tmax-Wlen/2)/dt
            Ks = seq(from=K1, length=klen)
            
            tstart  = tmax-Wlen/2
            NWIN = c(tmax-Wlen/2, tmax+Wlen/2)

            ## temp = fy[tim>=NWIN[1]&tim<=NWIN[2]]

            ncomp = STA
            COMP = ncomp

            temp = amp[Ks]
            LT = length(temp)

            
            print(paste(sep=' ', kpix, LT, klen, tstart))

            
            JMAT[, kpix] = temp
 ###  dump.Nplot(GG, COMP=ncomp, WIN=NWIN, RMINST=FALSE,  INTEG=FALSE, FILT=FV , rot=FALSE, CINTEG=CINTEG, sfact=sfact)
            
            Gi = GG$info
            jd  = jday( Gi$yr[STA], Gi$mo[STA], Gi$dom[STA])
            t = recdate(jd , Gi$hr[STA], Gi$mn[STA],
              Gi$sec[STA]+Gi$off[STA]+Gi$msec[STA]/1000+Gi$t1[STA])
            titname = paste(sep="_", mSW[i], Gi$yr[STA], t$jday, t$hour, t$min,
              floor(t$sec), format.default(tstart, digits=5))
            
            IDS[kpix] = titname
            TIMS[kpix] = t$jday+t$hour/(24)+ t$min/(24*60)+(t$sec+tstart)/(24*60*60)

            
           #  title(titname)
           #  if(Pause>0)
            #   {
            #     Sys.sleep(Pause)
            #   }
           #  else
           #    {
                #  L = locator(1)
           #    }
            
          }
      }

    if(PLT==TRUE)  PLOT.MATN(JMAT, dt=dt, notes=IDS)
    
    return(list(JMAT=JMAT, IDS=IDS, TIMS=TIMS) )

  }
###
##############################################################################3
### source("/home/lees/Progs/R_stuff/stromb.R")

etna.Xtract3<-function(mSW, STA=c(2,3,4),  ORD=ORD , Wlen=30, FV=FV, sfact=1, Pause=0, PLT=FALSE )
  {
###   pick windows for Etna DATA
    
###   etna.Xtract3(DA3.LI, STA=c(2,3,4), ORD=TRUE , Wlen=30, FV=FV, PLT=TRUE)

    ##
    if(missing(STA))  {STA= c(2,3,4);}
    if(missing(sfact)) {sfact=1;}
    if(missing(Pause)) {Pause = 0 ; }
    if(missing(PLT)) {PLT=FALSE ;}
    if(missing(Wlen)) {Wlen = 30  ; }
    if(missing(ORD))
      { ORD=FALSE }

    
    if(missing(FV))
      {
        FV=list(ON=TRUE, fl=1/50, fh=1/2, type="BP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    
    print(paste(sep=' ', STA, sfact, Pause, PLT, Wlen))



    
    for(i in 1:length(mSW))
      {
        
        GG = get(mSW[i])
        amp = GG$dat[,STA[1]]
        dt = GG$info$dt[STA[1]]
        Mlen = Wlen/dt
       
        tim = dt*seq(from=0, length=length(amp))
        fy = butfilt(amp,FL, FH , dt, "BP" , "BU" )
        
        NUMP = (length(GG$PIX)/2)
        
        klen = Mlen

        ##  JMAT = matrix(NA, nrow=klen, ncol=NUMP)
        ## IDS =  rep("",NUMP)
        ## TIMS =  rep(0,NUMP)

        PANGS = as.list(1:NUMP)
        
        if(ORD==TRUE)
          {
            ord = order(GG$CLUST)
          }
        else
          {
            ord = 1:NUMP
          }
        for(indpix in 1:NUMP)
          {

            kpix = ord[indpix]
            clu =   GG$CLUST[kpix]
            
            j = 2*(kpix-1)+1
            
            WIN = c(GG$PIX[j], GG$PIX[j+1])
            
            temp = fy[tim>=WIN[1]&tim<=WIN[2]]

            wmax = which.max(temp)
            tmax = min(tim[tim>=WIN[1]&tim<=WIN[2]])+wmax*dt

            K1 = (tmax-Wlen/2)/dt
            Ks = seq(from=K1, length=klen)
            
            tstart  = tmax-Wlen/2
            NWIN = c(tmax-Wlen/2, tmax+Wlen/2)

            ## temp = fy[tim>=NWIN[1]&tim<=NWIN[2]]

            ncomp = STA
            COMP = ncomp

            temp = amp[Ks]

            Gi = GG$info
            jd  = jday( Gi$yr[STA[1]], Gi$mo[STA[1]], Gi$dom[STA[1]])
            t = recdate(jd , Gi$hr[STA[1]], Gi$mn[STA[1]],
              Gi$sec[STA[1]]+Gi$off[STA[1]]+Gi$msec[STA[1]]/1000+Gi$t1[STA[1]])
            titname = paste(sep="_", mSW[i], Gi$yr[STA[1]], t$jday, t$hour, t$min,
              floor(t$sec), format.default(tstart, digits=5))
            
            amp1 = GG$dat[Ks,STA[1]]
            amp2 = GG$dat[Ks,STA[2]]
            amp3 = GG$dat[Ks,STA[3]]

            JMAT = cbind(amp1, amp2, amp3)
            fy1 = butfilt(amp1,FL, FH , dt, "BP" , "BU" )
            fy2 = butfilt(amp2,FL, FH , dt, "BP" , "BU" )
            fy3 = butfilt(amp3,FL, FH , dt, "BP" , "BU" )
            
            FMAT = cbind(fy1, fy2, fy3)
            labs=c("Vert", "North", "East")
            
            if(PLT==TRUE)
              {
                dev.set(2)
                
                PLOT.MATN(JMAT, dt=dt , COL=rep(clu, 3))
                title(paste(sep=' ',   kpix,  titname,'in', clu  ))
                
                dnext()
                PLOT.MATN(FMAT, dt=dt, COL=rep(clu, 3) )
                 title(paste(sep=' ',   kpix,  titname,'in', clu  ))

                nn = length(FMAT[,1])
                dcols = nn/5
                cols = rep(1,length=nn)
                for(jj in 1:5)
                  {
                    j1 = (jj-1)*dcols+1
                    cols[j1:(j1+dcols-1) ] = jj+1
                
                  }

                E1 = dt*seq(0,length=nn)
                N1 = rep(1,nn)
                segments(E1[1:(nn-1)],N1[1:(nn-1)],E1[2:nn],N1[2:nn], col=cols, lwd=2)
                N1 = rep(0,nn)
                segments(E1[1:(nn-1)],N1[1:(nn-1)],E1[2:nn],N1[2:nn], col=cols, lwd=2)

                
                locator()
                 dev.set(2)
                pmotion(FMAT, 3, 2 , labs=labs, COL=5)
                PML = locator()
                if(length(PML$x) == 2)
                  {
                    
                    pang = atan2(PML$y[2]-PML$y[1], PML$x[2]-PML$x[1])
                    
                    PANGS[[indpix]] = list(ang=pang)
                  }
                dnext()
                 locator()
              }
            
           #  title(titname)
           #  if(Pause>0)
            #   {
            #     Sys.sleep(Pause)
            #   }
           #  else
           #    {
                #  L = locator(1)
           #    }
            
          }
      }

   
    
    return(PANGS)

  }

#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")

etna.Xtract4<-function(mSW, STA=c(2,3,4),  ORD=FALSE , Wlen=30, FV=FV, sfact=1, Pause=0, PLT=FALSE )
  {
###   pick windows for Etna DATA
    
###   etna.Xtract3(DA3.LI, STA=c(2,3,4), ORD=TRUE , Wlen=30, FV=FV, PLT=TRUE)

    ##
    if(missing(STA))  {STA= c(2,3,4);}
    if(missing(sfact)) {sfact=1;}
    if(missing(Pause)) {Pause = 0 ; }
    if(missing(PLT)) {PLT=FALSE ;}
    if(missing(Wlen)) {Wlen = 30  ; }
    if(missing(ORD))
      {
        ORD=FALSE
       
      }

    
    if(missing(FV))
      {
        FV=list(ON=TRUE, fl=1/50, fh=1/2, type="BP", proto="BU", vec=c(FALSE, TRUE, TRUE, TRUE))
      }
    
    print(paste(sep=' ', STA, sfact, Pause, PLT, Wlen))



    
    for(i in 1:length(mSW))
      {
        
        GG = get(mSW[i])
        amp = GG$dat[,STA[1]]
        dt = GG$info$dt[STA[1]]
        Mlen = Wlen/dt
       
        tim = dt*seq(from=0, length=length(amp))
        fy = butfilt(amp,FL, FH , dt, "BP" , "BU" )
        
        NUMP = (length(GG$PIX)/2)
        
        klen = Mlen

        ##  JMAT = matrix(NA, nrow=klen, ncol=NUMP)
        ## IDS =  rep("",NUMP)
        ## TIMS =  rep(0,NUMP)

        ##  PANGS = as.list(1:NUMP)
        DTS  =  rep(NA, NUMP)
        Pic1 = rep(NA, NUMP)
        Pic2 = rep(NA, NUMP)
        LABP = rep(NA, NUMP)
        KPIX = rep(NA, NUMP)
        
        
        if(ORD==TRUE)
          {
            ord = order(GG$CLUST)
          }
        else
          {
            ord = 1:NUMP
          }

        print(ord)
        
        for(indpix in 1:NUMP)
          {

            kpix = ord[indpix]
            clu =   GG$CLUST[kpix]
            
            j = 2*(kpix-1)+1
            
            WIN = c(GG$PIX[j], GG$PIX[j+1])
            
            temp = fy[tim>=WIN[1]&tim<=WIN[2]]

            wmax = which.max(temp)
            tmax = min(tim[tim>=WIN[1]&tim<=WIN[2]])+wmax*dt

            K1 = (tmax-Wlen/2)/dt
            Ks = seq(from=K1, length=klen)
            
            tstart  = tmax-Wlen/2
            NWIN = c(tmax-Wlen/2, tmax+Wlen/2)

            ## temp = fy[tim>=NWIN[1]&tim<=NWIN[2]]

            ncomp = STA
            COMP = ncomp

            temp = amp[Ks]

            Gi = GG$info
            jd  = jday( Gi$yr[STA[1]], Gi$mo[STA[1]], Gi$dom[STA[1]])
            t = recdate(jd , Gi$hr[STA[1]], Gi$mn[STA[1]],
              Gi$sec[STA[1]]+Gi$off[STA[1]]+Gi$msec[STA[1]]/1000+Gi$t1[STA[1]])
            titname = paste(sep="_", mSW[i], Gi$yr[STA[1]], t$jday, t$hour, t$min,
              floor(t$sec), format.default(tstart, digits=5))

            
            KPIX[indpix] = kpix
            LABP[indpix] = titname
            
            JMAT = matrix(ncol=length(STA), nrow=length(Ks) )
            KNOTES = rep(" ", length(STA))
            IN = rep(TRUE, length(STA))
            

              
            for(jj in 1:length(STA))
              {
                amp1 = GG$dat[Ks,STA[jj]]

                yna = length(amp1[is.na(amp1)])
                if(yna>0)
                  {
                    IN[jj] = FALSE
                    next;
                    
                  }

                if(FV$ON==TRUE)
                  {
                    amp = amp1
                    amp1 = butfilt(amp,FV$fl, FV$fh , dt, FV$type ,  FV$proto )
                  }
                
                JMAT[,jj] = amp1
                KNOTES[jj] = paste(sep=' ', GG$stn[STA[jj]], GG$comp[STA[jj]])
                
              }

            if(PLT==TRUE)
              {
                PLOT.MATN(JMAT[,IN], dt=dt, notes=KNOTES)
                
                L = locator()
                if( length(L$x) >=2)
                  {
                    PLOT.MATN(JMAT[,IN], WIN=c(L$x[length(L$x)-1], L$x[length(L$x)]) , dt=dt, notes=KNOTES)
                    
                    Y = locator()
                    
                    if( length(Y$x) >=2)
                      {
                        DTS[indpix] = Y$x[2]-Y$x[1]
                        
                        Pic1[indpix] = Y$x[1]
                        Pic2[indpix] = Y$x[2]
                        
                        print(paste(sep=' ',indpix, DTS[indpix]))
                      }
                  }
                
              }
            
            
            
          }
      }

   
    
    return(list(DTS=DTS, Pic1=Pic1, Pic2=Pic2, KPIX=KPIX, LAB=LABP, ord=ord) )

  }


#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")

### source("/home/lees/Progs/R_stuff/particle_motion.R")

####
etna.test<-function(SMAT)
  {


     print(paste(sep=' ',length(names(SMAT))))
     print(paste(sep=' ',names(SMAT)))
        print(paste(sep=' ',SMAT[[2]]))
  

    
   if(length(names(SMAT))==2)
      {
        SMAT = SMAT[[1]]
        IDS = SMAT[[2]]
        
        length(SMAT[[2]])
        
        print(paste(sep=' ', names(SMAT), length(names(SMAT)), length(SMAT[[2]])))
        
      }
    else
      {
        djm = dim(SMAT)
        IDS = seq(from=1, length=djm[2])
        
      }
  
  }
#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")


etna.clust1<-function(SMAT, FH=FH, dt=dt, KOR=KOR, KCLUST=temp, ORD=FALSE, DECON=FALSE, PRE=NULL, TIT="", GROUPS=3)
  {
    ### plot seismograms in matrix, after filtering and clustering
    ## SMAT is a matrix of seismograms
    ## FH is a vector of high cutoff freqs in Hz
    ## dt = sample frequency
    ## KOR = previous correlation matrix (if present, correlation matrix is not re-calculated)

    if(missing(FH)) { FH = 1/3   }
    if(missing(dt)) { dt = 0.008 }
    if(missing(ORD)) { ORD=FALSE }
    if(missing(DECON)) { DECON=FALSE }
    if(missing(KCLUST)) { KCLUST="fanny" }
    if(missing(PRE)) { PRE = NULL }
    if(missing(TIT)) { TIT = "" }
    if(missing(GROUPS)) { GROUPS = 3 }

   if(length(names(SMAT))==3)
      {
        IDS = SMAT[[2]]
        TIMS = SMAT[[3]]
        SMAT = SMAT[[1]]
        
      }
    else
      {
        djm = dim(SMAT)
        IDS = seq(from=1, length=djm[2])
        
      }

    if(exists("Kal")==FALSE)
      {

        Kal = PreSet.Instr()
        ### Calibnew = c(3,1.0, 0.4882812 )
        Calibnew = c(1,1.0, 0.0 )

      }

    
    FL = 1/50
    mast = 3
    FM = SMAT
    djm = dim(FM)
    
    HALF.low = floor(djm[1]/2)-floor(djm[1]/3)
    HALF.up = floor(djm[1]/2)+floor(djm[1]/3)
    
    print(paste(sep=' ', "HALF.low HALF.up=" , HALF.low, HALF.up))
    
    for(j in FH)
      {
	for(i in 1:djm[2])
          {
            amp = SMAT[,i]
            if(DECON==TRUE)
              {
                dy  = deconinst(amp, dt, Kal,1, Calibnew, waterlevel=1.e-8)
                cy =   trapz(dy, dt)
              }
            else
              {
                cy = amp
                
              }
            fy = butfilt(cy,FL, j , dt, "BP" , "BU" )
            
            FM[,i] = fy
            ##plot(fy)
            ## locator(1)
            ## Sys.sleep(.5)
          }
        
        docore  = FALSE
        if(missing(KOR))
          { 
            print("calculating the X-correlation matrix")
            docore  = TRUE
            KOR = JXCOR(FM[HALF.low:HALF.up,], dt, PLOT=FALSE, PIC=FALSE)
          }
        knote =  KOR$COR[mast,]
        
        knote[1:(mast-1) ] = KOR$COR[ 1:(mast-1) ,mast]
        
        
        notes = paste("",format.default(knote, digits=3))
        
        dmat = 1-KOR$COR


        if(is.character(KCLUST))
          {
            if(KCLUST=="fanny")
              {
                fan4 = fanny(dmat, GROUPS)
              }
            if(KCLUST=="pam")
              {
                fan4 = pam(dmat, GROUPS)
              }
            if(KCLUST=="done")
              {
                fan4 = PRE$fan
                temp = as.character(PRE$fan$call)
                KCLUST = temp[1]
              }
            
          }
       
        
       ## fan4 = pam(dmat, 4)
        ##  plot(fan4)

          a = dimnames(fan4$silinfo$widths)
          tags = as.numeric(a[[1]])

        
        ofan4 = order(fan4$clustering)
        
        ##  PLOT.MATN(FM, dt=0.008, notes=notes, COL=fan4$clustering)

        print(IDS)
        
        if(ORD==TRUE)
          {
            nm = paste(sep=' ', tags, IDS[tags])
            PLOT.MATN(FM[,tags], dt=dt, notes=nm, COL=fan4$clustering[tags])
          }
        else
          {
            nm = paste(sep=' ', tags, IDS)
            PLOT.MATN(FM, dt=dt, notes=nm, COL=fan4$clustering)
            
          }

        if(docore)
          {
            abline(v=c(HALF.low*dt, HALF.up*dt), col=5)
          }

        
        title(paste(sep=' ' , format.default(j, digits=3) , 'hz',
                    format.default(1/j, digits=3), 'sec', 'use:', KCLUST, TIT))
        # print("Click in active figure to continue")
        # locator(1)
        
        ###dev.set(dev.next())
        ###plot(TIMS, rep(1,length(TIMS)), type='h', col=fan4$clustering)
   
      }

 
    
    return(KOR=KOR, fan=fan4, KCLUST=KCLUST, tags=tags)

  }
#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")

#### DA1.CLU  = etna.clust1(DA1.JM, , FH=1/3, dt=0.008, ORD=TRUE)
#### DA3.CLU  = etna.clust1(DA3.JM, , FH=1/2.5, dt=0.008, ORD=TRUE, DECON=FALSE)

etna.exam<-function(amp, dt, flow = 1/50,  fhigh = 1/5)
  {

    if(missing(flow) )  { flow = 1/50 }
     if(missing(fhigh) )  {fhigh = 1/5}

    
    amp = amp-mean(amp)

    amp = applytaper(amp)
    fa = butfilt(amp,flow, fhigh , dt, "BP" , "BU" )

    dy  = deconinst(amp, dt, Kal, 1, Calibnew, waterlevel=1.e-8)
    dy = dy-mean(dy)
    dy = applytaper(dy)

    cy =   trapz(dy, dt)
    cy = cy - mean(cy)
    cy = applytaper(cy)

    fiv = butfilt(dy, flow, fhigh , dt, "BP" , "BU" )
    fiv = fiv-mean(fiv)
    fiv = applytaper(fiv)

    fy = butfilt(cy, flow, fhigh , dt, "BP" , "BU" )
    fy = fy - mean(fy)
    fy = applytaper(fy)	

    PLOT.MATN(cbind(amp, fa,  dy, cy, fiv, fy), dt=dt, notes=c("amp", "filt amp", "Vel", "Disp", "filt dec V", "filt disp"))



  }
#####################################################
### source("/home/lees/Progs/R_stuff/stromb.R")




###  etna.3comp(DA3.JMV1, DA3.JMN1,  DA3.JME1)

etna.3comp<-function(DA1, DA2, DA3)
  {
    
    inotes = c("vert", "north", "east")
    dj = dim(DA1$JMAT)
    n = dj[2]
    print(paste(sep=' ', n))
    
    for(i in 1:n)
      {
        notes=c(paste(sep=' ',inotes[1], DA1$IDS[i]), paste(sep=' ',inotes[2], DA2$IDS[i]), paste(sep=' ',inotes[3], DA3$IDS[i]))
        PLOT.MATN(cbind(DA1$JMAT[,i], DA2$JMAT[,i],  DA3$JMAT[,i]), dt=dt, notes=notes)
        locator()
        
      }

  }



### source("/home/lees/Progs/R_stuff/stromb.R")
