
###########  source("/home/lees/Progs/R_stuff/temp.R")

checkpix<-function(KH, ZGH)
  {

    dev.set(2)
    PLOT.SEISN(KH, notes=KH$KNOTES, WIN=NULL)

    dev.set(3)
    
    deltat = KH$dt[1]
    iny =  KH$JSTR[[1]]

    for(i in 1:length(ZGH$JJ$J) )
      {

        M = 8
        N = length(y1)
        T1=RATP$eye;
        O1=2; 
        O2=0.2; 
        W=3
    
        k1 = (ZGH$JJ$J[i]-O1/deltat-W/deltat) 
        k2 = (ZGH$JJ$L[i]+O2/deltat+W/deltat) 
        if(k1<1) k1 = 1
        if(k2>length(iny)) k2 = length(iny)
        
        y1 = iny[k1:k2]

        y1 = y1-mean(y1)
        plot.ts(y1)
        title(main=i)
        dev.set(2)
        vline(ZGH$JJ$J[i]*deltat, COL=2, per=-.2, LAB=i)
        vline(ZGH$JJ$L[i]*deltat, COL=3, per=-.2, LAB=i)

        dev.set(3)
        locator(1)
      }

  }
###########  source("/home/lees/Progs/R_stuff/temp.R")

########### checkpix(KH,ZGH)
########### detpix(KH,ZGH)
###########


###########  source("/home/lees/Progs/R_stuff/temp.R")

detpix<-function(KH, ZGH)
  {

    deltat = KH$dt[1]
    iny =  KH$JSTR[[1]]

    JET = length(ZGH$JJ$J)

    for(i in 1:length(ZGH$JJ$J) )
      {
        print(paste(sep = ' ' , "###############  working on ", i))
        ##  winmark(ZGH$JJ$J[i]*KH$dt[1],  ZGH$JJ$L[i]*KH$dt[1], col=4)
        M = 8
        O1=2; 
        O2=0.2; 
        W=2
    
        k1 = (ZGH$JJ$J[i]-O1/deltat-W/deltat) 
        k2 = (ZGH$JJ$L[i]+O2/deltat+W/deltat) 
        if(k1<1) k1 = 1
        if(k2>length(iny)) k2 = length(iny)
        print(paste(sep=' ',i,  "index:", k1, k2))
        
        y1 = iny[k1:k2]
        N = length(y1)
        y1 = y1-mean(y1)
        fy = butfilt(y1 , .7 ,20 , deltat , "BP" , "BU" )
        fy = fy-mean(fy)

        RATP = PSTLTcurve(fy, dt=deltat, fwlen=ifrwd,  bwlen=ibkwd, perc = 0.1, stretch=1000 , MED=77, PLOT=TRUE)
        T1=RATP$eye;
        locator(1)

    
        aout = rep(0, N)


        ary = .C("CALL_ARAIC", as.double(fy), as.integer(N),as.double(deltat), as.integer(M), as.integer(T1), as.double(O1), as.double(O2), as.double(W), as.double(aout)) 

        
        
        one()
        kaic = ary[[9]]
        kaic[kaic==0]=NA
        ###  plot.ts(kaic)

        ikaic = which.min(kaic)
        if(length( ikaic)<1)
          {
            next


          }

        xkaic = 1:length(kaic)
        plot(xkaic,kaic, type='l')
        
        lm1 = lm(kaic ~ cbind(xkaic, xkaic^2, xkaic^3, xkaic^4))
        lines(xkaic[!is.na(kaic)], lm1$fitted.values, col=2)

        vline(c(RATP$eye, RATP$ind, RATP$mix), per=-1,  LAB=c("eye", "ind", "mix"), COL=c(2,3,5))
        vline(which.min(kaic), COL=rgb(.4,.8,1) )
        
        locator(1)

        one()
        ##  plot.ts(y1)
        plot.ts(y1, type='l')

        vline(c(RATP$eye, RATP$ind, RATP$mix), per=-0.4,  LAB=c("eye", "ind", "mix"), COL=c(2,3,5), lwd=2)

        vline(which.min(kaic), COL=rgb(.4,.8,1), lwd=2 )

        z1 = y1[(T1+O2/deltat):(T1+O2/deltat+W/deltat)]
        z1 = z1 - mean(z1)
        sig1 = sum( z1^2 )

        z2 = y1[(T1-O1/deltat-W/deltat):(T1-O1/deltat)]
        z2 = z2-mean(z2)
        nois1 = sum( z2^2 )
        SNR = sig1/nois1

        winmark(T1+O2/deltat,T1+O2/deltat+W/deltat,col=4)
        winmark(T1-O1/deltat-W/deltat-O1/deltat, T1-O1/deltat-O1/deltat,col=5)
        lines(y1)

        title(main=paste(sep=' ',format.default(RATP$SNR, digits=5), format.default(SNR, digits=5))  )
        locator(1)

      }

  }
#########################################################

###########  source("/home/lees/Progs/R_stuff/temp.R")


detPpix<-function(KH, ZGH, M = 8, O1=2, O2=0.2, W=2,    flo=.02, fhi=20)
  {

    if(missing(M)) {M = 8  }
    if(missing(O1)) { O1=2 }
    if(missing(O2)) { O2=0.2 }
    if(missing(W)) {  W=2 }
    if(missing(flo)) { flo=0.02 }
    if(missing(fhi)) { fhi= 10.0 }

    deltat = KH$dt[1]
    iny =  KH$JSTR[[1]]

    JET = rep(NA, length(ZGH$JJ$J))

    for(i in 1:length(ZGH$JJ$J) )
      {
       ## print(paste(sep = ' ' , "###############  working on ", i))
        ##  winmark(ZGH$JJ$J[i]*KH$dt[1],  ZGH$JJ$L[i]*KH$dt[1], col=4)
        
    
        k1 = (ZGH$JJ$J[i]-O1/deltat-W/deltat) 
        k2 = (ZGH$JJ$L[i]+O2/deltat+W/deltat) 
        if(k1<1) k1 = 1
        if(k2>length(iny)) k2 = length(iny)
        ##  print(paste(sep=' ',i,  "index:", k1, k2))
        
        y1 = iny[k1:k2]
        N = length(y1)
        y1 = y1-mean(y1)
        fy = butfilt(y1 , flo ,fhi , deltat , "BP" , "BU" )
        fy = fy-mean(fy)

        RATP = PSTLTcurve(fy, dt=deltat, fwlen=ifrwd,  bwlen=ibkwd, perc = 0.1, stretch=1000 , MED=77, PLOT=FALSE)
        T1=RATP$eye;
       
    
        aout = rep(0, N)


        ary = .C("CALL_ARAIC", as.double(fy), as.integer(N),as.double(deltat), as.integer(M), as.integer(T1), as.double(O1), as.double(O2), as.double(W), as.double(aout)) 

        
        kaic = ary[[9]]
        kaic[kaic==0]=NA
        ###  plot.ts(kaic)

        ikaic = which.min(kaic)
        if(length( ikaic)<1)
          {
            next
          }


        ###  xkaic = 1:length(kaic)
        ip = ikaic
        JET[i] = k1+ip-1


        
      }
    return(JET)
    ### vline(IAIC*deltat, per=-.3, COL=2)

  }

#########################################################

###########  source("/home/lees/Progs/R_stuff/temp.R")
