##  source("/home/lees/Progs/R_stuff/volc.R")
##  depends on
##   source("/home/lees/Progs/R_stuff/SUBS.R")



rcirc<-function(x,y,xc,yc,r)
{

return( (x-xc)^2 + (y-yc)^2 - r^2) 
}

vdistF<-function(file)
  {
#  calculate the points along the arc
    # where volcanoes are projected onto a straight line
    # determine the stats of the distances between the
    # points
 #   VKK=vdist1("/home/lees/Site/World/volc_Kurile_KAM")
    #  input file is from the output of geotouch points file
    
    vkam=scan(file=file,
      list(nm="", lat=0, lon=0, z=0, kat=0,
           b1=0,a2=0, a3=0, a4=0, a5=0, a6=0))
    
    A = vdist1(vkam)
    
    return(A)
  }
##########################################
vdist1<-function(vkam, MAP=worldmap, maponly=FALSE )
  {
     if(missing(MAP)) { MAP = worldmap }
     if(missing(maponly)) {maponly=FALSE }


     
#  calculate the points along the arc
    # where volcanoes are projected onto a straight line
    # determine the stats of the distances between the
    # points
    screens(2)
    dev.set(2)
    par(mfrow=c(1,1))
  ##  nf <- layout(matrix(c(1,1,2,3),2,2,byrow=TRUE), heights=c(3,1), widths=c(2,2), TRUE)
  ##  layout.show(nf)


    lat = vkam$lat
    lon = vkam$lon

    ##  convert to km in X and Y
    CENLAT = mean(lat)
    CENLON = mean(lon)

    
   ## PKM = gclc( CENLAT , CENLON ,   lat,  lon )


    setPROJ(type=2, LAT0=CENLAT, LON0=CENLON )

    PKM  = GLOB.XY(lat, lon)

    EX = PKM$x
    WHY = PKM$y
    ZEE = vkam$z
    KAT = vkam$kat

    
    flgkam = KAT==57
    regkam=lm(WHY[flgkam] ~ EX[flgkam])
    b = regkam$coefficients[1]
    m = regkam$coefficients[2]
    xr = range(EX)
    yr =c(xr[1]*m+b, xr[2]*m+b)
    L = c(xr[2]-xr[1], yr[2]-yr[1])
    mL = sqrt( (L[1])^2 + (L[2])^2)

    B = cbind(EX[flgkam]-xr[1],WHY[flgkam]-yr[1])
    mB = sqrt( B[,1]^2 + B[,2]^2)

    ##  d=abs(B) * cos(alpha)
    ##  cos(alpha) = L dot B / (abs(B)*Bbs(L))
    ## so, d =  L dot B / abs(L)
    ## L = line vector (xr,yr)

    d = (L[1]*B[,1]+L[2]*B[,2])/mL
    P = cbind(xr[1]+d*L[1]/mL, yr[1]+d*L[2]/mL )
    
    ##points(P[,1], P[,2], pch=4, col=3)

    plot(c(EX, xr), c(WHY, yr) , type='n', xlab="Lon", ylab="Lat", asp=TRUE)
    points(EX[flgkam], WHY[flgkam], pch=2, col=2)
    points(EX[!flgkam], WHY[!flgkam], pch=5, col=4)
    ### PROJmap(WORLD, LAT=CENLAT, LON=CENLON, ADD=TRUE, ASP=TRUE)

###   map('world', add=TRUE)
###   plotleesmap(worldmap, add=FALSE)
###   points(ALLVOL$lon, ALLVOL$lat, col=2)
    wrldxy  = GLOB.XY(MAP$POINTS$lat, MAP$POINTS$lon)
    MAP$POINTS$x = wrldxy$x
    MAP$POINTS$y = wrldxy$y

    LY = range(lat)
     LX = range(lon)
     
    plotleesmapXY(MAP, LIM=c(LX[1], LY[1], LX[2], LY[2]),  add=TRUE)
    
    if(maponly==TRUE) return()

     
    ##  title("Kurile-Kamchatka Volcanoes")
    abline(regkam)
   ##   D = distaz( P[1,2], P[1,1],P[,2], P[,1])

    segments(P[,1], P[,2], EX[flgkam], WHY[flgkam])
    
    
   ##  Dkm = 6371*D$del*pi/180

    Dkm = hypot(P[1,2], P[1,1],P[,2], P[,1]) 
    dd = diff(sort(Dkm))

    dev.set(3)
    par(mfrow=c(1,2))
   ## hist(dd, breaks=seq(0,max(dd), by=25), main="Volcano Distances, Km")
     hist(dd, main="Inter-Volcano Distances, Km")
    boxplot(dd)

    return(list(lat=lat, lon=lon, x=EX, y=WHY, z=ZEE,
                CENLAT=CENLAT, CENLON=CENLON,
                kat=KAT, flgkam=flgkam  , reg=regkam, Dkm=Dkm))

  }
##########################################################
##  source("/home/lees/Progs/R_stuff/volc.R")

vproj<-function(vkam)
  {

    EX = vkam$x
    WHY = vkam$y
    ZEE = vkam$z
    KAT = vkam$kat
    CENLAT = vkam$CENLAT
    CENLON =vkam$CENLON
    flgkam = vkam$flgkam
    
    plot(c(EX), c(WHY) , type='n', xlab="Lon", ylab="Lat")
    points(EX[flgkam], WHY[flgkam], pch=2, col=2)
    points(EX[!flgkam], WHY[!flgkam], pch=5, col=4)
    PROJmap(WORLD, LAT=CENLAT, LON=CENLON, ADD=TRUE, ASP=TRUE)
  }
##########################################################
##  source("/home/lees/Progs/R_stuff/volc.R")

##########################################################
vdist2<-function(M)
  {

   nf <- layout(matrix(c(1,1,2,3),2,2,byrow=TRUE), heights=c(3,1), widths=c(2,2), TRUE)
    layout.show(nf)


    lat = M$lat
    lon = M$lon



    EX = M$x
    WHY = M$y
    ZEE = M$z
    KAT = M$kat
   
    kats = unique(KAT)
   KOL = match(KAT  , unique(KAT))

   
    flgkam = (KAT==57)
   
    regkam=lm(WHY[flgkam] ~ EX[flgkam])
    b = regkam$coefficients[1]
    m = regkam$coefficients[2]
    xr = range(EX)
    yr =c(xr[1]*m+b, xr[2]*m+b)
    L = c(xr[2]-xr[1], yr[2]-yr[1])
    mL = sqrt( (L[1])^2 + (L[2])^2)

    B = cbind(EX[flgkam]-xr[1],WHY[flgkam]-yr[1])
    mB = sqrt( B[,1]^2 + B[,2]^2)

    ##  d=abs(B) * cos(alpha)
    ##  cos(alpha) = L dot B / (abs(B)*Bbs(L))
    ## so, d =  L dot B / abs(L)
    ## L = line vector (xr,yr)

    d = (L[1]*B[,1]+L[2]*B[,2])/mL
    P = cbind(xr[1]+d*L[1]/mL, yr[1]+d*L[2]/mL )
    
    points(P[,1], P[,2], pch=4, col=3)

    
    
    plot(c(EX, xr), c(WHY, yr) , type='p', col=KOL, xlab="Lon", ylab="Lat")
   ## 
   
    points(EX[flgkam], WHY[flgkam], pch=2, col=2)
    points(EX[!flgkam], WHY[!flgkam], pch=5, col=4)
    ##  title("Kurile-Kamchatka Volcanoes")
    abline(regkam)
     abline(h=0)
   
   ##   D = distaz( P[1,2], P[1,1],P[,2], P[,1]) 
    
   ##  Dkm = 6371*D$del*pi/180

    Dkm = hypot(P[1,2], P[1,1],P[,2], P[,1]) 
    
   
    hist(diff(sort(Dkm)))
    boxplot(diff(sort(Dkm)))

  }
##  source("/home/lees/Progs/R_stuff/volc.R")

##########################################################

vpicker<-function(ALLVOL, MAP=worldmap, cenlon=0)
{
  if(missing(MAP)) { MAP = worldmap }
  if(missing(cenlon)) { cenlon=0 }

  
  #  pick out a subset of lat-lon volcano pairs
  #  get data base from
  #  ALLVOL = scan(file="/home/lees/Site/World/v.out", list(name="", lat=0, lon=0, z=0, kat=0,du="", t=0))

 #plot(ALLVOL$lon, ALLVOL$lat)

 #map('world', add=TRUE)

##  GENmap(WORLD, ADD=TRUE)

  if(cenlon>0)
    {
      MAP$POINTS$x = fmod(MAP$POINTS$lon, 360)
      MAP$POINTS$y = MAP$POINTS$lat
      ALLVOL$lon =  fmod(ALLVOL$lon, 360)
      plotleesmapXY(MAP, add=FALSE)
    }
  else
    {
      plotleesmap(MAP, add=FALSE)
    }
  
  points(ALLVOL$lon, ALLVOL$lat, col=2)

  POL=locator(type='o', col=4)

  POL2 = list(x=c(POL$x, POL$x[1]), y=c(POL$y, POL$y[1]))
     
  pic = inpoly(ALLVOL$lon, ALLVOL$lat,   POL2)
  sub = pic==1
  points(ALLVOL$lon[sub], ALLVOL$lat[sub], pch=2, col=2)
  
  return(list(name="", lat=ALLVOL$lat[sub], lon=ALLVOL$lon[sub], z=ALLVOL$z[sub], kat=ALLVOL$kat[sub] ,du=ALLVOL$du[sub], t=ALLVOL$t[sub]))
  
}
##########################################################
##  source("/home/lees/Progs/R_stuff/volc.R")


###########################
##########################
vdistarc<-function(x, y, sel=1, tit="HI")
  {

    if(missing(tit)) { tit = "Volcano Locations" }
    if(missing(sel)) { sel=1:length(x) }
    
    screens(2)
###  graphics.off()
    
    dev.set(2)
    par(mfrow=c(1,1))
    plot(x, y, type='p', pch = 2, col =3, asp=TRUE)
    title(main=tit)

    x =  x[sel]
    y =  y[sel]
    points(x, y, pch = 2)
    GLM = glm(y ~ cbind(x , x^2)  )

    ###    points( x,  GLM$fitted.values, col=2)

    DX = diff(range(x))
    nx = seq(from=min(x)-0.1*DX, to=max(x)+0.1*DX, length=2000)

    ZZ = GLM$coefficients
    ny = ZZ[1] + ZZ[2]*nx + ZZ[3]*nx^2
    lines(nx,ny, col=2)

   ##  plot(nx, ny)

    pp = rep(NA, length(x))

    for(i in 1:length(x))
      {
        px = x[i]
        py = y[i]

        Dkm = hypot(px, py,nx, ny)
        mm = which.min(Dkm)

        pp[i] = mm
      }

    segments(x,y, nx[pp] , ny[pp], col=2)



NL = nls( ~ rcirc(x,  y, xc, yc, r), start=list(xc=mean(x) , yc=mean(y), r=1))
v = summary(NL)
xc = v$parameters[1,1]
yc = v$parameters[2,1]
r =   v$parameters[3,1]
lines( r*c0$x+xc, r*c0$y+yc, col=4)

    gamma = hypot(xc,yc,x,y)
    circx = xc+ (r* (x-xc) / gamma)
    circy = yc+ (r* (y-yc)/ gamma)

    points(circx, circy, col=5)

    segments(x,y, circx, circy, col=2)


    
    spp = sort(pp)
    dev.set(3)

    H = hypot(nx[spp[1:(length(spp)-1)]],ny[spp[1:(length(spp)-1)]] ,nx[spp[2:(length(spp))]],ny[spp[2:(length(spp))]]) 

    hist(H, breaks=30, main=tit )
    ## title(main=tit)

  }
##########################################################
##  source("/home/lees/Progs/R_stuff/volc.R")

